/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.plugin;

import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import pl.waw.ipipan.zil.core.mmax4core.Messages;
import pl.waw.ipipan.zil.core.mmax4core.annotation.scheme.MMAX2AnnotationScheme;
import pl.waw.ipipan.zil.core.mmax4core.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4core.plugin.SuperannotationListener;

public class SuperannotationMenu
extends JMenuBar {
    private static final long serialVersionUID = 8716704947933256671L;
    private final JMenu attributeMenu;
    private ButtonGroup attributeGroup;
    private final ActionListener listener;

    public SuperannotationMenu(SuperannotationListener listener) {
        this.listener = listener;
        this.attributeMenu = new JMenu(Messages.getString("SuperannotationMenu.Attributes"));
        JRadioButtonMenuItem noAttributeItem = new JRadioButtonMenuItem(Messages.getString("SuperannotationMenu.mention"));
        noAttributeItem.setSelected(true);
        noAttributeItem.setActionCommand("attribute:no_attribute:no_attribute");
        noAttributeItem.addActionListener(listener);
        this.attributeMenu.add(noAttributeItem);
        this.add(this.attributeMenu);
    }

    public void updateAttributeMenu(MMAX2AnnotationScheme scheme) {
        this.attributeMenu.removeAll();
        this.attributeGroup = new ButtonGroup();
        JRadioButtonMenuItem noAttributeItem = new JRadioButtonMenuItem(Messages.getString("SuperannotationMenu.mention"));
        noAttributeItem.setSelected(true);
        noAttributeItem.setActionCommand("attribute:no_attribute:no_attribute");
        noAttributeItem.addActionListener(this.listener);
        this.attributeGroup.add(noAttributeItem);
        this.attributeMenu.add(noAttributeItem);
        int[] types = new int[]{3, 4, 6, 5};
        String[] typesString = new String[]{"freetext", "head", "pointer", "set"};
        int i = 0;
        while (i < types.length) {
            MMAX2Attribute attribute = scheme.getAttributesByType(types[i])[0];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(attribute.getLocalizedAttributeName());
            item.setActionCommand("attribute:" + typesString[i] + ":" + attribute.getLowerCasedAttributeName());
            item.addActionListener(this.listener);
            this.attributeGroup.add(item);
            this.attributeMenu.add(item);
            ++i;
        }
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(Messages.getString("SuperannotationMenu.dominating_expression"));
        item.setActionCommand("attribute:dominant:dominant");
        item.addActionListener(this.listener);
        this.attributeGroup.add(item);
        this.attributeMenu.add(item);
    }
}

