/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.annotation.markables;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4ref.api.MarkableAPI;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.DiscourseOrderDiscourseElementComparator;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2DiscourseElement;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Constants;

public final class Markable
implements Serializable,
MarkableAPI {
    private static final long serialVersionUID = -1610603273502145894L;
    private String ID = "";
    String string = "";
    String stringWithoutBrackets = "";
    private String[][] fragments;
    int singleFragments;
    private int size;
    Map<String, String> attributes;
    private MarkableLevel level;
    private Node nodeRepresentation = null;
    private int[] leftHandlePositions;
    private int[] rightHandlePositions;
    private int[] displayStartPositions;
    private int[] displayEndPositions;
    int[] discourseElementStartPositions;
    private boolean discontinuous = false;
    int leftmostDisplayPosition;
    int rightmostDisplayPosition;
    private boolean isInSearchResult = false;
    private String dominant = null;

    public MarkableLevel getLevel() {
        return this.level;
    }

    public Markable(Node _nodeRepresentation, String _ID, String[][] _fragments, Map<String, String> attributes2, MarkableLevel _level) {
        this.nodeRepresentation = _nodeRepresentation;
        this.ID = _ID;
        this.attributes = attributes2;
        this.fragments = _fragments;
        this.level = _level;
        if (this.attributes.containsKey("mention_head") && this.attributes.get("mention_head").equals("") && this.fragments.length == 1 && this.fragments[0].length == 1) {
            String onlyFragmentId = this.fragments[0][0];
            String de = this.level.getCurrentDiscourse().getDEStringById(onlyFragmentId);
            if (de != null) {
                this.attributes.put("mention_head", de);
            } else {
                System.out.println("no de " + onlyFragmentId + " found");
            }
        }
        if (this.attributes.containsKey("dominant") && !this.attributes.get("dominant").equals("")) {
            String dom = this.attributes.get("dominant");
            this.removeAttributeQuiet("dominant");
            this.dominant = dom;
        }
        if (!this.attributes.containsKey("mmax_level")) {
            ((Element)this.nodeRepresentation).setAttribute("mmax_level", this.level.getMarkableLevelName());
            this.attributes.put("mmax_level", this.level.getMarkableLevelName());
        } else if (!this.attributes.get("mmax_level").equalsIgnoreCase(this.level.getMarkableLevelName())) {
            ((Element)this.nodeRepresentation).setAttribute("mmax_level", this.level.getMarkableLevelName());
            this.attributes.put("mmax_level", this.level.getMarkableLevelName());
            this.level.setIsReadOnly(true);
        }
        this.singleFragments = this.fragments.length;
        if (this.singleFragments > 1) {
            this.discontinuous = true;
        }
        this.leftHandlePositions = new int[0];
        this.rightHandlePositions = new int[0];
        this.displayStartPositions = new int[this.singleFragments];
        this.displayEndPositions = new int[this.singleFragments];
        MarkableHelper.register(this, false);
    }

    public final void clearMarkableHandles() {
        this.leftHandlePositions = null;
        this.leftHandlePositions = new int[0];
        this.rightHandlePositions = null;
        this.rightHandlePositions = new int[0];
    }

    public final void update(String[][] _fragments) {
        this.fragments = _fragments;
        this.singleFragments = this.fragments.length;
        if (this.singleFragments > 1) {
            this.discontinuous = true;
        }
        this.leftHandlePositions = new int[this.singleFragments];
        this.rightHandlePositions = new int[this.singleFragments];
        this.displayStartPositions = new int[this.singleFragments];
        this.displayEndPositions = new int[this.singleFragments];
        MarkableHelper.register(this, true);
    }

    @Override
    public final String toString() {
        return this.string;
    }

    public final String[] getDiscourseElements() {
        String[] des = this.getDiscourseElementIDs();
        ArrayList<String> temp = new ArrayList<String>();
        int z = 0;
        while (z < des.length) {
            temp.add(this.level.getCurrentDiscourse().getDiscourseElementNode(des[z]).getFirstChild().getNodeValue());
            ++z;
        }
        return temp.toArray(new String[0]);
    }

    public final String[] getDiscourseElementIDs() {
        ArrayList<String> temp = new ArrayList<String>();
        int z = 0;
        while (z < this.singleFragments) {
            String[] currentFragment = this.fragments[z];
            int o = 0;
            while (o < currentFragment.length) {
                if (!temp.contains(currentFragment[o])) {
                    temp.add(currentFragment[o]);
                }
                ++o;
            }
            ++z;
        }
        return temp.toArray(new String[0]);
    }

    public final boolean removeDiscourseElements(String[] removees) {
        boolean result = false;
        MMAX2DiscourseElement[] sequence = this.level.getCurrentDiscourse().getDiscourseElements(this);
        ArrayList<MMAX2DiscourseElement> DEsAsList = new ArrayList<MMAX2DiscourseElement>(Arrays.asList(sequence));
        int o = 0;
        while (o < removees.length) {
            String currentRemovee = removees[o];
            int u = 0;
            while (u < DEsAsList.size()) {
                if (((MMAX2DiscourseElement)DEsAsList.get(u)).getID().equalsIgnoreCase(currentRemovee)) {
                    DEsAsList.remove(u);
                    break;
                }
                ++u;
            }
            ++o;
        }
        if (DEsAsList.size() != 0) {
            this.update(MarkableHelper.toFragments(DEsAsList));
            result = true;
        }
        this.level.setIsDirty(true, false);
        return result;
    }

    public final boolean addDiscourseElements(String[] addees) {
        MMAX2DiscourseElement[] sequence = this.level.getCurrentDiscourse().getDiscourseElements(this);
        ArrayList<MMAX2DiscourseElement> DEsAsList = new ArrayList<MMAX2DiscourseElement>(Arrays.asList(sequence));
        int z = 0;
        while (z < addees.length) {
            DEsAsList.add(this.level.getCurrentDiscourse().getDiscourseElementByID(addees[z]));
            ++z;
        }
        MarkableHelper.removeDuplicateDiscoursePositions(DEsAsList);
        Collections.sort(DEsAsList, new DiscourseOrderDiscourseElementComparator());
        this.update(MarkableHelper.toFragments(DEsAsList));
        this.level.setIsDirty(true, false);
        return true;
    }

    public final void deleteMe() {
        this.level.deleteMarkable(this);
    }

    public final SimpleAttributeSet getAttributedependentStyle() {
        return this.level.getRenderer().getAttributesForMarkable(this);
    }

    public final void destroyDependentComponents() {
        this.attributes = null;
        this.discourseElementStartPositions = null;
        this.displayStartPositions = null;
        this.displayEndPositions = null;
        this.fragments = null;
        this.leftHandlePositions = null;
        this.rightHandlePositions = null;
        this.nodeRepresentation = null;
        this.string = null;
        this.stringWithoutBrackets = null;
        this.level = null;
    }

    @Override
    public final int getLeftmostDiscoursePosition() {
        return this.level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(this.fragments[0][0]);
    }

    @Override
    public final int getRightmostDiscoursePosition() {
        String[] finalFrag = this.fragments[this.fragments.length - 1];
        return this.level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(finalFrag[finalFrag.length - 1]);
    }

    public final int getLeftmostDisplayPosition() {
        return this.leftmostDisplayPosition;
    }

    public final int getRightmostDisplayPosition() {
        return this.rightmostDisplayPosition;
    }

    public final int[] getDisplayStartPositions() {
        return this.displayStartPositions;
    }

    public final void setDisplayStartPositions(int pos, int val) {
        this.displayStartPositions[pos] = val;
    }

    public void setDisplayEndPositions(int pos, int val) {
        this.displayEndPositions[pos] = val;
    }

    public final int[] getDisplayEndPositions() {
        return this.displayEndPositions;
    }

    public final int[] getDiscourseElementStartPositions() {
        return this.discourseElementStartPositions;
    }

    protected final void resetHandles() {
        this.leftHandlePositions = null;
        this.leftHandlePositions = new int[0];
        this.rightHandlePositions = null;
        this.rightHandlePositions = new int[0];
    }

    public final void renderMe(int mode) {
        if (this.isInSearchResult && mode == MMAX2Constants.RENDER_UNSELECTED) {
            this.level.getRenderer().render(this, MMAX2Constants.RENDER_IN_SEARCHRESULT);
        } else {
            this.level.getRenderer().render(this, mode);
        }
    }

    public final boolean isDiscontinuous() {
        return this.discontinuous;
    }

    public final int getSize() {
        return this.size;
    }

    public final void addLeftHandlePosition(int pos) {
        if (this.leftHandlePositions.length == 0) {
            this.leftHandlePositions = null;
            this.leftHandlePositions = new int[this.singleFragments];
            this.level.setHasHandles(true);
        }
        int p = 0;
        while (p < this.singleFragments) {
            if (this.leftHandlePositions[p] == 0) {
                this.leftHandlePositions[p] = pos;
                break;
            }
            ++p;
        }
    }

    public final int[] getLeftHandlePositions() {
        return this.leftHandlePositions;
    }

    public final void addRightHandlePosition(int pos) {
        if (this.rightHandlePositions.length == 0) {
            this.rightHandlePositions = null;
            this.rightHandlePositions = new int[this.singleFragments];
        }
        int p = 0;
        while (p < this.singleFragments) {
            if (this.rightHandlePositions[p] == 0) {
                this.rightHandlePositions[p] = pos;
                break;
            }
            ++p;
        }
    }

    public final int[] getRightHandlePositions() {
        return this.rightHandlePositions;
    }

    public final Node getNodeRepresentation() {
        return this.nodeRepresentation;
    }

    @Override
    public final String getID() {
        return this.ID;
    }

    public final String getMarkableLevelName() {
        return this.level.getMarkableLevelName();
    }

    @Override
    public final MarkableLevel getMarkableLevel() {
        return this.level;
    }

    public final MMAX2Attribute[] getValidatedAttributes() {
        MMAX2Attribute[] result = null;
        boolean oldStat = false;
        if (this.level.getCurrentDiscourse().getMMAX2() != null) {
            oldStat = this.level.getCurrentDiscourse().getMMAX2().getIsAnnotationModified();
        }
        result = this.level.getCurrentAnnotationScheme().getAttributes(this);
        if (this.level.getCurrentDiscourse().getMMAX2() != null && !oldStat) {
            this.level.getCurrentDiscourse().getMMAX2().setIsAnnotationModified(false);
        }
        return result;
    }

    public final boolean coversDisplayPosition(int displayPosition) {
        boolean result = false;
        int z = 0;
        while (z < this.singleFragments) {
            if (displayPosition == this.displayStartPositions[z] || displayPosition == this.displayEndPositions[z]) {
                result = true;
                break;
            }
            if (displayPosition > this.displayStartPositions[z] && displayPosition < this.displayEndPositions[z]) {
                result = true;
                break;
            }
            ++z;
        }
        return result;
    }

    public final String[][] getFragments() {
        return this.fragments;
    }

    public final boolean getIsInSearchResult() {
        return this.isInSearchResult;
    }

    public final void setIsInSearchResult(boolean status) {
        this.isInSearchResult = status;
    }

    @Override
    public String toTrimmedString(int maxLen) {
        String complete;
        String copyofmarkabletext = complete = this.toString();
        if (complete.length() > maxLen) {
            complete = complete.substring(0, (maxLen - 5) / 2);
            complete = String.valueOf(complete) + " [...] ";
            complete = String.valueOf(complete) + copyofmarkabletext.substring(copyofmarkabletext.length() - (maxLen - 5) / 2 + 1, copyofmarkabletext.length());
        }
        complete.trim();
        return complete;
    }

    public final Point getPoint() {
        Point resultPoint = null;
        Rectangle tempRect = null;
        try {
            tempRect = this.leftHandlePositions.length == 0 ? this.level.getCurrentDiscourse().getMMAX2().getCurrentTextPane().modelToView(this.displayStartPositions[0]) : this.level.getCurrentDiscourse().getMMAX2().getCurrentTextPane().modelToView(this.leftHandlePositions[0]);
        }
        catch (BadLocationException ex) {
            System.out.println("Error with display position determination for Markable " + this.getID());
        }
        resultPoint = new Point((int)tempRect.getX(), (int)tempRect.getY());
        return resultPoint;
    }

    public final Map<String, String> getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Map<String, String> newAttributes) {
        this.attributes = null;
        this.attributes = newAttributes;
        String current2 = "";
        for (String current2 : newAttributes.keySet()) {
            ((Element)this.nodeRepresentation).setAttribute(current2, newAttributes.get(current2));
        }
        ((Element)this.nodeRepresentation).setAttribute("mmax_level", this.level.getMarkableLevelName());
    }

    public final void selectMe() {
        MMAX2 localMMAX2ref = this.getMarkableLevel().getCurrentDiscourse().getMMAX2();
        this.getMarkableLevel().getCurrentDiscourse().getCurrentMarkableChart().markableLeftClicked(this);
        localMMAX2ref.scrollToMarkable(this);
        localMMAX2ref.getCurrentTextPane().startAutoRefresh();
    }

    public final String getAttributeValue(String attributeName) {
        String result = null;
        if (this.attributes.containsKey(attributeName)) {
            result = this.attributes.get(attributeName);
        }
        return result;
    }

    @Override
    public final String getAttributeValue(String name, String defaultIfUndefined) {
        String result = this.attributes.get(name);
        if (result == null) {
            result = defaultIfUndefined;
        }
        return result;
    }

    public final void setAttributeValue(String attributeName, String value, boolean silent) {
        this.attributes.put(attributeName, value);
        if (!silent) {
            this.level.setIsDirty(true, false);
        }
    }

    @Override
    public final void setAttributeValue(String attributeName, String value) {
        this.setAttributeValue(attributeName, value, false);
    }

    public final void setAttributeValueToNode(String attributeName, String value) {
        this.nodeRepresentation.getAttributes().getNamedItem(attributeName).setNodeValue(value);
    }

    public final void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
        this.nodeRepresentation.getAttributes().removeNamedItem(attributeName);
        this.level.setIsDirty(true, false);
    }

    public final void removeAttributeQuiet(String attributeName) {
        this.attributes.remove(attributeName);
        this.nodeRepresentation.getAttributes().removeNamedItem(attributeName);
    }

    public final boolean isDefined(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    public final Markable cloneMarkable() {
        System.out.println(this.nodeRepresentation.getAttributes().toString());
        Markable result = new Markable(this.nodeRepresentation, this.ID, this.fragments, new HashMap<String, String>(this.attributes), this.level);
        return result;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String toStringWithoutBrackets() {
        return this.stringWithoutBrackets;
    }

    public String getDominant() {
        return this.dominant;
    }

    public void setDominant(String dom) {
        this.dominant = dom;
    }

    public String toHTMLString() {
        String base = this.toStringWithoutBrackets();
        String head = this.getAttributeValue("mention_head");
        if (head != null && !head.equals("")) {
            Pattern p = Pattern.compile("(" + head + ")", 2);
            Matcher m = p.matcher(base);
            base = m.replaceFirst("<u>$1</u>");
        }
        return "<html>" + base + "</html>";
    }
}

