/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.annotation.markables;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.swing.JOptionPane;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2AnnotationScheme;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.LocalResolver;

public class MarkableFileLoader {
    protected MarkableLevel currentMarkableLevel = null;
    private static EntityResolver resolver = new LocalResolver();

    public final void load(String fileName, String levelName, String schemeFileName, String customizationFileName, String localizedName) {
        File tempFile = new File(fileName);
        if (!tempFile.exists()) {
            System.err.println("   Level " + levelName + " not found, creating empty template ...");
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8");
                String header = "<?xml version=\"1.0\" ?>\n<!DOCTYPE markables SYSTEM \"markables.dtd\">\n<markables xmlns=\"www.eml.org/NameSpaces/" + levelName + "\">\n</markables>\n";
                writer.write(header);
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                System.err.println(ex.toString());
            }
        }
        try {
            InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8");
            this.load(r, fileName, levelName, schemeFileName, customizationFileName, localizedName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public final void load(Reader r, String fileName, String levelName, String schemeFileName, String customizationFileName, String localizedName) {
        DOMParser parser = new DOMParser();
        try {
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setEntityResolver(resolver);
            parser.parse(new InputSource(r));
            DocumentImpl markableDOM = (DocumentImpl)parser.getDocument();
            MMAX2AnnotationScheme currentScheme = new MMAX2AnnotationScheme(schemeFileName);
            this.currentMarkableLevel = new MarkableLevel(markableDOM, fileName, levelName, currentScheme, customizationFileName, localizedName);
        }
        catch (SAXParseException exception) {
            String error = "Line: " + exception.getLineNumber() + " Column: " + exception.getColumnNumber() + "\n" + exception.toString();
            JOptionPane.showMessageDialog(null, error, "MarkableFileLoader: " + fileName, 0);
        }
        catch (SAXException exception) {
            String error = exception.toString();
            JOptionPane.showMessageDialog(null, error, "MarkableFileLoader: " + fileName, 0);
        }
        catch (IOException exception) {
            String error = exception.toString();
            JOptionPane.showMessageDialog(null, error, "MarkableFileLoader: " + fileName, 0);
        }
    }

    public final void load(Reader r, MarkableLevel previous) {
        this.load(r, previous.getMarkableFileName(), previous.getMarkableLevelName(), previous.getCurrentAnnotationScheme().getSchemeFileName(), previous.getCustomizationFileName(), previous.getMarkableLevelLocalizedName());
    }

    public final MarkableLevel getMarkableLevel() {
        return this.currentMarkableLevel;
    }
}

