/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.annotation.markables;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xpath.NodeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkablePointer;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.comparator.DiscourseOrderMarkableComparator;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2AnnotationScheme;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4ref.api.MarkableLevelAPI;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2Discourse;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2DiscourseElement;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2DiscourseElementSequence;
import pl.waw.ipipan.zil.core.mmax4ref.gui.display.MarkableLevelRenderer;
import pl.waw.ipipan.zil.core.mmax4ref.gui.document.MMAX2Document;
import pl.waw.ipipan.zil.core.mmax4ref.gui.windows.MMAX2MarkableBrowser;
import pl.waw.ipipan.zil.core.mmax4ref.gui.windows.MMAX2MarkablePointerBrowser;
import pl.waw.ipipan.zil.core.mmax4ref.gui.windows.MMAX2MarkableSetBrowser;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Constants;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Utils;

public class MarkableLevel
implements ActionListener,
MarkableLevelAPI {
    private static final Logger logger = Logger.getLogger(MarkableLevel.class);
    private DocumentImpl markableDOM;
    private MMAX2Discourse currentDiscourse;
    private Map<String, Markable> markableHash;
    private String markableFileName = "";
    private String markableLevelName = "";
    private String localizedName = "";
    private String markableFileHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private String encoding = "UTF-8";
    private String markableNameSpace = "";
    private String dtdReference = "<!DOCTYPE markables>";
    private Map<String, Markable[]> markablesAtDiscourseElement;
    private Map<String, Markable[]> startedMarkablesAtDiscourseElement;
    private Map<String, Markable[]> endedMarkablesAtDiscourseElement;
    private Markable[][] markablesAtDiscoursePosition;
    private boolean active;
    private boolean visible;
    private int position;
    private JComboBox activatorComboBox = null;
    private BasicArrowButton moveUp = null;
    private BasicArrowButton moveDown = null;
    private Map<String, MarkableRelation> MarkableSetRelations = null;
    private Map<String, MarkableRelation> MarkablePointerRelations = null;
    private JButton updateCustomization = null;
    private JButton validateButton = null;
    private JButton deleteAllButton = null;
    private JCheckBox switchCustomizations = null;
    private MarkableLevelRenderer renderer = null;
    private JLabel nameLabel = null;
    private String matchableLevelName = "";
    private boolean hasHandles = false;
    private MMAX2AnnotationScheme annotationscheme = null;
    private MMAX2 mmax2 = null;
    private boolean dirty = false;
    private JMenuItem saveMenuItem = null;
    private String customizationFileName = "";
    private boolean readOnly = false;

    public MarkableLevel(DocumentImpl _markableDOM, String _markableFileName, String _markableLevelName, MMAX2AnnotationScheme _scheme, String _customizationFileName, String _localizedName) {
        this.customizationFileName = _customizationFileName;
        this.matchableLevelName = "," + _markableLevelName.toLowerCase() + ",";
        if (_markableDOM != null) {
            this.encoding = _markableDOM.getEncoding();
            if (this.encoding == null) {
                this.encoding = "UTF-8";
            }
            if (!this.encoding.equals("")) {
                this.markableFileHeader = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>";
            }
            this.markableDOM = _markableDOM;
            try {
                if (this.markableDOM.getElementsByTagName("markables").item(0).getAttributes().getNamedItem("xmlns") == null) {
                    JOptionPane.showMessageDialog(null, "Missing name space declaration on markable level " + _markableLevelName + "!\nEvery markable level file MUST have a name space declaration!\nMarkables on this level will not work properly!\n\nPlease modify the file\n" + _markableFileName, "Missing name space declaration!", 0);
                }
            }
            catch (NullPointerException ex) {
                JOptionPane.showMessageDialog(null, "Cannot access xmlns element in file " + _markableLevelName + "!\nProbably missing markables.dtd.", "Cannot access name space!", 0);
            }
            try {
                this.markableNameSpace = this.markableDOM.getElementsByTagName("markables").item(0).getAttributes().getNamedItem("xmlns").getNodeValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (this.markableDOM.getDoctype() == null) {
                JOptionPane.showMessageDialog(null, "Missing DOCTYPE declaration on markable level " + _markableLevelName + "!\nEvery markable level file MUST have a DOCTYPE declaration!\nMarkables on this level will not work properly!\n\nPlease modify the file\n" + _markableFileName, "Missing DOCTYPE declaration!", 0);
            } else if (this.markableDOM.getDoctype().getPublicId() != null) {
                this.dtdReference = "<!DOCTYPE markables PUBLIC \"" + this.markableDOM.getDoctype().getPublicId() + "\">";
            } else if (this.markableDOM.getDoctype().getSystemId() != null) {
                this.dtdReference = "<!DOCTYPE markables SYSTEM \"" + this.markableDOM.getDoctype().getSystemId() + "\">";
            }
        }
        this.markableFileName = _markableFileName;
        this.markableLevelName = _markableLevelName;
        this.localizedName = _localizedName;
        this.annotationscheme = _scheme;
        this.markablesAtDiscourseElement = new HashMap<String, Markable[]>();
        this.startedMarkablesAtDiscourseElement = new HashMap<String, Markable[]>();
        this.endedMarkablesAtDiscourseElement = new HashMap<String, Markable[]>();
        this.MarkableSetRelations = new HashMap<String, MarkableRelation>();
        this.MarkablePointerRelations = new HashMap<String, MarkableRelation>();
        if (_markableLevelName.equalsIgnoreCase("internal_basedata_representation")) {
            return;
        }
        this.renderer = new MarkableLevelRenderer(this, this.customizationFileName);
        this.moveUp = new BasicArrowButton(1);
        if (!this.isDefined()) {
            this.moveUp.setEnabled(false);
        }
        this.moveUp.addActionListener(this);
        this.moveUp.setToolTipText("Move this level up in hierarchy");
        this.moveDown = new BasicArrowButton(5);
        if (!this.isDefined()) {
            this.moveDown.setEnabled(false);
        }
        this.moveDown.addActionListener(this);
        this.moveDown.setToolTipText("Move this level down in hierarchy");
        this.activatorComboBox = new JComboBox();
        this.activatorComboBox.setFont(this.activatorComboBox.getFont().deriveFont(10.0f));
        this.activatorComboBox.setBorder(new EmptyBorder(0, 0, 1, 1));
        if (!this.isDefined()) {
            this.activatorComboBox.setEnabled(false);
        }
        this.activatorComboBox.setToolTipText("Activate/hide/deactivate this level");
        this.activatorComboBox.setActionCommand("activator");
        this.active = true;
        this.visible = true;
        this.activatorComboBox.addItem("active");
        this.activatorComboBox.addItem("visible");
        this.activatorComboBox.addItem("inactive");
        this.activatorComboBox.addActionListener(this);
        this.nameLabel = new JLabel(this.markableLevelName);
        this.nameLabel.setOpaque(true);
        if (!this.renderer.getForegroundIsTransparent()) {
            this.nameLabel.setForeground(this.renderer.getForegroundColor());
        } else {
            this.nameLabel.setForeground(Color.black);
        }
        if (this.renderer.getBackgroundIsTransparent()) {
            this.nameLabel.setBackground(Color.white);
        } else {
            this.nameLabel.setBackground(this.renderer.getBackgroundColor());
        }
        this.updateCustomization = new JButton("Update");
        this.updateCustomization.setFont(this.updateCustomization.getFont().deriveFont(10.0f));
        this.updateCustomization.setBorder(new EmptyBorder(0, 0, 1, 1));
        this.updateCustomization.setActionCommand("update");
        this.updateCustomization.addActionListener(this);
        if (this.customizationFileName.equals("")) {
            this.updateCustomization.setEnabled(false);
        } else {
            this.updateCustomization.setEnabled(true);
            this.updateCustomization.setToolTipText(this.customizationFileName);
        }
        if (!this.isDefined()) {
            this.updateCustomization.setEnabled(false);
        }
        this.validateButton = new JButton("Validate");
        this.validateButton.setFont(this.validateButton.getFont().deriveFont(10.0f));
        this.validateButton.setBorder(new EmptyBorder(0, 0, 1, 1));
        if (!this.isDefined()) {
            this.validateButton.setEnabled(false);
        }
        this.validateButton.setActionCommand("validate");
        this.validateButton.addActionListener(this);
        this.deleteAllButton = new JButton("Delete");
        this.deleteAllButton.setFont(this.deleteAllButton.getFont().deriveFont(10.0f));
        this.deleteAllButton.setBorder(new EmptyBorder(0, 0, 1, 1));
        if (!this.isDefined()) {
            this.deleteAllButton.setEnabled(false);
        }
        this.deleteAllButton.setActionCommand("delete_all");
        this.deleteAllButton.addActionListener(this);
        this.switchCustomizations = new JCheckBox("");
        if (!this.isDefined()) {
            this.switchCustomizations.setEnabled(false);
        }
        this.switchCustomizations.setActionCommand("switch");
        this.switchCustomizations.addActionListener(this);
        this.switchCustomizations.setToolTipText("Activate / deactivate markable customization for this level");
        if (this.customizationFileName.equals("")) {
            this.switchCustomizations.setEnabled(false);
        } else {
            this.switchCustomizations.setSelected(true);
            this.renderer.updateSimpleMarkableCustomizations(true);
        }
        this.saveMenuItem = new JMenuItem(this.markableLevelName);
        this.saveMenuItem.addActionListener(this);
        this.saveMenuItem.setActionCommand("save_this_level");
        this.saveMenuItem.setEnabled(false);
    }

    public final boolean getIsReadOnly() {
        return this.readOnly;
    }

    public final void setIsReadOnly(boolean status) {
        this.readOnly = status;
    }

    public final String getCustomizationFileName() {
        return this.customizationFileName;
    }

    public final MMAX2AnnotationScheme updateAnnotationScheme() {
        String temp = this.annotationscheme.getSchemeFileName();
        this.annotationscheme = null;
        System.gc();
        this.annotationscheme = new MMAX2AnnotationScheme(temp);
        this.annotationscheme.setMMAX2(this.mmax2);
        return this.annotationscheme;
    }

    public final void setMMAX2(MMAX2 _mmax2) {
        this.mmax2 = _mmax2;
        this.annotationscheme.setMMAX2(_mmax2);
    }

    public final boolean isDefined() {
        return this.markableDOM != null;
    }

    public final JMenuItem getSaveMarkableLevelItem() {
        return this.saveMenuItem;
    }

    public final boolean hasMarkableStartingAt(String deID) {
        return this.startedMarkablesAtDiscourseElement.get(deID) != null;
    }

    public final boolean hasMarkableEndingAt(String deID) {
        return this.endedMarkablesAtDiscourseElement.get(deID) != null;
    }

    public final Markable getMarkableAtSpan(String span) {
        Markable result = null;
        for (Markable temp : this.markableHash.values()) {
            if (!span.equalsIgnoreCase(MarkableHelper.getSpan(temp))) continue;
            result = temp;
            break;
        }
        return result;
    }

    public final void setIsDirty(boolean status, boolean refresh) {
        if (this.dirty != status) {
            this.dirty = status;
            logger.info("MarkableLevel " + this.markableLevelName + " set to dirty=" + status);
            this.saveMenuItem.setEnabled(status);
        }
        if (this.getCurrentDiscourse() != null && this.getCurrentDiscourse().getMMAX2() != null) {
            this.getCurrentDiscourse().getMMAX2().updateIsAnnotationModified();
        }
        if (this.getCurrentDiscourse().getMMAX2() != null) {
            MMAX2MarkablePointerBrowser activeBrowser3;
            MMAX2MarkableSetBrowser activeBrowser2;
            MMAX2MarkableBrowser activeBrowser;
            if (refresh && (activeBrowser = this.getCurrentDiscourse().getMMAX2().getMarkableBrowserForMarkableLevel(this.markableLevelName)) != null) {
                activeBrowser.refresh();
            }
            if ((activeBrowser2 = this.getCurrentDiscourse().getMMAX2().getMarkableSetBrowserForMarkableLevel(this.markableLevelName)) != null) {
                activeBrowser2.update();
            }
            if ((activeBrowser3 = this.getCurrentDiscourse().getMMAX2().getMarkablePointerBrowserForMarkableLevel(this.markableLevelName)) != null) {
                activeBrowser3.update();
            }
        }
    }

    public final boolean getIsDirty() {
        return this.dirty;
    }

    public final List<String> getAttributeNamesForValues(String valueList, String optionalAttributeName) {
        return this.annotationscheme.getAttributeNamesForValues(valueList, optionalAttributeName);
    }

    public final void setValidateButtonEnabled(boolean status) {
        this.validateButton.setEnabled(status);
    }

    public final void validate() {
        System.err.println("Validating " + this.markableHash.size() + " markables from MarkableLevel " + this.getMarkableLevelName());
        Iterator<Markable> allMarkables = this.markableHash.values().iterator();
        Markable current = null;
        this.getCurrentAnnotationScheme().getCurrentAttributePanel().getContainer().setVisible(false);
        while (allMarkables.hasNext()) {
            current = allMarkables.next();
            this.getCurrentAnnotationScheme().getCurrentAttributePanel().displayMarkableAttributes(current);
        }
        this.getCurrentAnnotationScheme().getCurrentAttributePanel().getContainer().setVisible(true);
        this.getCurrentAnnotationScheme().getCurrentAttributePanel().displayMarkableAttributes(null);
    }

    @Override
    public final void deleteAllMarkables() {
        ArrayList<Markable> temp = new ArrayList<Markable>();
        Iterator<Markable> allMarkables = this.markableHash.values().iterator();
        while (allMarkables.hasNext()) {
            temp.add(allMarkables.next());
        }
        allMarkables = null;
        int b = 0;
        while (b < temp.size()) {
            this.deleteMarkable((Markable)temp.get(b));
            ++b;
        }
    }

    @Override
    public final void deleteMarkable(Markable deletee) {
        MarkableRelation[] currentRelations = this.getActiveMarkableSetRelationsForMarkable(deletee);
        int b = 0;
        while (b < currentRelations.length) {
            MarkableRelation relation = currentRelations[b];
            String constitutingAttribute = relation.getAttributeName();
            MarkableSet set = relation.getMarkableSetContainingMarkable(deletee);
            if (set != null) {
                set.removeMarkable(deletee);
                if (set.getSize() == 1) {
                    logger.debug("Removing second but last markable from set. Destroying set.");
                    Markable last = set.getInitialMarkable();
                    set.removeMeFromMarkableRelation();
                    last.setAttributeValue(constitutingAttribute, MMAX2.defaultRelationValue);
                    ((Element)last.getNodeRepresentation()).setAttribute(constitutingAttribute, MMAX2.defaultRelationValue);
                }
            }
            ++b;
        }
        List<MarkablePointer> pointers = this.getMarkablePointersForTargetMarkable(deletee);
        for (MarkablePointer pointer : pointers) {
            MarkableRelation relation = pointer.getMarkableRelation();
            String constitutingAttributeName = relation.getAttributeName();
            Markable currentSource = pointer.getSourceMarkable();
            pointer.removeTargetMarkable(deletee);
            if (pointer.getSize() == 0) {
                logger.debug("The last element from pointer is removed, pointer is destroyed!");
                pointer.removeMeFromMarkableRelation();
                currentSource.setAttributeValue(constitutingAttributeName, MMAX2.defaultRelationValue);
                ((Element)currentSource.getNodeRepresentation()).setAttribute(constitutingAttributeName, MMAX2.defaultRelationValue);
                continue;
            }
            currentSource.setAttributeValue(constitutingAttributeName, pointer.getTargetSpan());
            ((Element)currentSource.getNodeRepresentation()).setAttribute(constitutingAttributeName, pointer.getTargetSpan());
        }
        List<MarkableRelation> rels = Arrays.asList(this.getActiveMarkablePointerRelationsForSourceMarkable(deletee));
        for (MarkableRelation rel : rels) {
            MarkablePointer pointer = rel.getMarkablePointerForSourceMarkable(deletee);
            pointer.removeMeFromMarkableRelation();
        }
        Node root = this.markableDOM.getElementsByTagName("markables").item(0);
        root.removeChild(deletee.getNodeRepresentation());
        this.markableHash.remove(deletee.getID());
        this.unregisterMarkable(deletee);
        Integer[] positions = this.currentDiscourse.removeDisplayAssociationsForMarkable(deletee);
        if (positions.length != 0) {
            this.renderer.removeHandlesAtDisplayPositions(positions);
        }
        deletee.renderMe(MMAX2Constants.RENDER_REMOVED);
        MMAX2 mmax = this.currentDiscourse.getMMAX2();
        if (deletee.equals(mmax.getCurrentPrimaryMarkable())) {
            mmax.setCurrentPrimaryMarkable(null);
        }
        mmax.setCurrentSecondaryMarkable(null);
        mmax.getCurrentTextPane().setCurrentHoveree(null, 0);
        deletee = null;
        this.setIsDirty(true, true);
    }

    @Override
    public final Markable addMarkable(String[] discourseElementIDs, Map<String, String> attributes) {
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        ArrayList<MMAX2DiscourseElement> discourseElements = new ArrayList<MMAX2DiscourseElement>();
        int n = 0;
        while (n < discourseElementIDs.length) {
            discourseElements.add(this.currentDiscourse.getDiscourseElementByID(discourseElementIDs[n]));
            ++n;
        }
        return this.addMarkable(discourseElements, attributes);
    }

    @Override
    public final Markable addMarkable(List<MMAX2DiscourseElement> discourseElements, Map<String, String> attributes) {
        String[][] fragments = MarkableHelper.toFragments(discourseElements);
        return this.addMarkable(fragments, attributes);
    }

    public final Markable addMarkable(String[][] fragments, Map<String, String> attributes) {
        String id = this.currentDiscourse.getCurrentMarkableChart().getNextFreeMarkableID();
        while (this.markableHash.containsKey(id)) {
            id = this.currentDiscourse.getCurrentMarkableChart().getNextFreeMarkableID();
            logger.warn("NEW ID already EXISTS! Skipping");
        }
        MMAX2Attribute[] mmaxAttributes = this.annotationscheme.getInitialAttributes().toArray(new MMAX2Attribute[0]);
        ElementImpl node = (ElementImpl)this.markableDOM.createElementNS(this.markableNameSpace, "markable");
        Node root = this.markableDOM.getElementsByTagName("markables").item(0);
        root.insertBefore(node, root.getFirstChild());
        int i = 0;
        while (i < mmaxAttributes.length) {
            String currentAttrib = mmaxAttributes[i].getLowerCasedAttributeName();
            if (!attributes.containsKey(currentAttrib)) {
                attributes.put(new String(currentAttrib), new String(mmaxAttributes[i].getSelectedValue()));
                node.setAttribute(new String(currentAttrib), new String(mmaxAttributes[i].getSelectedValue()));
            }
            ++i;
        }
        node.setAttribute(new String("id"), new String(id));
        Markable newMarkable = new Markable(node, id, fragments, attributes, this);
        this.markableHash.put(id, newMarkable);
        MarkableHelper.setDisplayPositions(newMarkable);
        int z = 0;
        while (z < fragments.length) {
            String[] currentFragment = fragments[z];
            int y = 0;
            while (y < currentFragment.length) {
                this.updateDiscoursePositionToMarkableMapping(fragments[z][y]);
                ++y;
            }
            ++z;
        }
        MMAX2Document doc = this.currentDiscourse.getDisplayDocument();
        doc.startChanges(newMarkable);
        newMarkable.renderMe(MMAX2Constants.RENDER_UNSELECTED);
        doc.commitChanges();
        this.setIsDirty(true, true);
        return newMarkable;
    }

    public final Markable addMarkable(String fragment) {
        String id = this.currentDiscourse.getCurrentMarkableChart().getNextFreeMarkableID();
        while (this.markableHash.containsKey(id)) {
            id = this.currentDiscourse.getCurrentMarkableChart().getNextFreeMarkableID();
            logger.warn("NEW ID already EXISTS! Skipping");
        }
        String[][] fragments = MarkableLevel.parseMarkableSpan(fragment, this.currentDiscourse.getWordDOM(), this);
        HashMap<String, String> attributes = new HashMap<String, String>();
        MMAX2Attribute[] mmaxAttributes = this.annotationscheme.getInitialAttributes().toArray(new MMAX2Attribute[0]);
        ElementImpl node = (ElementImpl)this.markableDOM.createElementNS(this.markableNameSpace, "markable");
        Node root = this.markableDOM.getElementsByTagName("markables").item(0);
        root.insertBefore(node, root.getFirstChild());
        int i = 0;
        while (i < mmaxAttributes.length) {
            attributes.put(new String(mmaxAttributes[i].getLowerCasedAttributeName()), new String(mmaxAttributes[i].getSelectedValue()));
            node.setAttribute(new String(mmaxAttributes[i].getLowerCasedAttributeName()), new String(mmaxAttributes[i].getSelectedValue()));
            ++i;
        }
        node.setAttribute(new String("id"), new String(id));
        Markable newMarkable = new Markable(node, id, fragments, attributes, this);
        this.markableHash.put(id, newMarkable);
        MarkableHelper.setDisplayPositions(newMarkable);
        int z = 0;
        while (z < fragments.length) {
            String[] currentFragment = fragments[z];
            int y = 0;
            while (y < currentFragment.length) {
                this.updateDiscoursePositionToMarkableMapping(fragments[z][y]);
                ++y;
            }
            ++z;
        }
        MMAX2Document doc = this.currentDiscourse.getDisplayDocument();
        doc.startChanges(newMarkable);
        newMarkable.renderMe(MMAX2Constants.RENDER_UNSELECTED);
        doc.commitChanges();
        this.setIsDirty(true, true);
        this.getCurrentDiscourse().getMMAX2().requestReapplyDisplay();
        return newMarkable;
    }

    @Override
    public final void saveMarkables(String newFileName) {
        this.saveMarkables(newFileName, false);
    }

    public final void saveMarkables(Writer fw, boolean autoSaveMode) {
        String rootElement = "";
        rootElement = this.markableNameSpace.equals("") ? "<markables>" : "<markables xmlns=\"" + this.markableNameSpace + "\">";
        try {
            fw.write(String.valueOf(this.markableFileHeader) + "\n" + this.dtdReference + "\n" + rootElement + "\n");
            fw.flush();
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        logger.debug("Saving " + this.markableHash.size() + " markables");
        ArrayList<Markable> sorted = new ArrayList<Markable>(this.markableHash.values());
        Collections.sort(sorted, MMAX2Discourse.DISCOURSEORDERCOMP);
        for (Markable m : sorted) {
            try {
                fw.write(String.valueOf(MarkableHelper.toXMLElement(m)) + "\n");
            }
            catch (IOException ex) {
                logger.error("Error saving markable " + m.getID());
            }
        }
        try {
            fw.write("</markables>");
            fw.close();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
    }

    public final void saveMarkables(String newFileName, boolean autoSaveMode) {
        File destinationFile;
        if (!this.getIsDirty()) {
            if (autoSaveMode) {
                System.err.print("Auto-Save: ");
            }
            System.err.println("Markable level " + this.getMarkableLevelName() + " is clean, not saving!");
            return;
        }
        if (this.getIsReadOnly()) {
            if (autoSaveMode) {
                System.err.println("Auto-Save: Markable level " + this.getMarkableLevelName() + " is READ-ONLY, not saving!");
            } else {
                JOptionPane.showMessageDialog(null, "Markable level " + this.getMarkableLevelName() + " is READ-ONLY, not saving!", "Save problem", 1);
            }
            return;
        }
        if (autoSaveMode) {
            System.err.print("Auto-Save: ");
        }
        System.err.println("Saving level " + this.getMarkableLevelName() + " ... ");
        if (!newFileName.equals("")) {
            this.markableFileName = newFileName;
        }
        if ((destinationFile = new File(this.markableFileName)).exists()) {
            if (!destinationFile.canWrite()) {
                if (autoSaveMode) {
                    System.err.println("Auto-Save: Cannot save markables on level " + this.getMarkableLevelName() + "!'Write' not allowed!");
                } else {
                    JOptionPane.showMessageDialog(null, "Cannot save markables on level " + this.getMarkableLevelName() + "!\n'Write' not allowed!", "Save problem:" + this.markableFileName, 2);
                }
                return;
            }
            if (autoSaveMode) {
                System.err.print("Auto-Save: ");
            }
            System.err.println("Filename " + destinationFile.getAbsolutePath() + " exists, creating backup (.bak) file!");
            File oldDestinationFile = new File(String.valueOf(this.markableFileName) + ".bak");
            if (oldDestinationFile.exists()) {
                System.err.println("Removing old .bak file!");
                oldDestinationFile.delete();
                oldDestinationFile = new File(String.valueOf(this.markableFileName) + ".bak");
            }
            destinationFile.renameTo(oldDestinationFile);
        }
        if (autoSaveMode) {
            System.err.print("Auto-Save: ");
        }
        System.err.println("Writing to file " + this.markableFileName);
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.markableFileName), this.encoding));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.saveMarkables(fw, autoSaveMode);
        this.setIsDirty(false, false);
    }

    public final void initMarkableRelations() {
        Iterator<String> it;
        Set<String> allMarkableIDsSet;
        MMAX2Attribute[] currentAttributes = null;
        MMAX2Attribute currentAttribute = null;
        Markable currentMarkable = null;
        String currentAttributeName = null;
        String currentValue = "";
        currentAttributes = this.annotationscheme.getAttributesByType(5);
        int i = 0;
        while (i < currentAttributes.length) {
            currentAttribute = currentAttributes[i];
            currentAttributeName = currentAttribute.getLowerCasedAttributeName();
            MarkableRelation newRelation = new MarkableRelation(currentAttribute, currentAttribute.getType(), true, currentAttribute.getLineWidth(), currentAttribute.getLineColor(), currentAttribute.getLineStyle(), currentAttribute.getMaxSize(), currentAttribute.getIsDashed(), currentAttribute.getAttributeNameToShowInMarkablePointerFlag());
            this.MarkableSetRelations.put(currentAttributeName, newRelation);
            currentAttribute.setMarkableRelation(newRelation);
            newRelation = null;
            ++i;
        }
        Iterator<String> allAttributeNames = this.MarkableSetRelations.keySet().iterator();
        while (allAttributeNames.hasNext()) {
            MarkableRelation currentRelation = this.MarkableSetRelations.get(allAttributeNames.next());
            currentAttributeName = currentRelation.getAttributeName();
            allMarkableIDsSet = this.markableHash.keySet();
            it = allMarkableIDsSet.iterator();
            while (it.hasNext()) {
                currentMarkable = this.markableHash.get(it.next());
                currentValue = currentMarkable.getAttributeValue(currentAttributeName);
                if (currentValue == null || currentValue.equals("") || currentValue.equals(MMAX2.defaultRelationValue)) continue;
                currentRelation.addMarkableWithAttributeValueToMarkableSet(currentMarkable, currentValue);
                int currentNum = MMAX2Utils.parseID(currentValue);
                if (this.currentDiscourse.getCurrentMarkableChart().getNextFreeMarkableSetNum() > currentNum) continue;
                this.currentDiscourse.getCurrentMarkableChart().setNextFreeMarkableSetNum(currentNum + 1);
            }
        }
        currentAttributes = this.annotationscheme.getAttributesByType(6);
        int i2 = 0;
        while (i2 < currentAttributes.length) {
            currentAttribute = currentAttributes[i2];
            currentAttributeName = currentAttribute.getLowerCasedAttributeName();
            MarkableRelation newRelation = new MarkableRelation(currentAttribute, currentAttribute.getType(), true, currentAttribute.getLineWidth(), currentAttribute.getLineColor(), currentAttribute.getLineStyle(), currentAttribute.getMaxSize(), currentAttribute.getIsDashed(), currentAttribute.getAttributeNameToShowInMarkablePointerFlag());
            this.MarkablePointerRelations.put(currentAttributeName, newRelation);
            currentAttribute.setMarkableRelation(newRelation);
            newRelation = null;
            ++i2;
        }
        allAttributeNames = this.MarkablePointerRelations.keySet().iterator();
        while (allAttributeNames.hasNext()) {
            MarkableRelation currentRelation = this.MarkablePointerRelations.get(allAttributeNames.next());
            currentAttributeName = currentRelation.getAttributeName();
            allMarkableIDsSet = this.markableHash.keySet();
            it = allMarkableIDsSet.iterator();
            while (it.hasNext()) {
                currentMarkable = this.markableHash.get(it.next());
                currentValue = currentMarkable.getAttributeValue(currentAttributeName);
                if (currentValue == null || currentValue.equals("") || currentValue.equals(MMAX2.defaultRelationValue)) continue;
                currentRelation.createMarkablePointer(currentMarkable, this);
            }
        }
    }

    public final MarkableRelation[] getActiveMarkableSetRelationsForMarkable(Markable markable) {
        ArrayList<MarkableRelation> templist = new ArrayList<MarkableRelation>();
        MarkableRelation[] result = new MarkableRelation[]{};
        Iterator<String> allAttributeNames = this.MarkableSetRelations.keySet().iterator();
        while (allAttributeNames.hasNext()) {
            MarkableRelation currentRelation = this.MarkableSetRelations.get(allAttributeNames.next());
            String currentAttributeName = currentRelation.getAttributeName();
            if (markable.getAttributeValue(currentAttributeName) == null || markable.getAttributeValue(currentAttributeName).equals("") || markable.getAttributeValue(currentAttributeName).equals(MMAX2.defaultRelationValue)) continue;
            templist.add(currentRelation);
        }
        if (templist.size() != 0) {
            result = new MarkableRelation[templist.size()];
            result = templist.toArray(new MarkableRelation[1]);
        }
        return result;
    }

    public final MarkablePointer[] getActiveMarkablePointersForTargetMarkable(Markable markable, String pointerRelationName) {
        List<Object> templist = new ArrayList();
        MarkablePointer[] result = null;
        MarkableRelation requiredPointerRelation = this.MarkablePointerRelations.get(pointerRelationName);
        templist = Arrays.asList(requiredPointerRelation.getMarkablePointersWithTargetMarkable(markable));
        result = templist.size() != 0 ? templist.toArray(new MarkablePointer[0]) : new MarkablePointer[]{};
        return result;
    }

    public final MarkableRelation[] getActiveMarkablePointerRelationsForSourceMarkable(Markable markable) {
        ArrayList<MarkableRelation> templist = new ArrayList<MarkableRelation>();
        MarkableRelation[] result = new MarkableRelation[]{};
        for (MarkableRelation currentRelation : this.MarkablePointerRelations.values()) {
            String currentAttributeName = currentRelation.getAttributeName();
            if (markable.getAttributeValue(currentAttributeName) == null || markable.getAttributeValue(currentAttributeName).equals("") || markable.getAttributeValue(currentAttributeName).equals(MMAX2.defaultRelationValue)) continue;
            templist.add(currentRelation);
        }
        if (templist.size() != 0) {
            result = new MarkableRelation[templist.size()];
            result = templist.toArray(new MarkableRelation[1]);
        }
        return result;
    }

    public final List<MarkablePointer> getMarkablePointersForTargetMarkable(Markable markable) {
        ArrayList<MarkablePointer> result = new ArrayList<MarkablePointer>();
        Iterator<String> allAttributeNames = this.MarkablePointerRelations.keySet().iterator();
        while (allAttributeNames.hasNext()) {
            MarkableRelation currentRelation = this.MarkablePointerRelations.get(allAttributeNames.next());
            result.addAll(Arrays.asList(currentRelation.getMarkablePointersWithTargetMarkable(markable)));
        }
        return result;
    }

    public final void destroyDependentComponents() {
        Set<String> allMarkableIDsSet = this.markableHash.keySet();
        Iterator<String> it = allMarkableIDsSet.iterator();
        while (it.hasNext()) {
            this.markableHash.get(it.next()).destroyDependentComponents();
        }
        this.currentDiscourse = null;
        this.markableDOM = null;
        this.endedMarkablesAtDiscourseElement.clear();
        this.endedMarkablesAtDiscourseElement = null;
        this.startedMarkablesAtDiscourseElement.clear();
        this.startedMarkablesAtDiscourseElement = null;
        this.markableHash.clear();
        this.markableHash = null;
        this.markablesAtDiscourseElement.clear();
        this.markablesAtDiscourseElement = null;
        this.markablesAtDiscoursePosition = null;
        this.renderer.destroyDependentComponents();
        this.renderer = null;
        this.moveUp.removeActionListener(this);
        this.moveUp = null;
        this.moveDown.removeActionListener(this);
        this.moveDown = null;
        this.updateCustomization.removeActionListener(this);
        this.updateCustomization = null;
        this.activatorComboBox.removeActionListener(this);
        this.activatorComboBox = null;
        this.switchCustomizations.removeActionListener(this);
        this.switchCustomizations = null;
        this.MarkableSetRelations.clear();
        this.MarkableSetRelations = null;
        this.MarkablePointerRelations.clear();
        this.MarkablePointerRelations = null;
        this.annotationscheme.destroyDependentComponents();
        this.annotationscheme = null;
        System.gc();
    }

    public final MMAX2AnnotationScheme getCurrentAnnotationScheme() {
        return this.annotationscheme;
    }

    protected final void resetMarkablesForStyleSheetReapplication() {
        Set<String> allMarkableIDsSet = this.markableHash.keySet();
        Iterator<String> it = allMarkableIDsSet.iterator();
        while (it.hasNext()) {
            this.markableHash.get(it.next()).resetHandles();
        }
    }

    public final int getMarkableCount() {
        return this.markableHash.size();
    }

    public final JLabel getNameLabel() {
        return this.nameLabel;
    }

    public final JComboBox getActivatorComboBox() {
        return this.activatorComboBox;
    }

    public final JCheckBox getSwitchCheckBox() {
        return this.switchCustomizations;
    }

    public final BasicArrowButton getMoveUpButton() {
        return this.moveUp;
    }

    public final BasicArrowButton getMoveDownButton() {
        return this.moveDown;
    }

    public final JButton getUpdateButton() {
        return this.updateCustomization;
    }

    public final JButton getValidateButton() {
        return this.validateButton;
    }

    public final JButton getDeleteButton() {
        return this.deleteAllButton;
    }

    public final void setPosition(int pos) {
        this.position = pos;
        this.moveUp.setActionCommand("up:" + pos);
        this.moveDown.setActionCommand("down:" + pos);
    }

    public final int getPosition() {
        return this.position;
    }

    public final String getMarkableFileName() {
        return this.markableFileName;
    }

    public final String getAbsoluteMarkableFileName() {
        File temp = new File(this.markableFileName);
        return temp.getAbsolutePath();
    }

    @Override
    public final String getMarkableLevelName() {
        return this.markableLevelName;
    }

    public final String getMatchableMarkableLevelName() {
        return this.matchableLevelName;
    }

    public final MarkableLevelRenderer getRenderer() {
        return this.renderer;
    }

    public final boolean getIsActive() {
        return this.active;
    }

    public final boolean getIsVisible() {
        return this.visible;
    }

    public final boolean getHasHandles() {
        return this.hasHandles;
    }

    public final void setHasHandles(boolean status) {
        this.hasHandles = status;
    }

    public final List<Markable> getMarkables() {
        return new ArrayList<Markable>(this.markableHash.values());
    }

    public final List<Markable> getMarkables(Comparator<Markable> comp) {
        ArrayList<Markable> temp = new ArrayList<Markable>(this.markableHash.values());
        if (comp != null) {
            Collections.sort(temp, comp);
        }
        return temp;
    }

    public final void updateMarkables() {
        this.startedMarkablesAtDiscourseElement = null;
        this.startedMarkablesAtDiscourseElement = new HashMap<String, Markable[]>();
        this.endedMarkablesAtDiscourseElement = null;
        this.endedMarkablesAtDiscourseElement = new HashMap<String, Markable[]>();
        this.markablesAtDiscourseElement = null;
        this.markablesAtDiscourseElement = new HashMap<String, Markable[]>();
        NodeList allMarkableNodes = this.markableDOM.getElementsByTagName("markable");
        Node currentMarkableNode = null;
        int len = allMarkableNodes.getLength();
        String currentID = "";
        String currentSpan = "";
        Markable currentMarkable = null;
        int z = 0;
        while (z < len) {
            currentMarkableNode = allMarkableNodes.item(z);
            currentID = currentMarkableNode.getAttributes().getNamedItem("id").getNodeValue();
            currentMarkable = this.getMarkableByID(currentID);
            currentSpan = MarkableHelper.getSpan(currentMarkable);
            currentMarkable.update(MarkableLevel.parseMarkableSpan(currentSpan, this.currentDiscourse.getWordDOM(), this));
            ++z;
        }
    }

    public final void createMarkables() {
        boolean readOnlyAtStart = this.getIsReadOnly();
        int maxIDNum = 0;
        boolean added = false;
        if (this.isDefined()) {
            NodeList allMarkableNodes = this.markableDOM.getElementsByTagName("markable");
            Node currentMarkableNode = null;
            int len = allMarkableNodes.getLength();
            this.markableHash = new HashMap<String, Markable>(len);
            String currentID = "";
            int currentIDNum = 0;
            String currentSpan = "";
            Markable newMarkable = null;
            Map<String, String> attributes = null;
            int z = 0;
            while (z < len) {
                currentMarkableNode = allMarkableNodes.item(z);
                if (currentMarkableNode.getAttributes().getNamedItem("mmax_level") == null) {
                    added = true;
                    ((Element)currentMarkableNode).setAttribute("mmax_level", this.getMarkableLevelName());
                    this.setIsDirty(true, false);
                }
                if ((currentIDNum = MMAX2Utils.parseID((attributes = MMAX2Utils.convertNodeMapToHashMap(currentMarkableNode.getAttributes())).get("id"))) > maxIDNum) {
                    maxIDNum = currentIDNum;
                }
                attributes.remove("id");
                attributes.remove("span");
                try {
                    currentID = currentMarkableNode.getAttributes().getNamedItem("id").getNodeValue();
                }
                catch (NullPointerException ex) {
                    JOptionPane.showMessageDialog(null, "Missing ID attribute on markable!", "MarkableLevel: " + this.markableFileName, 0);
                }
                try {
                    currentSpan = currentMarkableNode.getAttributes().getNamedItem("span").getNodeValue();
                }
                catch (NullPointerException ex) {
                    JOptionPane.showMessageDialog(null, "Missing span attribute on markable!", "MarkableLevel: " + this.markableFileName, 0);
                }
                newMarkable = new Markable(currentMarkableNode, currentID, MarkableLevel.parseMarkableSpan(currentSpan, this.currentDiscourse.getWordDOM(), this), attributes, this);
                this.markableHash.put(currentID, newMarkable);
                newMarkable = null;
                ++z;
            }
        } else {
            this.markableHash = new HashMap<String, Markable>();
        }
        if (added) {
            JOptionPane.showMessageDialog(null, "The attribute 'mmax_level' has been added to at least one markable on level " + this.getMarkableLevelName() + "!\nPlease make sure to save this level later.", "Markable level has been modified!", 1);
        }
        if (!readOnlyAtStart && this.getIsReadOnly()) {
            System.err.println("Level " + this.getMarkableLevelName() + " has been set to read-only!");
        }
        if (this.currentDiscourse.getCurrentMarkableChart().getNextFreeMarkableIDNum() <= maxIDNum) {
            this.currentDiscourse.getCurrentMarkableChart().setNextFreeMarkableIDNum(maxIDNum + 1);
        }
    }

    public void setCurrentDiscourse(MMAX2Discourse _discourse) {
        this.currentDiscourse = _discourse;
    }

    public MMAX2Discourse getCurrentDiscourse() {
        return this.currentDiscourse;
    }

    public Markable getMarkableByID(String markableId) {
        return this.markableHash.get(markableId);
    }

    public final Markable[] getAllMarkablesStartingWith(MMAX2DiscourseElementSequence sequence) {
        MMAX2DiscourseElement[] elements = sequence.getContent();
        ArrayList<Markable> temp = new ArrayList<Markable>();
        int lastDiscPosInElements = elements[elements.length - 1].getDiscoursePosition();
        Markable[] started = this.getAllMarkablesStartedByDiscourseElement(elements[0].getID());
        int z = 0;
        while (z < started.length) {
            int currentFinalDiscPos = started[z].getRightmostDiscoursePosition();
            if (currentFinalDiscPos <= lastDiscPosInElements) {
                temp.add(started[z]);
            }
            ++z;
        }
        return temp.toArray(new Markable[0]);
    }

    public final Markable getSingleLongestMarkableStartingWith(MMAX2DiscourseElementSequence sequence) {
        Markable result = null;
        Markable[] candidates = this.getAllMarkablesStartingWith(sequence);
        if (candidates.length == 1) {
            result = candidates[0];
        } else if (candidates.length > 0) {
            Arrays.sort(candidates, new DiscourseOrderMarkableComparator());
            if (candidates[candidates.length - 1].getSize() != candidates[candidates.length - 2].getSize()) {
                result = candidates[candidates.length - 1];
            }
        }
        if (result != null && result.getSize() < sequence.getLength()) {
            result = null;
        }
        return result;
    }

    public Markable[] getAllMarkablesAtDiscourseElement(String discourseElementId, boolean sort) {
        Markable[] result = this.markablesAtDiscourseElement.get(discourseElementId);
        if (result == null) {
            result = new Markable[]{};
        }
        if (sort) {
            Arrays.sort(result, MMAX2Discourse.DISCOURSEORDERCOMP);
        }
        return result;
    }

    public List<Markable> getMarkablesAtDiscourseElementID(String discourseElementId, Comparator<Markable> comp) {
        Markable[] result = this.markablesAtDiscourseElement.get(discourseElementId);
        if (result == null) {
            result = new Markable[]{};
        }
        if (comp != null) {
            Arrays.sort(result, comp);
        }
        return new ArrayList<Markable>(Arrays.asList(result));
    }

    public List<Markable> getMarkablesAtDiscoursePosition(int discPos, Comparator<Markable> comp) {
        String discourseElementId = this.getCurrentDiscourse().getDiscourseElementIDAtDiscoursePosition(discPos);
        Markable[] result = this.markablesAtDiscourseElement.get(discourseElementId);
        if (result == null) {
            result = new Markable[]{};
        }
        if (comp != null) {
            Arrays.sort(result, comp);
        }
        return new ArrayList<Markable>(Arrays.asList(result));
    }

    @Override
    public Markable[] getAllMarkablesStartedByDiscourseElement(String discourseElementId) {
        Markable[] result = null;
        result = this.startedMarkablesAtDiscourseElement.get(discourseElementId);
        if (result == null) {
            result = new Markable[]{};
        }
        return result;
    }

    public Markable getSingleMarkableExactlyAtDiscourseElement(String discourseElementId) {
        Markable result = null;
        Markable[] started = this.getAllMarkablesStartedByDiscourseElement(discourseElementId);
        Markable[] ended = this.getAllMarkablesEndedByDiscourseElement(discourseElementId);
        ArrayList<Markable> startedAsList = new ArrayList<Markable>(Arrays.asList(started));
        startedAsList.retainAll(Arrays.asList(ended));
        if (startedAsList.size() == 1) {
            result = (Markable)startedAsList.get(0);
        }
        return result;
    }

    @Override
    public Markable[] getAllMarkablesEndedByDiscourseElement(String discourseElementId) {
        Markable[] result = null;
        result = this.endedMarkablesAtDiscourseElement.get(discourseElementId);
        if (result == null) {
            result = new Markable[]{};
        } else {
            Arrays.sort(result, MMAX2Discourse.IDCOMP);
            Arrays.sort(result, MMAX2Discourse.ENDCOMP);
        }
        return result;
    }

    @Override
    public Markable[] getAllMarkablesAtDiscoursePosition(int pos) {
        return this.markablesAtDiscoursePosition[pos];
    }

    public final void getAllStartedMarkablesAsNodes(String discourseElementId, NodeSet result) {
        Markable[] temp = this.getAllMarkablesStartedByDiscourseElement(discourseElementId);
        if (temp != null) {
            Arrays.sort(temp, MMAX2Discourse.STARTCOMP);
            int len = temp.length;
            int o = 0;
            while (o < len) {
                result.addNode(temp[o].getNodeRepresentation());
                ++o;
            }
        }
    }

    public final void getAllEndedMarkablesAsNodes(String discourseElementId, NodeSet result) {
        Markable[] temp = this.getAllMarkablesEndedByDiscourseElement(discourseElementId);
        if (temp != null) {
            Arrays.sort(temp, MMAX2Discourse.ENDCOMP);
            int len = temp.length;
            int o = 0;
            while (o < len) {
                result.addNode(temp[o].getNodeRepresentation());
                ++o;
            }
        }
    }

    public final void unregisterMarkable(Markable unregisteree) {
        String[][] frags = unregisteree.getFragments();
        String[] currentFragment = null;
        int singleFragments = frags.length;
        int z = 0;
        while (z < singleFragments) {
            currentFragment = frags[z];
            this.unregisterMarkableAtStartOfFragment(unregisteree, currentFragment[0]);
            this.unregisterMarkableAtEndOfFragment(unregisteree, currentFragment[currentFragment.length - 1]);
            int o = 0;
            while (o < currentFragment.length) {
                this.unregisterMarkableAtDiscourseElement(unregisteree, currentFragment[o]);
                ++o;
            }
            ++z;
        }
    }

    public final void unregisterMarkableAtDiscourseElement(Markable unregisteree, String de) {
        Markable[] markables = this.getAllMarkablesAtDiscourseElement(de, false);
        Markable[] newMapping = new Markable[markables.length - 1];
        int filler = 0;
        int u = 0;
        while (u < markables.length) {
            if (markables[u] == unregisteree) {
                filler = 1;
            } else {
                newMapping[u - filler] = markables[u];
            }
            ++u;
        }
        this.markablesAtDiscourseElement.remove(de);
        if (newMapping.length > 0) {
            this.markablesAtDiscourseElement.put(de, newMapping);
        }
        this.updateDiscoursePositionToMarkableMapping(de);
    }

    public final void unregisterMarkableAtStartOfFragment(Markable unregisteree, String de) {
        Markable[] markables = this.getAllMarkablesStartedByDiscourseElement(de);
        Markable[] newMapping = new Markable[markables.length - 1];
        int filler = 0;
        int u = 0;
        while (u < markables.length) {
            if (markables[u] == unregisteree) {
                filler = 1;
            } else {
                newMapping[u - filler] = markables[u];
            }
            ++u;
        }
        this.startedMarkablesAtDiscourseElement.remove(de);
        if (newMapping.length > 0) {
            this.startedMarkablesAtDiscourseElement.put(de, newMapping);
        }
    }

    public final void unregisterMarkableAtEndOfFragment(Markable unregisteree, String de) {
        Markable[] markables = this.getAllMarkablesEndedByDiscourseElement(de);
        Markable[] newMapping = new Markable[markables.length - 1];
        int filler = 0;
        int u = 0;
        while (u < markables.length) {
            if (markables[u] == unregisteree) {
                filler = 1;
            } else {
                newMapping[u - filler] = markables[u];
            }
            ++u;
        }
        this.endedMarkablesAtDiscourseElement.remove(de);
        if (newMapping.length > 0) {
            this.endedMarkablesAtDiscourseElement.put(de, newMapping);
        }
    }

    public final void registerMarkableAtStartOfFragment(String discourseElementId, Markable markable) {
        Markable[] markables = this.getAllMarkablesStartedByDiscourseElement(discourseElementId);
        Markable[] mapping = null;
        if (markables == null) {
            mapping = new Markable[]{markable};
        } else {
            mapping = new Markable[markables.length + 1];
            System.arraycopy(markables, 0, mapping, 0, markables.length);
            mapping[markables.length] = markable;
            this.startedMarkablesAtDiscourseElement.remove(discourseElementId);
        }
        this.startedMarkablesAtDiscourseElement.put(discourseElementId, mapping);
    }

    public final void registerMarkableAtEndOfFragment(String discourseElementId, Markable markable) {
        Markable[] markables = this.getAllMarkablesEndedByDiscourseElement(discourseElementId);
        Markable[] mapping = null;
        if (markables == null) {
            mapping = new Markable[]{markable};
        } else {
            mapping = new Markable[markables.length + 1];
            System.arraycopy(markables, 0, mapping, 0, markables.length);
            mapping[markables.length] = markable;
            this.endedMarkablesAtDiscourseElement.remove(discourseElementId);
        }
        this.endedMarkablesAtDiscourseElement.put(discourseElementId, mapping);
    }

    public final void registerMarkableAtDiscourseElement(String discourseElementId, Markable markable) {
        Markable[] markables = this.getAllMarkablesAtDiscourseElement(discourseElementId, false);
        Markable[] mapping = null;
        if (markables == null) {
            mapping = new Markable[]{markable};
        } else {
            mapping = new Markable[markables.length + 1];
            System.arraycopy(markables, 0, mapping, 0, markables.length);
            mapping[markables.length] = markable;
            this.markablesAtDiscourseElement.remove(discourseElementId);
        }
        this.markablesAtDiscourseElement.put(discourseElementId, mapping);
    }

    public final void setMarkableDisplayPositions() {
        Set<String> allMarkableIDsSet = this.markableHash.keySet();
        Iterator<String> it = allMarkableIDsSet.iterator();
        while (it.hasNext()) {
            MarkableHelper.setDisplayPositions(this.markableHash.get(it.next()));
        }
    }

    public final void createDiscoursePositionToMarkableMapping() {
        this.markablesAtDiscoursePosition = new Markable[this.getCurrentDiscourse().getDiscourseElementCount()][0];
        int tempDiscPos = 0;
        String tempDE = "";
        String[] allDEs = this.markablesAtDiscourseElement.keySet().toArray(new String[0]);
        int numDEs = allDEs.length;
        int z = 0;
        while (z < numDEs) {
            tempDE = allDEs[z];
            tempDiscPos = this.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(tempDE);
            if (tempDiscPos != -1) {
                this.markablesAtDiscoursePosition[tempDiscPos] = this.getAllMarkablesAtDiscourseElement(tempDE, true);
            }
            ++z;
        }
    }

    public final void updateDiscoursePositionToMarkableMapping(String tempDE) {
        int tempDiscPos = this.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(tempDE);
        this.markablesAtDiscoursePosition[tempDiscPos] = this.getAllMarkablesAtDiscourseElement(tempDE, true);
    }

    protected final void updateNameLabelText() {
        boolean doit = false;
        String HTMLText = "";
        try {
            doit = this.currentDiscourse.getMMAX2().getUseFancyLabels();
        }
        catch (NullPointerException ex) {
            doit = true;
        }
        if (doit) {
            HTMLText = !this.renderer.getForegroundIsTransparent() ? "<html><font face=\"monospace\" color=\"" + MMAX2Utils.colorToHTML(this.renderer.getForegroundColor()) + "\">" : "<html><font face=\"monospace\">";
            if (this.getHasHandles()) {
                HTMLText = String.valueOf(HTMLText) + "<font color=\"" + MMAX2Utils.colorToHTML(this.renderer.getHandleColor()) + "\"><b>[</b></font>";
            }
            if (this.renderer.getIsBold()) {
                HTMLText = String.valueOf(HTMLText) + "<b>";
            }
            if (this.renderer.getIsItalic()) {
                HTMLText = String.valueOf(HTMLText) + "<i>";
            }
            if (this.renderer.getIsSuperscript()) {
                HTMLText = String.valueOf(HTMLText) + "<sup>";
            }
            if (this.renderer.getIsSubscript()) {
                HTMLText = String.valueOf(HTMLText) + "<sub>";
            }
            if (this.renderer.getIsUnderline()) {
                HTMLText = String.valueOf(HTMLText) + "<u>";
            }
            if (this.renderer.getIsStrikethrough()) {
                HTMLText = String.valueOf(HTMLText) + "<strike>";
            }
            HTMLText = String.valueOf(HTMLText) + this.getMarkableLevelName();
            if (this.renderer.getIsStrikethrough()) {
                HTMLText = String.valueOf(HTMLText) + "</strike>";
            }
            if (this.renderer.getIsUnderline()) {
                HTMLText = String.valueOf(HTMLText) + "</u>";
            }
            if (this.renderer.getIsSubscript()) {
                HTMLText = String.valueOf(HTMLText) + "</sub>";
            }
            if (this.renderer.getIsSuperscript()) {
                HTMLText = String.valueOf(HTMLText) + "</sup>";
            }
            if (this.renderer.getIsItalic()) {
                HTMLText = String.valueOf(HTMLText) + "</i>";
            }
            if (this.renderer.getIsBold()) {
                HTMLText = String.valueOf(HTMLText) + "</b>";
            }
            if (this.getHasHandles()) {
                HTMLText = String.valueOf(HTMLText) + "<font color=\"" + MMAX2Utils.colorToHTML(this.renderer.getHandleColor()) + "\"><b>]</b></font>";
            }
            HTMLText = String.valueOf(HTMLText) + "<font></html>";
            this.nameLabel.setText(HTMLText);
            this.nameLabel.setOpaque(true);
        } else {
            this.nameLabel.setText(this.getMarkableLevelName());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command.equals("activator")) {
            JComboBox control = (JComboBox)actionEvent.getSource();
            String val = control.getSelectedItem().toString();
            if (val.equalsIgnoreCase("inactive")) {
                this.setInactive();
            } else if (val.equalsIgnoreCase("visible")) {
                this.setVisible();
            } else if (val.equalsIgnoreCase("active")) {
                this.setActive();
            }
            if (this.getCurrentDiscourse().getMMAX2().getAutoRefreshUponPanelAction()) {
                this.getCurrentDiscourse().getCurrentMarkableChart().rerender();
            }
        } else if (command.equals("update")) {
            this.renderer.updateSimpleMarkableCustomizations(true);
            this.getCurrentDiscourse().getCurrentMarkableChart().rerender();
        } else if (command.equals("switch")) {
            this.renderer.updateSimpleMarkableCustomizations(((JCheckBox)actionEvent.getSource()).isSelected());
            this.updateCustomization.setEnabled(((JCheckBox)actionEvent.getSource()).isSelected());
            this.getCurrentDiscourse().getCurrentMarkableChart().rerender();
        } else if (command.equals("validate")) {
            int result = JOptionPane.showConfirmDialog(null, "This will start the validation of " + this.getMarkableCount() + " markables!\nAre you sure?", this.getMarkableLevelName(), 0);
            if (result == 0) {
                this.validate();
            }
        } else if (command.equals("delete_all")) {
            int result = JOptionPane.showConfirmDialog(null, "This will delete " + this.getMarkableCount() + " markables!\nAre you sure?", this.getMarkableLevelName(), 0);
            if (result == 0) {
                this.deleteAllMarkables();
                if (this.mmax2 != null) {
                    this.mmax2.requestRefreshDisplay();
                    this.mmax2.requestReapplyDisplay();
                }
            }
        } else if (command.equals("save_this_level")) {
            this.saveMarkables("", false);
            this.setIsDirty(false, false);
        } else {
            this.getCurrentDiscourse().getCurrentMarkableChart().reorderMarkableLayers(command);
            if (this.getCurrentDiscourse().getMMAX2().getAutoRefreshUponPanelAction()) {
                this.getCurrentDiscourse().getCurrentMarkableChart().rerender();
            }
        }
    }

    public final void setActive() {
        this.activatorComboBox.removeActionListener(this);
        this.active = true;
        System.err.println("Layer " + this.markableLevelName + " has been set to active");
        this.nameLabel.setEnabled(true);
        this.visible = true;
        this.switchCustomizations.setEnabled(true);
        if (this.switchCustomizations.isSelected()) {
            this.updateCustomization.setEnabled(true);
        }
        this.deleteAllButton.setEnabled(true);
        this.validateButton.setEnabled(true);
        this.activatorComboBox.setSelectedItem("active");
        this.activatorComboBox.addActionListener(this);
    }

    public final void setInactive() {
        this.activatorComboBox.removeActionListener(this);
        this.active = false;
        System.err.println("Layer " + this.markableLevelName + " has been set to inactive");
        this.nameLabel.setEnabled(false);
        this.visible = false;
        this.switchCustomizations.setEnabled(false);
        this.updateCustomization.setEnabled(false);
        this.deleteAllButton.setEnabled(false);
        this.validateButton.setEnabled(false);
        this.activatorComboBox.setSelectedItem("inactive");
        this.activatorComboBox.addActionListener(this);
    }

    public final void setVisible() {
        this.activatorComboBox.removeActionListener(this);
        this.active = false;
        System.err.println("Layer " + this.markableLevelName + " has been set to visible!");
        this.nameLabel.setEnabled(false);
        this.visible = true;
        this.switchCustomizations.setEnabled(true);
        if (this.switchCustomizations.isSelected()) {
            this.updateCustomization.setEnabled(true);
        }
        this.deleteAllButton.setEnabled(false);
        this.validateButton.setEnabled(false);
        this.activatorComboBox.setSelectedItem("visible");
        this.activatorComboBox.addActionListener(this);
    }

    private static final String[][] parseMarkableSpan(String span, DocumentImpl dom, MarkableLevel _level) {
        String currentspan = "";
        ArrayList<String[]> spanlist = new ArrayList<String[]>();
        String[] fragArray = null;
        int spanlen = span.length();
        int i = 0;
        while (i < spanlen) {
            if (span.charAt(i) != ',') {
                currentspan = String.valueOf(currentspan) + span.charAt(i);
            } else {
                currentspan.trim();
                fragArray = MarkableLevel.parseMarkableSpanFragmentToArray(currentspan, dom, _level);
                spanlist.add(fragArray);
                currentspan = "";
                fragArray = null;
            }
            ++i;
        }
        currentspan.trim();
        fragArray = MarkableLevel.parseMarkableSpanFragmentToArray(currentspan, dom, _level);
        spanlist.add(fragArray);
        currentspan = "";
        fragArray = null;
        return (String[][])spanlist.toArray((T[])new String[1][1]);
    }

    private static final String[] parseMarkableSpanFragmentToArray(String span, DocumentImpl dom, MarkableLevel _level) {
        ArrayList<String> newWordsIDList = new ArrayList<String>();
        if (span.indexOf("..") == -1) {
            newWordsIDList.add(span);
        } else {
            String firstIDString = span.substring(0, span.indexOf(".."));
            String lastIDString = span.substring(span.lastIndexOf("..") + 2);
            double lastIDValue = Double.parseDouble(lastIDString.substring(lastIDString.indexOf("_") + 1));
            Node currentNode = MarkableLevel.getWordNodeOrClosestSuccessor(dom, firstIDString);
            if (currentNode == null) {
                String message = "A markable on level " + _level.getMarkableLevelName() + " references an element with id " + firstIDString + ",\n";
                message = String.valueOf(message) + "but an element with ID " + firstIDString + " could not be found!\n";
                message = String.valueOf(message) + "This is a serious error, and might be caused by a missing DTD declaration in the word file.";
                JOptionPane.showMessageDialog(null, message, "ID not found !", 0);
                System.exit(0);
            }
            newWordsIDList.add(firstIDString);
            Node nextNode = null;
            while ((nextNode = currentNode.getNextSibling()) != null) {
                if (nextNode.getNodeType() != 1) {
                    currentNode = nextNode;
                    continue;
                }
                newWordsIDList.add(nextNode.getAttributes().getNamedItem("id").getNodeValue());
                String justAddedID = nextNode.getAttributes().getNamedItem("id").getNodeValue();
                double justAddedValue = Double.parseDouble(justAddedID.substring(justAddedID.indexOf("_") + 1));
                if (justAddedID.equalsIgnoreCase(lastIDString)) break;
                if (justAddedValue > lastIDValue) {
                    newWordsIDList.remove(newWordsIDList.size() - 1);
                    break;
                }
                currentNode = nextNode;
            }
        }
        return newWordsIDList.toArray(new String[0]);
    }

    private static final Node getWordNodeOrClosestSuccessor(DocumentImpl dom, String id) {
        Node result = null;
        result = dom.getElementById(id);
        if (result == null) {
            int requiredID = Integer.parseInt(id.substring(id.indexOf("_") + 1));
            Node node = dom.getDocumentElement();
            node = node.getFirstChild();
            while (true) {
                Node tmpnode;
                if (node != null && node.getNodeType() == 1 && node.getAttributes() != null) {
                    String currentIDString;
                    int currentIDNum;
                    if (node.getAttributes() != null && node.getAttributes().getNamedItem("id") != null && (currentIDNum = Integer.parseInt((currentIDString = node.getAttributes().getNamedItem("id").getNodeValue()).substring(currentIDString.indexOf("_") + 1))) >= requiredID) {
                        result = node;
                        break;
                    }
                } else if (node == null) break;
                node = tmpnode = node.getNextSibling();
            }
        }
        return result;
    }

    public String getMarkableLevelLocalizedName() {
        return this.localizedName;
    }
}

