/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pl.waw.ipipan.zil.core.mmax4ref.Messages;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2AnnotationScheme;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2AttributeValue;
import pl.waw.ipipan.zil.core.mmax4ref.api.AttributeAPI;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.gui.windows.MMAX2AttributePanel;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Utils;

public class MMAX2Attribute
extends JPanel
implements ActionListener,
DocumentListener,
AttributeAPI {
    private static final long serialVersionUID = 4215757727670566210L;
    private static final Logger logger = Logger.getLogger(MMAX2Attribute.class);
    private final String ID;
    private final String localizedAttributeName;
    private final String displayAttributeName;
    private final String lowerCasedAttributeName;
    private boolean frozen = false;
    public int size;
    private MMAX2AnnotationScheme annotationscheme;
    private final int type;
    private String toShowInFlag = "";
    private final int lineWidth;
    private final Color lineColor;
    private final int lineStyle;
    private final int maxSize;
    private final boolean dashed;
    private final String add_to_markableset_instruction;
    private final String remove_from_markableset_instruction;
    private final String adopt_into_markableset_instruction;
    private final String merge_into_markableset_instruction;
    private final String point_to_markable_instruction;
    private final String remove_pointer_to_markable_instruction;
    private MarkableRelation markableRelation;
    private final String targetDomain;
    private final JRadioButton invisibleButton;
    public List<String> buttonIndicesToLowerCasedValueStrings;
    private final List<JRadioButton> buttons;
    private final List<String> nextAttributes;
    public Hashtable<String, Integer> lowerCasedValueStringsToButtonIndices;
    private ButtonGroup group = null;
    public JComboBox listSelector = null;
    private JTextArea freetextArea;
    private JScrollPane scrollPane;
    private JLabel idLabel;
    private final JLabel attributeLabel;
    public boolean isBranching = false;
    public boolean readOnly = false;
    private final String tooltiptext;
    public String oldValue = "";
    private int currentIndex = -1;
    private final String noneAvailableForValue = "<no hint available for this value>";
    private final List<MMAX2Attribute> dependsOn = new ArrayList<MMAX2Attribute>();
    private final List<String> orderedValues = new ArrayList<String>();
    private static String localizedEmptyRelName = Messages.getString("MMAX2Attribute.empty");

    public MMAX2Attribute(String id, String attributeName, int _type, NodeList allChildren, MMAX2AnnotationScheme currentScheme, int width, String tiptext, String hintText, int _lineWidth, Color _color, int _lineStyle, int _maxSize, String _targetDomain, String _add_instruction, String _remove_instruction, String _adopt_instruction, String _merge_instruction, String _point_to_markable_instruction, String _remove_pointer_to_markable_instruction, float fontSize, boolean _dashed, String _toShowInFlag, String localizedName) {
        this.setAlignmentX(0.0f);
        this.toShowInFlag = _toShowInFlag;
        this.dashed = _dashed;
        this.type = _type;
        this.tooltiptext = tiptext;
        this.ID = id;
        this.displayAttributeName = attributeName;
        this.lowerCasedAttributeName = attributeName.toLowerCase();
        this.localizedAttributeName = localizedName;
        this.size = 0;
        this.annotationscheme = currentScheme;
        this.lineWidth = _lineWidth;
        this.lineColor = _color;
        this.lineStyle = _lineStyle;
        this.maxSize = _maxSize;
        this.targetDomain = _targetDomain;
        this.add_to_markableset_instruction = _add_instruction;
        this.remove_from_markableset_instruction = _remove_instruction;
        this.adopt_into_markableset_instruction = _adopt_instruction;
        this.merge_into_markableset_instruction = _merge_instruction;
        this.point_to_markable_instruction = _point_to_markable_instruction;
        this.remove_pointer_to_markable_instruction = _remove_pointer_to_markable_instruction;
        this.nextAttributes = new ArrayList<String>();
        String filler = "";
        int q = 0;
        while (q < width + 3) {
            filler = String.valueOf(filler) + " ";
            ++q;
        }
        this.attributeLabel = new JLabel(this.localizedAttributeName);
        this.attributeLabel.setLayout(new FlowLayout(3, 0, 0));
        this.attributeLabel.setForeground(Color.darkGray);
        if (!this.tooltiptext.equals("")) {
            this.attributeLabel.setToolTipText(this.tooltiptext);
        }
        this.setAlignmentX(0.0f);
        this.setLayout(new FlowLayout(3, 0, 0));
        Box innerBox = Box.createHorizontalBox();
        Box labelBox = Box.createVerticalBox();
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new FlowLayout(3, 0, 0));
        JPanel buttonBox = new JPanel();
        this.attributeLabel.setLayout(new FlowLayout(3, 0, 0));
        labelPanel.add(this.attributeLabel);
        labelBox.add(Box.createHorizontalStrut(120));
        labelBox.add(labelPanel);
        innerBox.add(labelBox);
        Node currentNode = null;
        String nextValue = "";
        String currentValue = "";
        String tempText = "";
        JRadioButton currentButton = null;
        this.invisibleButton = new JRadioButton();
        this.group = new ButtonGroup();
        this.group.add(this.invisibleButton);
        this.buttonIndicesToLowerCasedValueStrings = new ArrayList<String>();
        this.buttons = new ArrayList<JRadioButton>();
        this.lowerCasedValueStringsToButtonIndices = new Hashtable();
        int z = 0;
        while (z < allChildren.getLength()) {
            currentNode = allChildren.item(z);
            if (currentNode.getNodeType() == 1) {
                NodeList valueChildren2;
                try {
                    tempText = currentNode.getAttributes().getNamedItem("text").getNodeValue();
                }
                catch (NullPointerException ex) {
                    tempText = "";
                }
                String descFileName = "";
                try {
                    descFileName = currentNode.getAttributes().getNamedItem("description").getNodeValue();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (!descFileName.equals("")) {
                    String schemeFileName = this.annotationscheme.getSchemeFileName();
                    tempText = MMAX2AnnotationScheme.readHTMLFromFile(String.valueOf(schemeFileName.substring(0, schemeFileName.lastIndexOf(File.separator) + 1)) + descFileName);
                }
                if (tempText.equals("") && (valueChildren2 = currentNode.getChildNodes()) != null) {
                    int q2 = 0;
                    while (q2 < valueChildren2.getLength()) {
                        Node valueChild = valueChildren2.item(q2);
                        if (valueChild.getNodeName().equalsIgnoreCase("longtext")) {
                            try {
                                tempText = "<html>" + valueChild.getFirstChild().getNodeValue() + "</html>";
                            }
                            catch (NumberFormatException ex) {
                                tempText = "";
                            }
                            break;
                        }
                        ++q2;
                    }
                }
                if (tempText.equals("")) {
                    try {
                        tempText = currentNode.getAttributes().getNamedItem("id").getNodeValue();
                    }
                    catch (NullPointerException valueChildren2) {
                        // empty catch block
                    }
                }
                if (!tempText.equals("")) {
                    tempText = tempText.replaceAll("\\{", "<");
                    tempText = tempText.replaceAll("\\}", ">");
                }
                String currentText = tempText;
                try {
                    currentValue = currentNode.getAttributes().getNamedItem("name").getNodeValue();
                }
                catch (NullPointerException ex) {
                    System.out.println("Error: No 'name' attribute for <value> " + currentNode);
                }
                this.orderedValues.add(currentValue);
                if (this.type == 1) {
                    currentButton = null;
                    currentButton = new JRadioButton(currentValue);
                    if (currentText.equals("<no hint available for this value>")) {
                        currentButton.setToolTipText(currentText);
                    }
                    currentButton.addActionListener(this);
                    this.buttonIndicesToLowerCasedValueStrings.add(currentValue);
                    this.lowerCasedValueStringsToButtonIndices.put(new String(currentValue), new Integer(this.size));
                    currentButton.setActionCommand(new String(String.valueOf(this.size)));
                    this.buttons.add(currentButton);
                    try {
                        nextValue = currentNode.getAttributes().getNamedItem("next").getNodeValue();
                    }
                    catch (NullPointerException ex) {
                        nextValue = "";
                    }
                    if (!nextValue.equals("")) {
                        this.isBranching = true;
                    }
                    this.group.add(currentButton);
                    buttonBox.add(currentButton);
                    this.nextAttributes.add(nextValue);
                    ++this.size;
                } else if (this.type == 2) {
                    if (this.listSelector == null) {
                        this.listSelector = new JComboBox();
                    }
                    this.buttonIndicesToLowerCasedValueStrings.add(currentValue);
                    this.lowerCasedValueStringsToButtonIndices.put(new String(currentValue), new Integer(this.size));
                    this.listSelector.addItem(currentValue);
                    try {
                        nextValue = currentNode.getAttributes().getNamedItem("next").getNodeValue();
                    }
                    catch (NullPointerException ex) {
                        nextValue = "";
                    }
                    if (!nextValue.equals("")) {
                        this.isBranching = true;
                    }
                    if (this.listSelector.getItemCount() == 1) {
                        buttonBox.add(this.listSelector);
                    }
                    this.nextAttributes.add(nextValue);
                    ++this.size;
                } else if (this.type == 3) {
                    if (currentValue.equals("comment")) {
                        this.freetextArea = new JTextArea(5, 20);
                        this.freetextArea.setLineWrap(true);
                    } else {
                        this.freetextArea = new JTextArea(1, 10);
                        this.freetextArea.setLineWrap(false);
                    }
                    this.freetextArea.getDocument().addDocumentListener(this);
                    this.freetextArea.setWrapStyleWord(true);
                    this.scrollPane = new JScrollPane(this.freetextArea);
                    this.scrollPane.setVerticalScrollBarPolicy(20);
                    this.scrollPane.setHorizontalScrollBarPolicy(31);
                    buttonBox.add(this.scrollPane);
                    this.freetextArea.setVisible(true);
                } else if (this.type == 4) {
                    if (this.listSelector == null) {
                        this.listSelector = new JComboBox();
                    }
                    this.lowerCasedValueStringsToButtonIndices.put("", new Integer(this.size));
                    this.buttonIndicesToLowerCasedValueStrings.add("");
                    this.listSelector.addItem("");
                    buttonBox.add(this.listSelector);
                    ++this.size;
                } else if (this.type == 7) {
                    if (this.listSelector == null) {
                        this.listSelector = new JComboBox();
                    }
                    this.lowerCasedValueStringsToButtonIndices.put(currentValue, new Integer(this.size));
                    this.buttonIndicesToLowerCasedValueStrings.add(currentValue);
                    this.listSelector.addItem(new MMAX2AttributeValue(currentValue, currentNode));
                    buttonBox.add(this.listSelector);
                    ++this.size;
                } else if (this.type == 8) {
                    if (this.listSelector == null) {
                        this.listSelector = new JComboBox();
                    }
                    this.setVisible(false);
                    this.lowerCasedValueStringsToButtonIndices.put(currentValue, new Integer(this.size));
                    this.buttonIndicesToLowerCasedValueStrings.add(currentValue);
                    this.listSelector.addItem(new MMAX2AttributeValue(currentValue, currentNode));
                    buttonBox.add(this.listSelector);
                    ++this.size;
                } else if (this.type == 6) {
                    if (this.idLabel == null) {
                        this.idLabel = new JLabel();
                        this.setIdLabel(MMAX2.defaultRelationValue);
                        this.idLabel.setEnabled(false);
                        buttonBox.add(this.idLabel);
                    }
                    this.setVisible(false);
                    try {
                        nextValue = currentNode.getAttributes().getNamedItem("next").getNodeValue();
                    }
                    catch (NullPointerException ex) {
                        nextValue = "";
                    }
                    if (!nextValue.equals("")) {
                        this.isBranching = true;
                    }
                    this.nextAttributes.add(nextValue);
                    ++this.size;
                } else if (this.type == 5) {
                    this.idLabel = new JLabel();
                    this.setIdLabel(MMAX2.defaultRelationValue);
                    this.idLabel.setEnabled(false);
                    buttonBox.add(this.idLabel);
                }
            }
            ++z;
        }
        if (this.listSelector != null) {
            this.listSelector.addActionListener(this);
        }
        if (this.isBranching) {
            this.attributeLabel.setText("< > " + this.attributeLabel.getText());
        }
        innerBox.add(buttonBox);
        this.add(innerBox);
    }

    public final String getDisplayAttributeName() {
        return this.displayAttributeName;
    }

    public final List<String> getOrderedValues() {
        return this.orderedValues;
    }

    public final MMAX2Attribute[] getDirectlyDependentAttributes() {
        ArrayList<MMAX2Attribute> temp = new ArrayList<MMAX2Attribute>();
        if (this.type == 1 || this.type == 2 || this.type == 6) {
            int z = 0;
            while (z < this.nextAttributes.size()) {
                String nextVal = this.nextAttributes.get(z);
                if (!nextVal.equals("")) {
                    List<String> tempresult = MarkableHelper.parseCompleteSpan(nextVal);
                    int p = 0;
                    while (p < tempresult.size()) {
                        MMAX2Attribute currentAttrib = this.annotationscheme.getAttributeByID(tempresult.get(p));
                        if (currentAttrib != null) {
                            if (!temp.contains(currentAttrib)) {
                                temp.add(currentAttrib);
                            }
                        } else {
                            System.err.println("Attribute " + tempresult.get(p) + " not found!");
                        }
                        ++p;
                    }
                }
                ++z;
            }
        }
        return temp.toArray(new MMAX2Attribute[0]);
    }

    public final String getAttributeNameToShowInMarkablePointerFlag() {
        return this.toShowInFlag;
    }

    public final void destroy() {
        this.markableRelation = null;
        this.annotationscheme = null;
    }

    public final boolean inDomain(String domain) {
        boolean result = false;
        if (this.targetDomain.equals("")) {
            result = true;
        } else if (this.targetDomain.equals(domain) || this.targetDomain.startsWith(String.valueOf(domain) + ",") || this.targetDomain.endsWith("," + domain) || this.targetDomain.indexOf("," + domain + ",") != -1) {
            result = true;
        }
        return result;
    }

    public final String getAddToMarkablesetInstruction() {
        return this.add_to_markableset_instruction;
    }

    public final String getRemoveFromMarkablesetInstruction() {
        return this.remove_from_markableset_instruction;
    }

    public final String getAdoptIntoMarkablesetInstruction() {
        return this.adopt_into_markableset_instruction;
    }

    public final String getMergeIntoMarkablesetInstruction() {
        return this.merge_into_markableset_instruction;
    }

    public final String getPointToMarkableInstruction() {
        return this.point_to_markable_instruction;
    }

    public final String getRemovePointerToMarkableInstruction() {
        return this.remove_pointer_to_markable_instruction;
    }

    public final void setMarkableRelation(MarkableRelation mrelation) {
        this.markableRelation = mrelation;
    }

    @Override
    public final MarkableRelation getMarkableRelation() {
        return this.markableRelation;
    }

    public String getDefaultValue() {
        String result = "";
        if (this.type == 1) {
            result = this.buttonIndicesToLowerCasedValueStrings.get(0);
        } else if (this.type == 2) {
            result = (String)this.listSelector.getItemAt(0);
        } else if (this.type == 4) {
            result = "";
        } else if (this.type == 7) {
            result = ((MMAX2AttributeValue)this.listSelector.getItemAt(0)).getName();
        } else if (this.type == 8) {
            result = ((MMAX2AttributeValue)this.listSelector.getItemAt(0)).getName();
        } else if (this.type == 3) {
            result = "";
        } else if (this.type == 5 || this.type == 6) {
            result = MMAX2.defaultRelationValue;
        }
        return result;
    }

    public final boolean getIsDashed() {
        return this.dashed;
    }

    public final int getLineWidth() {
        return this.lineWidth;
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public final int getLineStyle() {
        return this.lineStyle;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void actionPerformed(ActionEvent p1) {
        if (this.annotationscheme.ignoreClick) {
            return;
        }
        if (this.type == 1) {
            int position = new Integer(p1.getActionCommand());
            if (position == this.currentIndex) {
                return;
            }
            this.currentIndex = position;
            this.setIsFrozen(false, "");
            this.annotationscheme.valueChanged(this, this, null, position, new ArrayList<MMAX2Attribute>());
        } else if (this.type == 2) {
            int position = this.listSelector.getSelectedIndex();
            if (position == this.currentIndex) {
                return;
            }
            this.currentIndex = position;
            this.setIsFrozen(false, "");
            this.annotationscheme.valueChanged(this, this, null, position, new ArrayList<MMAX2Attribute>());
        } else if (this.type == 4) {
            int position = this.listSelector.getSelectedIndex();
            if (position == this.currentIndex) {
                return;
            }
            this.currentIndex = position;
            this.setIsFrozen(false, "");
            this.annotationscheme.valueChanged(this, this, null, position, new ArrayList<MMAX2Attribute>());
        } else if (this.type == 7) {
            int position = this.listSelector.getSelectedIndex();
            if (position == this.currentIndex) {
                return;
            }
            this.currentIndex = position;
            this.setIsFrozen(false, "");
            this.annotationscheme.valueChanged(this, this, null, position, new ArrayList<MMAX2Attribute>());
        } else if (this.type == 8) {
            int position = this.listSelector.getSelectedIndex();
            if (position == this.currentIndex) {
                return;
            }
            this.currentIndex = position;
            this.setIsFrozen(false, "");
            this.annotationscheme.valueChanged(this, this, null, position, new ArrayList<MMAX2Attribute>());
        }
    }

    public MMAX2Attribute[] getNextAttributes(boolean toDefault) {
        MMAX2Attribute[] result = new MMAX2Attribute[]{};
        if (this.frozen) {
            return result;
        }
        List<Object> tempresult = new ArrayList();
        int selIndex = -1;
        if (this.getType() == 1 || this.getType() == 2) {
            selIndex = this.getSelectedIndex();
        } else if (this.getType() == 6) {
            String currentValue = this.getSelectedValue();
            selIndex = currentValue.equalsIgnoreCase(MMAX2.defaultRelationValue) ? 0 : 1;
        } else {
            if (this.getType() == 5 || this.getType() == 3 || this.getType() == 4 || this.getType() == 7 || this.getType() == 8) {
                return result;
            }
            System.out.println("Error: Unknown attribute type! " + this.getLowerCasedAttributeName());
            return result;
        }
        String nextString = this.nextAttributes.get(selIndex);
        if (!nextString.equals("")) {
            tempresult = MarkableHelper.parseCompleteSpan(nextString);
            result = new MMAX2Attribute[tempresult.size()];
            int p = 0;
            while (p < tempresult.size()) {
                result[p] = this.annotationscheme.getAttributeByID((String)tempresult.get(p));
                if (result[p] != null) {
                    if (toDefault) {
                        result[p].toDefault();
                    }
                } else {
                    System.err.println("No Attribute with ID " + (String)tempresult.get(p) + "!");
                }
                ++p;
            }
        }
        return result;
    }

    public int getSelectedIndex() {
        int index = -1;
        if (this.type == 1) {
            JRadioButton currentButton = null;
            int p = 0;
            while (p < this.size) {
                currentButton = this.buttons.get(p);
                if (currentButton.isSelected()) {
                    index = p;
                    break;
                }
                ++p;
            }
        } else if (this.type == 2) {
            index = this.listSelector.getSelectedIndex();
        } else if (this.type == 4) {
            index = this.listSelector.getSelectedIndex();
        } else if (this.type == 7) {
            index = this.listSelector.getSelectedIndex();
        } else if (this.type == 8) {
            index = this.listSelector.getSelectedIndex();
        } else {
            System.err.println("getSelectedIndex not legal for attribute " + this.attributeLabel.getText());
        }
        return index;
    }

    public String getSelectedValue() {
        if (this.frozen) {
            return "";
        }
        String value = "";
        JRadioButton currentButton = null;
        if (this.type == 1) {
            int p = 0;
            while (p < this.size) {
                currentButton = this.buttons.get(p);
                if (currentButton.isSelected()) {
                    value = this.buttonIndicesToLowerCasedValueStrings.get(p);
                    break;
                }
                ++p;
            }
        } else if (this.type == 2) {
            value = (String)this.listSelector.getSelectedItem();
        } else if (this.type == 4) {
            value = (String)this.listSelector.getSelectedItem();
        } else if (this.type == 7) {
            value = ((MMAX2AttributeValue)this.listSelector.getSelectedItem()).getName();
        } else if (this.type == 8) {
            value = ((MMAX2AttributeValue)this.listSelector.getSelectedItem()).getName();
        } else if (this.type == 3) {
            try {
                value = this.freetextArea.getText();
            }
            catch (NullPointerException ex) {
                value = "";
            }
            value.trim();
            String tempresult = "";
            String currentChar = "";
            int z = 0;
            while (z < value.length()) {
                currentChar = value.substring(z, z + 1);
                if (currentChar.equals("\"")) {
                    currentChar = "'";
                } else if (currentChar.equals("\ufffd")) {
                    currentChar = "ae";
                } else if (currentChar.equals("\ufffd")) {
                    currentChar = "ue";
                } else if (currentChar.equals("\ufffd")) {
                    currentChar = "oe";
                } else if (currentChar.equals("\ufffd")) {
                    currentChar = "AE";
                } else if (currentChar.equals("\ufffd")) {
                    currentChar = "UE";
                } else if (currentChar.equals("\ufffd")) {
                    currentChar = "OE";
                } else if (currentChar.equals("<")) {
                    currentChar = "";
                } else if (currentChar.equals(">")) {
                    currentChar = "";
                } else if (currentChar.equals("\ufffd")) {
                    currentChar = "ss";
                } else if (currentChar.equals("\n")) {
                    currentChar = " ";
                }
                tempresult = String.valueOf(tempresult) + currentChar;
                ++z;
            }
            value = tempresult.trim();
        } else if (this.type == 5) {
            value = this.getIdLabel();
        } else if (this.type == 6) {
            value = MMAX2Utils.expandTargetSpan(this.getIdLabel());
        }
        return value;
    }

    public boolean setSelectedValue(String desiredValue, boolean ignore) {
        boolean result = false;
        int buttonPosition = 0;
        int itemPosition = -1;
        if (this.type == 1) {
            if (desiredValue == null || desiredValue.equals("")) {
                this.setSelectedIndex(0);
                result = true;
            } else {
                try {
                    buttonPosition = this.lowerCasedValueStringsToButtonIndices.get(desiredValue);
                }
                catch (NullPointerException ex) {
                    buttonPosition = -1;
                    result = false;
                }
                if (buttonPosition != -1) {
                    if (ignore) {
                        this.setSelectedIndex(buttonPosition);
                    } else {
                        this.buttons.get(buttonPosition).doClick();
                    }
                    result = true;
                } else {
                    logger.warn("Warning: Value " + desiredValue + " not found on attribute " + this.displayAttributeName + "!");
                }
            }
        } else if (this.type == 2 || this.type == 4) {
            if (desiredValue == null || desiredValue.equals("")) {
                this.listSelector.setSelectedIndex(0);
                result = true;
            } else {
                try {
                    int z = 0;
                    while (z < this.listSelector.getItemCount()) {
                        if (desiredValue.equalsIgnoreCase((String)this.listSelector.getItemAt(z))) {
                            itemPosition = z;
                            break;
                        }
                        ++z;
                    }
                }
                catch (NullPointerException ex) {
                    itemPosition = -1;
                    result = false;
                }
                if (ignore) {
                    this.annotationscheme.ignoreClick = true;
                }
                if (itemPosition != -1) {
                    this.listSelector.setSelectedIndex(itemPosition);
                    this.currentIndex = itemPosition;
                    result = true;
                } else {
                    logger.warn("Warning: Value " + desiredValue + " not found on attribute " + this.displayAttributeName + "!");
                }
                this.annotationscheme.ignoreClick = false;
            }
        } else if (this.type == 7 || this.type == 8) {
            if (desiredValue == null || desiredValue.equals("")) {
                this.listSelector.setSelectedIndex(0);
                result = true;
            } else {
                try {
                    int z = 0;
                    while (z < this.listSelector.getItemCount()) {
                        if (desiredValue.equalsIgnoreCase(((MMAX2AttributeValue)this.listSelector.getItemAt(z)).getName())) {
                            itemPosition = z;
                            break;
                        }
                        ++z;
                    }
                }
                catch (NullPointerException ex) {
                    itemPosition = -1;
                    result = false;
                }
                if (ignore) {
                    this.annotationscheme.ignoreClick = true;
                }
                if (itemPosition != -1) {
                    this.listSelector.setSelectedIndex(itemPosition);
                    this.currentIndex = itemPosition;
                    result = true;
                } else {
                    logger.warn("Warning: Value " + desiredValue + " not found on attribute " + this.displayAttributeName + "!");
                }
                this.annotationscheme.ignoreClick = false;
            }
        } else if (this.type == 3) {
            if (ignore) {
                this.annotationscheme.ignoreClick = true;
            }
            if (desiredValue != null) {
                this.freetextArea.setText(desiredValue);
            } else {
                this.freetextArea.setText("");
            }
            this.annotationscheme.ignoreClick = false;
            result = true;
        } else if (this.type == 5) {
            if (desiredValue != null && !desiredValue.equals("") && !desiredValue.equals(MMAX2.defaultRelationValue)) {
                this.setIdLabel(desiredValue);
            } else {
                this.setIdLabel(MMAX2.defaultRelationValue);
            }
            result = true;
        } else if (this.type == 6) {
            if (desiredValue != null && !desiredValue.equals("") && !desiredValue.equals(MMAX2.defaultRelationValue)) {
                this.setIdLabel(MMAX2Utils.condenseTargetSpan(desiredValue));
            } else {
                this.setIdLabel(MMAX2.defaultRelationValue);
            }
            result = true;
        }
        return result;
    }

    public final void addDependsOn(MMAX2Attribute attrib) {
        this.dependsOn.add(attrib);
    }

    public final boolean isIndependent() {
        return this.dependsOn.size() == 0;
    }

    public final boolean dependsOn(MMAX2Attribute superiorAttribute) {
        boolean result = false;
        if (this.dependsOn.contains(superiorAttribute)) {
            result = true;
        } else {
            MMAX2Attribute currentAttribute = null;
            int z = 0;
            while (z < this.dependsOn.size()) {
                currentAttribute = this.dependsOn.get(z);
                if (currentAttribute.dependsOn(superiorAttribute)) {
                    result = true;
                    break;
                }
                ++z;
            }
        }
        return result;
    }

    public void removeAllItems() {
        if (this.type == 2 || this.type == 4 || this.type == 7 || this.type == 8) {
            this.annotationscheme.ignoreClick = true;
            this.listSelector.removeAllItems();
            this.currentIndex = -1;
            this.annotationscheme.ignoreClick = false;
        }
    }

    public void addItem(String de) {
        if (this.type == 2 || this.type == 4) {
            this.annotationscheme.ignoreClick = true;
            this.listSelector.addItem(de);
            this.annotationscheme.ignoreClick = false;
        }
    }

    public void setSelectedIndex(int num) {
        if (this.type == 1) {
            this.annotationscheme.ignoreClick = true;
            this.buttons.get(num).setSelected(true);
            this.currentIndex = num;
            this.annotationscheme.ignoreClick = false;
        } else if (this.type == 2 || this.type == 4 || this.type == 7 || this.type == 8) {
            this.annotationscheme.ignoreClick = true;
            this.listSelector.setSelectedIndex(num);
            this.currentIndex = num;
            this.annotationscheme.ignoreClick = false;
        }
    }

    @Override
    public void setEnabled(boolean status) {
        if (this.type == 1) {
            int o = 0;
            while (o < this.size) {
                this.buttons.get(o).setEnabled(status);
                if (this.readOnly) {
                    this.buttons.get(o).setEnabled(false);
                }
                ++o;
            }
        } else if (this.type == 2 || this.type == 2) {
            this.listSelector.setEnabled(status);
        } else if (this.type == 3) {
            this.freetextArea.setEnabled(status);
            this.freetextArea.setEditable(status);
        }
    }

    public void toDefault() {
        if (this.type == 1) {
            this.annotationscheme.ignoreClick = true;
            this.buttons.get(0).setSelected(true);
            this.annotationscheme.ignoreClick = false;
            this.currentIndex = 0;
        }
        if (this.type == 2) {
            this.annotationscheme.ignoreClick = true;
            this.listSelector.setSelectedIndex(0);
            this.annotationscheme.ignoreClick = false;
            this.currentIndex = 0;
        } else if (this.type == 3) {
            this.annotationscheme.ignoreClick = true;
            this.freetextArea.setText("");
            this.annotationscheme.ignoreClick = false;
        } else if (this.type == 5 || this.type == 6) {
            this.setIdLabel(MMAX2.defaultRelationValue);
        } else if (this.type == 4) {
            this.annotationscheme.ignoreClick = true;
            this.listSelector.removeAllItems();
            this.lowerCasedValueStringsToButtonIndices.clear();
            this.buttonIndicesToLowerCasedValueStrings.clear();
            this.size = 0;
            this.listSelector.addItem("");
            this.lowerCasedValueStringsToButtonIndices.put("", new Integer(this.size));
            this.buttonIndicesToLowerCasedValueStrings.add("");
            ++this.size;
            this.listSelector.setSelectedIndex(0);
            this.currentIndex = 0;
            this.annotationscheme.ignoreClick = false;
        } else if (this.type == 7) {
            this.annotationscheme.ignoreClick = true;
            this.listSelector.setSelectedIndex(0);
            this.currentIndex = 0;
            this.annotationscheme.ignoreClick = false;
        } else if (this.type == 8) {
            this.annotationscheme.ignoreClick = true;
            this.listSelector.setSelectedIndex(0);
            this.currentIndex = 0;
            this.annotationscheme.ignoreClick = false;
        }
    }

    private void setIdLabel(String value) {
        this.idLabel.setText(value.equals(MMAX2.defaultRelationValue) ? localizedEmptyRelName : value);
    }

    private String getIdLabel() {
        return this.idLabel.getText().equals(localizedEmptyRelName) ? MMAX2.defaultRelationValue : this.idLabel.getText();
    }

    @Override
    public void removeUpdate(DocumentEvent p1) {
        this.freetextChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent p1) {
        this.freetextChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent p1) {
        this.freetextChanged();
    }

    private void freetextChanged() {
        if (this.annotationscheme.ignoreClick) {
            return;
        }
        MMAX2AttributePanel currentAttributePanel = this.annotationscheme.getCurrentAttributePanel();
        if (!currentAttributePanel.hasUncommittedChanges) {
            currentAttributePanel.setHasUncommittedChanges(true);
        }
        if (currentAttributePanel.getContainer().isAutoApply()) {
            logger.debug("Auto applying changes in freetext attribute " + this.ID);
            currentAttributePanel.keepables.clear();
            currentAttributePanel.setMarkableAttributes(currentAttributePanel.currentMarkable, true);
            currentAttributePanel.currentMarkable.getMarkableLevel().setIsDirty(true, true);
        } else {
            currentAttributePanel.setApplyEnabled(true);
            currentAttributePanel.setUndoEnabled(true);
        }
    }

    public int getType() {
        return this.type;
    }

    public final String decodeAttributeType() {
        String result = "unknown type !";
        if (this.type == 1 || this.type == 2) {
            result = "(NOMINAL";
        } else if (this.type == 5) {
            result = "(MARKABLE_SET";
        } else if (this.type == 6) {
            result = "(MARKABLE_POINTER";
        } else if (this.type == 3) {
            result = "(FREETEXT";
        } else if (this.type == 4) {
            result = "(HEAD";
        } else if (this.type == 7) {
            result = "(TYPE";
        } else if (this.type == 8) {
            result = "(MARKABLE_POINTER_ATTR";
        }
        result = this.isBranching ? String.valueOf(result) + ", branching)" : String.valueOf(result) + ")";
        return result;
    }

    public boolean isDefined(String value) {
        if (this.type == 1 || this.type == 2 || this.type == 4 || this.type == 7 || this.type == 8) {
            return this.buttonIndicesToLowerCasedValueStrings.contains(value);
        }
        if (this.type == 3) {
            return true;
        }
        if (this.type == 5) {
            if (value.equalsIgnoreCase("empty")) {
                return true;
            }
            if (value.equalsIgnoreCase("initial")) {
                return true;
            }
            return value.equalsIgnoreCase("final");
        }
        if (this.type == 6) {
            if (value.equalsIgnoreCase("empty")) {
                return true;
            }
            return value.equalsIgnoreCase("target");
        }
        return false;
    }

    public final String getLowerCasedAttributeName() {
        return this.lowerCasedAttributeName;
    }

    public final String getID() {
        return this.ID;
    }

    public final boolean getIsBranching() {
        return this.isBranching;
    }

    public final boolean getIsFrozen() {
        return this.frozen;
    }

    public final boolean getIsReadOnly() {
        return this.readOnly;
    }

    public void setIsFrozen(boolean status, String illegalValue) {
        if (status) {
            if (this.type == 1) {
                String warning = "Illegal attribute value: '" + illegalValue + "'";
                this.invisibleButton.setSelected(true);
                this.attributeLabel.setForeground(Color.red);
                this.attributeLabel.setToolTipText(warning);
                this.frozen = true;
            } else if (this.type == 2 || this.type == 4 || this.type == 7 || this.type == 8) {
                String warning = "Illegal attribute value: '" + illegalValue + "'";
                this.attributeLabel.setForeground(Color.red);
                this.attributeLabel.setToolTipText(warning);
                this.frozen = true;
            }
        } else if (this.frozen) {
            this.attributeLabel.setForeground(Color.darkGray);
            this.attributeLabel.setToolTipText(this.tooltiptext);
            this.toDefault();
            this.frozen = false;
        }
    }

    public String getLocalizedAttributeName() {
        return this.localizedAttributeName;
    }

    @Override
    public String toString() {
        return this.localizedAttributeName;
    }
}

