/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.core;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.LocalResolver;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Constants;

public class UserSettings {
    private static final Logger logger = Logger.getLogger(UserSettings.class);
    private String displayFontFamily = MMAX2Constants.DEFAULT_FONT.getFamily();
    private int displayFontSize = MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE;
    private float displayLineSpacing = 0.0f;
    private Map<String, FrameSizeAndPosition> framesSizesAndPositions = new HashMap<String, FrameSizeAndPosition>();
    private boolean highlightMatchingHandles = true;
    private boolean createSilently = false;
    private boolean suppressHandlesWhenRendering = true;
    private boolean selectAfterCreation = true;
    private boolean attributePanelToFront = false;
    private boolean autoApply = true;

    public void load() {
        HashMap<String, String> userSettings;
        block26: {
            File settings = LocalResolver.findUserSettings();
            userSettings = new HashMap<String, String>();
            if (settings != null) {
                logger.info("Loading user settings from file: " + settings.getPath());
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new FileReader(settings));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            String[] spl = line.split("=");
                            if (spl.length != 2) continue;
                            userSettings.put(spl[0], spl[1]);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error loading user settings..." + e.getStackTrace());
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            logger.error("Error closing user settings file..." + e2.getStackTrace());
                        }
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        logger.error("Error closing user settings file..." + e.getStackTrace());
                    }
                    throw throwable;
                }
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error("Error closing user settings file..." + e.getStackTrace());
                }
            } else {
                logger.info("User settings file not found.");
            }
        }
        for (Map.Entry e : userSettings.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            try {
                if (key.equals("displayFontFamily")) {
                    this.displayFontFamily = val;
                    continue;
                }
                if (key.equals("displayFontSize")) {
                    this.displayFontSize = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("displayLineSpacing")) {
                    this.displayLineSpacing = Float.parseFloat(val);
                    continue;
                }
                if (key.equals("highlightMatchingHandles")) {
                    this.highlightMatchingHandles = Boolean.parseBoolean(val);
                    continue;
                }
                if (key.equals("createSilently")) {
                    this.createSilently = Boolean.parseBoolean(val);
                    continue;
                }
                if (key.equals("suppressHandlesWhenRendering")) {
                    this.suppressHandlesWhenRendering = Boolean.parseBoolean(val);
                    continue;
                }
                if (key.equals("selectAfterCreation")) {
                    this.selectAfterCreation = Boolean.parseBoolean(val);
                    continue;
                }
                if (key.equals("attributePanelToFront")) {
                    this.attributePanelToFront = Boolean.parseBoolean(val);
                    continue;
                }
                if (key.equals("autoApply")) {
                    this.autoApply = Boolean.parseBoolean(val);
                    continue;
                }
                if (!key.startsWith("fap:")) continue;
                String[] spl = key.split(":");
                String className = spl[1];
                this.framesSizesAndPositions.put(className, new FrameSizeAndPosition(val));
            }
            catch (Exception ex) {
                logger.error("Error with entry: " + key + " - " + val);
            }
        }
    }

    public void save() {
        File f = LocalResolver.getDisplaySettingsFile();
        logger.info("Saving user settings in file: " + f.getPath());
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new FileWriter(f));
                bw.append("displayFontFamily=" + this.displayFontFamily + "\n");
                bw.append("displayFontSize=" + this.displayFontSize + "\n");
                bw.append("displayLineSpacing=" + this.displayLineSpacing + "\n");
                bw.append("highlightMatchingHandles=" + this.highlightMatchingHandles + "\n");
                bw.append("createSilently=" + this.createSilently + "\n");
                bw.append("suppressHandlesWhenRendering=" + this.suppressHandlesWhenRendering + "\n");
                bw.append("selectAfterCreation=" + this.selectAfterCreation + "\n");
                bw.append("attributePanelToFront=" + this.attributePanelToFront + "\n");
                bw.append("autoApply=" + this.autoApply + "\n");
                for (Map.Entry<String, FrameSizeAndPosition> e : this.framesSizesAndPositions.entrySet()) {
                    String className = e.getKey();
                    FrameSizeAndPosition fap = e.getValue();
                    bw.append("fap:" + className + "=" + fap.marshall() + "\n");
                }
                bw.close();
            }
            catch (IOException e) {
                logger.error("Error saving user settings..." + e.getStackTrace());
                try {
                    bw.close();
                }
                catch (IOException e1) {
                    logger.error("Error closing user settings file..." + e1.getStackTrace());
                }
            }
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e1) {
                logger.error("Error closing user settings file..." + e1.getStackTrace());
            }
        }
    }

    public void storeFrameSettings(JFrame frame, String className) {
        if (frame != null) {
            FrameSizeAndPosition fap = new FrameSizeAndPosition(frame);
            this.framesSizesAndPositions.put(className, fap);
            logger.debug("Storing in memory " + className + " settings: " + fap.toString());
        } else {
            this.framesSizesAndPositions.remove(className);
        }
    }

    public FrameSizeAndPosition loadFrameSettings(String className) {
        return this.framesSizesAndPositions.get(className);
    }

    public void setDisplayFontFamily(String newFontFamily) {
        this.displayFontFamily = newFontFamily;
    }

    public void setDisplayFontSize(int newFontSize) {
        this.displayFontSize = newFontSize;
    }

    public void setDisplayLineSpacing(float spacing) {
        this.displayLineSpacing = spacing;
    }

    public void setHighlightMatchingHandles(boolean status) {
        this.highlightMatchingHandles = status;
    }

    public boolean isHighlightMatchingHandles() {
        return this.highlightMatchingHandles;
    }

    public String getDisplayFontFamily() {
        return this.displayFontFamily;
    }

    public boolean isCreateSilently() {
        return this.createSilently;
    }

    public void setCreateSilently(boolean createSilently) {
        this.createSilently = createSilently;
    }

    public boolean isSuppressHandlesWhenRendering() {
        return this.suppressHandlesWhenRendering;
    }

    public void setSuppressHandlesWhenRendering(boolean suppressHandlesWhenRendering) {
        this.suppressHandlesWhenRendering = suppressHandlesWhenRendering;
    }

    public boolean isSelectAfterCreation() {
        return this.selectAfterCreation;
    }

    public void setSelectAfterCreation(boolean selectAfterCreation) {
        this.selectAfterCreation = selectAfterCreation;
    }

    public int getDisplayFontSize() {
        return this.displayFontSize;
    }

    public float getDisplayLineSpacing() {
        return this.displayLineSpacing;
    }

    public boolean isAttributePanelToFront() {
        return this.attributePanelToFront;
    }

    public void setAttributePanelToFront(boolean attributePanelToFront) {
        this.attributePanelToFront = attributePanelToFront;
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public void setAutoApply(boolean autoApply) {
        this.autoApply = autoApply;
    }

    public class FrameSizeAndPosition {
        private Point location;
        private int height;
        private int width;

        public FrameSizeAndPosition(JFrame frame) {
            this.location = frame.getLocation();
            this.height = frame.getHeight();
            this.width = frame.getWidth();
        }

        public FrameSizeAndPosition(String marshalledString) throws Exception {
            String[] spl = marshalledString.split(",");
            this.location = new Point(Integer.parseInt(spl[0]), Integer.parseInt(spl[1]));
            this.height = Integer.parseInt(spl[2]);
            this.width = Integer.parseInt(spl[3]);
        }

        public String marshall() {
            return String.valueOf(this.location.x) + "," + this.location.y + "," + this.height + "," + this.width;
        }

        public String toString() {
            return "location: (" + this.location.x + ", " + this.location.y + "), height: " + this.height + ", width: " + this.width;
        }

        public Dimension getDimension() {
            return new Dimension(this.width, this.height);
        }

        public Point getLocation() {
            return this.location;
        }
    }
}

