/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.gui.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Node;
import pl.waw.ipipan.zil.core.mmax4ref.Messages;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableChart;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Constants;

public class MMAX2LevelSelector
extends JPopupMenu {
    private static final long serialVersionUID = 8575606233086716107L;

    public MMAX2LevelSelector(MarkableLevel[] activeLevels, final String fragment, final MarkableChart chart) {
        this.addPopupMenuListener(new CancellationListener(chart));
        JMenuItem item = null;
        int z = 0;
        while (z < activeLevels.length) {
            item = activeLevels.length == 1 ? new JMenuItem(Messages.getString("MMAX2LevelSelector.Create_markable")) : new JMenuItem("Create Markable on level '" + activeLevels[z].getMarkableLevelName() + "'");
            final MarkableLevel tempLevel = activeLevels[z];
            final boolean selectAfterCreation = chart.getCurrentDiscourse().getMMAX2().getUserSettings().isSelectAfterCreation();
            item.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent ae) {
                    chart.getCurrentDiscourse().getMMAX2().saveStateForUndo();
                    Markable newMarkable = tempLevel.addMarkable(fragment);
                    if (selectAfterCreation) {
                        chart.markableLeftClicked(newMarkable);
                    }
                }
            });
            this.add(item);
            ++z;
        }
        this.addSeparator();
        item = null;
        item = new JMenuItem(Messages.getString("MMAX2LevelSelector.Add_ellipsis"));
        item.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                String[] fragmentBorders = fragment.split("\\.\\.");
                String lastWordId = fragmentBorders[fragmentBorders.length - 1];
                Node lastWordNode = chart.getCurrentDiscourse().getDiscourseElementNode(lastWordId);
                chart.getCurrentDiscourse().requestAddBasedataElement(lastWordNode, MMAX2Constants.INSERT_ELLIPSIS);
            }
        });
        this.add(item);
        this.addSeparator();
        final MMAX2 tempMMAX = chart.getCurrentDiscourse().getMMAX2();
        final int start = chart.getSelectionStart();
        final int end = chart.getSelectionEnd();
        item = null;
        item = new JMenuItem(Messages.getString("MMAX2LevelSelector.Copy_to_clipboard"));
        item.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                tempMMAX.copyDocumentSpanToClipboard(start, end);
            }
        });
        this.add(item);
    }

    public class CancellationListener
    implements PopupMenuListener {
        MarkableChart chart = null;

        public CancellationListener(MarkableChart _chart) {
            this.chart = _chart;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.chart.removeTemporarySelection();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

