/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.gui.windows;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4ref.Messages;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableChart;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2Discourse;

public class MMAX2MarkableBrowser
extends JFrame
implements ListSelectionListener,
ActionListener,
MouseListener,
WindowListener {
    private static final long serialVersionUID = 7306676492337643096L;
    private static final Logger logger = Logger.getLogger(MMAX2MarkableBrowser.class);
    private MMAX2 mmax2 = null;
    private MarkableChart chart = null;
    private JMenu sortOrdersMenu = null;
    private JMenu levelMenu = null;
    private JCheckBox KWICView = null;
    private ButtonGroup sortorderButtonGroup = null;
    private ButtonGroup levelButtonGroup = null;
    private JScrollPane scrollPane = null;
    private JList markableList = null;
    private String currentLevelName = "";
    private String currentSortOrder = "";
    private MarkableLevel[] availableLevels = null;
    private List<Markable> markables = null;
    boolean ignore = false;

    public MMAX2MarkableBrowser(MMAX2 _mmax2, Markable initialSelection) {
        this.addWindowListener(this);
        this.setResizable(true);
        this.mmax2 = _mmax2;
        this.chart = this.mmax2.getCurrentDiscourse().getCurrentMarkableChart();
        JMenuBar menu = new JMenuBar();
        this.availableLevels = this.chart.getMarkableLevels();
        this.levelButtonGroup = new ButtonGroup();
        this.levelMenu = new JMenu("Levels");
        int z = 0;
        while (z < this.availableLevels.length) {
            JRadioButtonMenuItem currentLevel = new JRadioButtonMenuItem(this.availableLevels[z].getMarkableLevelName());
            if (this.currentLevelName.equals("") && z == 0) {
                currentLevel.setSelected(true);
                this.currentLevelName = this.availableLevels[z].getMarkableLevelName();
            } else if (this.currentLevelName.equals(this.availableLevels[z].getMarkableLevelName())) {
                currentLevel.setSelected(true);
            }
            currentLevel.setActionCommand("levelselection:" + this.availableLevels[z].getMarkableLevelName());
            currentLevel.addActionListener(this);
            this.levelButtonGroup.add(currentLevel);
            this.levelMenu.add(currentLevel);
            currentLevel = null;
            ++z;
        }
        if (this.availableLevels.length > 1) {
            menu.add(this.levelMenu);
        }
        this.sortorderButtonGroup = new ButtonGroup();
        this.sortOrdersMenu = new JMenu(Messages.getString("MMAX2MarkableBrowser.Order"));
        JRadioButtonMenuItem alphaOrder = new JRadioButtonMenuItem(Messages.getString("MMAX2MarkableBrowser.Alphabetic"));
        this.sortorderButtonGroup.add(alphaOrder);
        alphaOrder.setActionCommand("alphaorder");
        alphaOrder.addActionListener(this);
        this.sortOrdersMenu.add(alphaOrder);
        JRadioButtonMenuItem documentOrder = new JRadioButtonMenuItem(Messages.getString("MMAX2MarkableBrowser.Document"));
        this.sortorderButtonGroup.add(documentOrder);
        documentOrder.setActionCommand("documentorder");
        documentOrder.addActionListener(this);
        if (this.currentSortOrder.equals("") || this.currentSortOrder.equals("alpha")) {
            alphaOrder.setSelected(true);
            this.currentSortOrder = "alpha";
        } else {
            documentOrder.setSelected(true);
            this.currentSortOrder = "document";
        }
        this.sortOrdersMenu.add(documentOrder);
        menu.add(this.sortOrdersMenu);
        this.KWICView = new JCheckBox(Messages.getString("MMAX2MarkableBrowser.KWIC_view"));
        this.KWICView.addActionListener(this);
        this.KWICView.setActionCommand("kwic");
        this.KWICView.setSelected(false);
        menu.add(this.KWICView);
        this.setJMenuBar(menu);
        this.markableList = new JList();
        this.markableList.addListSelectionListener(this);
        this.markableList.addMouseListener(this);
        this.markableList.setVisibleRowCount(25);
        this.markableList.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.markableList);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        Box tempBox = Box.createVerticalBox();
        tempBox.add(this.scrollPane);
        this.getContentPane().add(tempBox);
        this.updateList(initialSelection);
        this.pack();
        this.setLocation(0, this.mmax2.getScreenHeight() - this.getHeight());
        this.setTitle(Messages.getString("MMAX2MarkableBrowser.MMAX2MarkableBrowser"));
        this.setVisible(true);
    }

    public final void refresh() {
        this.updateList();
        this.invalidate();
        this.repaint();
    }

    public final String getCurrentlyDisplayedMarkableLevelName() {
        return this.currentLevelName;
    }

    @Override
    public final void dispose() {
        this.mmax2.dismissMarkableBrowser();
        super.dispose();
    }

    public final void updateList() {
        if (this.markableList.isSelectionEmpty()) {
            this.updateList(null);
        } else {
            Markable selectedMarkable = this.markables.get(this.markableList.getSelectedIndex());
            this.updateList(selectedMarkable);
        }
    }

    public void selectMarkable(Markable targetMarkable) {
        Markable currentSelection = null;
        if (!this.markableList.isSelectionEmpty()) {
            currentSelection = this.markables.get(this.markableList.getSelectedIndex());
        }
        if (targetMarkable == null) {
            if (currentSelection == null) {
                return;
            }
            this.markableList.clearSelection();
            return;
        }
        if (targetMarkable.equals(currentSelection)) {
            return;
        }
        int i = 0;
        while (i < this.markables.size()) {
            if (this.markables.get(i).equals(targetMarkable)) {
                this.markableList.setSelectedIndex(i);
                this.markableList.ensureIndexIsVisible(i);
                return;
            }
            ++i;
        }
        logger.error("Error selecting markable " + targetMarkable);
    }

    public final void updateList(Markable preselection) {
        this.markables = this.chart.getMarkableLevelByName(this.currentLevelName, true).getMarkables();
        if (this.currentSortOrder.equals("alpha")) {
            Collections.sort(this.markables, MMAX2Discourse.DISCOURSEORDERCOMP);
            Collections.sort(this.markables, MMAX2Discourse.ALPHACOMP);
        } else if (this.currentSortOrder.equals("document")) {
            Collections.sort(this.markables, MMAX2Discourse.DISCOURSEORDERCOMP);
        }
        String[] markablesForDisplay = new String[this.markables.size()];
        int i = 0;
        for (Markable m : this.markables) {
            markablesForDisplay[i] = this.KWICView.isSelected() ? MarkableHelper.toKWICString(m) : m.toHTMLString();
            ++i;
        }
        this.markableList.setListData(markablesForDisplay);
        this.selectMarkable(preselection);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)actionEvent.getSource();
            String action = item.getActionCommand();
            if (action.equals("alphaorder")) {
                this.currentSortOrder = "alpha";
                this.updateList();
            } else if (action.equals("documentorder")) {
                this.currentSortOrder = "document";
                this.updateList();
            } else if (action.startsWith("levelselection:")) {
                this.currentLevelName = action.substring(action.indexOf(":") + 1);
                this.updateList();
            }
        } else if (actionEvent.getActionCommand().equals("kwic")) {
            JCheckBox temp = (JCheckBox)actionEvent.getSource();
            this.updateList();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Markable clickedMarkable = this.markables.get(this.markableList.locationToIndex(mouseEvent.getPoint()));
        MarkableChart currentMarkableChart = this.mmax2.getCurrentDiscourse().getCurrentMarkableChart();
        if (mouseEvent.getButton() == 3) {
            currentMarkableChart.markableRightClicked(clickedMarkable, this.markableList, mouseEvent.getPoint());
            this.mmax2.scrollToMarkable(clickedMarkable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        } else if (mouseEvent.getButton() == 1) {
            currentMarkableChart.markableLeftClicked(clickedMarkable);
            this.mmax2.scrollToMarkable(clickedMarkable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
    }
}

