/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.utils;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.w3c.dom.NamedNodeMap;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Constants;

public class MMAX2Utils {
    public static final Color getColorByName(String name) {
        Color result = null;
        if (name != null) {
            if (name.equalsIgnoreCase("black")) {
                result = Color.black;
            }
            if (name.equalsIgnoreCase("blue")) {
                result = Color.blue;
            }
            if (name.equalsIgnoreCase("cyan")) {
                result = Color.cyan;
            }
            if (name.equalsIgnoreCase("darkGray")) {
                result = Color.darkGray;
            }
            if (name.equalsIgnoreCase("gray")) {
                result = Color.gray;
            }
            if (name.equalsIgnoreCase("green")) {
                result = Color.green;
            }
            if (name.equalsIgnoreCase("lightGray")) {
                result = Color.lightGray;
            }
            if (name.equalsIgnoreCase("magenta")) {
                result = Color.magenta;
            }
            if (name.equalsIgnoreCase("orange")) {
                result = Color.orange;
            }
            if (name.equalsIgnoreCase("pink")) {
                result = Color.pink;
            }
            if (name.equalsIgnoreCase("red")) {
                result = Color.red;
            }
            if (name.equalsIgnoreCase("white")) {
                result = Color.white;
            }
            if (name.equalsIgnoreCase("yellow")) {
                result = Color.yellow;
            }
            if (name.startsWith("x:")) {
                result = MMAX2Utils.getColorByHexValue(name);
            }
            if (name.startsWith("d:")) {
                result = MMAX2Utils.getColorByDecValue(name);
            }
        } else {
            result = Color.black;
        }
        if (result == null) {
            System.err.println("Illegal color name: " + name);
            result = Color.black;
        }
        return result;
    }

    public static final Color getColorByDecValue(String value) {
        Color result = null;
        int red = 0;
        int green = 0;
        int blue = 0;
        if (!value.startsWith("d:") || value.length() != 11) {
            System.err.println("Format error in dec color code!!");
            result = Color.red;
        }
        try {
            red = Integer.decode(value.substring(2, 5));
            green = Integer.decode(value.substring(5, 8));
            blue = Integer.decode(value.substring(8, 11));
        }
        catch (NumberFormatException ex) {
            System.err.println("Parsing error in dec color code!!");
            result = Color.red;
        }
        if (result == null) {
            result = new Color(red, green, blue);
        }
        return result;
    }

    public static final Color getColorByHexValue(String value) {
        Color result = null;
        int red = 0;
        int green = 0;
        int blue = 0;
        if (!value.startsWith("x:") || value.length() != 8) {
            System.err.println("Format error in hex color code!!");
            result = Color.red;
        }
        try {
            red = Integer.decode("#" + value.substring(2, 4));
            green = Integer.decode("#" + value.substring(4, 6));
            blue = Integer.decode("#" + value.substring(6, 8));
        }
        catch (NumberFormatException ex) {
            System.err.println("Parsing error in hex color code!!");
            result = Color.red;
        }
        if (result == null) {
            result = new Color(red, green, blue);
        }
        return result;
    }

    public static final SimpleAttributeSet createSimpleAttributeSet(String attributestring, boolean blackAndWhiteDefault) {
        SimpleAttributeSet resultSet = new SimpleAttributeSet();
        attributestring = attributestring.toLowerCase().trim();
        String value = "";
        StringTokenizer tokenizer = new StringTokenizer(attributestring);
        while (tokenizer.hasMoreTokens()) {
            String temp;
            value = tokenizer.nextToken();
            if (value.startsWith("handles")) {
                resultSet.addAttribute("handles", MMAX2Utils.getColorByName(value.substring(value.indexOf("=") + 1)));
                continue;
            }
            if (value.startsWith("markable_set_line_color") || value.startsWith("markable_pointer_line_color")) {
                temp = value.substring(0, value.indexOf("="));
                resultSet.addAttribute(temp, MMAX2Utils.getColorByName(value.substring(value.indexOf("=") + 1)));
                continue;
            }
            if (value.startsWith("markable_set_line_style") || value.startsWith("markable_pointer_line_style")) {
                temp = value.substring(0, value.indexOf("="));
                String val = value.substring(value.indexOf("=") + 1);
                int toSet = MMAX2Constants.STRAIGHT;
                if (val.equalsIgnoreCase("lcurve")) {
                    toSet = MMAX2Constants.LCURVE;
                } else if (val.equalsIgnoreCase("rcurve")) {
                    toSet = MMAX2Constants.RCURVE;
                } else if (val.equalsIgnoreCase("smartcurve")) {
                    toSet = MMAX2Constants.SMARTCURVE;
                } else if (val.equalsIgnoreCase("xcurve")) {
                    toSet = MMAX2Constants.XCURVE;
                } else if (val.equalsIgnoreCase("straight")) {
                    toSet = MMAX2Constants.STRAIGHT;
                }
                resultSet.addAttribute(temp, new Integer(toSet));
                continue;
            }
            if (value.startsWith("background")) {
                StyleConstants.setBackground(resultSet, MMAX2Utils.getColorByName(value.substring(value.indexOf("=") + 1)));
                continue;
            }
            if (value.startsWith("foreground")) {
                StyleConstants.setForeground(resultSet, MMAX2Utils.getColorByName(value.substring(value.indexOf("=") + 1)));
                continue;
            }
            if (value.startsWith("bold=") && value.startsWith("bold=true")) {
                StyleConstants.setBold(resultSet, true);
            }
            if (value.startsWith("italic=")) {
                if (!value.startsWith("italic=true")) continue;
                StyleConstants.setItalic(resultSet, true);
                continue;
            }
            if (value.startsWith("strikethrough=")) {
                if (!value.startsWith("strikethrough=true")) continue;
                StyleConstants.setStrikeThrough(resultSet, true);
                continue;
            }
            if (value.startsWith("subscript=")) {
                if (!value.startsWith("subscript=true")) continue;
                StyleConstants.setSubscript(resultSet, true);
                continue;
            }
            if (value.startsWith("superscript=")) {
                if (!value.startsWith("superscript=true")) continue;
                StyleConstants.setSuperscript(resultSet, true);
                continue;
            }
            if (value.startsWith("underline=")) {
                if (!value.startsWith("underline=true")) continue;
                StyleConstants.setUnderline(resultSet, true);
                continue;
            }
            if (value.startsWith("size=")) {
                if (value.startsWith("size=huge")) {
                    StyleConstants.setFontSize(resultSet, MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE + 10);
                } else if (value.startsWith("size=big")) {
                    StyleConstants.setFontSize(resultSet, MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE + 6);
                } else if (value.startsWith("size=normal")) {
                    StyleConstants.setFontSize(resultSet, MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE);
                } else if (value.startsWith("size=small")) {
                    StyleConstants.setFontSize(resultSet, MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE - 6);
                } else if (value.startsWith("size=tiny")) {
                    StyleConstants.setFontSize(resultSet, MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE - 10);
                } else {
                    String numPart = value.substring(value.indexOf("=") + 1);
                    try {
                        StyleConstants.setFontSize(resultSet, Integer.parseInt(numPart));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (!value.startsWith("font-family=") || !value.startsWith("font-family=courier")) continue;
            StyleConstants.setFontFamily(resultSet, "courier");
        }
        if (blackAndWhiteDefault) {
            if (resultSet.isDefined(StyleConstants.Foreground)) {
                StyleConstants.setForeground(resultSet, Color.black);
            }
            if (resultSet.isDefined(StyleConstants.Background)) {
                StyleConstants.setBackground(resultSet, Color.white);
            }
        }
        return resultSet;
    }

    public static final Map<String, String> convertNodeMapToHashMap(NamedNodeMap nodemap) {
        HashMap<String, String> resultmap = new HashMap<String, String>();
        String currentattributename = "";
        String currentvalue = "";
        if (nodemap != null) {
            int len = nodemap.getLength();
            int i = 0;
            while (i < len) {
                currentattributename = nodemap.item(i).getNodeName();
                currentvalue = nodemap.item(i).getNodeValue();
                resultmap.put(currentattributename.toLowerCase(), currentvalue);
                ++i;
            }
        }
        return resultmap;
    }

    public static final String colorToHTML(Color _color) {
        String blue;
        String green;
        String red = Integer.toHexString(_color.getRed());
        if (red.equals("0")) {
            red = "00";
        }
        if ((green = Integer.toHexString(_color.getGreen())).equals("0")) {
            green = "00";
        }
        if ((blue = Integer.toHexString(_color.getBlue())).equals("0")) {
            blue = "00";
        }
        return "#" + red + green + blue;
    }

    public static final int parseID(String id) {
        int result = 0;
        result = Integer.parseInt(id.substring(id.indexOf("_") + 1));
        return result;
    }

    public static final String toAttributeString(NamedNodeMap attributeMap, boolean removeIDAttribute) {
        String result = "";
        Map<String, String> allAttribsAsHash = MMAX2Utils.convertNodeMapToHashMap(attributeMap);
        for (String currentAttribute : allAttribsAsHash.keySet()) {
            if (currentAttribute.equalsIgnoreCase("id") && removeIDAttribute) continue;
            String currentValue = allAttribsAsHash.get(currentAttribute);
            if (!currentValue.startsWith("'") && !currentValue.startsWith("\"")) {
                currentValue = "\"" + currentValue;
            }
            if (!currentValue.endsWith("'") && !currentValue.endsWith("\"")) {
                currentValue = String.valueOf(currentValue) + "\"";
            }
            result = String.valueOf(result) + currentAttribute + "=" + currentValue + " ";
        }
        return result;
    }

    public static final String toAttributeString(Map<String, String> allAttribsAsHash, boolean removeIDAttribute) {
        String result = "";
        for (String currentAttribute : allAttribsAsHash.keySet()) {
            if (currentAttribute.equalsIgnoreCase("id") && removeIDAttribute) continue;
            String currentValue = allAttribsAsHash.get(currentAttribute);
            if (currentValue.isEmpty()) {
                currentValue = "\"\"";
            }
            if (currentValue.equals("\"")) {
                currentValue = "\"" + MarkableHelper.encodeXML("\"") + "\"";
            }
            if (!currentValue.startsWith("\"")) {
                currentValue = "\"" + currentValue;
            }
            if (!currentValue.endsWith("\"")) {
                currentValue = String.valueOf(currentValue) + "\"";
            }
            result = String.valueOf(result) + currentAttribute + "=" + currentValue + " ";
        }
        return result;
    }

    public static final List<String> toAttributeList(String attributeString) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer toki = new StringTokenizer(attributeString, " ");
        while (toki.hasMoreElements()) {
            String currentToken = toki.nextToken().trim();
            int temp = currentToken.indexOf("=");
            if (temp == -1) {
                System.err.println("Error with attribute " + currentToken);
                continue;
            }
            String currentAttribute = currentToken.substring(0, temp).trim();
            if (currentAttribute.equalsIgnoreCase("id")) continue;
            String currentValue = currentToken.substring(temp + 1).trim();
            if (!currentValue.startsWith("\"") && !currentValue.startsWith("'")) {
                currentValue = "\"" + currentValue;
            }
            if (!currentValue.endsWith("\"") && !currentValue.endsWith("'")) {
                currentValue = String.valueOf(currentValue) + "\"";
            }
            result.add(String.valueOf(currentAttribute) + "=" + currentValue);
        }
        return result;
    }

    public static final Point calculateControlPoint(int x_source, int y_source, int x_target, int y_target, int lineStyle) {
        Point result = null;
        int x_diff = 0;
        int y_diff = 0;
        double x_ortho = 0.0;
        double y_ortho = 0.0;
        int x_middle = 0;
        double c = 0.2;
        if (lineStyle == MMAX2Constants.XCURVE) {
            x_diff = x_target - x_source;
            y_diff = y_target - y_source;
            x_ortho = (double)y_diff * c;
            y_ortho = (double)(-x_diff) * c;
            x_middle = (x_source + x_target) / 2;
            result = new Point((int)((double)x_middle + x_ortho), (int)((double)x_middle + y_ortho));
        } else if (x_source < x_target && y_source < y_target) {
            if (lineStyle == MMAX2Constants.LCURVE) {
                result = new Point(x_target, y_source);
            } else if (lineStyle == MMAX2Constants.RCURVE) {
                result = new Point(x_source, y_target);
            }
        } else if (x_source > x_target && y_source < y_target) {
            if (lineStyle == MMAX2Constants.LCURVE) {
                result = new Point(x_source, y_target);
            } else if (lineStyle == MMAX2Constants.RCURVE) {
                result = new Point(x_target, y_source);
            }
        } else if (x_source > x_target && y_source > y_target) {
            if (lineStyle == MMAX2Constants.LCURVE) {
                result = new Point(x_target, y_source);
            } else if (lineStyle == MMAX2Constants.RCURVE) {
                result = new Point(x_source, y_target);
            }
        } else if (x_source < x_target && y_source > y_target) {
            if (lineStyle == MMAX2Constants.LCURVE) {
                result = new Point(x_source, y_target);
            } else if (lineStyle == MMAX2Constants.RCURVE) {
                result = new Point(x_target, y_source);
            }
        } else if (y_source == y_target) {
            if (x_target < x_source) {
                if (lineStyle == MMAX2Constants.LCURVE) {
                    result = new Point((x_source - x_target) / 2 + x_target, y_source + 20);
                } else if (lineStyle == MMAX2Constants.RCURVE) {
                    result = new Point((x_source - x_target) / 2 + x_target, y_source - 20);
                }
            } else if (lineStyle == MMAX2Constants.LCURVE) {
                result = new Point((x_target - x_source) / 2 + x_source, y_source - 20);
            } else if (lineStyle == MMAX2Constants.RCURVE) {
                result = new Point((x_target - x_source) / 2 + x_source, y_source + 20);
            }
        } else if (x_source == x_target) {
            if (y_target < y_source) {
                if (lineStyle == MMAX2Constants.LCURVE) {
                    result = new Point(x_source - 20, (y_source - y_target) / 2 + y_target);
                } else if (lineStyle == MMAX2Constants.RCURVE) {
                    result = new Point(x_source + 20, (y_source - y_target) / 2 + y_target);
                }
            } else if (lineStyle == MMAX2Constants.LCURVE) {
                result = new Point(x_source - 20, (y_target - y_source) / 2 + y_source);
            } else if (lineStyle == MMAX2Constants.RCURVE) {
                result = new Point(x_source + 20, (y_target - y_source) / 2 + y_source);
            }
        }
        return result;
    }

    public static final String condenseSatelliteSpan_bak(String span) {
        String result = "";
        List<String> list = MMAX2Utils.parseTargetSpan(span, ";");
        int b = 0;
        while (b < list.size()) {
            String currentEntry = list.get(b);
            currentEntry = currentEntry.substring(currentEntry.indexOf("_") + 1);
            result = b == 0 ? currentEntry : String.valueOf(result) + " " + currentEntry;
            ++b;
        }
        return result.trim();
    }

    public static final String condenseTargetSpan(String span) {
        String result = "";
        List<String> list = MMAX2Utils.parseTargetSpan(span, ";");
        int b = 0;
        while (b < list.size()) {
            String currentEntry = list.get(b);
            String currentNameSpace = "";
            if (currentEntry.indexOf(":") != -1) {
                currentNameSpace = currentEntry.substring(0, currentEntry.indexOf(":") + 1);
            }
            currentEntry = currentEntry.substring(currentEntry.indexOf("_") + 1);
            result = b == 0 ? String.valueOf(currentNameSpace) + currentEntry : String.valueOf(result) + " " + currentNameSpace + currentEntry;
            ++b;
        }
        return result.trim();
    }

    public static final String expandTargetSpan(String span) {
        String result = MMAX2.defaultRelationValue;
        List<String> list = MMAX2Utils.parseTargetSpan(span, " ");
        int z = 0;
        while (z < list.size()) {
            String currentEntry = list.get(z);
            if (currentEntry.equals(MMAX2.defaultRelationValue)) break;
            String currentNameSpace = "";
            if (currentEntry.indexOf(":") != -1) {
                currentNameSpace = currentEntry.substring(0, currentEntry.indexOf(":") + 1);
                currentEntry = currentEntry.substring(currentEntry.indexOf(":") + 1);
            }
            result = z == 0 ? String.valueOf(currentNameSpace) + "markable_" + currentEntry : String.valueOf(result) + ";" + currentNameSpace + "markable_" + currentEntry;
            ++z;
        }
        return result;
    }

    public static final List<String> parseTargetSpan(String span, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer toki = new StringTokenizer(span, delimiter);
        while (toki.hasMoreTokens()) {
            result.add(toki.nextToken());
        }
        return result;
    }
}

