/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.gui.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4ref.Messages;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2Discourse;

public class MMAX2MarkableSetBrowser
extends JFrame
implements ActionListener,
WindowListener,
MouseListener {
    private static final long serialVersionUID = -2021373972982437097L;
    private static final Logger logger = Logger.getLogger(MMAX2MarkableSetBrowser.class);
    MMAX2 mmax2 = null;
    JComboBox levelBox = null;
    JComboBox attributeBox = null;
    MMAX2Discourse discourse = null;
    JScrollPane treeViewPane = null;
    JTree tree = null;
    DefaultMutableTreeNode root = null;
    private JCheckBox expandAllCheckbox = null;

    public MMAX2MarkableSetBrowser(MMAX2 _mmax2) {
        this.addWindowListener(this);
        this.mmax2 = _mmax2;
        this.discourse = this.mmax2.getCurrentDiscourse();
        this.root = new DefaultMutableTreeNode(Messages.getString("MMAX2MarkableSetBrowser.Document"));
        this.tree = new JTree(this.root);
        MarkableSetCellRenderer renderer = new MarkableSetCellRenderer();
        CustomTreeCellEditor editor = new CustomTreeCellEditor(this.tree, renderer);
        this.tree.setCellRenderer(renderer);
        this.tree.setCellEditor(editor);
        this.tree.setEditable(true);
        this.tree.addMouseListener(this);
        this.treeViewPane = new JScrollPane(this.tree);
        this.getContentPane().add(this.treeViewPane);
        MarkableLevel[] levels = this.discourse.getCurrentMarkableChart().getMarkableLevels();
        JMenuBar menu = new JMenuBar();
        menu.setLayout(new FlowLayout(0, 5, 5));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        Box tmp = Box.createHorizontalBox();
        this.levelBox = new JComboBox();
        JLabel levelBoxLabel = new JLabel("Level:");
        tmp.add(levelBoxLabel);
        tmp.add(Box.createHorizontalStrut(10));
        tmp.add(this.levelBox);
        panel.add(tmp);
        tmp = Box.createHorizontalBox();
        this.attributeBox = new JComboBox();
        this.attributeBox.addActionListener(this);
        JLabel attributeBoxLabel = new JLabel("Attribute:");
        tmp.add(attributeBoxLabel);
        tmp.add(Box.createHorizontalStrut(10));
        tmp.add(this.attributeBox);
        panel.add(tmp);
        tmp = Box.createHorizontalBox();
        this.expandAllCheckbox = new JCheckBox(Messages.getString("MMAX2MarkableSetBrowser.Expand_all"));
        this.expandAllCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int setCount = MMAX2MarkableSetBrowser.this.root.getChildCount();
                int z = 0;
                while (z < setCount) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)MMAX2MarkableSetBrowser.this.root.getChildAt(z);
                    if (!MMAX2MarkableSetBrowser.this.expandAllCheckbox.isSelected()) {
                        MMAX2MarkableSetBrowser.this.tree.collapsePath(new TreePath(node.getPath()));
                    } else {
                        MMAX2MarkableSetBrowser.this.tree.expandPath(new TreePath(node.getPath()));
                    }
                    ++z;
                }
                MMAX2MarkableSetBrowser.this.update();
            }
        });
        tmp.add(this.expandAllCheckbox);
        panel.add(tmp);
        if (levels.length == 1) {
            this.levelBox.addItem(levels[0].getMarkableLevelName());
            this.levelBox.setSelectedIndex(0);
            this.updateAttributeList((String)this.levelBox.getSelectedItem());
            this.levelBox.getParent().getParent().remove(this.levelBox.getParent());
        } else {
            this.levelBox.addItem("<none>");
            this.levelBox.setSelectedIndex(0);
            int b = 0;
            while (b < levels.length) {
                this.levelBox.addItem(levels[b].getMarkableLevelName());
                ++b;
            }
            this.attributeBox.addItem("<none>");
        }
        this.levelBox.addActionListener(this);
        menu.add(panel);
        this.setJMenuBar(menu);
        this.setTitle(Messages.getString("MMAX2MarkableSetBrowser.MMAX2_Markable_Set_Browser"));
        this.setVisible(true);
        this.pack();
        this.setLocation(0, this.mmax2.getScreenHeight() - this.getHeight());
        this.tree.expandRow(0);
    }

    public final void update() {
        this.updateSetDisplay((String)this.levelBox.getSelectedItem(), (String)this.attributeBox.getSelectedItem());
    }

    public final String getCurrentlyDisplayedMarkableLevelName() {
        return (String)this.levelBox.getSelectedItem();
    }

    public final String getCurrentlyDisplayedAttributeName() {
        return (String)this.attributeBox.getSelectedItem();
    }

    public final void updateSetDisplay(String levelName, String attributeName) {
        HashSet<String> expanded = new HashSet<String>();
        int setCount = this.root.getChildCount();
        int z = 0;
        while (z < setCount) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(z);
            if (this.tree.isExpanded(new TreePath(node.getPath())) || this.expandAllCheckbox.isSelected()) {
                expanded.add(((MarkableSet)node.getUserObject()).getAttributeValue());
            }
            ++z;
        }
        this.root.removeAllChildren();
        if (!attributeName.equals("<none>")) {
            MarkableLevel level = this.discourse.getCurrentMarkableChart().getMarkableLevelByName(levelName, false);
            MMAX2Attribute attribute = level.getCurrentAnnotationScheme().getUniqueAttributeByName("^" + attributeName.toLowerCase() + "$");
            MarkableRelation relation = attribute.getMarkableRelation();
            MarkableSet[] sets = relation.getMarkableSets(true);
            MarkableSet currentSet = null;
            int z2 = 0;
            while (z2 < sets.length) {
                currentSet = sets[z2];
                DefaultMutableTreeNode setNode = new DefaultMutableTreeNode();
                setNode.setUserObject(currentSet);
                this.root.add(setNode);
                ArrayList<Markable> allElements = new ArrayList<Markable>(Arrays.asList(currentSet.getOrderedMarkables()));
                int b = 0;
                while (b < allElements.size()) {
                    DefaultMutableTreeNode elementNode = new DefaultMutableTreeNode(((Markable)allElements.get(b)).toString());
                    elementNode.setUserObject(allElements.get(b));
                    setNode.add(elementNode);
                    ++b;
                }
                if (expanded.contains(((MarkableSet)setNode.getUserObject()).getAttributeValue())) {
                    this.tree.expandPath(new TreePath(setNode.getPath()));
                }
                ++z2;
            }
        }
        this.tree.updateUI();
        this.repaint();
    }

    public final void updateAttributeList(String levelName) {
        this.attributeBox.removeActionListener(this);
        this.attributeBox.removeAllItems();
        if (!levelName.equals("<none>")) {
            MarkableLevel level = this.discourse.getCurrentMarkableChart().getMarkableLevelByName(levelName, false);
            MMAX2Attribute[] attribs = level.getCurrentAnnotationScheme().getAttributesByType(5);
            if (attribs.length == 1) {
                this.attributeBox.addItem(attribs[0].getDisplayAttributeName());
                this.attributeBox.setSelectedIndex(0);
                this.attributeBox.getParent().getParent().remove(this.attributeBox.getParent());
            } else {
                this.attributeBox.addItem("<none>");
                int z = 0;
                while (z < attribs.length) {
                    this.attributeBox.addItem(attribs[z].getDisplayAttributeName());
                    ++z;
                }
            }
        } else {
            this.attributeBox.addItem("<none>");
        }
        this.attributeBox.addActionListener(this);
        this.root.removeAllChildren();
        this.tree.updateUI();
        this.repaint();
        this.update();
        this.pack();
    }

    @Override
    public final void dispose() {
        this.mmax2.dismissMarkableSetBrowser();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof JButton)) {
            JComboBox source = (JComboBox)e.getSource();
            if (source == this.levelBox) {
                this.updateAttributeList((String)source.getSelectedItem());
            } else if (source == this.attributeBox) {
                this.updateSetDisplay((String)this.levelBox.getSelectedItem(), (String)source.getSelectedItem());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            DefaultMutableTreeNode closestNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if ((closestNode.isLeaf() || closestNode.isRoot()) && !closestNode.isRoot()) {
                Markable selectedMarkable = (Markable)closestNode.getUserObject();
                if (e.getButton() == 3) {
                    this.discourse.getCurrentMarkableChart().markableRightClicked(selectedMarkable, this.tree, e.getPoint());
                    this.mmax2.scrollToMarkable(selectedMarkable);
                    this.mmax2.getCurrentTextPane().startAutoRefresh();
                } else if (e.getButton() == 1) {
                    this.discourse.getCurrentMarkableChart().markableLeftClicked(selectedMarkable);
                    this.mmax2.scrollToMarkable(selectedMarkable);
                    this.mmax2.getCurrentTextPane().startAutoRefresh();
                }
            }
        } else {
            this.mmax2.getCurrentDiscourse().getCurrentMarkableChart().nothingClicked(e.getButton());
        }
    }

    public void selectMarkable(Markable markable) {
        if (markable != null) {
            int i = 0;
            while (i < this.root.getChildCount()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.root.getChildAt(i);
                int j = 0;
                while (j < child.getChildCount()) {
                    DefaultMutableTreeNode member = (DefaultMutableTreeNode)child.getChildAt(j);
                    Markable m = (Markable)member.getUserObject();
                    if (m.equals(markable)) {
                        this.tree.expandPath(new TreePath(child.getPath()));
                        TreePath path = new TreePath(member.getPath());
                        this.tree.setSelectionPath(path);
                        this.tree.scrollPathToVisible(path);
                        logger.debug("Selected markable: " + markable);
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
        logger.debug("Selected markable: " + markable + " not found in set browser. Deselecting.");
        this.tree.clearSelection();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class CustomTreeCellEditor
    extends DefaultTreeCellEditor {
        public CustomTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            Object node;
            boolean returnValue = super.isCellEditable(event);
            if (returnValue && (node = this.tree.getLastSelectedPathComponent()) != null && node instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)node;
                returnValue = !treeNode.isLeaf();
            }
            return returnValue;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Object userObject;
            if (value != null && value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof MarkableSet) {
                final MarkableSet m = (MarkableSet)userObject;
                Vector<String> options = new Vector<String>();
                if (m.getDominant() != null) {
                    options.add(m.getDominant());
                } else {
                    options.add("");
                }
                Markable[] markableArray = m.getOrderedMarkables();
                int n = markableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Markable mark = markableArray[n2];
                    options.add(mark.toStringWithoutBrackets());
                    ++n2;
                }
                final JComboBox combo = new JComboBox(options);
                combo.setEditable(true);
                combo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String newSelection = combo.getSelectedItem().toString();
                        m.setDominant(newSelection, false);
                    }
                });
                return combo;
            }
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }
    }

    private class MarkableSetCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -4305190469475456883L;

        private MarkableSetCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            MarkableSet m;
            Object userObject;
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value != null && value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof MarkableSet && (m = (MarkableSet)userObject).getDominant() == null) {
                c.setForeground(Color.magenta);
            }
            return c;
        }
    }
}

