/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.plugin;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import pl.waw.ipipan.zil.core.mmax4ref.Messages;
import pl.waw.ipipan.zil.core.mmax4ref.plugin.SuperannotationPluginWindow;

class SimpleMultiLineCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = -8320008800972024094L;
    private SuperannotationPluginWindow superannotationPluginWindow;
    private List<Set<String>> allDistinctPartitionSets;
    private Map<String, String> spansToStrings;

    public SimpleMultiLineCellRenderer(SuperannotationPluginWindow superannotationPluginWindow, List<Set<String>> allDistinctPartitionSets, Map<String, String> spansToStrings) {
        this.superannotationPluginWindow = superannotationPluginWindow;
        this.allDistinctPartitionSets = allDistinctPartitionSets;
        this.spansToStrings = spansToStrings;
        this.setOpaque(true);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = value.toString();
        this.setForeground(table.getForeground());
        this.setBackground(table.getBackground());
        if (this.superannotationPluginWindow.getCurrentAttributeType().equals("set") && column > 0) {
            String valueString = (String)value;
            if (valueString.equals(SuperannotationPluginWindow.NO_VALUE)) {
                text = Messages.getString("SimpleMultiLineCellRenderer.singleton");
            } else if (valueString.equals(SuperannotationPluginWindow.NO_MARKABLE)) {
                text = Messages.getString("SimpleMultiLineCellRenderer.no_mention");
            } else {
                int val = Integer.parseInt(valueString) - 1;
                int setSize = this.allDistinctPartitionSets.get(val).size();
                text = value == null ? "" : String.valueOf(Messages.getString("SimpleMultiLineCellRenderer.cluster")) + " " + value.toString() + " (" + setSize + " " + Messages.getString("SimpleMultiLineCellRenderer.occ") + ")";
                float hue = (float)(val * 31 % 263) * 1.0f / 263.0f;
                float saturation = 0.5f;
                float luminance = 1.0f;
                Color color = Color.getHSBColor(hue, 0.5f, 1.0f);
                this.setBackground(color);
            }
        } else if (this.superannotationPluginWindow.getCurrentAttributeType().equals("pointer") && column > 0) {
            text = !value.equals(SuperannotationPluginWindow.NO_VALUE) && !value.equals(SuperannotationPluginWindow.NO_MARKABLE) ? this.spansToStrings.get(value) : (value == null ? "" : value.toString());
        } else {
            String string = text = value == null ? "" : value.toString();
            if (text.equals("+")) {
                this.setBackground(Color.green);
            }
        }
        this.setText(text);
        this.setSize(table.getColumnModel().getColumn(column).getWidth(), table.getRowHeight(row));
        int heightWanted = this.getPreferredSize().height;
        if (heightWanted > table.getRowHeight(row)) {
            table.setRowHeight(row, heightWanted);
        }
        return this;
    }
}

