/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.annotation.markables;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4ref.Messages;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Renderable;
import pl.waw.ipipan.zil.core.mmax4ref.api.MarkableSetAPI;
import pl.waw.ipipan.zil.core.mmax4ref.gui.document.MMAX2Document;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Constants;

public class MarkableSet
implements Renderable,
MarkableSetAPI {
    private static final Logger logger = Logger.getLogger(MarkableSet.class);
    private final MarkableRelation markableRelation;
    private final String attributeValue;
    private final boolean ordered;
    private Set<Markable> unorderedSet;
    private List<Markable> orderedSet;
    private int size;
    private final int lineWidth;
    private int leftMostPosition = Integer.MAX_VALUE;
    private int rightMostPosition = -1;
    private boolean opaque = false;
    private boolean permanent = false;

    public MarkableSet(String _attributeValue, boolean _ordered, int _lineWidth, Color _color, int _lineStyle, MarkableRelation relation) {
        this.attributeValue = _attributeValue;
        this.ordered = _ordered;
        if (this.ordered) {
            this.orderedSet = new ArrayList<Markable>();
        } else {
            this.unorderedSet = new HashSet<Markable>();
        }
        this.lineWidth = _lineWidth;
        this.markableRelation = relation;
    }

    @Override
    public final void setIsPermanent(boolean _permanent) {
        this.permanent = _permanent;
    }

    @Override
    public final boolean getIsPermanent() {
        return this.permanent;
    }

    public final void setOpaque(boolean status) {
        this.opaque = status;
    }

    @Override
    public final boolean isOpaque() {
        return this.opaque;
    }

    public final String getAttributeValue() {
        return this.attributeValue;
    }

    public final void removeMarkable(Markable _markable) {
        if (!this.ordered) {
            this.unorderedSet.remove(_markable);
        } else {
            this.orderedSet.remove(_markable);
        }
        --this.size;
    }

    public final void addMarkable(Markable _markable) {
        if (_markable.getLeftmostDisplayPosition() < this.leftMostPosition) {
            this.leftMostPosition = _markable.getLeftmostDisplayPosition();
        }
        if (_markable.getRightmostDisplayPosition() > this.rightMostPosition) {
            this.rightMostPosition = _markable.getRightmostDisplayPosition();
        }
        boolean added = false;
        if (!this.ordered) {
            this.unorderedSet.add(_markable);
        } else if (this.size == 0) {
            this.orderedSet.add(_markable);
        } else {
            Markable markableAtCurrentPos = null;
            int o = 0;
            while (o < this.size) {
                markableAtCurrentPos = this.orderedSet.get(o);
                if (_markable.getDisplayStartPositions()[0] < markableAtCurrentPos.getDisplayStartPositions()[0]) {
                    this.orderedSet.add(o, _markable);
                    added = true;
                    break;
                }
                if (_markable.getDisplayStartPositions()[0] == markableAtCurrentPos.getDisplayStartPositions()[0] && _markable.getSize() < markableAtCurrentPos.getSize()) {
                    this.orderedSet.add(o, _markable);
                    added = true;
                    break;
                }
                ++o;
            }
            if (!added) {
                this.orderedSet.add(_markable);
            }
        }
        ++this.size;
    }

    @Override
    public final void updateLinePoints() {
        this.updateLinePoints(false);
    }

    public final void updateLinePoints(boolean recalcExtent) {
        if (recalcExtent) {
            Markable currentMarkable = null;
            this.leftMostPosition = Integer.MAX_VALUE;
            this.rightMostPosition = -1;
            int z = 0;
            while (z < this.size) {
                currentMarkable = this.orderedSet.get(z);
                if (currentMarkable.getLeftmostDisplayPosition() < this.leftMostPosition) {
                    this.leftMostPosition = currentMarkable.getLeftmostDisplayPosition();
                }
                if (currentMarkable.getRightmostDisplayPosition() > this.rightMostPosition) {
                    this.rightMostPosition = currentMarkable.getRightmostDisplayPosition();
                }
                ++z;
            }
        }
    }

    @Override
    public final void select(Graphics2D graphics, MMAX2Document doc, Markable currentlySelectedMarkable) {
        Markable temp = null;
        this.updateLinePoints(false);
        doc.startChanges(this.leftMostPosition, this.rightMostPosition - this.leftMostPosition + 1);
        if (this.ordered && this.size > 1) {
            int z = 0;
            while (z < this.size) {
                temp = this.orderedSet.get(z);
                if (!temp.equals(currentlySelectedMarkable)) {
                    temp.renderMe(MMAX2Constants.RENDER_IN_SET);
                }
                ++z;
            }
        }
        doc.commitChanges();
    }

    @Override
    public final void refresh(Graphics2D graphics) {
    }

    @Override
    public final void unselect(MMAX2Document doc) {
        doc.startChanges(this.leftMostPosition, this.rightMostPosition - this.leftMostPosition + 1);
        if (this.ordered && this.size > 1) {
            int z = 0;
            while (z < this.size) {
                this.orderedSet.get(z).renderMe(MMAX2Constants.RENDER_UNSELECTED);
                ++z;
            }
        }
        doc.commitChanges();
        this.opaque = false;
    }

    @Override
    public final MarkableRelation getMarkableRelation() {
        return this.markableRelation;
    }

    @Override
    public final boolean containsMarkable(Markable markable) {
        if (this.ordered) {
            return this.orderedSet.contains(markable);
        }
        return this.unorderedSet.contains(markable);
    }

    public final boolean startsWithMarkable(Markable markable) {
        if (this.ordered) {
            return this.orderedSet.get(0).equals(markable);
        }
        System.err.println("startsWith undefined for unordered MarkableSet!");
        return false;
    }

    @Override
    public final Markable getInitialMarkable() {
        Markable result = null;
        if (this.ordered && !this.orderedSet.isEmpty()) {
            result = this.orderedSet.get(0);
        }
        return result;
    }

    @Override
    public final Markable[] getOrderedMarkables() {
        ArrayList<Markable> temp = new ArrayList<Markable>(this.orderedSet);
        return temp.toArray(new Markable[0]);
    }

    @Override
    public final int getMarkableIndex(Markable _markable) {
        int index = -1;
        if (this.ordered) {
            int z = 0;
            while (z < this.orderedSet.size()) {
                if (this.orderedSet.get(z) == _markable) {
                    index = z;
                    break;
                }
                ++z;
            }
        } else {
            System.err.println("Error: getMarkableIndex is undefined for unordered MarkableSets!");
        }
        return index;
    }

    public final boolean matches(int requiredSize, List<Markable> startMarkables) {
        boolean result = true;
        boolean sizeMatch = false;
        boolean startsWithMatch = false;
        if (requiredSize != -1) {
            if (this.ordered) {
                sizeMatch = requiredSize == this.orderedSet.size();
            } else {
                boolean bl = sizeMatch = requiredSize == this.unorderedSet.size();
            }
        }
        if (startMarkables != null) {
            startsWithMatch = startMarkables.contains(this.orderedSet.get(0));
        }
        if (requiredSize != -1 && startMarkables != null) {
            result = sizeMatch && startsWithMatch;
        } else if (requiredSize != -1) {
            result = sizeMatch;
        } else if (startMarkables != null) {
            result = startsWithMatch;
        }
        return result;
    }

    public final List<String> getVilainRepresentation() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.ordered) {
            int z = 0;
            while (z < this.orderedSet.size() - 1) {
                String entry = String.valueOf(MarkableHelper.getSpan(this.orderedSet.get(z))) + " " + MarkableHelper.getSpan(this.orderedSet.get(z + 1));
                result.add(entry);
                ++z;
            }
        } else {
            Markable[] temp = this.unorderedSet.toArray(new Markable[1]);
            int z = 0;
            while (z < temp.length - 1) {
                String entry = String.valueOf(MarkableHelper.getSpan(temp[z])) + " " + MarkableHelper.getSpan(temp[z + 1]);
                result.add(entry);
                ++z;
            }
        }
        return result;
    }

    public final List<String> getIDVilainRepresentation() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.ordered) {
            int z = 0;
            while (z < this.orderedSet.size() - 1) {
                String entry = String.valueOf(this.orderedSet.get(z).getID()) + " " + this.orderedSet.get(z + 1).getID();
                result.add(entry);
                ++z;
            }
        } else {
            Markable[] temp = this.unorderedSet.toArray(new Markable[1]);
            int z = 0;
            while (z < temp.length - 1) {
                String entry = String.valueOf(this.orderedSet.get(z).getID()) + " " + this.orderedSet.get(z + 1).getID();
                result.add(entry);
                ++z;
            }
        }
        return result;
    }

    public final Set<String> getSetOfStrings() {
        HashSet<String> result = new HashSet<String>();
        if (this.ordered) {
            int z = 0;
            while (z < this.orderedSet.size()) {
                result.add(MarkableHelper.getSpan(this.orderedSet.get(z)));
                ++z;
            }
        } else {
            Markable[] temp = this.unorderedSet.toArray(new Markable[1]);
            int z = 0;
            while (z < temp.length) {
                result.add(MarkableHelper.getSpan(temp[z]));
                ++z;
            }
        }
        return result;
    }

    public final int getSize() {
        return this.size;
    }

    public String toString() {
        String dom = this.getDominant();
        return String.valueOf(dom == null ? Messages.getString("MarkableSet.No_dominant") : this.getDominant()) + " [" + this.size + "]";
    }

    public final void removeMeFromMarkableRelation() {
        this.markableRelation.removeMarkableSet(this);
        this.size = 0;
    }

    @Override
    public void setFlagLevel(int _level) {
    }

    public void setDominant(String dom, boolean quiet) {
        if (dom.equals("")) {
            dom = null;
        }
        logger.debug("Setting dominant:" + dom + " for set: " + this.toString());
        Markable[] markableArray = this.getOrderedMarkables();
        int n = markableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Markable m = markableArray[n2];
            m.setDominant(dom);
            ++n2;
        }
        if (!quiet && this.getInitialMarkable() != null) {
            this.getInitialMarkable().getLevel().setIsDirty(true, true);
        }
    }

    public String getDominant() {
        HashMap<String, Integer> doms = new HashMap<String, Integer>();
        Markable[] markableArray = this.getOrderedMarkables();
        int n = markableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Markable m = markableArray[n2];
            if (doms.containsKey(m.getDominant())) {
                doms.put(m.getDominant(), (Integer)doms.get(m.getDominant()) + 1);
            } else {
                doms.put(m.getDominant(), 1);
            }
            ++n2;
        }
        if (doms.size() == 1) {
            return (String)doms.keySet().iterator().next();
        }
        logger.warn("Multiple dominants found in set " + this.getAttributeValue());
        int max = -1;
        String best = null;
        for (Map.Entry entry : doms.entrySet()) {
            Integer c = (Integer)entry.getValue();
            if (c <= max) continue;
            max = c;
            best = (String)entry.getKey();
        }
        if (max > doms.size() / 2) {
            logger.warn("A dominant dominant found in set! Correcting.");
            Markable[] markableArray2 = this.getOrderedMarkables();
            int n3 = markableArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Markable markable = markableArray2[n4];
                markable.setDominant(best);
                ++n4;
            }
            return best;
        }
        logger.warn("No dominant dominant in set! Correcting.");
        Markable[] markableArray3 = this.getOrderedMarkables();
        int n5 = markableArray3.length;
        int n6 = 0;
        while (n6 < n5) {
            Markable markable = markableArray3[n6];
            markable.setDominant(null);
            ++n6;
        }
        return null;
    }
}

