/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.gui.document;

import java.awt.Color;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;

public class MMAX2Document
extends DefaultStyledDocument {
    private static final long serialVersionUID = -8979566665447678627L;
    private static final Logger logger = Logger.getLogger(MMAX2Document.class);
    private AbstractDocument.DefaultDocumentEvent uncommittedChanges = null;
    private SimpleAttributeSet currentAttributes = null;
    private MMAX2 mmax2 = null;

    public MMAX2Document(String currentDisplayFontName, int currentDisplayFontSize, float currentDisplayLineSpacing, MMAX2 mmax22) {
        this.setStyle(currentDisplayFontName, currentDisplayFontSize, currentDisplayLineSpacing);
        this.mmax2 = mmax22;
    }

    public MMAX2Document(MMAX2Document prev, MMAX2 mmax22) {
        this.currentAttributes = new SimpleAttributeSet();
        this.setDisplayLineSpacing(prev.getDisplayLineSpacing());
        this.setDisplayFontFamily(prev.getDisplayFontFamily());
        this.setDisplayFontSize(prev.getDisplayFontSize());
        this.mmax2 = mmax22;
    }

    public void setStyle(String currentDisplayFontName, int currentDisplayFontSize, float currentDisplayLineSpacing) {
        this.currentAttributes = new SimpleAttributeSet();
        this.setDisplayLineSpacing(currentDisplayLineSpacing);
        this.setDisplayFontFamily(currentDisplayFontName);
        this.setDisplayFontSize(currentDisplayFontSize);
    }

    public final String getDisplayFontFamily() {
        return StyleConstants.getFontFamily(this.currentAttributes);
    }

    public final int getDisplayFontSize() {
        return StyleConstants.getFontSize(this.currentAttributes);
    }

    public final float getDisplayLineSpacing() {
        return StyleConstants.getLineSpacing(this.currentAttributes);
    }

    public final void setDisplayFontFamily(String name) {
        StyleConstants.setFontFamily(this.currentAttributes, name);
    }

    public final void setDisplayLineSpacing(float ls) {
        StyleConstants.setLineSpacing(this.currentAttributes, ls);
        this.setParagraphAttributes(0, this.getLength(), this.currentAttributes, false);
    }

    public final void setDisplayFontSize(int size) {
        StyleConstants.setFontSize(this.currentAttributes, size);
    }

    public final void setBold(boolean status) {
        this.flush();
        StyleConstants.setBold(this.currentAttributes, status);
    }

    public final void setUnderline(boolean status) {
        this.flush();
        StyleConstants.setUnderline(this.currentAttributes, status);
    }

    public final void setItalic(boolean status) {
        this.flush();
        StyleConstants.setItalic(this.currentAttributes, status);
    }

    public final void setSubscript(boolean status) {
        this.flush();
        StyleConstants.setSubscript(this.currentAttributes, status);
    }

    public final void setSuperscript(boolean status) {
        this.flush();
        StyleConstants.setSuperscript(this.currentAttributes, status);
    }

    public final void setStrikeThrough(boolean status) {
        this.flush();
        StyleConstants.setStrikeThrough(this.currentAttributes, status);
    }

    public final void setColor(Color color, boolean status) {
        this.flush();
        if (status) {
            StyleConstants.setForeground(this.currentAttributes, color);
        }
    }

    public final void setDefaultColor() {
        this.flush();
        StyleConstants.setForeground(this.currentAttributes, Color.black);
    }

    public void flush() {
        int currentLen = this.getLength();
        String toAppend = this.mmax2.getCurrentDiscourse().getNextDocumentChunk();
        if (!toAppend.equals("")) {
            this.currentAttributes.addAttribute("t", new String(String.valueOf(currentLen)));
            try {
                this.insertString(this.getLength(), toAppend, this.currentAttributes);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    public final void bulkApplyStyleToDisplaySpanBackground(int firstDisplayPositionToChange, int sizeOfChange, AttributeSet s) {
        if (!s.isDefined(StyleConstants.Background)) {
            System.err.println("Warning: No Background color defined in attributes for 'bulkApplyStyleToDisplaySpanBackground'!");
        }
        int offset = 0;
        int start = 0;
        int len = 0;
        Element run = null;
        MutableAttributeSet attr = null;
        int r = 0;
        while (r < sizeOfChange) {
            offset = firstDisplayPositionToChange + r;
            run = this.getCharacterElement(offset);
            if (!this.mmax2.getUseFancyMultilineRendering() || this.mmax2.getCurrentDiscourse().getDiscoursePositionAtDisplayPosition(offset) != -1 || this.mmax2.getCurrentDiscourse().getMarkableAtDisplayAssociation(offset) != null) {
                start = run.getStartOffset();
                len = run.getEndOffset() - start;
                r += len - 1;
                try {
                    attr = (MutableAttributeSet)run.getAttributes();
                    StyleConstants.setBackground(attr, StyleConstants.getBackground(s));
                }
                catch (Error ex) {
                    ex.printStackTrace();
                }
                offset = 0;
                run = null;
                attr = null;
            }
            ++r;
        }
    }

    public final void bulkApplyStyleToMarkableHandle(int characterPosition, AttributeSet s, boolean replace) {
        Element run = null;
        MutableAttributeSet attr = null;
        run = this.getCharacterElement(characterPosition);
        attr = (MutableAttributeSet)run.getAttributes();
        if (replace) {
            attr.removeAttributes(attr);
        }
        attr.addAttributes(s);
    }

    public final void bulkApplyStyleToDiscourseElement(int discourseElementStartPosition, AttributeSet s, boolean replace) {
        try {
            Element run = null;
            MutableAttributeSet attr = null;
            run = this.getCharacterElement(discourseElementStartPosition);
            try {
                attr = (MutableAttributeSet)run.getAttributes();
                if (replace) {
                    attr.removeAttributes(attr);
                }
                attr.addAttributes(s);
            }
            catch (Error ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void startChanges(Markable concerned) {
        if (concerned == null) {
            return;
        }
        int start = 0;
        int end = 0;
        start = concerned.getLeftmostDisplayPosition();
        end = concerned.getRightmostDisplayPosition();
        this.startChanges(start, end - start + 1);
    }

    public final void startChanges(Markable[] concerned) {
        int start = this.getLength();
        int end = 0;
        int currentLeft = 0;
        int currentRight = 0;
        int i = 0;
        while (i < concerned.length) {
            if (concerned[i] != null) {
                currentLeft = concerned[i].getLeftmostDisplayPosition();
                if (currentLeft < start) {
                    start = currentLeft;
                }
                if ((currentRight = concerned[i].getRightmostDisplayPosition()) > end) {
                    end = currentRight;
                }
            }
            ++i;
        }
        this.startChanges(start, end - start + 1);
    }

    public final void startChanges(int start, int length) {
        this.commitChanges();
        this.writeLock();
        this.uncommittedChanges = new AbstractDocument.DefaultDocumentEvent(this, start, length, DocumentEvent.EventType.CHANGE);
    }

    public final void commitChanges() {
        if (this.uncommittedChanges == null) {
            return;
        }
        this.uncommittedChanges.end();
        try {
            this.fireChangedUpdate(this.uncommittedChanges);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            logger.error(ex.getStackTrace());
        }
        this.uncommittedChanges = null;
        this.writeUnlock();
    }
}

