/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.gui.windows;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4ref.Messages;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkablePointer;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2AttributeValue;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.LocalResolver;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2Discourse;
import pl.waw.ipipan.zil.core.mmax4ref.gui.display.BoxIcon;

public class MMAX2MarkablePointerBrowser
extends JFrame
implements ActionListener,
WindowListener,
MouseListener {
    private static final long serialVersionUID = 6664631616154686092L;
    private static final Logger logger = Logger.getLogger(MMAX2MarkablePointerBrowser.class);
    MMAX2 mmax2 = null;
    MMAX2Discourse discourse = null;
    JLabel levelBoxLabel = null;
    JComboBox levelBox = null;
    JLabel attributeBoxLabel = null;
    JComboBox attributeBox = null;
    JScrollPane treeViewPane = null;
    JTree tree = null;
    DefaultMutableTreeNode root = null;

    public MMAX2MarkablePointerBrowser(MMAX2 _mmax2) {
        this.addWindowListener(this);
        this.mmax2 = _mmax2;
        this.discourse = this.mmax2.getCurrentDiscourse();
        this.root = new DefaultMutableTreeNode(Messages.getString("MMAX2MarkablePointerBrowser.Document"));
        this.tree = new JTree(this.root);
        MarkablePointerCellRenderer renderer = new MarkablePointerCellRenderer();
        this.tree.setCellRenderer(renderer);
        this.tree.addMouseListener(this);
        this.treeViewPane = new JScrollPane(this.tree);
        this.getContentPane().add(this.treeViewPane);
        JMenuBar menu = new JMenuBar();
        menu.setLayout(new FlowLayout(0, 5, 5));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        Box tmp = Box.createHorizontalBox();
        this.levelBox = new JComboBox();
        this.levelBoxLabel = new JLabel("Level:");
        tmp.add(this.levelBoxLabel);
        tmp.add(Box.createHorizontalStrut(10));
        tmp.add(this.levelBox);
        panel.add(tmp);
        tmp = Box.createHorizontalBox();
        this.attributeBox = new JComboBox();
        this.attributeBox.addActionListener(this);
        this.attributeBoxLabel = new JLabel("");
        tmp.add(this.attributeBoxLabel);
        tmp.add(Box.createHorizontalStrut(10));
        tmp.add(this.attributeBox);
        panel.add(tmp);
        MarkableLevel[] levels = this.discourse.getCurrentMarkableChart().getMarkableLevels();
        if (levels.length == 1) {
            this.levelBox.addItem(levels[0].getMarkableLevelName());
            this.levelBox.setSelectedIndex(0);
            this.updateAttributeList((String)this.levelBox.getSelectedItem());
            this.levelBox.getParent().getParent().remove(this.levelBox.getParent());
        } else {
            this.levelBox.addItem("<none>");
            this.levelBox.setSelectedIndex(0);
            int b = 0;
            while (b < levels.length) {
                this.levelBox.addItem(levels[b].getMarkableLevelName());
                ++b;
            }
        }
        this.levelBox.addActionListener(this);
        menu.add(panel);
        this.setJMenuBar(menu);
        this.setTitle(Messages.getString("MMAX2MarkablePointerBrowser.MMAX2_Markable_Pointer_Browser"));
        this.setVisible(true);
        this.tree.expandRow(0);
        this.pack();
    }

    public final void update() {
        this.updatePointerDisplay((String)this.levelBox.getSelectedItem());
    }

    public final String getCurrentlyDisplayedMarkableLevelName() {
        return (String)this.levelBox.getSelectedItem();
    }

    public final String getCurrentlyDisplayedAttributeName() {
        MMAX2Attribute selectedItem = (MMAX2Attribute)this.attributeBox.getSelectedItem();
        return selectedItem.getDisplayAttributeName();
    }

    public final void updatePointerDisplay(String levelName) {
        MMAX2Attribute[] attributes;
        HashSet<String> expanded = new HashSet<String>();
        int setCount = this.root.getChildCount();
        int z = 0;
        while (z < setCount) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(z);
            expanded.add(((MMAX2Attribute)node.getUserObject()).getName());
            ++z;
        }
        this.root.removeAllChildren();
        MarkableLevel level = this.discourse.getCurrentMarkableChart().getMarkableLevelByName(levelName, false);
        MMAX2Attribute[] mMAX2AttributeArray = attributes = level.getCurrentAnnotationScheme().getAttributesByType(6);
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            MMAX2Attribute linkAttr = mMAX2AttributeArray[n2];
            MarkableRelation relation = linkAttr.getMarkableRelation();
            MarkablePointer[] pointers = relation.getMarkablePointers(true);
            if (pointers.length > 0) {
                DefaultMutableTreeNode pointerType = new DefaultMutableTreeNode(linkAttr);
                this.root.add(pointerType);
                MarkablePointer[] markablePointerArray = pointers;
                int n3 = pointers.length;
                int n4 = 0;
                while (n4 < n3) {
                    MarkablePointer currentPointer = markablePointerArray[n4];
                    DefaultMutableTreeNode pointerNode = new DefaultMutableTreeNode(currentPointer);
                    pointerType.add(pointerNode);
                    ++n4;
                }
                if (expanded.contains(linkAttr.getName())) {
                    this.tree.expandPath(new TreePath(pointerType.getPath()));
                }
            }
            ++n2;
        }
        this.tree.updateUI();
        this.repaint();
    }

    public final void updateAttributeList(String levelName) {
        this.attributeBox.removeActionListener(this);
        this.attributeBox.removeAllItems();
        this.attributeBox.addItem("<all>");
        this.attributeBox.setSelectedIndex(0);
        this.attributeBox.getParent().getParent().remove(this.attributeBox.getParent());
        this.attributeBox.addActionListener(this);
        this.root.removeAllChildren();
        this.tree.updateUI();
        this.repaint();
        this.update();
        this.pack();
        this.setLocation(0, this.mmax2.getScreenHeight() - this.getHeight());
    }

    @Override
    public final void dispose() {
        this.mmax2.dismissMarkablePointerBrowser();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox source = (JComboBox)e.getSource();
        if (source == this.levelBox) {
            this.updateAttributeList((String)source.getSelectedItem());
        } else if (source == this.attributeBox) {
            this.updatePointerDisplay((String)this.levelBox.getSelectedItem());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            DefaultMutableTreeNode closestNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            this.tree.setSelectionPath(selPath);
            if (!closestNode.isRoot() && closestNode.isLeaf()) {
                final MarkablePointer selectedPointer = (MarkablePointer)closestNode.getUserObject();
                final Markable selectedMarkable = selectedPointer.getSourceMarkable();
                this.discourse.getCurrentMarkableChart().markableLeftClicked(selectedMarkable);
                this.mmax2.scrollToMarkable(selectedMarkable);
                this.mmax2.getCurrentTextPane().startAutoRefresh();
                if (e.getButton() == 3) {
                    final MarkableRelation markableRelation = selectedPointer.getMarkableRelation();
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem(selectedPointer.toString());
                    menu.add(item);
                    menu.addSeparator();
                    item = new JMenuItem("    " + Messages.getString("MMAX2MarkablePointerBrowser.Delete_pointer"), new BoxIcon(markableRelation.getAttribute().getLineColor()));
                    menu.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            MMAX2MarkablePointerBrowser.this.mmax2.saveStateForUndo();
                            MMAX2MarkablePointerBrowser.this.discourse.getCurrentMarkableChart().removeMarkablePointerWithSourceMarkable(selectedMarkable, markableRelation, true);
                        }
                    });
                    menu.addSeparator();
                    item = new JMenuItem(Messages.getString("MMAX2MarkablePointerBrowser.Set_facet"));
                    menu.add(item);
                    for (MMAX2AttributeValue option : selectedPointer.getFacetOrderedValues()) {
                        final String optionName = option.getName();
                        item = optionName.equals(selectedPointer.getSelectedFacet()) ? new JMenuItem("    " + option.getLocalizedName(), new BoxIcon(markableRelation.getAttribute().getLineColor())) : new JMenuItem("    " + option.getLocalizedName());
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                selectedPointer.setFacet(optionName);
                            }
                        });
                        menu.add(item);
                    }
                    menu.show(this.tree, e.getX(), e.getY());
                }
            }
        } else {
            this.discourse.getCurrentMarkableChart().nothingClicked(e.getButton());
        }
    }

    public void selectMarkable(Markable markable) {
        if (markable != null) {
            int i = 0;
            while (i < this.root.getChildCount()) {
                DefaultMutableTreeNode pointerType = (DefaultMutableTreeNode)this.root.getChildAt(i);
                int j = 0;
                while (j < pointerType.getChildCount()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)pointerType.getChildAt(j);
                    MarkablePointer pointer = (MarkablePointer)child.getUserObject();
                    Markable source = pointer.getSourceMarkable();
                    if (source.equals(markable)) {
                        TreePath path = new TreePath(child.getPath());
                        this.tree.setSelectionPath(path);
                        this.tree.scrollPathToVisible(path);
                        logger.debug("Selected markable: " + markable);
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
        logger.debug("Selected markable: " + markable + " not found in pointer browser. Deselecting.");
        this.tree.clearSelection();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.mmax2.requestWindowsToFront(e);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private class MarkablePointerCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1022886120940435400L;

        private MarkablePointerCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value != null && value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof MarkablePointer) {
                MarkablePointer m = (MarkablePointer)userObject;
                String facetImage = m.getSelectedFacetImage();
                this.setIcon(new ImageIcon(LocalResolver.getImage(facetImage).getAbsolutePath()));
            }
            return c;
        }
    }
}

