/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.annotation.markables;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkablePointer;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Renderable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4ref.api.MarkableRelationAPI;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Utils;

public class MarkableRelation
implements MarkableRelationAPI {
    private static final Logger logger = Logger.getLogger(MarkableRelation.class);
    private MMAX2Attribute attribute;
    private boolean ordered;
    private Map<String, Renderable> individualSets;
    private int lineWidth;
    private Color lineColor;
    private Color defaultLineColor;
    private int lineStyle;
    private int defaultLineStyle;
    private String attributeNameToShowInFlag = "";
    private int maxSize;
    private boolean dashed;

    public MarkableRelation(MMAX2Attribute _attribute, int type, boolean _ordered, int _lineWidth, Color _color, int _lineStyle, int _maxSize, boolean _dashed, String _attributeNameToShowInFlag) {
        this.attributeNameToShowInFlag = _attributeNameToShowInFlag;
        this.attribute = _attribute;
        this.ordered = _ordered;
        this.individualSets = new HashMap<String, Renderable>();
        this.lineWidth = _lineWidth;
        this.defaultLineColor = _color;
        this.lineColor = _color;
        this.lineStyle = _lineStyle;
        this.defaultLineStyle = _lineStyle;
        this.maxSize = _maxSize;
        this.dashed = _dashed;
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(Color _color) {
        this.lineColor = _color == null ? this.defaultLineColor : _color;
    }

    public final String getAttributeNameToShowInFlag() {
        return this.attributeNameToShowInFlag;
    }

    public final int getLineStyle() {
        return this.lineStyle;
    }

    public final void setLineStyle(Integer _style) {
        this.lineStyle = _style == null ? this.defaultLineStyle : _style;
    }

    @Override
    public final MarkableSet[] getMarkableSets(boolean order) {
        ArrayList<Renderable> allSets = new ArrayList<Renderable>(this.individualSets.values());
        MarkableSet[] sets = allSets.toArray(new MarkableSet[0]);
        if (order) {
            Arrays.sort(sets, new MarkableSetComparator());
        }
        return sets;
    }

    @Override
    public final MarkablePointer[] getMarkablePointers(boolean order) {
        ArrayList<Renderable> allPointers = new ArrayList<Renderable>(this.individualSets.values());
        MarkablePointer[] pointers = allPointers.toArray(new MarkablePointer[0]);
        if (order) {
            Arrays.sort(pointers, new MarkablePointerComparator());
        }
        return pointers;
    }

    public final String getAttributeName() {
        return this.attribute.getLowerCasedAttributeName();
    }

    public final MMAX2Attribute getAttribute() {
        return this.attribute;
    }

    public final MarkableSet addMarkableWithAttributeValueToMarkableSet(Markable _markable, String value) {
        MarkableSet oldSet = (MarkableSet)this.individualSets.get(value);
        if (oldSet == null) {
            oldSet = new MarkableSet(value, this.ordered, this.lineWidth, this.lineColor, this.lineStyle, this);
            this.individualSets.put(value, oldSet);
        }
        oldSet.addMarkable(_markable);
        return oldSet;
    }

    @Override
    public final MarkableSet getMarkableSetWithAttributeValue(String _attributeValue) {
        return (MarkableSet)this.individualSets.get(_attributeValue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final MarkableSet getMarkableSetContainingMarkable(Markable contained) {
        void var2_6;
        Object var2_2 = null;
        for (MarkableSet markableSet : this.individualSets.values()) {
            if (markableSet.containsMarkable(contained)) break;
            Object var2_5 = null;
        }
        return var2_6;
    }

    public final void removeMarkableSet(MarkableSet removee) {
        this.individualSets.remove(removee.getAttributeValue());
    }

    public final void removeMarkablePointer(MarkablePointer removee) {
        removee.setDefaultFacet();
        this.individualSets.remove(removee.getSourceMarkable().getID());
    }

    public final void createMarkablePointer(Markable sourceMarkable, MarkableLevel sourceMarkableLevel) {
        MarkablePointer newMarkablePointer = new MarkablePointer(sourceMarkable, this.lineWidth, this.lineColor, this.lineStyle, this.maxSize, this, this.dashed);
        List<String> allTargetIDs = MMAX2Utils.parseTargetSpan(sourceMarkable.getAttributeValue(this.getAttributeName()), ";");
        int z = 0;
        while (z < allTargetIDs.size()) {
            Markable currentTarget;
            String currentIDEntry;
            String currentID = currentIDEntry = allTargetIDs.get(z);
            String currentTargetLevelName = sourceMarkableLevel.getMarkableLevelName();
            MarkableLevel currentTargetMarkableLevel = sourceMarkableLevel;
            if (currentIDEntry.indexOf(":") != -1) {
                currentTargetLevelName = currentIDEntry.substring(0, currentIDEntry.indexOf(":"));
                currentTargetMarkableLevel = sourceMarkableLevel.getCurrentDiscourse().getMarkableLevelByName(currentTargetLevelName, false);
                currentID = currentIDEntry.substring(currentIDEntry.indexOf(":") + 1);
            }
            if ((currentTarget = sourceMarkableLevel.getCurrentDiscourse().getCurrentMarkableChart().getMarkableByID(currentID, currentTargetMarkableLevel)) != null) {
                newMarkablePointer.addTargetMarkable(currentTarget);
            } else {
                System.err.println("Markable " + currentID + " was not found");
            }
            ++z;
        }
        this.individualSets.put(new String(sourceMarkable.getID()), newMarkablePointer);
    }

    public final void createMarkablePointer(Markable sourceMarkable, Markable firstTargetMarkable) {
        MarkablePointer newMarkablePointer = new MarkablePointer(sourceMarkable, this.lineWidth, this.lineColor, this.lineStyle, this.maxSize, this, this.dashed);
        newMarkablePointer.addTargetMarkable(firstTargetMarkable);
        this.individualSets.put(new String(sourceMarkable.getID()), newMarkablePointer);
    }

    @Override
    public final MarkablePointer getMarkablePointerForSourceMarkable(Markable sourceMarkable) {
        return (MarkablePointer)this.individualSets.get(sourceMarkable.getID());
    }

    @Override
    public final MarkablePointer[] getMarkablePointersWithTargetMarkable(Markable target) {
        ArrayList<MarkablePointer> result = new ArrayList<MarkablePointer>();
        Iterator<String> allPointerSets = this.individualSets.keySet().iterator();
        while (allPointerSets.hasNext()) {
            MarkablePointer currentMarkablePointer = (MarkablePointer)this.individualSets.get(allPointerSets.next());
            if (!currentMarkablePointer.isTargetMarkable(target)) continue;
            result.add(currentMarkablePointer);
        }
        return result.toArray(new MarkablePointer[0]);
    }

    public Set<String> getMarkableSetsIds() {
        return this.individualSets.keySet();
    }

    class MarkablePointerComparator
    implements Comparator {
        MarkablePointerComparator() {
        }

        public int compare(Object o1, Object o2) {
            int m2;
            MarkablePointer p1 = (MarkablePointer)o1;
            MarkablePointer p2 = (MarkablePointer)o2;
            int m1 = p1.getSourceMarkable().getLeftmostDiscoursePosition();
            if (m1 < (m2 = p2.getSourceMarkable().getLeftmostDiscoursePosition())) {
                return -1;
            }
            if (m2 < m1) {
                return 1;
            }
            return 0;
        }
    }

    class MarkableSetComparator
    implements Comparator {
        MarkableSetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int m2;
            MarkableSet s1 = (MarkableSet)o1;
            MarkableSet s2 = (MarkableSet)o2;
            int m1 = s1.getInitialMarkable().getLeftmostDiscoursePosition();
            if (m1 < (m2 = s2.getInitialMarkable().getLeftmostDiscoursePosition())) {
                return -1;
            }
            if (m2 < m1) {
                return 1;
            }
            return 0;
        }
    }
}

