/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.plugin;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4ref.Messages;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableFileLoader;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.comparator.other.MarkableSpanComparator;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2AnnotationScheme;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2Discourse;
import pl.waw.ipipan.zil.core.mmax4ref.plugin.MMAX2Plugin;
import pl.waw.ipipan.zil.core.mmax4ref.plugin.SimpleMultiLineCellRenderer;
import pl.waw.ipipan.zil.core.mmax4ref.plugin.SuperannotationListener;
import pl.waw.ipipan.zil.core.mmax4ref.plugin.SuperannotationMenu;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Constants;

public class SuperannotationPluginWindow
extends MMAX2Plugin {
    private static final String STRING_COLUMN_HEADER = Messages.getString("SuperannotationPluginWindow.mention");
    public static final String NO_MARKABLE = Messages.getString("SuperannotationPluginWindow.no_mention");
    public static final String NO_VALUE = Messages.getString("SuperannotationPluginWindow.empty");
    private static final long serialVersionUID = 3574674289514519098L;
    private static Logger logger = Logger.getLogger(SuperannotationPluginWindow.class);
    private MMAX2 mmax2 = null;
    private MMAX2Discourse discourse = null;
    private MarkableLevel majorLevel = null;
    private List<MarkableLevel> minorLevels = new ArrayList<MarkableLevel>();
    private String majorLevelName = "";
    private String majorLevelLocalizedName = "";
    private String majorLevelSchemeFileName = "";
    private String majorLevelCustomizationFileName = "";
    private String currentAttributeName = "no_attribute";
    private String currentAttributeType = "no_attribute";
    private JTable table = null;
    private String[][] tableData = null;
    private JScrollPane tablePane = null;
    private List<Integer> columnWidths = new ArrayList<Integer>(Arrays.asList(300, 100));
    private List<Map<String, String>> spanToIDMappingsForAllLevels = null;
    public static int MAJOR_COLUMN = 2;
    private SuperannotationListener listener;
    private SuperannotationMenu menu;

    public SuperannotationPluginWindow() {
    }

    public SuperannotationPluginWindow(MMAX2Discourse _discourse) {
        logger.info("Starting " + SuperannotationPluginWindow.class.getSimpleName() + ".");
        this.setTitle(Messages.getString("SuperannotationPluginWindow.Supeannotation_Window"));
        this.discourse = _discourse;
        this.mmax2 = this.discourse.getMMAX2();
        this.listener = new SuperannotationListener(this);
        this.menu = new SuperannotationMenu(this.listener);
        this.setJMenuBar(this.menu);
        this.tableData = new String[1][1];
        this.tableData[0][0] = "";
        Object[] header = new String[]{"SPAN", STRING_COLUMN_HEADER};
        DefaultTableModel dm = new DefaultTableModel();
        dm.setDataVector(this.tableData, header);
        this.table = new JTable(dm){
            private static final long serialVersionUID = 480808351088028798L;

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(0);
        this.addWindowListener(this.listener);
        this.table.addMouseListener(this.listener);
        this.table.addKeyListener(this.listener);
        this.table.getTableHeader().addMouseListener(this.listener);
        this.table.getSelectionModel().addListSelectionListener(this.listener);
        this.tablePane = new JScrollPane(this.table);
        Box upperPanelBox = Box.createVerticalBox();
        upperPanelBox.add(this.tablePane);
        upperPanelBox.add(Box.createVerticalStrut(5));
        Box lowerBox = Box.createHorizontalBox();
        JButton refreshButton = new JButton(Messages.getString("SuperannotationPluginWindow.Refresh"));
        refreshButton.setActionCommand("refresh");
        refreshButton.addActionListener(this.listener);
        lowerBox.add(refreshButton);
        JButton copyChanges = new JButton(Messages.getString("SuperannotationPluginWindow.Accept_visible_version"));
        copyChanges.setActionCommand("sync");
        copyChanges.addActionListener(this.listener);
        lowerBox.add(copyChanges);
        upperPanelBox.add(lowerBox);
        upperPanelBox.add(Box.createVerticalStrut(5));
        this.getContentPane().add(upperPanelBox);
        this.loadLevels();
        this.pack();
        this.setVisible(true);
        _discourse.getMMAX2().addRunningPlugin(this);
    }

    public void loadLevels() {
        MarkableLevel[] baseLevels = this.mmax2.getCurrentDiscourse().getCurrentMarkableChart().getMarkableLevels();
        this.majorLevel = baseLevels[0];
        this.majorLevelName = this.majorLevel.getMarkableLevelName();
        this.majorLevelSchemeFileName = this.majorLevel.getCurrentAnnotationScheme().getSchemeFileName();
        this.majorLevelCustomizationFileName = this.majorLevel.getCustomizationFileName();
        this.majorLevelLocalizedName = this.majorLevel.getMarkableLevelLocalizedName();
        this.minorLevels = new ArrayList<MarkableLevel>();
        char letter = 'A';
        while (letter <= 'Z') {
            String letterStr = Character.toString(letter);
            if (!this.mmax2.currentMmaxFilename.startsWith(letterStr)) {
                String requestedFileName = String.valueOf(letterStr) + "_mentions.xml";
                requestedFileName = new File(this.mmax2.currentWorkingDirectory) + File.separator + requestedFileName;
                if (new File(requestedFileName).exists()) {
                    this.minorLevels.add(this.loadOtherLevel(requestedFileName));
                    this.columnWidths.add(100);
                }
            }
            letter = (char)(letter + '\u0001');
        }
        this.updateMenuAndMarkablesDisplay();
    }

    public void updateMenuAndMarkablesDisplay() {
        if (this.minorLevels.size() > 0) {
            this.menu.updateAttributeMenu(this.majorLevel.getCurrentAnnotationScheme(), this.attributesWithDiffs());
            this.updateMarkableDisplay();
        }
    }

    private MarkableLevel loadOtherLevel(String requestedFileName) {
        MarkableFileLoader mfl = new MarkableFileLoader();
        mfl.load(requestedFileName, this.majorLevelName, this.majorLevelSchemeFileName, this.majorLevelCustomizationFileName, this.majorLevelLocalizedName);
        MarkableLevel thisLevel = mfl.getMarkableLevel();
        thisLevel.setCurrentDiscourse(this.mmax2.getCurrentDiscourse());
        thisLevel.createMarkables();
        thisLevel.initMarkableRelations();
        thisLevel.setMarkableDisplayPositions();
        thisLevel.createDiscoursePositionToMarkableMapping();
        thisLevel.getRenderer().updateSimpleMarkableCustomizations(true);
        return thisLevel;
    }

    public static void show(MMAX2Discourse discourse) {
        try {
            SuperannotationPluginWindow diffWindow = new SuperannotationPluginWindow(discourse);
            diffWindow.setVisible(true);
        }
        catch (Exception e) {
            logger.error("Error loading plugin. ", e);
        }
    }

    private MarkableSet getMarkableSet(String attributeName, String markableID, MarkableLevel level) {
        if (markableID == null) {
            return null;
        }
        MMAX2Attribute currentSetAttribute = level.getCurrentAnnotationScheme().getUniqueAttributeByNameAndType("^" + attributeName + "$", 5);
        if (currentSetAttribute == null) {
            System.err.println("Warning: No set attribute '" + attributeName + "' on level '" + level.getMarkableLevelName() + "'!");
            return null;
        }
        MarkableRelation currentSetRelation = currentSetAttribute.getMarkableRelation();
        if (currentSetRelation == null) {
            System.err.println("Warning: No set relation '" + attributeName + "' on level '" + level.getMarkableLevelName() + "'!");
            return null;
        }
        return currentSetRelation.getMarkableSetWithAttributeValue(level.getMarkableByID(markableID).getAttributeValue(attributeName, ""));
    }

    public Map<String, Set<String>> getAllDistinctPartitionSets(String attributeName, int attributeType, MarkableLevel level, List<Set<String>> allDistinctPartitionSets, Set<String> allSpans) {
        HashMap<String, Set<String>> mapping = new HashMap<String, Set<String>>();
        MMAX2Attribute currentSetAttribute = level.getCurrentAnnotationScheme().getUniqueAttributeByNameAndType("^" + attributeName + "$", 5);
        if (currentSetAttribute == null) {
            System.err.println("Warning: No set attribute '" + attributeName + "' on level '" + level.getMarkableLevelName() + "'!");
            return null;
        }
        MarkableRelation currentSetRelation = currentSetAttribute.getMarkableRelation();
        if (currentSetRelation == null) {
            System.err.println("Warning: No set relation '" + attributeName + "' on level '" + level.getMarkableLevelName() + "'!");
            return null;
        }
        MarkableSet[] allSets = currentSetRelation.getMarkableSets(false);
        int z = 0;
        while (z < allSets.length) {
            MarkableSet currentSet = allSets[z];
            Set<String> temp = currentSet.getSetOfStrings();
            if (!allDistinctPartitionSets.contains(temp)) {
                allDistinctPartitionSets.add(temp);
            }
            mapping.put(currentSet.getAttributeValue(), temp);
            ++z;
        }
        return mapping;
    }

    public void updateMarkableDisplay() {
        DefaultTableModel dm = new DefaultTableModel();
        if (this.majorLevel == null || this.minorLevels.size() == 0) {
            this.tableData = new String[1][1];
            this.tableData[0][0] = "";
            Object[] header = new String[]{"SPAN", STRING_COLUMN_HEADER};
            dm.setDataVector(this.tableData, header);
            this.table.setModel(dm);
            this.table.updateUI();
            return;
        }
        ArrayList<String> tempHeader = new ArrayList<String>();
        tempHeader.add("SPAN");
        tempHeader.add(STRING_COLUMN_HEADER);
        tempHeader.add(new File(this.majorLevel.getAbsoluteMarkableFileName()).getName());
        for (MarkableLevel minorLevel : this.minorLevels) {
            tempHeader.add(new File(minorLevel.getAbsoluteMarkableFileName()).getName());
        }
        HashMap<String, String> spansToStrings = new HashMap<String, String>();
        this.spanToIDMappingsForAllLevels = new ArrayList<Map<String, String>>();
        HashMap<String, String> currentLevelsSpanToIDMappings = new HashMap<String, String>();
        HashSet<String> allSpans = new HashSet<String>();
        HashSet<String> majorSpans = new HashSet<String>();
        ArrayList<Set<String>> minorLevelsSpans = new ArrayList<Set<String>>();
        for (Markable temp : this.majorLevel.getMarkables()) {
            String tempSpan = MarkableHelper.getSpan(temp);
            allSpans.add(tempSpan);
            if (majorSpans.contains(tempSpan)) {
                logger.error("Duplicate span: " + tempSpan + " in base mention file");
                this.majorLevel.getCurrentDiscourse().getCurrentMarkableChart().deleteMarkable(temp);
                continue;
            }
            majorSpans.add(tempSpan);
            spansToStrings.put(tempSpan, temp.toString());
            currentLevelsSpanToIDMappings.put(tempSpan, temp.getID());
        }
        this.spanToIDMappingsForAllLevels.add(currentLevelsSpanToIDMappings);
        for (MarkableLevel minorLevel : this.minorLevels) {
            HashSet<String> minorSpans = new HashSet<String>();
            currentLevelsSpanToIDMappings = new HashMap();
            for (Markable markable : minorLevel.getMarkables()) {
                String tempSpan = MarkableHelper.getSpan(markable);
                if (minorSpans.contains(tempSpan)) {
                    logger.error("Duplicate span: " + tempSpan + " in second mention file");
                    minorLevel.getCurrentDiscourse().getCurrentMarkableChart().deleteMarkable(markable);
                    continue;
                }
                minorSpans.add(tempSpan);
                allSpans.add(tempSpan);
                spansToStrings.put(tempSpan, markable.toString());
                currentLevelsSpanToIDMappings.put(tempSpan, markable.getID());
            }
            this.spanToIDMappingsForAllLevels.add(currentLevelsSpanToIDMappings);
            minorLevelsSpans.add(minorSpans);
        }
        ArrayList<Set<String>> allDistinctPartitionSets = new ArrayList<Set<String>>();
        ArrayList<Map<String, Set<String>>> partitionToSetIDMappingsForAllLevels = new ArrayList<Map<String, Set<String>>>();
        if (this.getCurrentAttributeType().equals("set")) {
            partitionToSetIDMappingsForAllLevels.add(this.getAllDistinctPartitionSets(this.currentAttributeName, 5, this.majorLevel, allDistinctPartitionSets, allSpans));
            for (MarkableLevel minorLevel : this.minorLevels) {
                partitionToSetIDMappingsForAllLevels.add(this.getAllDistinctPartitionSets(this.currentAttributeName, 5, minorLevel, allDistinctPartitionSets, allSpans));
            }
        }
        ArrayList<String> allSpansSorted = new ArrayList<String>(allSpans);
        Collections.sort(allSpansSorted, new MarkableSpanComparator());
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        this.iterateSpans(majorSpans, minorLevelsSpans, allSpansSorted, spansToStrings, allDistinctPartitionSets, partitionToSetIDMappingsForAllLevels, arrayList);
        this.tableData = new String[arrayList.size()][3 + this.minorLevels.size()];
        int b = 0;
        while (b < arrayList.size()) {
            this.tableData[b] = (String[])arrayList.get(b);
            ++b;
        }
        Object[] header = tempHeader.toArray(new String[1]);
        dm.setDataVector(this.tableData, header);
        int i = 0;
        while (i < this.table.getColumnModel().getColumnCount()) {
            this.columnWidths.set(i, this.table.getColumnModel().getColumn(i).getWidth());
            ++i;
        }
        this.table.setModel(dm);
        this.table.setDefaultRenderer(Object.class, new SimpleMultiLineCellRenderer(this, allDistinctPartitionSets, spansToStrings));
        this.table.removeColumn(this.table.getColumnModel().getColumn(0));
        i = 0;
        while (i < this.table.getColumnModel().getColumnCount()) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.columnWidths.get(i));
            ++i;
        }
        this.table.updateUI();
    }

    private void iterateSpans(Set<String> majorSpans, List<Set<String>> minorLevelsSpans, List<String> allSpans, Map<String, String> spansToStrings, List<Set<String>> allDistinctPartitionSets, List<Map<String, Set<String>>> partitionToSetIDMappingsForAllLevels, List<String[]> rowsToDisplay) {
        int line = 0;
        while (line < allSpans.size()) {
            String currentSpan;
            String[] currentTableLine = new String[minorLevelsSpans.size() + 3];
            currentTableLine[0] = currentSpan = allSpans.get(line);
            currentTableLine[1] = spansToStrings.get(currentSpan);
            if (this.currentAttributeName.equals("no_attribute")) {
                currentTableLine = this.mentionsLine(currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
            } else if (this.getCurrentAttributeType().equals("head")) {
                currentTableLine = this.valueLine(this.currentAttributeName, currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
            } else if (this.getCurrentAttributeType().equals("type")) {
                currentTableLine = this.valueLine(this.currentAttributeName, currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
            } else if (this.getCurrentAttributeType().equals("freetext")) {
                currentTableLine = this.valueLine(this.currentAttributeName, currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
            } else if (this.getCurrentAttributeType().equals("set")) {
                currentTableLine = this.mentionsSetLine(currentTableLine, currentSpan, majorSpans, minorLevelsSpans, allDistinctPartitionSets, partitionToSetIDMappingsForAllLevels);
            } else if (this.getCurrentAttributeType().equals("pointer")) {
                currentTableLine = this.pointerLine(currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
            } else if (this.getCurrentAttributeType().equals("dominant")) {
                currentTableLine = this.dominantLine(currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
            }
            if (!this.sameValues(Arrays.copyOfRange(currentTableLine, 2, minorLevelsSpans.size() + 3))) {
                rowsToDisplay.add(currentTableLine);
            }
            ++line;
        }
    }

    private String[] mentionsLine(String[] currentLine, String currentSpan, Set<String> majorSpans, List<Set<String>> minorLevelsSpans) {
        currentLine[2] = majorSpans.contains(currentSpan) ? "+" : "-";
        int level = 0;
        while (level < minorLevelsSpans.size()) {
            currentLine[level + 3] = minorLevelsSpans.get(level).contains(currentSpan) ? "+" : "-";
            ++level;
        }
        return currentLine;
    }

    private String[] valueLine(String attributeName, String[] currentLine, String currentSpan, Set<String> majorSpans, List<Set<String>> minorLevelsSpans) {
        String val = this.getAttributeValue(attributeName, currentSpan, 0, this.spanToIDMappingsForAllLevels);
        if (val.equals("")) {
            val = NO_VALUE;
        }
        currentLine[2] = val;
        int level = 0;
        while (level < minorLevelsSpans.size()) {
            val = this.getAttributeValue(attributeName, currentSpan, level + 1, this.spanToIDMappingsForAllLevels);
            if (val.equals("")) {
                val = NO_VALUE;
            }
            currentLine[level + 3] = val;
            ++level;
        }
        return currentLine;
    }

    private String[] mentionsSetLine(String[] currentLine, String currentSpan, Set<String> majorSpans, List<Set<String>> minorLevelsSpans, List<Set<String>> allDistinctPartitionSets, List<Map<String, Set<String>>> partitionToSetIDMappingsForAllLevels) {
        String val;
        String setID = this.getAttributeValue("set", currentSpan, 0, this.spanToIDMappingsForAllLevels);
        if (setID.equalsIgnoreCase("empty")) {
            setID = NO_VALUE;
        }
        currentLine[2] = val = this.getDisplayValueForSetID(setID, 0, partitionToSetIDMappingsForAllLevels, allDistinctPartitionSets, currentSpan);
        int level = 0;
        while (level < minorLevelsSpans.size()) {
            setID = this.getAttributeValue("set", currentSpan, level + 1, this.spanToIDMappingsForAllLevels);
            if (setID.equalsIgnoreCase("empty")) {
                setID = NO_VALUE;
            }
            currentLine[level + 3] = val = this.getDisplayValueForSetID(setID, level + 1, partitionToSetIDMappingsForAllLevels, allDistinctPartitionSets, currentSpan);
            ++level;
        }
        return currentLine;
    }

    private String[] pointerLine(String[] currentLine, String currentSpan, Set<String> majorSpans, List<Set<String>> minorLevelsSpans) {
        Markable m;
        String pointerVal = this.getAttributeValue("pointer", currentSpan, 0, this.spanToIDMappingsForAllLevels);
        if (pointerVal.equalsIgnoreCase("empty") || pointerVal.equals("")) {
            pointerVal = NO_VALUE;
        } else if (!pointerVal.equalsIgnoreCase(NO_MARKABLE) && (m = this.majorLevel.getMarkableByID(pointerVal)) != null) {
            pointerVal = MarkableHelper.getSpan(m);
        }
        currentLine[2] = pointerVal;
        int level = 0;
        while (level < minorLevelsSpans.size()) {
            Markable m2;
            pointerVal = this.getAttributeValue("pointer", currentSpan, level + 1, this.spanToIDMappingsForAllLevels);
            if (pointerVal.equalsIgnoreCase("empty") || pointerVal.equals("")) {
                pointerVal = NO_VALUE;
            } else if (!pointerVal.equalsIgnoreCase(NO_MARKABLE) && (m2 = this.minorLevels.get(level).getMarkableByID(pointerVal)) != null) {
                pointerVal = MarkableHelper.getSpan(m2);
            }
            currentLine[level + 3] = pointerVal;
            ++level;
        }
        return currentLine;
    }

    private String[] dominantLine(String[] currentLine, String currentSpan, Set<String> majorSpans, List<Set<String>> minorLevelsSpans) {
        String dom;
        Markable m = this.getMarkableFromSpan(currentSpan, 0, this.majorLevel);
        currentLine[2] = m == null || m.getAttributeValue("mention_group").equals("empty") ? NO_MARKABLE : ((dom = m.getDominant()) != null ? dom : Messages.getString("SuperannotationPluginWindow.No_dom_expr"));
        int level = 0;
        while (level < minorLevelsSpans.size()) {
            String dom2;
            m = this.getMarkableFromSpan(currentSpan, level + 1, this.minorLevels.get(level));
            currentLine[level + 3] = m == null || m.getAttributeValue("mention_group").equals("empty") ? NO_MARKABLE : ((dom2 = m.getDominant()) != null ? dom2 : Messages.getString("SuperannotationPluginWindow.No_dom_expr"));
            ++level;
        }
        return currentLine;
    }

    private boolean sameValues(String[] colValues) {
        String first = colValues[0];
        String[] stringArray = colValues;
        int n = colValues.length;
        int n2 = 0;
        while (n2 < n) {
            String colValue = stringArray[n2];
            if (!colValue.equals(first)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private final String getDisplayValueForSetID(String setID, int level, List<Map<String, Set<String>>> partitionToSetIDMappingsForAllLevels, List<Set<String>> allDistinctPartitionSets, String currentSpan) {
        Map<String, Set<String>> map = partitionToSetIDMappingsForAllLevels.get(level);
        Set<String> set = map.get(setID);
        int val = allDistinctPartitionSets.indexOf(set);
        if (val == -1) {
            return setID;
        }
        return String.valueOf(val + 1);
    }

    public final Markable getMarkableFromSpan(String span, int levelPos, MarkableLevel level) {
        Markable result = null;
        String ID = "";
        Map<String, String> map = this.spanToIDMappingsForAllLevels.get(levelPos);
        ID = map.get(span);
        if (ID != null) {
            result = level.getMarkableByID(ID);
        }
        return result;
    }

    public final String getAttributeValue(String attributeName, String span, int levelPos, List<Map<String, String>> spanToIDMappingsForAllLevels2) {
        MarkableLevel level = null;
        String ID = "";
        level = levelPos == 0 ? this.majorLevel : this.minorLevels.get(levelPos - 1);
        Map<String, String> map = spanToIDMappingsForAllLevels2.get(levelPos);
        ID = map.get(span);
        if (ID == null) {
            return NO_MARKABLE;
        }
        return level.getMarkableByID(ID).getAttributeValue(attributeName, NO_VALUE);
    }

    public int determineIntersectionSize(Set<String> set, Set<String> set2, String refElement) {
        HashSet<String> temp1 = new HashSet<String>(set);
        temp1.remove(refElement);
        HashSet<String> temp2 = new HashSet<String>(set2);
        temp2.remove(refElement);
        temp1.retainAll(temp2);
        return temp1.size();
    }

    public void mouseClicked(boolean withShift) {
        int clickedRow = this.table.getSelectedRow();
        int clickedCol = this.table.getSelectedColumn() + 1;
        if (clickedRow < 0) {
            return;
        }
        if (withShift) {
            logger.debug("MOUSE shift Clicked row:" + clickedRow + ", col:" + clickedCol);
            if (clickedCol == MAJOR_COLUMN || clickedCol > MAJOR_COLUMN) {
                this.chooseLevel(clickedRow, clickedCol);
            }
        } else {
            logger.debug("MOUSE Clicked row:" + clickedRow + ", col:" + clickedCol);
            if (clickedCol == MAJOR_COLUMN || clickedCol > MAJOR_COLUMN) {
                this.clickLevel(clickedRow, clickedCol);
            } else {
                this.clickSpan(clickedRow);
            }
        }
    }

    private void chooseLevel(int clickedRow, int clickedColumn) {
        String spanInTable = (String)this.table.getModel().getValueAt(clickedRow, 0);
        boolean major = false;
        if (clickedColumn == MAJOR_COLUMN) {
            major = true;
        }
        String clickedVal = (String)this.table.getModel().getValueAt(clickedRow, clickedColumn);
        MarkableLevel clickedLevel = this.getMarkableLevel(clickedColumn);
        int mlIndex = clickedColumn - MAJOR_COLUMN;
        Markable markableClicked = this.getMarkableFromSpan(spanInTable, mlIndex, clickedLevel);
        ArrayList<String> otherVals = this.getOtherVals(clickedRow, clickedColumn);
        ArrayList<MarkableLevel> otherLevels = this.getOtherLevels(clickedColumn);
        ArrayList<Markable> otherMarkables = this.getOtherMarkables(spanInTable, clickedColumn);
        if (this.currentAttributeName.equals("no_attribute")) {
            this.applySelectedMarkable(clickedVal, markableClicked, otherVals, otherMarkables, otherLevels, major);
        } else {
            if (markableClicked == null || otherMarkables.contains(null)) {
                logger.warn("One of markables is null!");
                return;
            }
            if (this.currentAttributeName.equals("comment")) {
                this.applySelectedValue(markableClicked, otherMarkables);
            } else if (this.currentAttributeName.equals("mention_head")) {
                this.applySelectedValue(markableClicked, otherMarkables);
            } else if (this.currentAttributeName.equals("mention_type")) {
                this.applySelectedValue(markableClicked, otherMarkables);
            } else if (this.currentAttributeName.equals("dominant")) {
                this.applySelectedDominant(markableClicked, otherMarkables, otherLevels);
            } else if (!this.currentAttributeName.equals("near_identity") && this.currentAttributeName.equals("mention_group")) {
                this.applySelectedMentionGroup(clickedVal, markableClicked, clickedLevel, otherVals, otherMarkables, otherLevels);
            }
        }
        clickedLevel.setIsDirty(true, false);
        this.updateMarkableDisplay();
    }

    private MarkableLevel getMarkableLevel(int tableColumn) {
        MarkableLevel level = null;
        if (tableColumn == MAJOR_COLUMN) {
            level = this.majorLevel;
        } else if (tableColumn > MAJOR_COLUMN) {
            level = this.minorLevels.get(tableColumn - 3);
        }
        return level;
    }

    private ArrayList<String> getOtherVals(int clickedRow, int clickedColumn) {
        ArrayList<String> otherVals = new ArrayList<String>();
        int col = MAJOR_COLUMN;
        while (col < this.table.getModel().getColumnCount()) {
            if (col != clickedColumn) {
                String val = (String)this.table.getModel().getValueAt(clickedRow, col);
                otherVals.add(val);
            }
            ++col;
        }
        return otherVals;
    }

    private ArrayList<MarkableLevel> getOtherLevels(int clickedColumn) {
        ArrayList<MarkableLevel> otherLevels = new ArrayList<MarkableLevel>();
        int col = MAJOR_COLUMN;
        while (col < this.table.getModel().getColumnCount()) {
            if (col != clickedColumn) {
                MarkableLevel level = this.getMarkableLevel(col);
                otherLevels.add(level);
            }
            ++col;
        }
        return otherLevels;
    }

    private ArrayList<Markable> getOtherMarkables(String spanInTable, int clickedColumn) {
        ArrayList<Markable> otherMarkables = new ArrayList<Markable>();
        int col = MAJOR_COLUMN;
        while (col < this.table.getModel().getColumnCount()) {
            if (col != clickedColumn) {
                int mlIndex = col - MAJOR_COLUMN;
                MarkableLevel level = this.getMarkableLevel(col);
                Markable markable = this.getMarkableFromSpan(spanInTable, mlIndex, level);
                otherMarkables.add(markable);
            }
            ++col;
        }
        return otherMarkables;
    }

    private void applySelectedMarkable(String clickedVal, Markable markableClicked, ArrayList<String> otherVals, ArrayList<Markable> otherMarkables, ArrayList<MarkableLevel> otherLevels, boolean major) {
        if (clickedVal.equals("-")) {
            int i = 0;
            while (i < otherMarkables.size()) {
                if (otherVals.get(i).equals("+")) {
                    logger.info("Deleting markable " + otherMarkables.get(i) + " from level " + (major ? "minor" : "major"));
                    otherMarkables.get(i).deleteMe();
                }
                ++i;
            }
            if (!major) {
                this.discourse.reapplyStyleSheet();
            }
        } else if (clickedVal.equals("+")) {
            int i = 0;
            while (i < otherMarkables.size()) {
                if (otherVals.get(i).equals("-")) {
                    logger.info("Adding markable " + markableClicked + " to level " + (major ? "minor" : "major"));
                    Markable addedMarkable = otherLevels.get(i).addMarkable(MarkableHelper.getSpan(markableClicked));
                    addedMarkable.setAttributeValue("mention_head", markableClicked.getAttributeValue("mention_head"));
                }
                ++i;
            }
            if (!major) {
                this.discourse.reapplyStyleSheet();
            }
        }
    }

    private void applySelectedValue(Markable markableClicked, ArrayList<Markable> otherMarkables) {
        String clickedValue = markableClicked.getAttributeValue(this.currentAttributeName);
        for (Markable markableOther : otherMarkables) {
            String otherValue = markableOther.getAttributeValue(this.currentAttributeName);
            if (clickedValue.equals(otherValue)) continue;
            logger.info("Setting " + this.currentAttributeName + " for " + markableOther);
            markableOther.setAttributeValue(this.currentAttributeName, clickedValue);
        }
    }

    private void applySelectedDominant(Markable markableClicked, ArrayList<Markable> otherMarkables, ArrayList<MarkableLevel> otherLevels) {
        String clickedDominant = markableClicked.getDominant();
        int i = 0;
        while (i < otherMarkables.size()) {
            String otherDominant = otherMarkables.get(i).getDominant();
            if (!clickedDominant.equals(otherDominant)) {
                logger.info("Setting dominant for " + otherMarkables.get(i));
                otherMarkables.get(i).setDominant(clickedDominant);
                MarkableRelation relationOther = otherLevels.get(i).getCurrentAnnotationScheme().getAttributeByID("level_mention_group").getMarkableRelation();
                MarkableSet setOther = relationOther.getMarkableSetContainingMarkable(otherMarkables.get(i));
                if (setOther != null) {
                    setOther.setDominant(clickedDominant, false);
                }
            }
            ++i;
        }
    }

    private void applySelectedMentionGroup(String clickedVal, Markable markableClicked, MarkableLevel clickedLevel, ArrayList<String> otherVals, ArrayList<Markable> otherMarkables, ArrayList<MarkableLevel> otherLevels) {
        int i = 0;
        while (i < otherMarkables.size()) {
            MarkableRelation relationOther;
            MarkableSet setOther;
            if (!clickedVal.equals(otherVals.get(i)) && (setOther = (relationOther = otherLevels.get(i).getCurrentAnnotationScheme().getAttributeByID("level_mention_group").getMarkableRelation()).getMarkableSetContainingMarkable(otherMarkables.get(i))) != null) {
                logger.info("Removing mention " + otherMarkables.get(i) + " from its cluster.");
                otherLevels.get(i).getCurrentDiscourse().getCurrentMarkableChart().removeMarkableFromMarkableSet(otherMarkables.get(i), setOther, true);
            }
            ++i;
        }
        if (!clickedVal.equals(NO_VALUE)) {
            MarkableRelation relationClicked = clickedLevel.getCurrentAnnotationScheme().getAttributeByID("level_mention_group").getMarkableRelation();
            MarkableSet setClicked = relationClicked.getMarkableSetContainingMarkable(markableClicked);
            MarkableSet newSet = null;
            Markable[] markableArray = setClicked.getOrderedMarkables();
            int n = markableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Markable m = markableArray[n2];
                int i2 = 0;
                while (i2 < otherMarkables.size()) {
                    Markable correspMarkable;
                    if (!clickedVal.equals(otherVals.get(i2)) && !m.equals(markableClicked) && (correspMarkable = otherLevels.get(i2).getMarkableAtSpan(MarkableHelper.getSpan(m))) != null) {
                        MarkableRelation relationOther = otherLevels.get(i2).getCurrentAnnotationScheme().getAttributeByID("level_mention_group").getMarkableRelation();
                        MarkableSet set = relationOther.getMarkableSetContainingMarkable(correspMarkable);
                        if (set != null) {
                            logger.info("Removing mention " + correspMarkable + " from its cluster.");
                            otherLevels.get(i2).getCurrentDiscourse().getCurrentMarkableChart().removeMarkableFromMarkableSet(correspMarkable, set, true);
                        }
                        logger.info("Adding mention " + correspMarkable + " to new cluster with " + otherMarkables.get(i2));
                        if (newSet == null) {
                            newSet = otherLevels.get(i2).getCurrentDiscourse().getCurrentMarkableChart().addMarkableToNewMarkableSet(otherMarkables.get(i2), correspMarkable, relationOther, true);
                        } else {
                            otherLevels.get(i2).getCurrentDiscourse().getCurrentMarkableChart().addMarkableToExistingMarkableSet(correspMarkable, newSet, false);
                        }
                    }
                    ++i2;
                }
                ++n2;
            }
        }
    }

    private void clickLevel(int clickedRow, int clickedColumn) {
        MarkableLevel clickedLevel = this.getMarkableLevel(clickedColumn);
        String spanInTable = (String)this.table.getModel().getValueAt(clickedRow, 0);
        int mlIndex = clickedColumn - MAJOR_COLUMN;
        Markable markable = this.getMarkableFromSpan(spanInTable, mlIndex, clickedLevel);
        this.mmax2.getCurrentDiscourse().reapplyStyleSheet();
        if (markable == null) {
            logger.debug("No markable to display");
        } else if (this.currentAttributeType.equals("set")) {
            MarkableSet set = this.getMarkableSet(this.currentAttributeName, markable.getID(), clickedLevel);
            if (set != null) {
                Markable[] markableArray = set.getOrderedMarkables();
                int n = markableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Markable m = markableArray[n2];
                    Markable mCopy = this.getMarkableFromSpan(MarkableHelper.getSpan(m), mlIndex, clickedLevel);
                    MarkableHelper.setDisplayPositions(mCopy);
                    this.majorLevel.getRenderer().render(mCopy.getDisplayStartPositions(), mCopy.getDisplayEndPositions(), Color.ORANGE);
                    ++n2;
                }
            } else {
                this.majorLevel.getRenderer().render(markable.getDisplayStartPositions(), markable.getDisplayEndPositions(), Color.ORANGE);
            }
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        } else if (!this.currentAttributeType.equals("pointer")) {
            this.majorLevel.getRenderer().render(markable.getDisplayStartPositions(), markable.getDisplayEndPositions(), Color.ORANGE);
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        }
    }

    private void clickSpan(int clickedRow) {
        String spanInTable = (String)this.table.getModel().getValueAt(clickedRow, 0);
        Markable markable = this.getMarkableFromSpan(spanInTable, 0, this.majorLevel);
        MarkableLevel clickedLevel = this.majorLevel;
        if (markable == null) {
            for (MarkableLevel level : this.minorLevels) {
                markable = this.getMarkableFromSpan(spanInTable, 1, level);
                clickedLevel = level;
                if (markable != null) break;
            }
        }
        this.mmax2.getCurrentDiscourse().reapplyStyleSheet();
        if (markable == null) {
            logger.debug("No markable to display");
        } else if (this.currentAttributeType.equals("set")) {
            MarkableSet set = this.getMarkableSet(this.currentAttributeName, markable.getID(), clickedLevel);
            if (set != null) {
                Markable[] markableArray = set.getOrderedMarkables();
                int n = markableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Markable m = markableArray[n2];
                    Markable mCopy = this.majorLevel.getMarkableAtSpan(MarkableHelper.getSpan(m));
                    this.majorLevel.getRenderer().render(mCopy.getDisplayStartPositions(), mCopy.getDisplayEndPositions(), Color.ORANGE);
                    ++n2;
                }
            }
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        } else if (!this.currentAttributeType.equals("pointer")) {
            this.majorLevel.getRenderer().render(markable.getDisplayStartPositions(), markable.getDisplayEndPositions(), Color.ORANGE);
            this.mmax2.scrollToMarkable(markable);
            this.mmax2.getCurrentTextPane().startAutoRefresh();
        }
    }

    public String getCurrentAttributeType() {
        return this.currentAttributeType;
    }

    public void close() {
        this.mmax2.emptyRenderingList(true);
        this.discourse.getCurrentMarkableChart().nothingClicked(MMAX2Constants.LEFTMOUSE);
        this.discourse.reapplyStyleSheet();
        this.dispose();
    }

    public void updateAttribute(String name, String type) {
        this.currentAttributeName = name;
        this.currentAttributeType = type;
    }

    public void saveText() {
        logger.info("Saving other annotation levels");
        for (MarkableLevel minorLevel : this.minorLevels) {
            minorLevel.saveMarkables("");
        }
    }

    @Override
    public final void dispose() {
        this.mmax2.dismissSuperanno();
        super.dispose();
    }

    public void syncAnnotations() {
        int showConfirmDialog = JOptionPane.showConfirmDialog(this, String.valueOf(Messages.getString("SuperannotationPluginWindow.do_you_want_to_copy_main_annotation")) + " (" + new File(this.majorLevel.getAbsoluteMarkableFileName()).getName() + ")\n" + Messages.getString("SuperannotationPluginWindow.to_second_version") + "(" + this.otherLevelsFileNames() + ")?", String.valueOf(Messages.getString("SuperannotationPluginWindow.are_u_sure")) + "?", 0);
        if (showConfirmDialog == 0) {
            logger.info("Copying all changes from base level to others...");
            this.majorLevel.saveMarkables("");
            String baseFileName = this.majorLevel.getAbsoluteMarkableFileName();
            for (MarkableLevel minorLevel : this.minorLevels) {
                FileChannel baseChannel = null;
                AbstractInterruptibleChannel secondChannel = null;
                String otherFileName = minorLevel.getAbsoluteMarkableFileName();
                try {
                    try {
                        baseChannel = new FileInputStream(baseFileName).getChannel();
                        secondChannel = new FileOutputStream(otherFileName).getChannel();
                        baseChannel.transferTo(0L, baseChannel.size(), (WritableByteChannel)((Object)secondChannel));
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(this, Messages.getString("SuperannotationPluginWindow.Couldnt_copy"), Messages.getString("SuperannotationPluginWindow.Error"), 0);
                        logger.error(e.getMessage());
                        if (baseChannel != null) {
                            try {
                                baseChannel.close();
                            }
                            catch (IOException e2) {
                                logger.error(e2.getMessage());
                            }
                        }
                        if (secondChannel == null) continue;
                        try {
                            secondChannel.close();
                        }
                        catch (IOException e3) {
                            logger.error(e3.getMessage());
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (baseChannel != null) {
                        try {
                            baseChannel.close();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage());
                        }
                    }
                    if (secondChannel != null) {
                        try {
                            secondChannel.close();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage());
                        }
                    }
                    throw throwable;
                }
                if (baseChannel != null) {
                    try {
                        baseChannel.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                }
                if (secondChannel == null) continue;
                try {
                    secondChannel.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            this.loadLevels();
        }
    }

    private String otherLevelsFileNames() {
        String fileNames = "";
        for (MarkableLevel level : this.minorLevels) {
            String fileName = new File(level.getAbsoluteMarkableFileName()).getName();
            fileNames = fileNames.isEmpty() ? fileName : String.valueOf(fileNames) + ", " + fileName;
        }
        return fileNames;
    }

    public ArrayList<String> attributesWithDiffs() {
        ArrayList<String> attributesWithDiffs = new ArrayList<String>();
        HashSet<String> allSpans = new HashSet<String>();
        HashSet<String> majorSpans = new HashSet<String>();
        ArrayList<Set<String>> minorLevelsSpans = new ArrayList<Set<String>>();
        this.spanToIDMappingsForAllLevels = new ArrayList<Map<String, String>>();
        HashMap<String, String> currentLevelsSpanToIDMappings = new HashMap<String, String>();
        for (Markable temp : this.majorLevel.getMarkables()) {
            String tempSpan = MarkableHelper.getSpan(temp);
            allSpans.add(tempSpan);
            majorSpans.add(tempSpan);
            currentLevelsSpanToIDMappings.put(tempSpan, temp.getID());
        }
        this.spanToIDMappingsForAllLevels.add(currentLevelsSpanToIDMappings);
        for (MarkableLevel minorLevel : this.minorLevels) {
            currentLevelsSpanToIDMappings = new HashMap();
            HashSet<String> minorSpans = new HashSet<String>();
            for (Markable temp : minorLevel.getMarkables()) {
                String tempSpan = MarkableHelper.getSpan(temp);
                minorSpans.add(tempSpan);
                allSpans.add(tempSpan);
                currentLevelsSpanToIDMappings.put(tempSpan, temp.getID());
            }
            this.spanToIDMappingsForAllLevels.add(currentLevelsSpanToIDMappings);
            minorLevelsSpans.add(minorSpans);
        }
        ArrayList allSpansSorted = new ArrayList(allSpans);
        Collections.sort(allSpansSorted, new MarkableSpanComparator());
        int mention = -1;
        int dominant = -2;
        int[] types = new int[]{mention, 3, 4, 7, 6, 5, dominant};
        MMAX2AnnotationScheme scheme = this.majorLevel.getCurrentAnnotationScheme();
        int i = 0;
        while (i < types.length) {
            int attributeType = types[i];
            String attributeName = "";
            if (attributeType == mention) {
                attributeName = "no_attribute";
            } else if (attributeType == dominant) {
                attributeName = "dominant";
            } else {
                MMAX2Attribute attribute = scheme.getAttributesByType(types[i])[0];
                attributeName = attribute.getLowerCasedAttributeName();
            }
            ArrayList<Set<String>> allDistinctPartitionSets = new ArrayList<Set<String>>();
            ArrayList<Map<String, Set<String>>> partitionToSetIDMappingsForAllLevels = new ArrayList<Map<String, Set<String>>>();
            if (attributeType == 5) {
                partitionToSetIDMappingsForAllLevels.add(this.getAllDistinctPartitionSets(attributeName, 5, this.majorLevel, allDistinctPartitionSets, allSpans));
                for (MarkableLevel minorLevel : this.minorLevels) {
                    partitionToSetIDMappingsForAllLevels.add(this.getAllDistinctPartitionSets(attributeName, 5, minorLevel, allDistinctPartitionSets, allSpans));
                }
            }
            int line = 0;
            while (line < allSpans.size()) {
                String[] currentTableLine = new String[minorLevelsSpans.size() + 3];
                currentTableLine[0] = "";
                currentTableLine[1] = "";
                String currentSpan = (String)allSpansSorted.get(line);
                if (attributeType == mention) {
                    currentTableLine = this.mentionsLine(currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
                } else if (attributeType == 4) {
                    currentTableLine = this.valueLine(attributeName, currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
                } else if (attributeType == 7) {
                    currentTableLine = this.valueLine(attributeName, currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
                } else if (attributeType == 3) {
                    currentTableLine = this.valueLine(attributeName, currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
                } else if (attributeType == 5) {
                    currentTableLine = this.mentionsSetLine(currentTableLine, currentSpan, majorSpans, minorLevelsSpans, allDistinctPartitionSets, partitionToSetIDMappingsForAllLevels);
                } else if (attributeType == 6) {
                    currentTableLine = this.pointerLine(currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
                } else if (attributeType == dominant) {
                    currentTableLine = this.dominantLine(currentTableLine, currentSpan, majorSpans, minorLevelsSpans);
                }
                if (!this.sameValues(Arrays.copyOfRange(currentTableLine, 2, minorLevelsSpans.size() + 3))) {
                    attributesWithDiffs.add(attributeName);
                    break;
                }
                ++line;
            }
            ++i;
        }
        return attributesWithDiffs;
    }

    public MMAX2 getMMAX2() {
        return this.mmax2;
    }
}

