/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.annotation.markables;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.xpath.NodeSet;
import org.w3c.dom.Element;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableHelper;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkablePointer;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.core.UserSettings;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2Discourse;
import pl.waw.ipipan.zil.core.mmax4ref.gui.display.MMAX2ActionSelector;
import pl.waw.ipipan.zil.core.mmax4ref.gui.display.MMAX2LevelSelector;
import pl.waw.ipipan.zil.core.mmax4ref.gui.display.MarkableLevelRenderer;
import pl.waw.ipipan.zil.core.mmax4ref.gui.document.MMAX2Document;
import pl.waw.ipipan.zil.core.mmax4ref.gui.windows.MMAX2AttributePanelContainer;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Constants;

public class MarkableChart {
    MMAX2ActionSelector selector = null;
    public MMAX2AttributePanelContainer attributePanelContainer = null;
    private Map<String, MarkableLevel> levels = null;
    private MarkableLevel[] orderedLevels = null;
    private MMAX2Discourse currentDiscourse = null;
    private int nextFreeMarkableSetNum = 0;
    private int nextFreeMarkableIDNum = 0;
    private int selectionStart = 0;
    private int selectionEnd = 0;
    private int dotsDiscoursePosition = 0;
    private int marksDiscoursePosition = 0;

    public MarkableChart(MMAX2Discourse _discourse) {
        this.currentDiscourse = _discourse;
        this.levels = new HashMap<String, MarkableLevel>();
        this.orderedLevels = new MarkableLevel[0];
        this.attributePanelContainer = new MMAX2AttributePanelContainer();
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public final void saveAllMarkableLevels() {
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].saveMarkables("", false);
            ++z;
        }
    }

    public final void updateAllMarkableLevels() {
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].updateMarkables();
            ++z;
        }
    }

    public final MMAX2Discourse getCurrentDiscourse() {
        return this.currentDiscourse;
    }

    public final Markable getMarkableByID(String nameSpacedID, MarkableLevel defaultLevel) {
        Markable result = null;
        if (nameSpacedID.indexOf(":") == -1) {
            result = defaultLevel.getMarkableByID(nameSpacedID);
        } else {
            String levelName = nameSpacedID.substring(0, nameSpacedID.indexOf(":"));
            String id = nameSpacedID.substring(nameSpacedID.indexOf(":") + 1);
            result = this.getMarkableLevelByName(levelName, false).getMarkableByID(id);
        }
        return result;
    }

    public final void selectionOccurred(int dot, int mark) {
        if (this.orderedLevels.length > 0) {
            MMAX2 mmax2 = this.currentDiscourse.getMMAX2();
            Rectangle tempRect = null;
            int popUp = dot;
            if (dot > mark) {
                int temp = mark;
                mark = dot;
                dot = temp;
            }
            --mark;
            MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
            String wordUnderDot = this.currentDiscourse.getDiscourseElementIDAtDiscoursePosition(this.currentDiscourse.getDiscoursePositionAtDisplayPosition(dot));
            while (wordUnderDot.equals("") && dot < mark) {
                wordUnderDot = this.currentDiscourse.getDiscourseElementIDAtDiscoursePosition(this.currentDiscourse.getDiscoursePositionAtDisplayPosition(++dot));
            }
            this.dotsDiscoursePosition = this.currentDiscourse.getDiscoursePositionAtDisplayPosition(dot);
            String wordUnderMark = this.currentDiscourse.getDiscourseElementIDAtDiscoursePosition(this.currentDiscourse.getDiscoursePositionAtDisplayPosition(mark));
            while (wordUnderMark.equals("") && mark > dot) {
                wordUnderMark = this.currentDiscourse.getDiscourseElementIDAtDiscoursePosition(this.currentDiscourse.getDiscoursePositionAtDisplayPosition(--mark));
            }
            this.marksDiscoursePosition = this.currentDiscourse.getDiscoursePositionAtDisplayPosition(mark);
            if (wordUnderDot.equals("") || wordUnderMark.equals("")) {
                System.out.println("Invalid selection");
                return;
            }
            this.selectionStart = this.currentDiscourse.getDisplayStartPositionFromDiscoursePosition(this.dotsDiscoursePosition);
            this.selectionEnd = this.currentDiscourse.getDisplayEndPositionFromDiscoursePosition(this.marksDiscoursePosition);
            doc.startChanges(this.selectionStart, this.selectionEnd - this.selectionStart + 1);
            SimpleAttributeSet styleToUse = this.currentDiscourse.getMMAX2().getSelectionSpanStyle();
            StyleConstants.setFontSize(styleToUse, doc.getDisplayFontSize());
            StyleConstants.setFontFamily(styleToUse, doc.getDisplayFontFamily());
            doc.bulkApplyStyleToDisplaySpanBackground(this.selectionStart, this.selectionEnd - this.selectionStart + 1, styleToUse);
            doc.commitChanges();
            Markable currentPrimaryMarkable = this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable();
            if (currentPrimaryMarkable == null) {
                String fragment = "";
                fragment = wordUnderDot.equals(wordUnderMark) ? wordUnderDot : String.valueOf(wordUnderDot) + ".." + wordUnderMark;
                MarkableLevel[] activeLevels = this.getMarkableLevels();
                Markable newMarkable = null;
                if (activeLevels.length == 0) {
                    this.removeTemporarySelection();
                    return;
                }
                if (activeLevels.length == 1 && mmax2.getUserSettings().isCreateSilently()) {
                    newMarkable = activeLevels[0].addMarkable(fragment);
                    if (this.getCurrentDiscourse().getMMAX2().getUserSettings().isSelectAfterCreation()) {
                        this.markableLeftClicked(newMarkable);
                    }
                } else {
                    MMAX2LevelSelector selector = new MMAX2LevelSelector(activeLevels, fragment, this);
                    try {
                        tempRect = mmax2.getCurrentTextPane().modelToView(popUp);
                    }
                    catch (BadLocationException ex) {
                        System.out.println("Error with display position determination of dot position " + dot);
                    }
                    int xPos = (int)tempRect.getX();
                    int yPos = (int)tempRect.getY() + MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE + MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE / 3;
                    int currentScreenWidth = mmax2.getScreenWidth();
                    int selectorWidth = selector.getWidth();
                    if (xPos + mmax2.getX() > currentScreenWidth / 2) {
                        xPos -= selectorWidth;
                    }
                    selector.show(mmax2.getCurrentTextPane(), xPos, yPos);
                }
            } else {
                ArrayList<String> tempDEIDs = new ArrayList<String>();
                int currentDiscPos = 0;
                String currentDEID = "";
                int z = dot;
                while (z <= mark) {
                    currentDiscPos = this.getCurrentDiscourse().getDiscoursePositionAtDisplayPosition(z);
                    currentDEID = this.getCurrentDiscourse().getDiscourseElementIDAtDiscoursePosition(currentDiscPos);
                    if (!currentDEID.equals("") && !tempDEIDs.contains(currentDEID)) {
                        tempDEIDs.add(currentDEID);
                    }
                    ++z;
                }
                int mode = -1;
                String[] modifiables = tempDEIDs.toArray(new String[0]);
                ArrayList<String> markablesIDs = new ArrayList<String>(Arrays.asList(currentPrimaryMarkable.getDiscourseElementIDs()));
                mode = !markablesIDs.contains(modifiables[0]) || !markablesIDs.contains(modifiables[modifiables.length - 1]) ? MMAX2Constants.ADD_DES : MMAX2Constants.REMOVE_DES;
                if (mode != -1) {
                    MMAX2ActionSelector actionSelector = new MMAX2ActionSelector(currentPrimaryMarkable, modifiables, this, mode);
                    try {
                        tempRect = mmax2.getCurrentTextPane().modelToView(popUp);
                    }
                    catch (BadLocationException ex) {
                        System.out.println("Error with display position determination of dot position " + dot);
                    }
                    int xPos = (int)tempRect.getX();
                    int yPos = (int)tempRect.getY() + MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE + MMAX2Constants.DEFAULT_DISPLAY_FONT_SIZE / 3;
                    int currentScreenWidth = mmax2.getScreenWidth();
                    int selectorWidth = actionSelector.getWidth();
                    if (xPos + mmax2.getX() > currentScreenWidth / 2) {
                        xPos -= selectorWidth;
                    }
                    actionSelector.show(mmax2.getCurrentTextPane(), xPos, yPos);
                }
            }
        }
    }

    public final void removeTemporarySelection() {
        if (this.orderedLevels.length > 0) {
            SimpleAttributeSet styleToUse = new SimpleAttributeSet();
            StyleConstants.setBackground(styleToUse, Color.white);
            MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
            doc.startChanges(this.selectionStart, this.selectionEnd - this.selectionStart + 1);
            doc.bulkApplyStyleToDisplaySpanBackground(this.selectionStart, this.selectionEnd - this.selectionStart + 1, styleToUse);
            styleToUse = null;
            int z = this.dotsDiscoursePosition;
            while (z <= this.marksDiscoursePosition) {
                styleToUse = this.getTopAttributesAtDiscourseElement(this.currentDiscourse.getDiscourseElementIDAtDiscoursePosition(z));
                doc.bulkApplyStyleToDiscourseElement(this.currentDiscourse.getDisplayStartPositionFromDiscoursePosition(z), styleToUse, true);
                ++z;
            }
            doc.commitChanges();
        }
    }

    public final void requestModifyMarkablesDEs(Markable modified, String[] DEs, int mode) {
        boolean success = false;
        int start = modified.getLeftmostDisplayPosition();
        int end = modified.getRightmostDisplayPosition();
        modified.getMarkableLevel().unregisterMarkable(modified);
        if (mode == MMAX2Constants.REMOVE_DES) {
            success = modified.removeDiscourseElements(DEs);
        } else if (mode == MMAX2Constants.ADD_DES) {
            success = modified.addDiscourseElements(DEs);
        }
        if (success) {
            MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
            SimpleAttributeSet styleToUse = new SimpleAttributeSet();
            StyleConstants.setBackground(styleToUse, Color.white);
            StyleConstants.setFontSize(styleToUse, doc.getDisplayFontSize());
            StyleConstants.setFontFamily(styleToUse, doc.getDisplayFontFamily());
            doc.startChanges(start, end - start + 1);
            doc.bulkApplyStyleToDisplaySpanBackground(start, end - start + 1, styleToUse);
            doc.commitChanges();
            modified.getMarkableLevel().setIsDirty(true, true);
        } else {
            System.out.println("Markable modification failed");
            MarkableHelper.register(modified, true);
        }
        MarkableHelper.setDisplayPositions(modified);
        this.removeTemporarySelection();
        modified.renderMe(MMAX2Constants.RENDER_SELECTED);
        this.attributePanelContainer.displayMarkableAttributes(modified);
        this.getCurrentDiscourse().getMMAX2().requestReapplyDisplay();
    }

    public final void setNextFreeMarkableSetNum(int num) {
        this.nextFreeMarkableSetNum = num;
    }

    public final int getNextFreeMarkableSetNum() {
        return this.nextFreeMarkableSetNum;
    }

    public final void setNextFreeMarkableIDNum(int num) {
        this.nextFreeMarkableIDNum = num;
    }

    public final int getNextFreeMarkableIDNum() {
        return this.nextFreeMarkableIDNum;
    }

    public final void getAttributeWindowToFront() {
        this.attributePanelContainer.toFront();
    }

    public final void destroyDependentComponents() {
        this.attributePanelContainer.setVisible(false);
        this.attributePanelContainer = null;
        this.levels = null;
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].destroyDependentComponents();
            ++z;
        }
        this.orderedLevels = null;
        if (this.selector != null) {
            this.selector.setVisible(false);
        }
        this.selector = null;
        System.gc();
    }

    public final void initMarkableRelations() {
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].initMarkableRelations();
            ++z;
        }
    }

    public final Color getForegroundColorForLevel(String levelname) {
        return this.getMarkableLevelByName(levelname, false).getRenderer().getForegroundColor();
    }

    public final Color getHandleColorForLevel(String levelname) {
        return this.getMarkableLevelByName(levelname, false).getRenderer().getHandleColor();
    }

    public final MarkableLevel getMarkableLevelByName(String levelname, boolean interactive) {
        MarkableLevel result = null;
        if (levelname.equalsIgnoreCase("basedata")) {
            result = new MarkableLevel(null, "", "internal_basedata_representation", null, "", "");
            result.setCurrentDiscourse(this.getCurrentDiscourse());
        } else {
            result = this.levels.get(levelname.toLowerCase());
        }
        if (result == null) {
            if (interactive) {
                JOptionPane.showMessageDialog(null, "No MarkableLevel with name " + levelname + "!", "MarkableChart", 0);
            } else {
                System.err.println("No MarkableLevel with name " + levelname);
            }
        }
        return result;
    }

    public final void resetMarkablesForStyleSheetReapplication() {
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].resetMarkablesForStyleSheetReapplication();
            ++z;
        }
    }

    public final void initAttributePanelContainer() {
        this.attributePanelContainer.setAttributePanel(this.orderedLevels[0]);
        this.attributePanelContainer.setMMAX2(this.getCurrentDiscourse().getMMAX2());
        UserSettings us = this.attributePanelContainer.getMMAX2().getUserSettings();
        UserSettings.FrameSizeAndPosition fap = us.loadFrameSettings(MMAX2AttributePanelContainer.class.getSimpleName());
        if (fap == null) {
            this.attributePanelContainer.pack();
        } else {
            this.attributePanelContainer.setLocation(fap.getLocation());
            this.attributePanelContainer.setSize(fap.getDimension());
        }
        this.attributePanelContainer.setVisible(true);
        this.attributePanelContainer.disableAll();
    }

    public final void addMarkableLevel(MarkableLevel level) {
        if (this.orderedLevels.length == 0) {
            this.orderedLevels = new MarkableLevel[1];
            this.orderedLevels[0] = level;
        } else {
            MarkableLevel[] tempLevels = new MarkableLevel[this.orderedLevels.length + 1];
            System.arraycopy(this.orderedLevels, 0, tempLevels, 0, this.orderedLevels.length);
            tempLevels[this.orderedLevels.length] = level;
            this.orderedLevels = tempLevels;
        }
        level.setPosition(this.orderedLevels.length - 1);
        this.levels.put(new String(level.getMarkableLevelName().toLowerCase()), level);
    }

    public final void removeAllLevels() {
        this.orderedLevels = new MarkableLevel[0];
        this.levels.clear();
    }

    public final MarkableLevel removeMarkableLevel(MarkableLevel level) {
        return this.levels.remove(level.getMarkableLevelName().toLowerCase());
    }

    public final Markable[][] getMarkablesAtDiscoursePosition(int position, boolean activeLevelsOnly) {
        Markable[][] result = new Markable[this.orderedLevels.length][0];
        Markable[] tempResult = null;
        MarkableLevel currentLevel = null;
        int z = 0;
        while (z < this.orderedLevels.length) {
            currentLevel = this.orderedLevels[z];
            if (!activeLevelsOnly || currentLevel.getIsActive()) {
                tempResult = currentLevel.getAllMarkablesAtDiscoursePosition(position);
                result[z] = tempResult;
            }
            ++z;
        }
        return result;
    }

    public final boolean getIsAnyMarkableLevelModified() {
        boolean result = false;
        MarkableLevel currentLevel = null;
        int z = 0;
        while (z < this.orderedLevels.length) {
            currentLevel = this.orderedLevels[z];
            if (currentLevel.getIsDirty()) {
                result = true;
                break;
            }
            ++z;
        }
        return result;
    }

    public final Color getPrevailingBackgroundColorForMarkableHandle(int displayPosition) {
        Color resultColor = Color.white;
        try {
            if (this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable().coversDisplayPosition(displayPosition) || this.currentDiscourse.getMMAX2().getCurrentSecondaryMarkable().coversDisplayPosition(displayPosition)) {
                resultColor = StyleConstants.getBackground(this.currentDiscourse.getMMAX2().getSelectedStyle());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return resultColor;
    }

    public final SimpleAttributeSet getTopAttributesAtDiscourseElement(String de_id) {
        MarkableLevel currentLevel = null;
        Markable[] activeMarkables = null;
        SimpleAttributeSet result = new SimpleAttributeSet();
        SimpleAttributeSet tempResult = null;
        int z = this.orderedLevels.length - 1;
        while (z >= 0) {
            currentLevel = this.orderedLevels[z];
            if (currentLevel.getIsVisible() && (activeMarkables = currentLevel.getAllMarkablesAtDiscourseElement(de_id, true)) != null) {
                int q = 0;
                while (q < activeMarkables.length) {
                    tempResult = currentLevel.getRenderer().getAttributesForMarkable(activeMarkables[q]);
                    if (result == null) {
                        result = tempResult;
                    } else {
                        SimpleAttributeSet intermediate;
                        result = intermediate = MarkableLevelRenderer.mergeAttributes(tempResult, result);
                        intermediate = null;
                    }
                    ++q;
                }
            }
            --z;
        }
        if (!result.isDefined(StyleConstants.Foreground)) {
            StyleConstants.setForeground(result, Color.black);
        }
        if (!result.isDefined(StyleConstants.Background)) {
            StyleConstants.setBackground(result, Color.white);
        }
        MMAX2Document doc = this.getCurrentDiscourse().getMMAX2().getCurrentDocument();
        if (!result.isDefined(StyleConstants.FontSize)) {
            StyleConstants.setFontSize(result, doc.getDisplayFontSize());
        }
        if (!result.isDefined(StyleConstants.FontFamily)) {
            StyleConstants.setFontFamily(result, doc.getDisplayFontFamily());
        }
        return result;
    }

    public final NodeSet getActiveStartedMarkables(String discourseElementId) {
        NodeSet result = new NodeSet();
        MarkableLevel level = null;
        int z = this.orderedLevels.length - 1;
        while (z >= 0) {
            level = this.orderedLevels[z];
            if ((level.getIsActive() || level.getIsVisible()) && level.isDefined()) {
                level.getAllStartedMarkablesAsNodes(discourseElementId, result);
            }
            --z;
        }
        return result;
    }

    public final NodeSet getActiveStartedMarkables(String discourseElementId, String levels) {
        NodeSet result = new NodeSet();
        MarkableLevel level = null;
        String currentLevelName = "";
        int z = this.orderedLevels.length - 1;
        while (z >= 0) {
            level = this.orderedLevels[z];
            if ((level.getIsActive() || level.getIsVisible()) && level.isDefined() && levels.indexOf(currentLevelName = level.getMatchableMarkableLevelName()) != -1) {
                level.getAllStartedMarkablesAsNodes(discourseElementId, result);
            }
            --z;
        }
        return result;
    }

    public final List<Markable> getAllStartedMarkables(String deID) {
        ArrayList<Markable> result = new ArrayList<Markable>();
        Markable[] tempResult = null;
        int z = 0;
        while (z < this.orderedLevels.length) {
            MarkableLevel level = this.orderedLevels[z];
            tempResult = level.getAllMarkablesStartedByDiscourseElement(deID);
            if (tempResult != null) {
                int len = tempResult.length;
                int o = 0;
                while (o < len) {
                    if (tempResult[o] != null) {
                        result.add(tempResult[o]);
                    }
                    ++o;
                }
            }
            ++z;
        }
        return result;
    }

    public final List<Markable> getAllEndedMarkables(String deID) {
        ArrayList<Markable> result = new ArrayList<Markable>();
        Markable[] tempResult = null;
        int z = 0;
        while (z < this.orderedLevels.length) {
            MarkableLevel level = this.orderedLevels[z];
            tempResult = level.getAllMarkablesEndedByDiscourseElement(deID);
            if (tempResult != null) {
                int len = tempResult.length;
                int o = 0;
                while (o < len) {
                    if (tempResult[o] != null) {
                        result.add(tempResult[o]);
                    }
                    ++o;
                }
            }
            ++z;
        }
        return result;
    }

    public final NodeSet getActiveEndedMarkables(String discourseElementId) {
        NodeSet result = new NodeSet();
        MarkableLevel level = null;
        int z = 0;
        while (z < this.orderedLevels.length) {
            level = this.orderedLevels[z];
            if ((level.getIsActive() || level.getIsVisible()) && level.isDefined()) {
                level.getAllEndedMarkablesAsNodes(discourseElementId, result);
            }
            ++z;
        }
        return result;
    }

    public final NodeSet getActiveEndedMarkables(String discourseElementId, String levels) {
        NodeSet result = new NodeSet();
        MarkableLevel level = null;
        String currentLevelName = "";
        int z = 0;
        while (z < this.orderedLevels.length) {
            level = this.orderedLevels[z];
            if ((level.getIsActive() || level.getIsVisible()) && level.isDefined() && levels.indexOf(currentLevelName = level.getMatchableMarkableLevelName()) != -1) {
                level.getAllEndedMarkablesAsNodes(discourseElementId, result);
            }
            ++z;
        }
        return result;
    }

    public final void setMarkableLevelDisplayPositions() {
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].setMarkableDisplayPositions();
            ++z;
        }
    }

    public final void createDiscoursePositionToMarkableMappings() {
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].createDiscoursePositionToMarkableMapping();
            ++z;
        }
    }

    public final void updateLabels() {
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].updateNameLabelText();
            ++z;
        }
    }

    public final void validateAll() {
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].validate();
            ++z;
        }
    }

    public final void resetHasHandles() {
        int z = 0;
        while (z < this.orderedLevels.length) {
            this.orderedLevels[z].setHasHandles(false);
            ++z;
        }
    }

    public final List<String> getLevelAndAttributeNamesForValues(String valueList, String optionalAttributeName, boolean activeLevelsOnly) {
        ArrayList<String> result = new ArrayList<String>();
        int z = 0;
        while (z < this.orderedLevels.length) {
            if (this.orderedLevels[z].getIsActive() || !activeLevelsOnly) {
                List<String> temp = this.orderedLevels[z].getAttributeNamesForValues(valueList, optionalAttributeName);
                int b = 0;
                while (b < temp.size()) {
                    result.add(String.valueOf(this.orderedLevels[z].getMarkableLevelName()) + ":" + temp.get(b));
                    ++b;
                }
            }
            ++z;
        }
        return result;
    }

    public final void reorderMarkableLayers(String command) {
        MarkableLevel movee = null;
        int posToChange = Integer.parseInt(command.substring(command.indexOf(":") + 1));
        String direction = command.substring(0, command.indexOf(":"));
        if (posToChange == 0 && direction.equals("up") || posToChange == this.orderedLevels.length - 1 && direction.equals("down")) {
            return;
        }
        if (direction.equals("up")) {
            movee = this.orderedLevels[posToChange - 1];
            movee.setPosition(movee.getPosition() + 1);
            this.orderedLevels[posToChange].setPosition(this.orderedLevels[posToChange].getPosition() - 1);
            this.orderedLevels[posToChange - 1] = this.orderedLevels[posToChange];
            this.orderedLevels[posToChange] = movee;
        } else {
            movee = this.orderedLevels[posToChange + 1];
            movee.setPosition(movee.getPosition() - 1);
            this.orderedLevels[posToChange].setPosition(this.orderedLevels[posToChange].getPosition() + 1);
            this.orderedLevels[posToChange + 1] = this.orderedLevels[posToChange];
            this.orderedLevels[posToChange] = movee;
        }
    }

    public final void requestCopyMarkableSetToLevel(MarkableSet setToCopy, MarkableLevel target) {
        MMAX2Attribute targetAttribute = null;
        MMAX2Attribute[] targetAttributes = target.getCurrentAnnotationScheme().getAttributesByNameAndType("^" + setToCopy.getMarkableRelation().getAttributeName() + "$", 5, 5);
        if (targetAttributes.length > 0) {
            targetAttribute = targetAttributes[0];
        }
        if (targetAttribute == null) {
            System.err.println("Cannot copy to level " + target.getMarkableLevelName() + ". No appropriate target attribute!");
            return;
        }
        MarkableRelation targetRelation = targetAttribute.getMarkableRelation();
        List<Markable> markablesToCopy = Arrays.asList(setToCopy.getOrderedMarkables());
        Markable currentToCopy = null;
        Markable chainInitial = null;
        int u = 0;
        while (u < markablesToCopy.size()) {
            currentToCopy = markablesToCopy.get(u);
            if (target.getMarkableAtSpan(MarkableHelper.getSpan(currentToCopy)) == null) {
                this.requestCopyMarkableToLevel(currentToCopy, target.getMarkableLevelName());
            }
            ++u;
        }
        u = 0;
        while (u < markablesToCopy.size()) {
            currentToCopy = markablesToCopy.get(u);
            Markable copy = target.getMarkableAtSpan(MarkableHelper.getSpan(currentToCopy));
            if (chainInitial == null) {
                chainInitial = copy;
                this.addMarkableToNewMarkableSet(copy, targetRelation);
            } else {
                this.addMarkableToExistingMarkableSet(copy, targetRelation.getMarkableSetContainingMarkable(chainInitial), false);
            }
            ++u;
        }
    }

    public final void markableRightClicked(Markable secondaryMarkable) {
        this.markableRightClicked(secondaryMarkable, null, null);
    }

    public final void markableRightClicked(Markable secondaryMarkable, Component invoker, Point pos) {
        this.selector = null;
        this.currentDiscourse.getMMAX2().setCurrentSecondaryMarkable(secondaryMarkable);
        Markable primaryMarkable = this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable();
        if (primaryMarkable != null && primaryMarkable != secondaryMarkable) {
            this.attributePanelContainer.displayMarkableAttributes(primaryMarkable);
            this.selector = new MMAX2ActionSelector(primaryMarkable, secondaryMarkable, this);
        } else if (primaryMarkable != secondaryMarkable) {
            this.selector = new MMAX2ActionSelector(secondaryMarkable, primaryMarkable, this, true);
        } else if (primaryMarkable == secondaryMarkable) {
            this.selector = new MMAX2ActionSelector(secondaryMarkable, primaryMarkable, this, true);
        }
        if (this.selector != null && !this.selector.isEmpty()) {
            MMAX2 mmax2 = this.currentDiscourse.getMMAX2();
            if (invoker == null) {
                invoker = mmax2.getCurrentTextPane();
                int xPos = mmax2.getCurrentTextPane().getCurrentMouseMoveEvent().getX();
                int yPos = mmax2.getCurrentTextPane().getCurrentMouseMoveEvent().getY();
                int currentScreenWidth = mmax2.getScreenWidth();
                int selectorWidth = this.selector.getWidth();
                if (xPos + mmax2.getX() > currentScreenWidth / 2) {
                    xPos -= selectorWidth;
                }
                pos = new Point(xPos, yPos);
            }
            this.selector.show(invoker, pos.x, pos.y);
            mmax2.getCurrentTextPane().startAutoRefresh();
        }
        secondaryMarkable.renderMe(MMAX2Constants.RENDER_NO_HANDLES);
    }

    public final void markableLeftClicked(Markable newClicked) {
        Markable oldClicked;
        Markable[] concerned = new Markable[2];
        concerned[0] = newClicked;
        MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
        concerned[1] = oldClicked = this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable();
        newClicked.renderMe(MMAX2Constants.RENDER_NO_HANDLES);
        doc.startChanges(concerned);
        if (oldClicked != null) {
            oldClicked.getMarkableLevel().setValidateButtonEnabled(true);
            oldClicked.renderMe(MMAX2Constants.RENDER_UNSELECTED);
            this.currentDiscourse.getMMAX2().emptyRenderingList();
            if (this.currentDiscourse.getMMAX2().getIsRendering()) {
                this.currentDiscourse.getMMAX2().setRedrawAllOnNextRefresh(true);
                this.currentDiscourse.getMMAX2().getCurrentTextPane().startAutoRefresh();
            }
        }
        newClicked.getMarkableLevel().setValidateButtonEnabled(false);
        this.currentDiscourse.getMMAX2().setCurrentSecondaryMarkable(null);
        this.currentDiscourse.getMMAX2().setCurrentPrimaryMarkable(newClicked);
        newClicked.renderMe(MMAX2Constants.RENDER_SELECTED);
        doc.commitChanges();
        this.attributePanelContainer.displayMarkableAttributes(newClicked);
    }

    public final void nothingClicked(int currentButton) {
        Markable[] concerned = new Markable[1];
        if (this.orderedLevels.length > 0) {
            Markable oldClicked;
            MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
            concerned[0] = oldClicked = this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable();
            doc.startChanges(concerned);
            if (oldClicked != null) {
                oldClicked.getMarkableLevel().setValidateButtonEnabled(true);
                oldClicked.renderMe(MMAX2Constants.RENDER_UNSELECTED);
            }
            this.currentDiscourse.getMMAX2().setCurrentPrimaryMarkable(null);
            this.currentDiscourse.getMMAX2().setCurrentSecondaryMarkable(null);
            this.currentDiscourse.getMMAX2().emptyRenderingList();
            doc.commitChanges();
            if (this.currentDiscourse.getMMAX2().getIsRendering()) {
                this.currentDiscourse.getMMAX2().setRedrawAllOnNextRefresh(true);
                this.currentDiscourse.getMMAX2().getCurrentTextPane().startAutoRefresh();
            }
            this.attributePanelContainer.displayMarkableAttributes(null);
        }
    }

    public final void rerender() {
        if (this.orderedLevels.length > 0) {
            this.orderedLevels[0].getRenderer().render(null, MMAX2Constants.RERENDER_EVERYTHING);
        }
        if (this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable() != null) {
            this.markableLeftClicked(this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable());
        }
    }

    public final String getLevelNameByOrderPosition(int pos) {
        return this.orderedLevels[pos].getMarkableLevelName();
    }

    public final void removeMarkablePointerWithSourceMarkable(Markable sourceMarkable, MarkableRelation relation, boolean refreshAttributeWindow) {
        MarkablePointer pointer = relation.getMarkablePointerForSourceMarkable(sourceMarkable);
        List<Markable> targets = Arrays.asList(pointer.getTargetMarkables());
        int z = targets.size() - 1;
        while (z >= 0) {
            this.removeTargetMarkableFromMarkablePointer(targets.get(z), pointer, refreshAttributeWindow);
            --z;
        }
    }

    public final void removeTargetMarkableFromMarkablePointer(Markable removee, MarkablePointer pointer, boolean refreshAttributeWindow) {
        Markable[] concerned = new Markable[2];
        Markable currentSource = pointer.getSourceMarkable();
        concerned[0] = removee;
        concerned[1] = currentSource;
        MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
        doc.startChanges(concerned);
        pointer.removeTargetMarkable(removee);
        removee.renderMe(MMAX2Constants.RENDER_UNSELECTED);
        currentSource.renderMe(MMAX2Constants.RENDER_UNSELECTED);
        String constitutingAttributeName = pointer.getMarkableRelation().getAttributeName();
        String constitutingAttributeValue = pointer.getTargetSpan();
        if (constitutingAttributeValue.isEmpty()) {
            constitutingAttributeValue = MMAX2.defaultRelationValue;
        }
        currentSource.setAttributeValue(constitutingAttributeName, constitutingAttributeValue);
        ((Element)currentSource.getNodeRepresentation()).setAttribute(constitutingAttributeName, constitutingAttributeValue);
        if (currentSource == this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable() && refreshAttributeWindow) {
            this.attributePanelContainer.displayMarkableAttributes(currentSource);
        } else if (refreshAttributeWindow) {
            this.attributePanelContainer.displayMarkableAttributes(this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable());
        }
        if (pointer.getSize() == 0) {
            System.err.println("The last element from pointer is removed, pointer is destroyed!");
            pointer.removeMeFromMarkableRelation();
            this.currentDiscourse.getMMAX2().removeFromRenderingList(pointer);
            pointer = null;
            this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable().renderMe(MMAX2Constants.RENDER_SELECTED);
        } else {
            pointer.updateLinePoints();
        }
        this.currentDiscourse.getMMAX2().setRedrawAllOnNextRefresh(true);
        this.currentDiscourse.getMMAX2().getCurrentViewport().repaint();
        this.currentDiscourse.getMMAX2().getCurrentTextPane().startAutoRefresh();
        doc.commitChanges();
        currentSource.getMarkableLevel().setIsDirty(true, false);
    }

    public final void removeMarkableFromMarkableSet(Markable removee, MarkableSet set, boolean refreshAttributeWindow) {
        Markable[] concerned = new Markable[2];
        Markable currentPrimary = this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable();
        concerned[0] = removee;
        concerned[1] = currentPrimary;
        String constitutingAttribute = set.getMarkableRelation().getAttributeName();
        MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
        doc.startChanges(concerned);
        set.removeMarkable(removee);
        removee.setAttributeValue(constitutingAttribute, MMAX2.defaultRelationValue);
        ((Element)removee.getNodeRepresentation()).setAttribute(constitutingAttribute, MMAX2.defaultRelationValue);
        removee.renderMe(MMAX2Constants.RENDER_UNSELECTED);
        if (set.getSize() == 1) {
            System.err.println("The second but last element is removed, set is destroyed!");
            Markable last = set.getInitialMarkable();
            System.err.println("Last " + last.toString());
            doc.startChanges(last);
            set.removeMeFromMarkableRelation();
            this.currentDiscourse.getMMAX2().removeFromRenderingList(set);
            set = null;
            last.setAttributeValue(constitutingAttribute, MMAX2.defaultRelationValue);
            ((Element)last.getNodeRepresentation()).setAttribute(constitutingAttribute, MMAX2.defaultRelationValue);
            last.renderMe(MMAX2Constants.RENDER_UNSELECTED);
            if (refreshAttributeWindow) {
                this.attributePanelContainer.displayMarkableAttributes(currentPrimary);
            }
            if (last == currentPrimary) {
                doc.startChanges(last);
                currentPrimary.renderMe(MMAX2Constants.RENDER_SELECTED);
                doc.commitChanges();
            }
            doc.commitChanges();
        }
        this.currentDiscourse.getMMAX2().setRedrawAllOnNextRefresh(true);
        this.currentDiscourse.getMMAX2().getCurrentViewport().repaint();
        this.currentDiscourse.getMMAX2().getCurrentTextPane().startAutoRefresh();
        doc.commitChanges();
        removee.getMarkableLevel().setIsDirty(true, false);
    }

    public final void mergeMarkableSetsIntoNewSet(MarkableSet oldSet) {
        String constitutingAttribute = oldSet.getMarkableRelation().getAttributeName();
        String newSetID = this.getNextFreeMarkableSetID();
        while (oldSet.getMarkableRelation().getMarkableSetsIds().contains(newSetID)) {
            newSetID = this.getNextFreeMarkableSetID();
            System.out.println("NEW SET ID already EXISTS! Skipping");
        }
        Markable currentPrimary = this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable();
        currentPrimary.setAttributeValue(constitutingAttribute, newSetID);
        ((Element)currentPrimary.getNodeRepresentation()).setAttribute(constitutingAttribute, newSetID);
        MarkableSet newSet = oldSet.getMarkableRelation().addMarkableWithAttributeValueToMarkableSet(currentPrimary, newSetID);
        this.mergeMarkableSets(newSet, oldSet);
        this.currentDiscourse.getMMAX2().putOnRenderingList(newSet);
        currentPrimary.renderMe(MMAX2Constants.RENDER_SELECTED);
        this.currentDiscourse.getMMAX2().setRedrawAllOnNextRefresh(true);
        this.currentDiscourse.getMMAX2().getCurrentViewport().repaint();
        this.currentDiscourse.getMMAX2().getCurrentTextPane().startAutoRefresh();
    }

    public final void adoptMarkableToExistingMarkableSet(Markable adoptee, MarkableSet oldSet, MarkableSet newSet) {
        this.removeMarkableFromMarkableSet(adoptee, oldSet, true);
        this.addMarkableToExistingMarkableSet(adoptee, newSet, true);
    }

    public final void adoptMarkableToNewMarkableSet(Markable adoptee, MarkableSet oldSet) {
        this.removeMarkableFromMarkableSet(adoptee, oldSet, true);
        this.addMarkableToNewMarkableSet(adoptee, oldSet.getMarkableRelation());
    }

    public final void mergeMarkableSets(MarkableSet finalSet, MarkableSet oldSet) {
        ArrayList<Markable> movers = new ArrayList<Markable>(Arrays.asList(oldSet.getOrderedMarkables()));
        int u = 0;
        u = 0;
        while (u < movers.size() - 1) {
            this.removeMarkableFromMarkableSet((Markable)movers.get(u), oldSet, true);
            this.addMarkableToExistingMarkableSet((Markable)movers.get(u), finalSet, true);
            ++u;
        }
        this.addMarkableToExistingMarkableSet((Markable)movers.get(u), finalSet, true);
    }

    public final void addTargetMarkableToNewMarkablePointer(Markable source, Markable target, MarkableRelation relation) {
        String constitutingAttribute = relation.getAttributeName();
        relation.createMarkablePointer(source, target);
        MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
        doc.startChanges(target);
        target.renderMe(MMAX2Constants.RENDER_IN_SET);
        MarkablePointer pointer = relation.getMarkablePointerForSourceMarkable(source);
        pointer.updateFacetAttribute();
        source.setAttributeValue(constitutingAttribute, pointer.getTargetSpan());
        ((Element)source.getNodeRepresentation()).setAttribute(constitutingAttribute, pointer.getTargetSpan());
        this.currentDiscourse.getMMAX2().setRedrawAllOnNextRefresh(true);
        source.renderMe(MMAX2Constants.RENDER_SELECTED);
        this.currentDiscourse.getMMAX2().getCurrentViewport().repaint();
        this.currentDiscourse.getMMAX2().getCurrentTextPane().startAutoRefresh();
        doc.commitChanges();
        this.attributePanelContainer.displayMarkableAttributes(source);
        source.getMarkableLevel().setIsDirty(true, false);
    }

    public final void addTargetMarkableToExistingMarkablePointer(Markable source, Markable target, MarkablePointer pointer) {
        String constitutingAttribute = pointer.getMarkableRelation().getAttributeName();
        pointer.addTargetMarkable(target);
        pointer.updateFacetAttribute();
        MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
        doc.startChanges(target);
        target.renderMe(MMAX2Constants.RENDER_IN_SET);
        source.setAttributeValue(constitutingAttribute, pointer.getTargetSpan());
        ((Element)source.getNodeRepresentation()).setAttribute(constitutingAttribute, pointer.getTargetSpan());
        pointer.updateLinePoints();
        this.currentDiscourse.getMMAX2().setRedrawAllOnNextRefresh(true);
        source.renderMe(MMAX2Constants.RENDER_SELECTED);
        this.currentDiscourse.getMMAX2().getCurrentViewport().repaint();
        this.currentDiscourse.getMMAX2().getCurrentTextPane().startAutoRefresh();
        doc.commitChanges();
        this.attributePanelContainer.displayMarkableAttributes(source);
        source.getMarkableLevel().setIsDirty(true, false);
    }

    public final void addMarkableToExistingMarkableSet(Markable addee, MarkableSet set, boolean setRendered) {
        String constitutingAttribute = set.getMarkableRelation().getAttributeName();
        set.addMarkable(addee);
        MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
        doc.startChanges(addee);
        addee.setAttributeValue(constitutingAttribute, set.getAttributeValue());
        ((Element)addee.getNodeRepresentation()).setAttribute(constitutingAttribute, set.getAttributeValue());
        if (setRendered) {
            addee.renderMe(MMAX2Constants.RENDER_IN_SET);
        } else {
            addee.renderMe(MMAX2Constants.RERENDER_THIS);
        }
        set.updateLinePoints(true);
        this.currentDiscourse.getMMAX2().getCurrentViewport().repaint();
        this.currentDiscourse.getMMAX2().getCurrentTextPane().startAutoRefresh();
        doc.commitChanges();
        addee.getMarkableLevel().setIsDirty(true, false);
    }

    public final MarkableSet addMarkableToNewMarkableSet(Markable firstMarkable, Markable addee, MarkableRelation relation, boolean withoutAttPanel) {
        Markable[] concerned = new Markable[2];
        concerned[0] = addee;
        MMAX2Document doc = this.orderedLevels[0].getCurrentDiscourse().getDisplayDocument();
        doc.startChanges(concerned);
        String newSetID = this.getNextFreeMarkableSetID();
        while (relation.getMarkableSetsIds().contains(newSetID)) {
            newSetID = this.getNextFreeMarkableSetID();
            System.out.println("NEW SET ID already EXISTS! Skipping");
        }
        MarkableSet set = relation.addMarkableWithAttributeValueToMarkableSet(firstMarkable, newSetID);
        firstMarkable.setAttributeValue(relation.getAttributeName(), newSetID);
        ((Element)firstMarkable.getNodeRepresentation()).setAttribute(relation.getAttributeName(), newSetID);
        this.attributePanelContainer.displayMarkableAttributes(firstMarkable);
        relation.addMarkableWithAttributeValueToMarkableSet(addee, newSetID);
        addee.setAttributeValue(relation.getAttributeName(), newSetID);
        ((Element)addee.getNodeRepresentation()).setAttribute(relation.getAttributeName(), newSetID);
        addee.renderMe(MMAX2Constants.RENDER_IN_SET);
        firstMarkable.renderMe(MMAX2Constants.RENDER_SELECTED);
        this.currentDiscourse.getMMAX2().getCurrentViewport().repaint();
        this.currentDiscourse.getMMAX2().getCurrentTextPane().startAutoRefresh();
        doc.commitChanges();
        addee.getMarkableLevel().setIsDirty(true, false);
        MMAX2Attribute attrib = addee.getMarkableLevel().getCurrentAnnotationScheme().getUniqueAttributeByName("^" + relation.getAttributeName() + "$");
        if (!withoutAttPanel) {
            addee.getMarkableLevel().getCurrentAnnotationScheme().valueChanged(attrib, attrib, null, 0, new ArrayList<MMAX2Attribute>());
        }
        return set;
    }

    public final void addMarkableToNewMarkableSet(Markable addee, MarkableRelation relation) {
        Markable currentPrimary = this.currentDiscourse.getMMAX2().getCurrentPrimaryMarkable();
        this.addMarkableToNewMarkableSet(currentPrimary, addee, relation, false);
    }

    public final Markable requestCopyMarkableToLevel(Markable markableToCopy, String levelToCopyTo) {
        MarkableLevel toAddTo = this.getMarkableLevelByName(levelToCopyTo, false);
        Markable newM = toAddTo.addMarkable(markableToCopy.getFragments(), new HashMap<String, String>());
        if (this.getCurrentDiscourse().getMMAX2().getUserSettings().isSelectAfterCreation()) {
            this.markableLeftClicked(newM);
        }
        return newM;
    }

    public final void deleteMarkable(Markable deletee) {
        MarkableLevel level = deletee.getMarkableLevel();
        MarkableRelation[] relations = level.getActiveMarkableSetRelationsForMarkable(deletee);
        int z = 0;
        while (z < relations.length) {
            String tempAttribute = relations[z].getAttributeName();
            MarkableSet tempSet = relations[z].getMarkableSetWithAttributeValue(deletee.getAttributeValue(tempAttribute));
            this.removeMarkableFromMarkableSet(deletee, tempSet, true);
            ++z;
        }
        List<MarkablePointer> allMarkablePointers = this.getAllMarkablePointersForTargetMarkable(deletee);
        System.err.println("Found " + allMarkablePointers.size() + " pointers ");
        int z2 = 0;
        while (z2 < allMarkablePointers.size()) {
            MarkablePointer currentMP = allMarkablePointers.get(z2);
            this.removeTargetMarkableFromMarkablePointer(deletee, currentMP, true);
            ++z2;
        }
        MMAX2 mmax = deletee.getMarkableLevel().getCurrentDiscourse().getMMAX2();
        deletee.deleteMe();
        mmax.requestReapplyDisplay();
        level.setIsDirty(true, true);
    }

    public final List<MarkablePointer> getAllMarkablePointersForTargetMarkable(Markable target) {
        ArrayList<MarkablePointer> result = new ArrayList<MarkablePointer>();
        int z = 0;
        while (z < this.orderedLevels.length) {
            MarkableLevel currentLevel = this.orderedLevels[z];
            result.addAll(currentLevel.getMarkablePointersForTargetMarkable(target));
            ++z;
        }
        return result;
    }

    public final boolean inMarkableFromLevel(String DE_ID, String targetLevelName) {
        boolean result = false;
        Markable[] allMarkables = this.getMarkableLevelByName(targetLevelName, true).getAllMarkablesAtDiscourseElement(DE_ID, false);
        if (allMarkables.length > 0) {
            result = true;
        }
        return result;
    }

    public final boolean inMarkableFromLevel(String markableID, String ownLevelName, String targetLevelName) {
        boolean result = false;
        Markable currentMarkable = this.getMarkableLevelByName(ownLevelName, true).getMarkableByID(markableID);
        String initial = currentMarkable.getFragments()[0][0];
        Markable[] allMarkables = this.getMarkableLevelByName(targetLevelName, true).getAllMarkablesAtDiscourseElement(initial, false);
        int b = 0;
        while (b < allMarkables.length) {
            if (allMarkables[b].getSize() >= currentMarkable.getSize()) {
                result = true;
                break;
            }
            ++b;
        }
        return result;
    }

    public final boolean startsMarkableFromLevel(String markableID, String ownLevelName, String targetLevelName) {
        Markable currentMarkable = this.getMarkableLevelByName(ownLevelName, true).getMarkableByID(markableID);
        String initial = currentMarkable.getFragments()[0][0];
        return this.getMarkableLevelByName(targetLevelName, true).hasMarkableStartingAt(initial);
    }

    public final boolean finishesMarkableFromLevel(String markableID, String ownLevelName, String targetLevelName) {
        Markable currentMarkable = this.getMarkableLevelByName(ownLevelName, true).getMarkableByID(markableID);
        String[][] fragments = currentMarkable.getFragments();
        String[] finalFragment = fragments[fragments.length - 1];
        String currentMarkablesEnd = finalFragment[finalFragment.length - 1];
        return this.getMarkableLevelByName(targetLevelName, true).hasMarkableEndingAt(currentMarkablesEnd);
    }

    public final String getNextFreeMarkableSetID() {
        String newID = "set_" + this.nextFreeMarkableSetNum;
        ++this.nextFreeMarkableSetNum;
        return newID;
    }

    public final String getNextFreeMarkableID() {
        String newID = "markable_" + this.nextFreeMarkableIDNum;
        ++this.nextFreeMarkableIDNum;
        return newID;
    }

    public final MarkableLevel[] getMarkableLevels() {
        return this.orderedLevels;
    }

    public void init() {
        this.createDiscoursePositionToMarkableMappings();
        this.setMarkableLevelDisplayPositions();
        this.initMarkableRelations();
        this.initAttributePanelContainer();
        this.updateLabels();
    }
}

