/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.annotation.markables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.dom.Node;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkablePointer;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.query.MMAX2MatchingCriterion;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2Discourse;
import pl.waw.ipipan.zil.core.mmax4ref.discourse.MMAX2DiscourseElement;
import pl.waw.ipipan.zil.core.mmax4ref.utils.MMAX2Constants;

public class MarkableHelper {
    public static final int LONGER_BEFORE_SHORTER = 1;
    public static final int SHORTER_BEFORE_LONGER = 2;
    public static final String legacyDefaultValue = "_MMAX default value_";
    public static final String DOMINANT = "dominant";

    public static String getFormattedAttributeString(Markable markable) {
        String result = "";
        int maxLen = 0;
        int currentLen = 0;
        Set<String> allattribs = markable.attributes.keySet();
        Object[] keys = allattribs.toArray(new String[0]);
        int i = 0;
        while (i < keys.length) {
            currentLen = ((String)keys[i]).length();
            if (currentLen > maxLen) {
                maxLen = currentLen;
            }
            ++i;
        }
        Arrays.sort(keys);
        Object key = "";
        String value = "";
        int i2 = 0;
        while (i2 < keys.length) {
            key = keys[i2];
            value = markable.getAttributeValue((String)key);
            key = String.valueOf(key) + "                                                                ";
            key = String.valueOf(((String)key).substring(0, maxLen + 1)) + "= ";
            result = String.valueOf(result) + (String)key + value + "\n";
            ++i2;
        }
        return result;
    }

    public static String[][] toFragments(List<MMAX2DiscourseElement> DEs) {
        ArrayList<String> currentFragment = new ArrayList<String>();
        ArrayList<String[]> allFragments = new ArrayList<String[]>();
        MMAX2DiscourseElement currentDE = null;
        int lastPos = -1;
        int currentPos = -1;
        int z = 0;
        while (z < DEs.size()) {
            currentDE = DEs.get(z);
            currentPos = currentDE.getDiscoursePosition();
            if (currentFragment.size() == 0) {
                currentFragment.add(currentDE.getID());
                lastPos = currentPos;
            } else if (currentPos == lastPos + 1) {
                currentFragment.add(currentDE.getID());
                lastPos = currentPos;
            } else {
                allFragments.add(currentFragment.toArray(new String[0]));
                currentFragment = null;
                currentFragment = new ArrayList();
                currentFragment.add(currentDE.getID());
                lastPos = currentPos;
            }
            ++z;
        }
        allFragments.add(currentFragment.toArray(new String[0]));
        return (String[][])allFragments.toArray((T[])new String[0][0]);
    }

    public static String[][] toFragments(List<String> IDs, MMAX2Discourse discourse) {
        ArrayList<String> currentFragment = new ArrayList<String>();
        ArrayList<String[]> allFragments = new ArrayList<String[]>();
        MMAX2DiscourseElement currentDE = null;
        String currentID = "";
        int lastPos = -1;
        int currentPos = -1;
        int z = 0;
        while (z < IDs.size()) {
            currentID = IDs.get(z);
            currentDE = discourse.getDiscourseElementByID(currentID);
            currentPos = currentDE.getDiscoursePosition();
            if (currentFragment.size() == 0) {
                currentFragment.add(currentDE.getID());
                lastPos = currentPos;
            } else if (currentPos == lastPos + 1) {
                currentFragment.add(currentDE.getID());
                lastPos = currentPos;
            } else {
                allFragments.add(currentFragment.toArray(new String[0]));
                currentFragment = null;
                currentFragment = new ArrayList();
                currentFragment.add(currentDE.getID());
                lastPos = currentPos;
            }
            ++z;
        }
        allFragments.add(currentFragment.toArray(new String[0]));
        return (String[][])allFragments.toArray((T[])new String[0][0]);
    }

    public static void removeDuplicateDiscoursePositions(List<MMAX2DiscourseElement> DEs) {
        HashSet<Integer> discPositions = new HashSet<Integer>();
        Iterator<MMAX2DiscourseElement> it = DEs.iterator();
        while (it.hasNext()) {
            int pos = it.next().getDiscoursePosition();
            if (discPositions.contains(pos)) {
                it.remove();
                continue;
            }
            discPositions.add(pos);
        }
    }

    public static boolean beforeStrict(Markable m1, Markable m2) {
        return MarkableHelper.beforeStrict(m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition());
    }

    public static boolean beforeStrict(int e1End, int e2Start) {
        return e1End < e2Start - 1;
    }

    public static boolean before(Markable m1, Markable m2) {
        return MarkableHelper.before(m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition());
    }

    public static boolean before(int e1End, int e2Start) {
        return e1End < e2Start;
    }

    public static boolean meets(Markable m1, Markable m2) {
        return MarkableHelper.meets(m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition());
    }

    public static boolean meets(int e1End, int e2Start) {
        return e1End == e2Start - 1;
    }

    public static boolean starts(Markable m1, Markable m2) {
        return MarkableHelper.starts(m1.getLeftmostDiscoursePosition(), m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
    }

    public static boolean starts(int e1Start, int e1End, int e2Start, int e2End) {
        return e1Start == e2Start && e1End <= e2End;
    }

    public static boolean startsStrict(Markable m1, Markable m2) {
        return MarkableHelper.startsStrict(m1.getLeftmostDiscoursePosition(), m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
    }

    public static boolean startsStrict(int e1Start, int e1End, int e2Start, int e2End) {
        return e1Start == e2Start && e1End < e2End;
    }

    public static boolean overlaps_right(Markable m1, Markable m2) {
        return MarkableHelper.overlaps_right(m1.getLeftmostDiscoursePosition(), m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
    }

    public static boolean overlaps_left(Markable m1, Markable m2) {
        return MarkableHelper.overlaps_left(m1.getLeftmostDiscoursePosition(), m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
    }

    public static boolean overlaps_right(int e1Start, int e1End, int e2Start, int e2End) {
        return e1Start < e2Start && e1End < e2End && e1End >= e2Start;
    }

    public static boolean overlaps_left(int e1Start, int e1End, int e2Start, int e2End) {
        return e1Start > e2Start && e1Start <= e2End && e1End > e2End;
    }

    public static boolean finishes(Markable m1, Markable m2) {
        return MarkableHelper.finishes(m1.getRightmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
    }

    public static boolean finishes(int t1End, int t2End) {
        return t1End == t2End;
    }

    public static boolean finishesStrict(Markable m1, Markable m2) {
        return MarkableHelper.finishesStrict(m1.getLeftmostDiscoursePosition(), m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
    }

    public static boolean finishesStrict(int t1Start, int t1End, int t2Start, int t2End) {
        return t1End == t2End && t1Start > t2Start;
    }

    public static boolean during(Markable m1, Markable m2) {
        return MarkableHelper.during(m1.getLeftmostDiscoursePosition(), m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
    }

    public static boolean during(int t1Start, int t1End, int t2Start, int t2End) {
        return t1Start >= t2Start && t1End <= t2End;
    }

    public static boolean duringFragments(String[][] m1Frags, String[][] m2Frags) {
        int fragsFound = 0;
        int z = 0;
        while (z < m1Frags.length) {
            String[] currentM1Frag = m1Frags[z];
            boolean currentM1FragFound = false;
            int y = 0;
            while (y < m2Frags.length) {
                String[] currentM2Frag = m2Frags[y];
                String m1Initial = currentM1Frag[0];
                String m1Final = currentM1Frag[currentM1Frag.length - 1];
                boolean initialFound = false;
                boolean finalFound = false;
                int b = 0;
                while (b < currentM2Frag.length) {
                    String currentM2Element = currentM2Frag[b];
                    if (currentM2Element.equals(m1Initial)) {
                        initialFound = true;
                        if (currentM1Frag.length == 1) {
                            finalFound = true;
                        }
                    } else if (currentM2Element.equals(m1Final)) {
                        finalFound = true;
                    }
                    if (initialFound && finalFound) {
                        currentM1FragFound = true;
                        break;
                    }
                    ++b;
                }
                if (currentM1FragFound) {
                    ++fragsFound;
                    currentM1FragFound = false;
                    initialFound = false;
                    finalFound = false;
                    break;
                }
                ++y;
            }
            ++z;
        }
        return fragsFound == m1Frags.length;
    }

    public static boolean duringStrict(Markable m1, Markable m2) {
        boolean during = MarkableHelper.during(m1.getLeftmostDiscoursePosition(), m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
        boolean equal = MarkableHelper.equals(m1.getLeftmostDiscoursePosition(), m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
        return during && !equal;
    }

    public static boolean equalFragments(String[][] m1Frags, String[][] m2Frags) {
        return MarkableHelper.getSpan(m1Frags).equalsIgnoreCase(MarkableHelper.getSpan(m2Frags));
    }

    public static boolean equals(Markable m1, Markable m2) {
        return MarkableHelper.equals(m1.getLeftmostDiscoursePosition(), m1.getRightmostDiscoursePosition(), m2.getLeftmostDiscoursePosition(), m2.getRightmostDiscoursePosition());
    }

    public static boolean equals(int t1Start, int t1End, int t2Start, int t2End) {
        return t1Start == t2Start && t1End == t2End;
    }

    public static final String toKWICString(String wordID, MMAX2Discourse discourse) {
        String currentWord;
        String currentWordID;
        int maxWidth = 100;
        int maxMarkableWidth = 30;
        int discPos = discourse.getDiscoursePositionFromDiscourseElementID(wordID);
        MMAX2DiscourseElement elem = discourse.getDiscourseElementAtDiscoursePosition(discPos);
        String result = "  " + elem.toString() + " ";
        String leftPart = "";
        int initialDiscoursePosition = discPos;
        int finalDiscoursePosition = discPos;
        int z = initialDiscoursePosition - 1;
        while (z >= 0) {
            currentWordID = discourse.getDiscourseElementIDAtDiscoursePosition(z);
            currentWord = discourse.getDiscourseElementNode(currentWordID).getFirstChild().getNodeValue();
            leftPart = String.valueOf(currentWord) + " " + leftPart;
            if (leftPart.length() >= (maxWidth - maxMarkableWidth) / 2) {
                leftPart = leftPart.substring(leftPart.length() - (maxWidth - maxMarkableWidth) / 2);
                break;
            }
            --z;
        }
        if (leftPart.length() < (maxWidth - maxMarkableWidth) / 2) {
            int p = leftPart.length();
            while (p < (maxWidth - maxMarkableWidth) / 2) {
                leftPart = " " + leftPart;
                ++p;
            }
        }
        result = String.valueOf(leftPart) + result;
        z = finalDiscoursePosition + 1;
        while (z <= Integer.MAX_VALUE) {
            currentWordID = discourse.getDiscourseElementIDAtDiscoursePosition(z);
            if (currentWordID.equals("")) break;
            currentWord = discourse.getDiscourseElementNode(currentWordID).getFirstChild().getNodeValue();
            if ((result = String.valueOf(result) + " " + currentWord).length() >= maxWidth) {
                result = result.substring(0, maxWidth);
                break;
            }
            ++z;
        }
        return result;
    }

    public static final String toKWICString(Markable markable) {
        String currentWord;
        String currentWordID;
        int maxWidth = 100;
        int maxMarkableWidth = 30;
        String result = "  " + markable.toTrimmedString(maxMarkableWidth) + " ";
        String leftPart = "";
        MarkableLevel level = markable.getMarkableLevel();
        int initialDiscoursePosition = markable.getLeftmostDiscoursePosition();
        int finalDiscoursePosition = markable.getRightmostDiscoursePosition();
        int z = initialDiscoursePosition - 1;
        while (z >= 0) {
            currentWordID = level.getCurrentDiscourse().getDiscourseElementIDAtDiscoursePosition(z);
            currentWord = level.getCurrentDiscourse().getDiscourseElementNode(currentWordID).getFirstChild().getNodeValue();
            leftPart = String.valueOf(currentWord) + " " + leftPart;
            if (leftPart.length() >= (maxWidth - maxMarkableWidth) / 2) {
                leftPart = leftPart.substring(leftPart.length() - (maxWidth - maxMarkableWidth) / 2);
                break;
            }
            --z;
        }
        if (leftPart.length() < (maxWidth - maxMarkableWidth) / 2) {
            int p = leftPart.length();
            while (p < (maxWidth - maxMarkableWidth) / 2) {
                leftPart = " " + leftPart;
                ++p;
            }
        }
        result = String.valueOf(leftPart) + result;
        z = finalDiscoursePosition + 1;
        while (z <= Integer.MAX_VALUE) {
            currentWordID = level.getCurrentDiscourse().getDiscourseElementIDAtDiscoursePosition(z);
            if (currentWordID.equals("")) break;
            currentWord = level.getCurrentDiscourse().getDiscourseElementNode(currentWordID).getFirstChild().getNodeValue();
            if ((result = String.valueOf(result) + " " + currentWord).length() >= maxWidth) {
                result = result.substring(0, maxWidth);
                break;
            }
            ++z;
        }
        return result;
    }

    public static final String toKWICString(Markable markable, int maxWidth) {
        String currentWord;
        String currentWordID;
        int maxMarkableWidth = 30;
        String result = "  " + markable.toTrimmedString(maxMarkableWidth) + " ";
        String leftPart = "";
        MarkableLevel level = markable.getMarkableLevel();
        int initialDiscoursePosition = markable.getLeftmostDiscoursePosition();
        int finalDiscoursePosition = markable.getRightmostDiscoursePosition();
        int z = initialDiscoursePosition - 1;
        while (z >= 0) {
            currentWordID = level.getCurrentDiscourse().getDiscourseElementIDAtDiscoursePosition(z);
            currentWord = level.getCurrentDiscourse().getDiscourseElementNode(currentWordID).getFirstChild().getNodeValue();
            leftPart = String.valueOf(currentWord) + " " + leftPart;
            if (leftPart.length() >= (maxWidth - maxMarkableWidth) / 2) {
                leftPart = leftPart.substring(leftPart.length() - (maxWidth - maxMarkableWidth) / 2);
                break;
            }
            --z;
        }
        if (leftPart.length() < (maxWidth - maxMarkableWidth) / 2) {
            int p = leftPart.length();
            while (p < (maxWidth - maxMarkableWidth) / 2) {
                leftPart = " " + leftPart;
                ++p;
            }
        }
        result = String.valueOf(leftPart) + result;
        z = finalDiscoursePosition + 1;
        while (z <= Integer.MAX_VALUE) {
            currentWordID = level.getCurrentDiscourse().getDiscourseElementIDAtDiscoursePosition(z);
            if (currentWordID.equals("")) break;
            currentWord = level.getCurrentDiscourse().getDiscourseElementNode(currentWordID).getFirstChild().getNodeValue();
            if ((result = String.valueOf(result) + " " + currentWord).length() >= maxWidth) {
                result = result.substring(0, maxWidth);
                break;
            }
            ++z;
        }
        return result;
    }

    public static final void register(Markable markable, boolean updateHash) {
        MarkableLevel level = markable.getMarkableLevel();
        markable.string = "";
        markable.stringWithoutBrackets = "";
        markable.setSize(0);
        String[] currentFragment = null;
        int currentFragmentLength = 0;
        Node currentDENode = null;
        boolean currentIsInvalid = false;
        boolean currentHasBeenAdded = false;
        ArrayList<String> currentFragmentsDEs = null;
        StringBuffer buffer = new StringBuffer();
        StringBuffer buffer2 = new StringBuffer();
        String[][] fragments = markable.getFragments();
        int z = 0;
        while (z < markable.singleFragments) {
            currentFragment = fragments[z];
            currentFragmentLength = currentFragment.length;
            currentFragmentsDEs = new ArrayList<String>();
            markable.setSize(markable.getSize() + currentFragmentLength);
            int o = 0;
            while (o < currentFragmentLength) {
                currentDENode = level.getCurrentDiscourse().getDiscourseElementNode(currentFragment[o]);
                if (o == 0) {
                    level.registerMarkableAtStartOfFragment(currentFragment[o], markable);
                    currentFragmentsDEs.add(currentDENode.getFirstChild().getNodeValue());
                    currentHasBeenAdded = true;
                }
                if (o == currentFragmentLength - 1) {
                    level.registerMarkableAtEndOfFragment(currentFragment[o], markable);
                    if (!currentHasBeenAdded) {
                        try {
                            currentFragmentsDEs.add(currentDENode.getFirstChild().getNodeValue());
                        }
                        catch (NullPointerException ex) {
                            currentFragmentsDEs.add("");
                        }
                        currentHasBeenAdded = true;
                    }
                }
                if (!currentHasBeenAdded && !currentIsInvalid) {
                    currentFragmentsDEs.add(currentDENode.getFirstChild().getNodeValue());
                }
                level.registerMarkableAtDiscourseElement(currentFragment[o], markable);
                if (updateHash) {
                    level.updateDiscoursePositionToMarkableMapping(currentFragment[o]);
                }
                currentHasBeenAdded = false;
                ++o;
            }
            buffer.append("[");
            buffer2.append(" ");
            int v = currentFragmentsDEs.size();
            int t = 0;
            while (t < v) {
                if (t == v - 1) {
                    buffer.append((String)currentFragmentsDEs.get(t));
                    buffer2.append((String)currentFragmentsDEs.get(t));
                } else {
                    buffer.append(String.valueOf((String)currentFragmentsDEs.get(t)) + " ");
                    buffer2.append(String.valueOf((String)currentFragmentsDEs.get(t)) + " ");
                }
                ++t;
            }
            buffer.append("]");
            ++z;
        }
        markable.string = buffer.toString();
        markable.stringWithoutBrackets = buffer2.length() < 1 ? "" : buffer2.substring(1);
        markable.discourseElementStartPositions = new int[markable.getSize()];
    }

    public static final int getFollowingValidDiscourseElementPosition(Markable markable, String[] currentFragment, int currentPos) {
        MarkableLevel level = markable.getMarkableLevel();
        int result = -1;
        Node currentNode = null;
        int tempPos = currentPos + 1;
        while (tempPos < currentFragment.length) {
            currentNode = level.getCurrentDiscourse().getDiscourseElementNode(currentFragment[tempPos]);
            try {
                if (!currentNode.getAttributes().getNamedItem("empty").getNodeValue().equals("true")) continue;
                ++tempPos;
            }
            catch (NullPointerException ex) {
                result = tempPos;
                break;
            }
        }
        return result;
    }

    public static final int getPreceedingValidDiscourseElementPosition(Markable markable, String[] currentFragment, int currentPos) {
        MarkableLevel level = markable.getMarkableLevel();
        int result = -1;
        Node currentNode = null;
        int tempPos = currentPos - 1;
        while (tempPos >= 0) {
            currentNode = level.getCurrentDiscourse().getDiscourseElementNode(currentFragment[tempPos]);
            try {
                if (!currentNode.getAttributes().getNamedItem("empty").getNodeValue().equals("true")) continue;
                --tempPos;
            }
            catch (NullPointerException ex) {
                result = tempPos;
                break;
            }
        }
        return result;
    }

    public static final void setDisplayPositions(Markable markable) {
        MarkableLevel level = markable.getMarkableLevel();
        String[] currentFragment = null;
        String currentDE = "";
        int currentDEsDiscoursePosition = 0;
        int fragPos = 0;
        String[][] fragments = markable.getFragments();
        int z = 0;
        while (z < markable.singleFragments) {
            currentFragment = fragments[z];
            markable.discourseElementStartPositions = new int[markable.getSize()];
            int q = 0;
            while (q < currentFragment.length) {
                int discPos = level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(currentFragment[q]);
                markable.discourseElementStartPositions[fragPos] = discPos == -1 ? -1 : level.getCurrentDiscourse().getDisplayStartPositionFromDiscoursePosition(discPos);
                ++fragPos;
                ++q;
            }
            currentDE = currentFragment[0];
            if (currentFragment.length == 1) {
                currentDEsDiscoursePosition = level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(currentDE);
                if (currentDEsDiscoursePosition != -1) {
                    markable.setDisplayStartPositions(z, level.getCurrentDiscourse().getDisplayStartPositionFromDiscoursePosition(currentDEsDiscoursePosition));
                    markable.setDisplayEndPositions(z, level.getCurrentDiscourse().getDisplayEndPositionFromDiscoursePosition(currentDEsDiscoursePosition));
                    markable.discourseElementStartPositions[z] = markable.getDisplayStartPositions()[z];
                } else {
                    markable.setDisplayStartPositions(z, -1);
                    markable.setDisplayEndPositions(z, -1);
                    markable.discourseElementStartPositions[z] = markable.getDisplayStartPositions()[z];
                }
            } else {
                currentDEsDiscoursePosition = level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(currentDE);
                if (currentDEsDiscoursePosition == -1) {
                    int nextPosition = MarkableHelper.getFollowingValidDiscourseElementPosition(markable, currentFragment, 0);
                    if (nextPosition != -1) {
                        currentDE = currentFragment[nextPosition];
                        currentDEsDiscoursePosition = level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(currentDE);
                        markable.setDisplayStartPositions(z, level.getCurrentDiscourse().getDisplayStartPositionFromDiscoursePosition(currentDEsDiscoursePosition));
                    } else {
                        markable.setDisplayStartPositions(z, -1);
                    }
                } else {
                    markable.setDisplayStartPositions(z, level.getCurrentDiscourse().getDisplayStartPositionFromDiscoursePosition(currentDEsDiscoursePosition));
                }
                currentDE = currentFragment[currentFragment.length - 1];
                currentDEsDiscoursePosition = level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(currentDE);
                if (currentDEsDiscoursePosition == -1) {
                    int prevPosition = MarkableHelper.getPreceedingValidDiscourseElementPosition(markable, currentFragment, currentFragment.length - 1);
                    if (prevPosition != -1) {
                        currentDE = currentFragment[prevPosition];
                        currentDEsDiscoursePosition = level.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(currentDE);
                        markable.setDisplayEndPositions(z, level.getCurrentDiscourse().getDisplayEndPositionFromDiscoursePosition(currentDEsDiscoursePosition));
                    } else {
                        markable.setDisplayEndPositions(z, -1);
                    }
                } else {
                    markable.setDisplayEndPositions(z, level.getCurrentDiscourse().getDisplayEndPositionFromDiscoursePosition(currentDEsDiscoursePosition));
                }
            }
            ++z;
        }
        markable.leftmostDisplayPosition = markable.getDisplayStartPositions()[0];
        markable.rightmostDisplayPosition = markable.getDisplayEndPositions()[markable.singleFragments - 1];
    }

    public static final String toXMLElement(Markable markable) {
        MMAX2Attribute[] validatedAttributes;
        String xmlstring = "<markable";
        xmlstring = String.valueOf(xmlstring) + " id=\"" + markable.getID() + "\"";
        xmlstring = String.valueOf(xmlstring) + " span=" + "\"" + MarkableHelper.getSpan(markable) + "\"";
        Set<String> allattribs = markable.attributes.keySet();
        Object[] keys = allattribs.toArray();
        String key = "";
        String value = "";
        int i = 0;
        while (i < keys.length) {
            key = (String)keys[i];
            if (key.compareToIgnoreCase("id") != 0) {
                value = markable.attributes.get((String)keys[i]);
                if (!((value = MarkableHelper.encodeXML(value)).equalsIgnoreCase(legacyDefaultValue) || value.equalsIgnoreCase("") && key.equals("comment"))) {
                    xmlstring = String.valueOf(xmlstring) + " " + key + "=\"" + value + "\" ";
                }
            }
            ++i;
        }
        MMAX2Attribute[] mMAX2AttributeArray = validatedAttributes = markable.getValidatedAttributes();
        int n = validatedAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String dom;
            MarkableSet currentMarkablesSet;
            MMAX2Attribute currentAttribute = mMAX2AttributeArray[n2];
            if (currentAttribute.getType() == 5 && (currentMarkablesSet = currentAttribute.getMarkableRelation().getMarkableSetWithAttributeValue(markable.getAttributeValue(currentAttribute.getLowerCasedAttributeName()))) != null && (dom = currentMarkablesSet.getDominant()) != null && !dom.equals("")) {
                xmlstring = String.valueOf(xmlstring) + " " + DOMINANT + "=\"" + MarkableHelper.encodeXML(dom) + "\" ";
            }
            ++n2;
        }
        xmlstring = String.valueOf(xmlstring) + "/>";
        return xmlstring;
    }

    public static final String encodeXML(String inString) {
        inString = inString.replaceAll("&([^;]*)$", "&amp;$1");
        inString = inString.replaceAll("\"", "&quot;");
        inString = inString.replaceAll("<", "&lt;");
        inString = inString.replaceAll(">", "&gt;");
        return inString;
    }

    public static final boolean matchesRegExp(Markable markable, String _attribute, String _value, int type, boolean _negated) {
        boolean negated;
        block20: {
            negated = _negated;
            Perl5Matcher regmatcher = null;
            String attribute = _attribute.trim();
            String value = _value.trim();
            Pattern pattern = null;
            try {
                pattern = new Perl5Compiler().compile(value);
            }
            catch (MalformedPatternException ex) {
                System.err.println("RegExp error: " + value);
                return false;
            }
            regmatcher = new Perl5Matcher();
            if (type == MMAX2Constants.MARKABLE_TEXT) {
                block17: {
                    try {
                        String text = markable.toString();
                        text = text.substring(1, text.length() - 1);
                        if (!regmatcher.matches(text, pattern)) break block17;
                        return !negated;
                    }
                    catch (NullPointerException ex) {
                        return false;
                    }
                }
                return negated;
            }
            if (type == MMAX2Constants.LEVEL_NAME) {
                block18: {
                    try {
                        String text = markable.getMarkableLevelName();
                        text = text.substring(1, text.length() - 1);
                        if (!regmatcher.matches(text, pattern)) break block18;
                        return !negated;
                    }
                    catch (NullPointerException ex) {
                        return false;
                    }
                }
                return negated;
            }
            if (type == 2 || type == 1 || type == 3) {
                block19: {
                    try {
                        if (!regmatcher.matches(markable.getAttributeValue(attribute), pattern)) break block19;
                        return !negated;
                    }
                    catch (NullPointerException ex) {
                        return false;
                    }
                }
                return negated;
            }
            try {
                if (!regmatcher.matches(markable.getAttributeValue(attribute), pattern)) break block20;
                return !negated;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return negated;
    }

    public static final boolean matchesRegExp(MMAX2DiscourseElement de, String _attribute, String _value, int type, boolean _negated) {
        boolean negated = _negated;
        Perl5Matcher regmatcher = null;
        String attribute = _attribute.trim();
        String value = _value.trim();
        Pattern pattern = null;
        try {
            pattern = new Perl5Compiler().compile(value);
        }
        catch (MalformedPatternException ex) {
            System.err.println("RegExp error: " + value);
            return false;
        }
        regmatcher = new Perl5Matcher();
        if (type == MMAX2Constants.BASEDATA_TEXT) {
            String text = de.toString();
            if (regmatcher.matches(text, pattern)) {
                return !negated;
            }
            return negated;
        }
        if (type == MMAX2Constants.BASEDATA_ATTRIBUTES) {
            if (regmatcher.matches(de.getAttributeValue(attribute, ""), pattern)) {
                return !negated;
            }
            return negated;
        }
        System.err.println("Only basedata_text and attribute matching supported!");
        return false;
    }

    public static final boolean matches(Markable markable, String _attribute, String _value, int type, boolean _negated) {
        MarkableLevel level = markable.getMarkableLevel();
        boolean negated = _negated;
        String attribute = _attribute.trim();
        String value = _value.trim();
        if (type == MMAX2Constants.MARKABLE_TEXT) {
            block41: {
                try {
                    String text = markable.toString();
                    text = text.substring(1, text.length() - 1);
                    if (!value.equalsIgnoreCase(text)) break block41;
                    return !negated;
                }
                catch (NullPointerException ex) {
                    return false;
                }
            }
            return negated;
        }
        if (type == MMAX2Constants.LEVEL_NAME) {
            block42: {
                try {
                    String text = markable.getMarkableLevelName();
                    if (!value.equalsIgnoreCase(text)) break block42;
                    return !negated;
                }
                catch (NullPointerException ex) {
                    return false;
                }
            }
            return negated;
        }
        if (type == 2 || type == 1 || type == 3 || type == 4 || type == 7 || type == 8) {
            block43: {
                try {
                    if (!value.equalsIgnoreCase(markable.getAttributeValue(attribute, ""))) break block43;
                    return !negated;
                }
                catch (NullPointerException ex) {
                    return false;
                }
            }
            return negated;
        }
        if (type == 5) {
            int pos;
            MarkableSet set = null;
            MarkableRelation[] relations = level.getActiveMarkableSetRelationsForMarkable(markable);
            int z = 0;
            while (z < relations.length) {
                if (relations[z].getAttributeName().equalsIgnoreCase(attribute)) {
                    set = relations[z].getMarkableSetWithAttributeValue(markable.getAttributeValue(attribute));
                }
                ++z;
            }
            if (value.equalsIgnoreCase("empty")) {
                if (set == null || set.getSize() == 1) {
                    return !negated;
                }
                return negated;
            }
            if (value.equalsIgnoreCase("initial")) {
                if (set == null) {
                    return negated;
                }
                pos = set.getMarkableIndex(markable);
                if (pos != 0) {
                    return negated;
                }
                return !negated;
            }
            if (value.equalsIgnoreCase("final")) {
                if (set == null) {
                    return negated;
                }
                pos = set.getMarkableIndex(markable);
                if (pos != set.getSize() - 1) {
                    return negated;
                }
                return !negated;
            }
            int val = -1;
            try {
                val = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (val != -1 && set != null) {
                if (set.getSize() == val) {
                    return !negated;
                }
                return negated;
            }
        } else if (type == 6) {
            int val;
            if (value.equalsIgnoreCase("target")) {
                MarkablePointer[] sourcePointer = level.getActiveMarkablePointersForTargetMarkable(markable, attribute);
                if (sourcePointer.length == 0) {
                    return negated;
                }
                return !negated;
            }
            MarkablePointer pointer = null;
            MarkableRelation[] relations = level.getActiveMarkablePointerRelationsForSourceMarkable(markable);
            int z = 0;
            while (z < relations.length) {
                if (relations[z].getAttributeName().equalsIgnoreCase(attribute)) {
                    pointer = relations[z].getMarkablePointerForSourceMarkable(markable);
                }
                ++z;
            }
            if (pointer != null) {
                val = -1;
                try {
                    val = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (val == pointer.getSize() || value.equalsIgnoreCase("empty") && pointer.getSize() == 0) {
                    return !negated;
                }
                return negated;
            }
            if (value.equalsIgnoreCase("empty")) {
                return !negated;
            }
            val = -1;
            try {
                val = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (val == 0) {
                return !negated;
            }
            return negated;
        }
        return false;
    }

    public static final boolean matches(MMAX2DiscourseElement de, String _attribute, String _value, int type, boolean _negated) {
        boolean negated = _negated;
        String attribute = _attribute.trim();
        String value = _value.trim();
        if (type == MMAX2Constants.BASEDATA_TEXT) {
            String text = de.toString();
            if (value.equalsIgnoreCase(text)) {
                return !negated;
            }
            return negated;
        }
        if (type == MMAX2Constants.BASEDATA_ATTRIBUTES) {
            if (value.equalsIgnoreCase(de.getAttributeValue(attribute, ""))) {
                return !negated;
            }
            return negated;
        }
        System.err.println("Only basedata_text and attribute matching supported!");
        return false;
    }

    public static final String getSpan(String[][] fragments) {
        String[] currentFrag = null;
        String currentSpan = "";
        String span = "";
        int z = 0;
        while (z < fragments.length) {
            currentFrag = fragments[z];
            currentSpan = currentFrag[0];
            if (currentFrag.length > 1) {
                currentSpan = String.valueOf(currentSpan) + ".." + currentFrag[currentFrag.length - 1];
            }
            span = String.valueOf(span) + currentSpan + ",";
            ++z;
        }
        return span.substring(0, span.length() - 1);
    }

    public static final String getSpan(Markable markable) {
        String[] currentFrag = null;
        String currentSpan = "";
        String span = "";
        String[][] fragments = markable.getFragments();
        int z = 0;
        while (z < markable.singleFragments) {
            currentFrag = fragments[z];
            currentSpan = currentFrag[0];
            if (currentFrag.length > 1) {
                currentSpan = String.valueOf(currentSpan) + ".." + currentFrag[currentFrag.length - 1];
            }
            span = String.valueOf(span) + currentSpan + ",";
            ++z;
        }
        return span.substring(0, span.length() - 1);
    }

    public static final boolean matchesAny(Markable markable, MMAX2MatchingCriterion criterion) {
        if (criterion.isMatchAll()) {
            return true;
        }
        int critlen = criterion.getSize();
        boolean tempresult = false;
        int z = 0;
        while (z < critlen) {
            tempresult = criterion.getRegExpMatch() ? MarkableHelper.matchesRegExp(markable, criterion.getAttributeName(), criterion.getValue(z), criterion.getAttributeType(), criterion.getNegated()) : MarkableHelper.matches(markable, criterion.getAttributeName(), criterion.getValue(z), criterion.getAttributeType(), criterion.getNegated());
            if (tempresult) {
                return true;
            }
            ++z;
        }
        return false;
    }

    public static final boolean matchesAny(MMAX2DiscourseElement de, MMAX2MatchingCriterion criterion) {
        if (criterion.isMatchAll()) {
            return true;
        }
        int critlen = criterion.getSize();
        boolean tempresult = false;
        int z = 0;
        while (z < critlen) {
            tempresult = criterion.getRegExpMatch() ? MarkableHelper.matchesRegExp(de, criterion.getAttributeName(), criterion.getValue(z), criterion.getAttributeType(), criterion.getNegated()) : MarkableHelper.matches(de, criterion.getAttributeName(), criterion.getValue(z), criterion.getAttributeType(), criterion.getNegated());
            if (tempresult) {
                return true;
            }
            ++z;
        }
        return false;
    }

    public static final boolean matchesAll(Markable markable, MMAX2MatchingCriterion criterion) {
        if (criterion.isMatchAll()) {
            return true;
        }
        int critlen = criterion.getSize();
        boolean tempresult = false;
        boolean anyTrue = false;
        int z = 0;
        while (z < critlen) {
            tempresult = criterion.getRegExpMatch() ? MarkableHelper.matchesRegExp(markable, criterion.getAttributeName(), criterion.getValue(z), criterion.getAttributeType(), criterion.getNegated()) : MarkableHelper.matches(markable, criterion.getAttributeName(), criterion.getValue(z), criterion.getAttributeType(), criterion.getNegated());
            if (!tempresult) {
                return false;
            }
            anyTrue = true;
            ++z;
        }
        return anyTrue;
    }

    public static final boolean matchesAll(MMAX2DiscourseElement de, MMAX2MatchingCriterion criterion) {
        if (criterion.isMatchAll()) {
            return true;
        }
        int critlen = criterion.getSize();
        boolean tempresult = false;
        boolean anyTrue = false;
        int z = 0;
        while (z < critlen) {
            tempresult = criterion.getRegExpMatch() ? MarkableHelper.matchesRegExp(de, criterion.getAttributeName(), criterion.getValue(z), criterion.getAttributeType(), criterion.getNegated()) : MarkableHelper.matches(de, criterion.getAttributeName(), criterion.getValue(z), criterion.getAttributeType(), criterion.getNegated());
            if (!tempresult) {
                return false;
            }
            anyTrue = true;
            ++z;
        }
        return anyTrue;
    }

    public static final HashMap<String, String> parseAttributesToHashMap(String attribs) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer toki = new StringTokenizer(attribs, ",", false);
        while (toki.hasMoreTokens()) {
            String currentToken = toki.nextToken().trim();
            int index = currentToken.indexOf("=");
            if (index == -1) {
                System.err.println("Error: expected '<att>=<val>', found " + currentToken);
                continue;
            }
            String currentAttrib = currentToken.substring(0, index).trim();
            String currentVal = currentToken.substring(index + 1).trim();
            result.put(new String(currentAttrib), new String(currentVal));
        }
        return result;
    }

    public static final List<String>[] parseAttributesToLists(String attribs) {
        ArrayList[] result = new ArrayList[2];
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer toki = new StringTokenizer(attribs, ",", false);
        while (toki.hasMoreTokens()) {
            String currentToken = toki.nextToken().trim();
            int index = currentToken.indexOf("=");
            if (index == -1) {
                System.err.println("Error: expected '<att>=<val>', found " + currentToken);
                continue;
            }
            String currentAttrib = currentToken.substring(0, index).trim();
            String currentVal = currentToken.substring(index + 1).trim();
            attributes.add(currentAttrib);
            values.add(currentVal);
        }
        result[0] = attributes;
        result[1] = values;
        return result;
    }

    public static final List<String> parseCompleteSpan(String span) {
        List<String> fraglist;
        String currentspan = "";
        ArrayList<String> spanlist = new ArrayList<String>();
        int spanlen = span.length();
        int i = 0;
        while (i < spanlen) {
            if (span.charAt(i) != ',') {
                currentspan = String.valueOf(currentspan) + span.charAt(i);
            } else {
                currentspan.trim();
                fraglist = MarkableHelper.parseSpanFragment(currentspan);
                if (fraglist.size() > 1) {
                    spanlist.addAll(fraglist);
                } else {
                    spanlist.add(fraglist.get(0));
                }
                currentspan = "";
                fraglist = null;
            }
            ++i;
        }
        currentspan.trim();
        fraglist = MarkableHelper.parseSpanFragment(currentspan);
        if (fraglist.size() > 1) {
            spanlist.addAll(fraglist);
        } else {
            spanlist.add(fraglist.get(0));
        }
        currentspan = "";
        fraglist = null;
        return spanlist;
    }

    public static final List<String> parseSpanFragment(String span) {
        ArrayList<String> NewWordsIDList = new ArrayList<String>();
        if (span.indexOf("..") == -1) {
            NewWordsIDList.add(span);
            return NewWordsIDList;
        }
        String NameSpace2 = span.substring(0, span.indexOf("_") + 1);
        String FirstIDString = span.substring(0, span.indexOf("."));
        String LastIDString = span.substring(span.lastIndexOf(".") + 1);
        int FirstIDInteger = Integer.parseInt(FirstIDString.substring(FirstIDString.indexOf("_") + 1));
        int LastIDInteger = Integer.parseInt(LastIDString.substring(LastIDString.indexOf("_") + 1));
        int i = FirstIDInteger;
        while (i <= LastIDInteger) {
            NewWordsIDList.add(String.valueOf(NameSpace2) + String.valueOf(i));
            ++i;
        }
        return NewWordsIDList;
    }
}

