/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.core;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.log4j.Logger;
import pl.waw.ipipan.zil.core.mmax4core.Messages;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableChart;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableFileLoader;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Renderable;
import pl.waw.ipipan.zil.core.mmax4core.core.MainMenu;
import pl.waw.ipipan.zil.core.mmax4core.core.UserSettings;
import pl.waw.ipipan.zil.core.mmax4core.discourse.MMAX2Discourse;
import pl.waw.ipipan.zil.core.mmax4core.discourse.MMAX2DiscourseLoader;
import pl.waw.ipipan.zil.core.mmax4core.gui.display.MMAX2TextPane;
import pl.waw.ipipan.zil.core.mmax4core.gui.document.MMAX2Document;
import pl.waw.ipipan.zil.core.mmax4core.gui.windows.MMAX2AttributePanelContainer;
import pl.waw.ipipan.zil.core.mmax4core.gui.windows.MMAX2MarkableBrowser;
import pl.waw.ipipan.zil.core.mmax4core.gui.windows.MMAX2MarkablePointerBrowser;
import pl.waw.ipipan.zil.core.mmax4core.gui.windows.MMAX2MarkableSetBrowser;
import pl.waw.ipipan.zil.core.mmax4core.gui.windows.MMAXFileFilter;
import pl.waw.ipipan.zil.core.mmax4core.plugin.MMAX2Plugin;
import pl.waw.ipipan.zil.core.mmax4core.plugin.SuperannotationPluginWindow;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Utils;

public class MMAX2
extends JFrame
implements ComponentListener {
    private static final long serialVersionUID = -6617920152842426693L;
    private static final Logger logger = Logger.getLogger(MMAX2.class);
    private Timer waitCursorTimer = null;
    private Timer autoSaveTimer = null;
    private Map<String, String> markableSelectorAttributes = new HashMap<String, String>();
    private String commonPathsFileName = "";
    private Markable currentPrimaryMarkable;
    private Markable currentSecondaryMarkable;
    private static String versionString = "1.4";
    private JScrollPane currentScrollPane = null;
    private MMAX2TextPane currentTextPane = null;
    private MMAX2Document currentDocument = null;
    private MMAX2Discourse currentDiscourse = null;
    public static String defaultRelationValue = "empty";
    private boolean selectFromActiveLevelsOnly = true;
    private boolean autoRefreshUponPanelAction = true;
    private boolean useFancyLabels = true;
    private List<Renderable> markableRelationsToRender;
    public boolean initializing = true;
    private Dimension screenSize = null;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private boolean isRendering = false;
    private boolean redrawAllOnNextRefresh = false;
    private boolean ignoreCaretUpdate = false;
    private SimpleAttributeSet selectedMarkableGlobalStyle = null;
    private final String selectedMarkableGlobalStyleString = "background=yellow";
    private SimpleAttributeSet selectionSpanGlobalStyle = null;
    private final String selectionSpanGlobalStyleString = "background=d:204204255";
    private boolean isAnnotationModified = false;
    private boolean isBasedataModified = false;
    public String currentWorkingDirectory = "../teksty/";
    private boolean blockAllInput = false;
    public JFrame editBasedataWindow = null;
    public String currentMmaxFilename = null;
    private MMAX2MarkableBrowser markableBrowser = null;
    private MMAX2MarkableSetBrowser markableSetBrowser = null;
    private MMAX2MarkablePointerBrowser markablePointerBrowser = null;
    private MainMenu mainMenu = null;
    private UserSettings us = new UserSettings();
    private final LinkedList<String> previousMentionsFileContent = new LinkedList();
    private SuperannotationPluginWindow superanno = null;

    public MMAX2() {
        this.us.load();
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenWidth = this.screenSize.width;
        this.screenHeight = this.screenSize.height;
        this.addComponentListener(this);
        this.currentScrollPane = new JScrollPane();
        this.currentScrollPane.setHorizontalScrollBarPolicy(30);
        Box mainBox = Box.createVerticalBox();
        mainBox.add(this.currentScrollPane);
        this.setContentPane(mainBox);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new MMAX2MainWindowListener());
        this.markableRelationsToRender = new ArrayList<Renderable>();
    }

    public final boolean getUseFancyMultilineRendering() {
        return true;
    }

    public final void setBlockAllInput(boolean state) {
        this.blockAllInput = state;
    }

    public final boolean getBlockAllInput() {
        return this.blockAllInput;
    }

    public final int getRenderingListSize() {
        return this.markableRelationsToRender.size();
    }

    public final int getScreenWidth() {
        return this.screenWidth;
    }

    public final int getScreenHeight() {
        return this.screenHeight;
    }

    public final void setIgnoreCaretUpdate(boolean status) {
        this.ignoreCaretUpdate = status;
    }

    public final boolean getIgnoreCaretUpdate() {
        return this.ignoreCaretUpdate;
    }

    public final void setCommonPathsFileName(String name) {
        this.commonPathsFileName = name;
    }

    public final String getCommonPathsFileName() {
        return this.commonPathsFileName;
    }

    public final boolean getIsBasedataEditingEnabled() {
        return false;
    }

    public final boolean getIsAutoReapplyEnabled() {
        return true;
    }

    public final boolean getIsAnnotationModified() {
        return this.isAnnotationModified;
    }

    public final boolean getIsBasedataModified() {
        return this.isBasedataModified;
    }

    public final void updateIsAnnotationModified() {
        this.setIsAnnotationModified(this.getCurrentDiscourse().getCurrentMarkableChart().getIsAnyMarkableLevelModified());
    }

    public final void setIsAnnotationModified(boolean status) {
        if (status) {
            if (!this.isAnnotationModified && !this.isBasedataModified) {
                this.setTitle(String.valueOf(this.getTitle()) + " [" + Messages.getString("MMAX2.modified") + "]");
            }
            this.mainMenu.enableSaveAll(true);
            this.isAnnotationModified = status;
        } else {
            this.mainMenu.enableSaveAll(false);
            String title = this.getTitle();
            if (title.endsWith("[" + Messages.getString("MMAX2.modified") + "]")) {
                this.setTitle(title.substring(0, title.lastIndexOf("[")));
            }
            this.isAnnotationModified = status;
        }
    }

    public void clearUndo() {
        this.mainMenu.enableUndo(false);
        this.previousMentionsFileContent.clear();
    }

    public void saveStateForUndo() {
        logger.info("Saving state");
        StringWriter sw = new StringWriter();
        this.getCurrentDiscourse().getCurrentMarkableChart().getMarkableLevels()[0].saveMarkables(sw, false);
        this.previousMentionsFileContent.addFirst(sw.toString());
        this.mainMenu.enableUndo(true);
    }

    public final void setIsBasedataModified(boolean status, boolean refresh) {
        MMAX2MarkableBrowser activeBrowser;
        if (status) {
            if (!this.isBasedataModified && !this.isAnnotationModified) {
                this.setTitle(String.valueOf(this.getTitle()) + " [" + Messages.getString("MMAX2.modified") + "]");
            }
            this.mainMenu.enableSaveAll(true);
            this.isBasedataModified = status;
        } else {
            this.mainMenu.enableSaveAll(false);
            String title = this.getTitle();
            if (title.endsWith("[" + Messages.getString("MMAX2.modified") + "]")) {
                this.setTitle(title.substring(0, title.lastIndexOf("[")));
            }
            this.isBasedataModified = status;
        }
        if (refresh && (activeBrowser = this.getMarkableBrowser()) != null) {
            activeBrowser.refresh();
        }
    }

    public final Renderable getCurrentlyRenderedMarkableRelationContaining(Markable _markable) {
        Renderable temp = null;
        Renderable result = null;
        int z = 0;
        while (z < this.markableRelationsToRender.size()) {
            block4: {
                try {
                    temp = this.markableRelationsToRender.get(z);
                }
                catch (ClassCastException ex) {
                    break block4;
                }
                if (temp.containsMarkable(_markable)) {
                    result = temp;
                    break;
                }
            }
            ++z;
        }
        return result;
    }

    public final MarkableSet getFirstCurrentlyRenderedMarkableSetContaining(Markable markable) {
        return (MarkableSet)this.getCurrentlyRenderedMarkableRelationContaining(markable);
    }

    public final Markable getMarkableFromCurrentlyRenderedMarkableSetContaining(String deID) {
        int pos = this.getCurrentDiscourse().getDiscoursePositionFromDiscourseElementID(deID);
        boolean found = false;
        Markable[][] temp = this.getCurrentDiscourse().getCurrentMarkableChart().getMarkablesAtDiscoursePosition(pos, true);
        Markable result = null;
        Markable tempRes = null;
        int z = 0;
        while (z < temp.length) {
            Markable[] currentLevel = temp[z];
            int b = 0;
            while (b < currentLevel.length) {
                tempRes = currentLevel[b];
                if (this.getCurrentlyRenderedMarkableRelationContaining(tempRes) != null) {
                    result = tempRes;
                    found = true;
                    break;
                }
                ++b;
            }
            if (found) break;
            ++z;
        }
        return result;
    }

    public final void putOnRenderingList(Renderable set) {
        if (set == null) {
            return;
        }
        if (!this.markableRelationsToRender.contains(set)) {
            this.markableRelationsToRender.add(set);
            set.select((Graphics2D)this.getCurrentTextPane().getGraphics(), this.getCurrentDocument(), this.getCurrentPrimaryMarkable());
            this.getCurrentTextPane().startAutoRefresh();
            this.isRendering = true;
        }
    }

    public final void removeFromRenderingList(Renderable set) {
        if (set.getIsPermanent()) {
            set.unselect(this.getCurrentDocument());
            set.setIsPermanent(false);
        }
        if (this.markableRelationsToRender != null) {
            set.unselect(this.getCurrentDocument());
            this.markableRelationsToRender.remove(set);
            this.repaint();
        }
        if (this.markableRelationsToRender.size() == 0) {
            this.markableRelationsToRender = new ArrayList<Renderable>();
            this.isRendering = false;
        }
    }

    public final void removeOpaqueRenderablesFromRenderingList() {
        int z = this.markableRelationsToRender.size() - 1;
        while (z >= 0) {
            if (this.markableRelationsToRender.get(z).isOpaque()) {
                this.markableRelationsToRender.get(z).unselect(this.getCurrentDocument());
                this.markableRelationsToRender.remove(z);
            }
            --z;
        }
    }

    public final void emptyRenderingList() {
        this.emptyRenderingList(false);
    }

    public final void emptyRenderingList(boolean force) {
        boolean mod = false;
        Renderable currentRenderable = null;
        try {
            int r = this.markableRelationsToRender.size() - 1;
            while (r >= 0) {
                currentRenderable = this.markableRelationsToRender.get(r);
                if (!currentRenderable.getIsPermanent() || force) {
                    this.markableRelationsToRender.get(r).unselect(this.getCurrentDocument());
                    this.markableRelationsToRender.remove(currentRenderable);
                    currentRenderable.setIsPermanent(false);
                    mod = true;
                }
                --r;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (mod) {
            this.repaint();
        }
        if (this.markableRelationsToRender.size() == 0) {
            this.isRendering = false;
        }
    }

    public final boolean isCurrentlyBeingRendered(Renderable renderable) {
        if (this.markableRelationsToRender == null) {
            return false;
        }
        return this.markableRelationsToRender.contains(renderable);
    }

    public final void updateRenderingListObjects() {
        this.isRendering = false;
        int z = 0;
        while (z < this.markableRelationsToRender.size()) {
            this.markableRelationsToRender.get(z).updateLinePoints();
            this.isRendering = true;
            ++z;
        }
    }

    public final boolean getIsRendering() {
        return this.isRendering;
    }

    public final void setSelectFromActiveLevelsOnly(boolean status) {
        this.selectFromActiveLevelsOnly = status;
    }

    public final boolean getSelectFromActiveLevelsOnly() {
        return this.selectFromActiveLevelsOnly;
    }

    public final void setHighlightMatchingHandles(boolean status) {
        this.us.setHighlightMatchingHandles(status);
        if (!status) {
            this.currentTextPane.deactivateMarkableHandleHighlight(false);
        }
    }

    public final boolean isHighlightMatchingHandles() {
        return this.us.isHighlightMatchingHandles();
    }

    public final void setAutoRefreshUponPanelAction(boolean status) {
        this.autoRefreshUponPanelAction = status;
    }

    public final boolean getAutoRefreshUponPanelAction() {
        return this.autoRefreshUponPanelAction;
    }

    public final boolean getGroupMarkablesByLevel() {
        return true;
    }

    public final void setUseFancyLabels(boolean status) {
        this.useFancyLabels = status;
        this.getCurrentDiscourse().getCurrentMarkableChart().updateLabels();
    }

    public final boolean getUseFancyLabels() {
        return this.useFancyLabels;
    }

    public final MMAX2Discourse getCurrentDiscourse() {
        return this.currentDiscourse;
    }

    public final void setCurrentDocument(MMAX2Document doc) {
        this.currentDocument = doc;
    }

    public final MMAX2Document getCurrentDocument() {
        return this.currentDocument;
    }

    public final MMAX2TextPane getCurrentTextPane() {
        return this.currentTextPane;
    }

    public static void main(String[] args) {
        logger.info("Starting mmax");
        String tl = null;
        if (args.length == 1) {
            tl = args[0];
        } else if (args.length > 1) {
            System.err.println("Wrong number of args!");
            return;
        }
        final String toLoad = tl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MMAX2 mmax2 = null;
                try {
                    mmax2 = new MMAX2();
                }
                catch (HeadlessException ex) {
                    System.err.println("MMAX2 main application cannot be run without a graphical display!");
                    return;
                }
                mmax2.setTitle(String.valueOf(Messages.getString("MMAX2.MMAX2_for_IPIPAN")) + " " + versionString);
                mmax2.createMenu();
                mmax2.initGlobalStyles();
                UserSettings.FrameSizeAndPosition fap = mmax2.getUserSettings().loadFrameSettings(MMAX2.class.getSimpleName());
                if (fap == null) {
                    int initialWidth = 800;
                    int initialHeight = 500;
                    mmax2.setSize(initialWidth, initialHeight);
                    mmax2.setLocation(mmax2.getScreenWidth() - initialWidth, 0);
                } else {
                    mmax2.setSize(fap.getDimension());
                    mmax2.setLocation(fap.getLocation());
                }
                if (toLoad != null) {
                    mmax2.loadMMAXFile(toLoad);
                }
                mmax2.setVisible(true);
                mmax2.toFront();
            }
        });
    }

    private final void arrangeBrowsers() {
        UserSettings.FrameSizeAndPosition fap = null;
        fap = this.us.loadFrameSettings(MMAX2MarkableBrowser.class.getSimpleName());
        if (fap != null) {
            this.requestMarkableBrowser();
            this.markableBrowser.setLocation(fap.getLocation());
            this.markableBrowser.setSize(fap.getDimension());
        }
        if ((fap = this.us.loadFrameSettings(MMAX2MarkableSetBrowser.class.getSimpleName())) != null) {
            this.requestMarkableSetBrowser();
            this.markableSetBrowser.setLocation(fap.getLocation());
            this.markableSetBrowser.setSize(fap.getDimension());
        }
        if ((fap = this.us.loadFrameSettings(MMAX2MarkablePointerBrowser.class.getSimpleName())) != null) {
            this.requestMarkablePointerBrowser();
            this.markablePointerBrowser.setLocation(fap.getLocation());
            this.markablePointerBrowser.setSize(fap.getDimension());
        }
        if ((fap = this.us.loadFrameSettings(SuperannotationPluginWindow.class.getSimpleName())) != null) {
            this.requestSuperannotationWindow();
            this.superanno.setLocation(fap.getLocation());
            this.superanno.setSize(fap.getDimension());
        }
    }

    private final void initGlobalStyles() {
        this.selectedMarkableGlobalStyle = MMAX2Utils.createSimpleAttributeSet("background=yellow", false);
        this.selectionSpanGlobalStyle = MMAX2Utils.createSimpleAttributeSet("background=d:204204255", false);
    }

    public final SimpleAttributeSet getSelectedStyle() {
        return this.selectedMarkableGlobalStyle;
    }

    public final SimpleAttributeSet getSelectionSpanStyle() {
        return this.selectionSpanGlobalStyle;
    }

    public final void startWaitCursor() {
        this.waitCursorTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MMAX2.this.setToWaitCursor(true);
            }
        });
        this.waitCursorTimer.setCoalesce(false);
        this.waitCursorTimer.setInitialDelay(1);
        this.waitCursorTimer.setRepeats(true);
        this.waitCursorTimer.start();
    }

    public final void stopWaitCursor() {
        this.setToWaitCursor(false);
        this.waitCursorTimer.stop();
    }

    public final void setReapplyBarToolTip(String text) {
    }

    public final void setToWaitCursor(boolean status) {
        if (status) {
            if (this.getGlassPane().getMouseListeners().length == 1) {
                this.getGlassPane().addMouseListener(new MouseAdapter(){});
            }
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getGlassPane().setVisible(true);
        } else {
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getGlassPane().setVisible(false);
        }
    }

    private final void loadMMAXFile(String fileName) {
        this.currentMmaxFilename = new File(fileName).getName();
        this.initializing = true;
        this.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.unloadText();
        logger.info("Loading mmax file: " + fileName);
        this.markableSelectorAttributes = new HashMap<String, String>();
        this.currentTextPane = new MMAX2TextPane();
        this.currentTextPane.setCursor(new Cursor(3));
        this.currentScrollPane.getVerticalScrollBar().addAdjustmentListener(this.currentTextPane);
        this.currentScrollPane.getHorizontalScrollBar().addAdjustmentListener(this.currentTextPane);
        this.currentScrollPane.getViewport().add(this.currentTextPane);
        MMAX2DiscourseLoader loader = new MMAX2DiscourseLoader(fileName, true, this.getCommonPathsFileName());
        this.currentWorkingDirectory = loader.getWorkingDirectory();
        logger.debug("Current working directory set to " + this.currentWorkingDirectory);
        this.currentDiscourse = loader.getCurrentDiscourse();
        this.currentDiscourse.setMMAX2(this);
        this.currentDocument = new MMAX2Document(this.us.getDisplayFontFamily(), this.us.getDisplayFontSize(), this.us.getDisplayLineSpacing(), this);
        logger.debug("Applying stylesheet " + this.currentDiscourse.getCurrentStyleSheet() + " ... ");
        this.currentDiscourse.reapplyStyleSheet();
        this.currentDiscourse.getCurrentMarkableChart().init();
        this.currentTextPane.setMMAX2(this);
        this.currentTextPane.setStyledDocument(this.currentDocument);
        this.initializing = false;
        this.getGlassPane().setVisible(false);
        this.setTitle(String.valueOf(Messages.getString("MMAX2.MMAX2_for_IPIPAN")) + " " + Messages.getString("MMAX2.version") + " " + versionString + " " + Messages.getString("MMAX2.Text") + ": " + this.currentMmaxFilename);
        this.updateIsAnnotationModified();
        this.mainMenu.textLoaded();
        this.requestSetFontSize(this.us.getDisplayFontSize());
        this.arrangeBrowsers();
        this.requestRefreshDisplay();
        this.setVisible(true);
        loader = null;
        System.gc();
        logger.info("File loaded.");
    }

    private void unloadText() {
        if (this.currentDiscourse == null) {
            return;
        }
        logger.info("Unloading text " + this.currentMmaxFilename + " ...");
        this.dismissAllBrowsers();
        this.dismissAttributePanel();
        this.currentScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.currentTextPane);
        this.currentScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.currentTextPane);
        this.currentScrollPane.getViewport().remove(this.currentTextPane);
        this.currentTextPane = null;
        this.currentPrimaryMarkable = null;
        this.currentSecondaryMarkable = null;
        this.emptyRenderingList();
        this.currentDiscourse.getCurrentMarkableChart().destroyDependentComponents();
        this.currentDiscourse.destroyDependentComponents();
        this.currentDiscourse = null;
        this.currentDocument = null;
        System.gc();
    }

    private void dismissAttributePanel() {
        logger.debug("Dismissing attribute panel");
        MMAX2AttributePanelContainer attributePanelContainer = this.currentDiscourse.getCurrentMarkableChart().attributePanelContainer;
        this.dismissFrame(attributePanelContainer, MMAX2AttributePanelContainer.class.getSimpleName());
    }

    private final void createMenu() {
        this.mainMenu = new MainMenu(this, this.us);
        this.setJMenuBar(this.mainMenu);
    }

    public final MMAX2MarkableBrowser getMarkableBrowser() {
        return this.markableBrowser;
    }

    public final MMAX2MarkableBrowser getMarkableBrowserForMarkableLevel(String name) {
        if (this.markableBrowser != null && this.markableBrowser.getCurrentlyDisplayedMarkableLevelName().equalsIgnoreCase(name)) {
            return this.markableBrowser;
        }
        return null;
    }

    public final MMAX2MarkableSetBrowser getMarkableSetBrowserForMarkableLevel(String name) {
        if (this.markableSetBrowser != null && this.markableSetBrowser.getCurrentlyDisplayedMarkableLevelName().equalsIgnoreCase(name)) {
            return this.markableSetBrowser;
        }
        return null;
    }

    public final MMAX2MarkablePointerBrowser getMarkablePointerBrowserForMarkableLevel(String name) {
        if (this.markablePointerBrowser != null && this.markablePointerBrowser.getCurrentlyDisplayedMarkableLevelName().equalsIgnoreCase(name)) {
            return this.markablePointerBrowser;
        }
        return null;
    }

    final void requestSetFontFamily(String newFontName) {
        this.getCurrentDocument().setDisplayFontFamily(newFontName);
        this.requestRefreshDisplay();
        this.us.setDisplayFontFamily(newFontName);
    }

    final void requestSetFontSize(int newFontSize) {
        SwingUtilities.invokeLater(new UpdateFontSizeRunnable(this, newFontSize));
    }

    public final void requestSetLineSpacing(float spacing) {
        this.getCurrentDocument().setDisplayLineSpacing(spacing);
        this.us.setDisplayLineSpacing(spacing);
    }

    private void dismissMainWindow() {
        logger.debug("Dismissing main window");
        this.dismissFrame(this, MMAX2.class.getSimpleName());
    }

    public final void requestSaveAll() {
        this.currentDiscourse.getCurrentMarkableChart().saveAllMarkableLevels();
        this.currentDiscourse.saveBasedata("");
        this.currentDiscourse.getCurrentMarkableChart().nothingClicked(1);
        if (this.superanno != null) {
            this.superanno.saveText();
        }
        this.clearUndo();
    }

    private final boolean checkIsSavingNeededBeforeLoadingNewFile() {
        if (this.getCurrentDiscourse() == null) {
            return true;
        }
        if (this.getIsAnnotationModified() && this.getIsBasedataModified()) {
            String message = Messages.getString("MMAX2.The_base_data_and_the_annotation_has_been_modified_Would_you_like_to_save_before_loading_new_project");
            Object[] options = new Object[]{Messages.getString("MMAX2.Save_changes"), Messages.getString("MMAX2.Discard_changes"), Messages.getString("MMAX2.Cancel")};
            int result = JOptionPane.showOptionDialog(null, message, Messages.getString("MMAX2.Load_annotation_Confirmation"), -1, 2, null, options, options[2]);
            if (result == 0) {
                this.requestSaveAll();
            } else if (result == 2 || result == -1 || result == 2) {
                System.err.println("Cancelling exit!");
                return false;
            }
        } else if (this.getIsAnnotationModified()) {
            String message = Messages.getString("MMAX2.The_annotation_has_been_modified_Would_you_like_to_save_before_loading_new_file");
            Object[] options = new Object[]{Messages.getString("MMAX2.Save_changes"), Messages.getString("MMAX2.Discard_changes"), Messages.getString("MMAX2.Cancel")};
            int result = JOptionPane.showOptionDialog(null, message, Messages.getString("MMAX2.Load_annotation_Confirmation"), -1, 2, null, options, options[2]);
            if (result == 0) {
                this.requestSaveAll();
            } else if (result == 2 || result == -1 || result == 2) {
                System.err.println("Cancelling exit!");
                return false;
            }
        } else if (this.getIsBasedataModified()) {
            String message = Messages.getString("MMAX2.The_base_data_has_been_modified_Would_you_like_to_save_before_loading_new_project");
            Object[] options = new Object[]{Messages.getString("MMAX2.Save_changes"), Messages.getString("MMAX2.Discard_changes"), Messages.getString("MMAX2.Cancel")};
            int result = JOptionPane.showOptionDialog(null, message, Messages.getString("MMAX2.Load_annotation_Confirmation"), -1, 2, null, options, options[2]);
            if (result == 0) {
                this.currentDiscourse.saveBasedata("");
            } else if (result == 2 || result == -1 || result == 2) {
                System.err.println("Cancelling exit!");
                return false;
            }
        }
        return true;
    }

    private void dismissAllBrowsers() {
        logger.debug("Dismissing browsers");
        this.dismissFrame(this.markableBrowser, MMAX2MarkableBrowser.class.getSimpleName());
        this.dismissFrame(this.markableSetBrowser, MMAX2MarkableSetBrowser.class.getSimpleName());
        this.dismissFrame(this.markablePointerBrowser, MMAX2MarkablePointerBrowser.class.getSimpleName());
        this.dismissFrame(this.superanno, SuperannotationPluginWindow.class.getSimpleName());
    }

    private void dismissFrame(JFrame frame, String name) {
        this.us.storeFrameSettings(frame, name);
        if (frame != null) {
            frame.dispose();
        }
    }

    public final void requestLoadFile() {
        if (!this.checkIsSavingNeededBeforeLoadingNewFile()) {
            return;
        }
        String requestedFileName = "";
        JFileChooser chooser = new JFileChooser(this.currentWorkingDirectory);
        chooser.setFileFilter(new MMAXFileFilter("mmax", Messages.getString("MMAX2.MMAX2_annotation_files")));
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            this.setCommonPathsFileName("");
            requestedFileName = chooser.getSelectedFile().getAbsolutePath();
            this.loadMMAXFile(requestedFileName);
        }
    }

    public final void redraw(SVGGraphics2D svgGraph) {
        Graphics2D graphics = (Graphics2D)this.getCurrentTextPane().getGraphics();
        if (svgGraph != null) {
            graphics = svgGraph;
        }
        MMAX2Document doc = this.getCurrentDocument();
        if (this.getRedrawAllOnNextRefresh()) {
            int z = 0;
            while (z < this.markableRelationsToRender.size()) {
                this.markableRelationsToRender.get(z).select(graphics, doc, this.getCurrentPrimaryMarkable());
                ++z;
            }
        } else {
            int z = 0;
            while (z < this.markableRelationsToRender.size()) {
                this.markableRelationsToRender.get(z).refresh(graphics);
                ++z;
            }
        }
        this.setRedrawAllOnNextRefresh(false);
    }

    public final void setRedrawAllOnNextRefresh(boolean status) {
        this.redrawAllOnNextRefresh = status;
    }

    public final boolean getRedrawAllOnNextRefresh() {
        return this.redrawAllOnNextRefresh;
    }

    public final void setCurrentPrimaryMarkable(Markable _markable) {
        if (this.markableBrowser != null) {
            this.markableBrowser.selectMarkable(_markable);
        }
        if (this.markableSetBrowser != null) {
            this.markableSetBrowser.selectMarkable(_markable);
        }
        if (this.markablePointerBrowser != null) {
            this.markablePointerBrowser.selectMarkable(_markable);
        }
        this.currentPrimaryMarkable = _markable;
    }

    public final Markable getCurrentPrimaryMarkable() {
        return this.currentPrimaryMarkable;
    }

    public final void setCurrentSecondaryMarkable(Markable _markable) {
        this.currentSecondaryMarkable = _markable;
    }

    public final Markable getCurrentSecondaryMarkable() {
        return this.currentSecondaryMarkable;
    }

    public final JViewport getCurrentViewport() {
        return this.currentScrollPane.getViewport();
    }

    public void setShowInMarkableSelectorAttribute(String level, String attribute) {
        this.markableSelectorAttributes.put(level, attribute);
        System.err.println(String.valueOf(level) + " " + attribute);
    }

    public String getShowInMarkableSelectorAttribute(String level) {
        String result = this.markableSelectorAttributes.get(level);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void requestUndo() {
        if (this.previousMentionsFileContent.isEmpty()) {
            logger.info("Nothing to undo!");
        } else {
            logger.info("Undoing...");
            MarkableChart chart = this.getCurrentDiscourse().getCurrentMarkableChart();
            MarkableLevel ml = chart.getMarkableLevels()[0];
            chart.removeAllLevels();
            this.setCurrentPrimaryMarkable(null);
            this.setCurrentSecondaryMarkable(null);
            MarkableFileLoader mfl = new MarkableFileLoader();
            logger.debug("Loading previous level.");
            mfl.load(new StringReader(this.previousMentionsFileContent.removeFirst()), ml);
            MarkableLevel newLevel = mfl.getMarkableLevel();
            newLevel.setCurrentDiscourse(this.currentDiscourse);
            newLevel.createMarkables();
            this.currentDiscourse.getCurrentMarkableChart().addMarkableLevel(newLevel);
            this.currentDiscourse.getCurrentMarkableChart().createDiscoursePositionToMarkableMappings();
            this.currentDiscourse.getCurrentMarkableChart().setMarkableLevelDisplayPositions();
            this.currentDiscourse.getCurrentMarkableChart().attributePanelContainer.setAttributePanel(newLevel);
            this.currentDiscourse.getCurrentMarkableChart().initMarkableRelations();
            this.currentDiscourse.getCurrentMarkableChart().updateLabels();
            if (this.markableBrowser != null) {
                this.markableBrowser.updateList();
            }
            if (this.markablePointerBrowser != null) {
                this.markablePointerBrowser.update();
            }
            if (this.markableSetBrowser != null) {
                this.markableSetBrowser.update();
            }
            this.requestReapplyDisplay();
            if (this.previousMentionsFileContent.isEmpty()) {
                this.clearUndo();
            }
            logger.info("Done");
        }
    }

    public void requestSetAutoSaveInterval(int interval) {
        System.err.println("Setting auto-save interval to " + interval + " minutes.");
        if (this.autoSaveTimer == null) {
            if (interval > 0) {
                this.autoSaveTimer = new Timer(60000 * interval, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        MMAX2.this.executeAutoSave();
                    }
                });
            }
        } else {
            if (this.autoSaveTimer.isRunning()) {
                this.autoSaveTimer.stop();
            }
            if (interval > 0) {
                this.autoSaveTimer = new Timer(60000 * interval, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        MMAX2.this.executeAutoSave();
                    }
                });
            }
        }
        if (interval > 0) {
            this.autoSaveTimer.setCoalesce(true);
            this.autoSaveTimer.setRepeats(true);
            this.autoSaveTimer.start();
        }
    }

    public void executeAutoSave() {
        MarkableLevel[] levels = this.getCurrentDiscourse().getCurrentMarkableChart().getMarkableLevels();
        logger.debug("Found " + levels.length + " active levels.");
        int b = 0;
        while (b < levels.length) {
            levels[b].saveMarkables("", true);
            ++b;
        }
    }

    public void loadNextText() {
        if (!new File(this.currentWorkingDirectory).exists()) {
            JOptionPane.showMessageDialog(null, Messages.getString("MMAX2.No_next_text_found"), Messages.getString("MMAX2.MMAX2_loader"), 1);
            return;
        }
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(new File(this.currentWorkingDirectory).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".mmax");
            }
        })));
        Collections.sort(files);
        String targetFile = null;
        if (this.currentMmaxFilename == null || this.currentMmaxFilename.equals("")) {
            if (files.size() > 0) {
                targetFile = ((File)files.get(0)).getPath();
            }
        } else {
            int i = 0;
            while (i < files.size()) {
                File f = (File)files.get(i);
                if (f.getName().equals(this.currentMmaxFilename)) {
                    if (i + 1 < files.size()) {
                        targetFile = ((File)files.get(i + 1)).getPath();
                        break;
                    }
                    targetFile = ((File)files.get(0)).getPath();
                    break;
                }
                ++i;
            }
        }
        if (targetFile == null) {
            System.out.println("No next file");
            JOptionPane.showMessageDialog(null, Messages.getString("MMAX2.No_next_text_found"), Messages.getString("MMAX2.MMAX2_loader"), 1);
        } else {
            if (!this.checkIsSavingNeededBeforeLoadingNewFile()) {
                return;
            }
            this.loadMMAXFile(targetFile);
        }
    }

    public void scrollToMarkable(Markable selectedMarkable) {
        this.scrollToPosition(selectedMarkable.getLeftmostDisplayPosition());
    }

    public void scrollToPosition(int rightmostDisplayPosition) {
        this.setIgnoreCaretUpdate(true);
        try {
            this.getCurrentTextPane().scrollRectToVisible(this.getCurrentTextPane().modelToView(rightmostDisplayPosition));
        }
        catch (BadLocationException ex) {
            System.err.println("Cannot render modelToView()");
        }
        this.setIgnoreCaretUpdate(false);
    }

    public UserSettings getUserSettings() {
        return this.us;
    }

    public final void requestReapplyDisplay() {
        this.startWaitCursor();
        this.getCurrentDiscourse().reapplyStyleSheet();
        this.stopWaitCursor();
    }

    public final void requestRefreshDisplay() {
        this.setCursor(new Cursor(3));
        this.currentScrollPane.setCursor(new Cursor(3));
        this.currentTextPane.setCursor(new Cursor(3));
        this.getCurrentDiscourse().getCurrentMarkableChart().rerender();
        this.setCursor(new Cursor(0));
        this.currentScrollPane.setCursor(new Cursor(0));
        this.currentTextPane.setCursor(new Cursor(0));
    }

    final void requestSuperannotationWindow() {
        if (this.superanno == null) {
            this.superanno = new SuperannotationPluginWindow(this.currentDiscourse);
        } else {
            this.superanno.toFront();
        }
    }

    final void requestMarkableSetBrowser() {
        if (this.markableSetBrowser == null) {
            this.markableSetBrowser = new MMAX2MarkableSetBrowser(this);
        } else {
            this.markableSetBrowser.toFront();
        }
    }

    final void requestMarkablePointerBrowser() {
        if (this.markablePointerBrowser == null) {
            this.markablePointerBrowser = new MMAX2MarkablePointerBrowser(this);
        } else {
            this.markablePointerBrowser.toFront();
        }
    }

    final void requestMarkableBrowser() {
        if (this.markableBrowser == null) {
            this.markableBrowser = new MMAX2MarkableBrowser(this, this.getCurrentPrimaryMarkable());
        } else {
            this.markableBrowser.toFront();
        }
    }

    final void requestExecutePlugin(String className, Map<String, String> attributes) {
        MMAX2Plugin plugin = null;
        try {
            Class<?> pluginClass = Class.forName(className);
            System.err.println(pluginClass);
            plugin = (MMAX2Plugin)pluginClass.newInstance();
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(null, String.valueOf(Messages.getString("MMAX2.Could_not_find_plugin_class")) + className + "!", Messages.getString("MMAX2.MMAX2_Plugin_handler"), 0);
            return;
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        if (plugin != null) {
            plugin.callPlugin(this.getCurrentDiscourse(), attributes);
        }
    }

    public final void requestExit() {
        logger.info("Requesting exit...");
        if (!this.checkIsSavingNeededBeforeExit()) {
            return;
        }
        this.unloadText();
        this.dismissMainWindow();
        this.us.save();
        logger.info("Exiting.");
        System.exit(0);
    }

    private boolean checkIsSavingNeededBeforeExit() {
        if (this.getCurrentDiscourse() == null) {
            return true;
        }
        if (this.getIsAnnotationModified() && this.getIsBasedataModified()) {
            String message = Messages.getString("MMAX2.The_base_data_and_the_annotation_has_been_modified_Would_you_like_to_save_before_exiting");
            Object[] options = new Object[]{Messages.getString("MMAX2.Save_and_exit"), Messages.getString("MMAX2.Exit_without_saving"), Messages.getString("MMAX2.Cancel")};
            int result = JOptionPane.showOptionDialog(null, message, Messages.getString("MMAX2.Exit_application_Confirmation"), -1, 2, null, options, options[2]);
            if (result == 0) {
                this.currentDiscourse.saveBasedata("");
                this.currentDiscourse.getCurrentMarkableChart().saveAllMarkableLevels();
            } else if (result == 2 || result == -1 || result == 2) {
                System.out.println("Cancelling exit!");
                return false;
            }
        } else if (this.getIsAnnotationModified()) {
            String message = Messages.getString("MMAX2.The_annotation_has_been_modified_Would_you_like_to_save_before_exiting");
            Object[] options = new Object[]{Messages.getString("MMAX2.Save_and_exit"), Messages.getString("MMAX2.Exit_without_saving"), Messages.getString("MMAX2.Cancel")};
            int result = JOptionPane.showOptionDialog(null, message, Messages.getString("MMAX2.Exit_application_Confirmation"), -1, 2, null, options, options[2]);
            if (result == 0) {
                this.currentDiscourse.getCurrentMarkableChart().saveAllMarkableLevels();
            } else if (result == 2 || result == -1 || result == 2) {
                System.out.println("Cancelling exit!");
                return false;
            }
        } else if (this.getIsBasedataModified()) {
            String message = Messages.getString("MMAX2.The_base_data_has_been_modified_Would_you_like_to_save_before_exiting");
            Object[] options = new Object[]{Messages.getString("MMAX2.Save_and_exit"), Messages.getString("MMAX2.Exit_without_saving"), Messages.getString("MMAX2.Cancel")};
            int result = JOptionPane.showOptionDialog(null, message, Messages.getString("MMAX2.Exit_application_Confirmation"), -1, 2, null, options, options[2]);
            if (result == 0) {
                this.currentDiscourse.saveBasedata("");
            } else if (result == 2 || result == -1 || result == 2) {
                System.out.println("Cancelling exit!");
                return false;
            }
        }
        return true;
    }

    public void dismissMarkableSetBrowser() {
        this.markableSetBrowser = null;
    }

    public void dismissMarkablePointerBrowser() {
        this.markablePointerBrowser = null;
    }

    public void dismissMarkableBrowser() {
        this.markableBrowser = null;
    }

    public void dismissSuperanno() {
        this.superanno = null;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void resetUserSettings() {
        this.us = new UserSettings();
        this.currentDocument.setStyle(this.us.getDisplayFontFamily(), this.us.getDisplayFontSize(), this.us.getDisplayLineSpacing());
        this.requestReapplyDisplay();
    }

    public void copyDocumentSpanToClipboard(int start, int end) {
        String text = "";
        try {
            text = this.getCurrentDocument().getText(start, end - start + 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        StringSelection sel = new StringSelection(text);
        Clipboard clippi = Toolkit.getDefaultToolkit().getSystemClipboard();
        clippi.setContents(sel, null);
    }

    public void addRunningPlugin(SuperannotationPluginWindow superannotationPluginWindow) {
        this.superanno = superannotationPluginWindow;
    }

    class MMAX2MainWindowListener
    extends WindowAdapter {
        MMAX2MainWindowListener() {
        }

        @Override
        public void windowActivated(WindowEvent we) {
            try {
                MMAX2.this.getCurrentTextPane().startAutoRefresh();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        public void windowDeiconified(WindowEvent we) {
            try {
                MMAX2.this.getCurrentTextPane().startAutoRefresh();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        public void windowClosing(WindowEvent we) {
            MMAX2.this.requestExit();
        }
    }

    private class UpdateFontSizeRunnable
    implements Runnable {
        private final MMAX2 mmax;
        private final int newFontSize;

        public UpdateFontSizeRunnable(MMAX2 mmax, int newFontSize) {
            this.mmax = mmax;
            this.newFontSize = newFontSize;
        }

        @Override
        public void run() {
            Enumeration enumer = UIManager.getDefaults().keys();
            while (enumer.hasMoreElements()) {
                Object key = enumer.nextElement();
                Object value = UIManager.get(key);
                if (!(value instanceof Font)) continue;
                UIManager.put(key, new FontUIResource(((Font)value).deriveFont((float)this.newFontSize - 1.0f)));
            }
            SwingUtilities.updateComponentTreeUI(this.mmax);
            if (MMAX2.this.markableBrowser != null) {
                SwingUtilities.updateComponentTreeUI(this.mmax.markableBrowser);
            }
            if (MMAX2.this.markablePointerBrowser != null) {
                SwingUtilities.updateComponentTreeUI(this.mmax.markablePointerBrowser);
            }
            if (MMAX2.this.markableSetBrowser != null) {
                SwingUtilities.updateComponentTreeUI(this.mmax.markableSetBrowser);
            }
            if (MMAX2.this.superanno != null) {
                SwingUtilities.updateComponentTreeUI(this.mmax.superanno);
            }
            if (MMAX2.this.getCurrentDocument() != null) {
                MMAX2.this.getCurrentDocument().setDisplayFontSize(this.newFontSize);
                if (MMAX2.this.getCurrentDiscourse().getCurrentMarkableChart().attributePanelContainer != null) {
                    SwingUtilities.updateComponentTreeUI(((MMAX2)this.mmax).currentDiscourse.getCurrentMarkableChart().attributePanelContainer);
                }
                MMAX2.this.requestRefreshDisplay();
                MMAX2.this.us.setDisplayFontSize(this.newFontSize);
            }
        }
    }
}

