/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4core.gui.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pl.waw.ipipan.zil.core.mmax4core.Messages;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkablePointer;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableRelation;
import pl.waw.ipipan.zil.core.mmax4core.annotation.markables.MarkableSet;
import pl.waw.ipipan.zil.core.mmax4core.annotation.scheme.MMAX2AnnotationScheme;
import pl.waw.ipipan.zil.core.mmax4core.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4core.gui.document.MMAX2Document;
import pl.waw.ipipan.zil.core.mmax4core.gui.windows.MMAX2AttributePanelContainer;
import pl.waw.ipipan.zil.core.mmax4core.utils.MMAX2Constants;

public class MMAX2AttributePanel
extends JPanel {
    private static final long serialVersionUID = 8910903519616361197L;
    private JScrollPane pane = null;
    static String VersionString = "MMAX2 port V0.5";
    public MMAX2AnnotationScheme scheme;
    private MMAX2AttributePanelContainer container = null;
    public JCheckBox suppressCheck;
    public JCheckBox warnOnExtraAttributes;
    public Markable currentMarkable;
    public List<MMAX2Attribute> lastValidAttributes = null;
    public List<String> keepables;
    public boolean hasUncommittedChanges = false;
    public static String MMAXDataPath = "";
    public JPanel modifiablePanel;
    private String oneClickAttributeName = "";

    public MMAX2AttributePanel(MMAX2AnnotationScheme _scheme) {
        this.setAlignmentX(0.0f);
        this.setLayout(new FlowLayout(3));
        this.scheme = _scheme;
    }

    public final void setScrollPane(JScrollPane _pane) {
        this.pane = _pane;
    }

    public final JScrollPane getScrollPane() {
        return this.pane;
    }

    public final void setAttributePanelContainer(MMAX2AttributePanelContainer _container) {
        this.container = _container;
    }

    public final void setOneClickAnnotationAttributeName(String _name) {
        this.oneClickAttributeName = _name;
    }

    public final String getOneClickAnnotationAttributeName() {
        return this.oneClickAttributeName;
    }

    public final void setHasUncommittedChanges(boolean newStatus) {
        if (newStatus) {
            if (this.currentMarkable != null) {
                this.container.setTitle(String.valueOf(this.currentMarkable.toString()) + " (" + Messages.getString("MMAX2AttributePanel.dirty") + ")");
            }
        } else if (this.currentMarkable != null) {
            this.container.setTitle(this.currentMarkable.toString());
        } else {
            this.container.setTitle(Messages.getString("MMAX2AttributePanel.nothing_selected"));
        }
        this.hasUncommittedChanges = newStatus;
    }

    public final List<String> getAllAttributes() {
        return this.scheme.getAllAttributeNames();
    }

    public void displayInitComplete() {
    }

    public final void create() {
        this.keepables = new ArrayList<String>();
        JPanel staticOuterPanel = new JPanel();
        staticOuterPanel.setAlignmentX(0.0f);
        Box staticOuterBox = Box.createVerticalBox();
        this.suppressCheck = new JCheckBox("Suppress check");
        this.suppressCheck.setToolTipText("Suppresses consistency check for CURRENTLY invalid attributes when selecting a Markable!");
        this.suppressCheck.setSelected(false);
        this.warnOnExtraAttributes = new JCheckBox("Warn on extra attributes");
        this.warnOnExtraAttributes.setToolTipText("Displays a message if undefined extra attributes are found on a Markable!");
        this.warnOnExtraAttributes.setSelected(true);
        Box outerButtonBox = Box.createVerticalBox();
        MMAX2Attribute[] initialAttributes = this.scheme.getInitialAttributes().toArray(new MMAX2Attribute[0]);
        this.lastValidAttributes = new ArrayList<MMAX2Attribute>();
        this.modifiablePanel = new JPanel();
        Box tempbox = Box.createHorizontalBox();
        Box AttributeBox = Box.createVerticalBox();
        int u = 0;
        while (u < initialAttributes.length) {
            AttributeBox.add(initialAttributes[u]);
            ++u;
        }
        tempbox.add(AttributeBox);
        this.modifiablePanel.add(tempbox);
        staticOuterBox.add(this.modifiablePanel);
        staticOuterBox.add(outerButtonBox);
        staticOuterPanel.add(staticOuterBox);
        staticOuterPanel.setLayout(new FlowLayout(0, 0, 0));
        this.add(staticOuterPanel);
    }

    @Override
    public final void setEnabled(boolean status) {
        this.scheme.setEnabled(status);
    }

    public final void displayMarkableAttributes(Markable markable) {
        this.keepables = new ArrayList<String>();
        if (markable == null) {
            this.scheme.reset();
            this.container.setTitle("<" + Messages.getString("MMAX2AttributePanel.nothing_selected") + ">");
            this.setApplyEnabled(false);
            this.setUndoEnabled(false);
            this.scheme.setEnabled(false);
            this.rebuild();
            return;
        }
        this.container.setTitle(markable.toString());
        this.scheme.resetAllAttributes();
        this.currentMarkable = markable;
        MMAX2Attribute[] currentAttributes = this.scheme.getAttributes(markable);
        this.removeAllAttributes();
        this.addAttributes(currentAttributes);
        this.lastValidAttributes = this.getAllCurrentAttributes();
        this.scheme.setEnabled(true);
        this.rebuild();
        if (this.container.isToFront()) {
            this.container.toFront();
        }
        this.setApplyEnabled(false);
        this.setUndoEnabled(false);
        this.setMarkableAttributes(markable, false);
    }

    public final Map<String, String> getAttributeValuePairs() {
        HashMap<String, String> result = new HashMap<String, String>();
        MMAX2Attribute currentAttribute = null;
        Box tempbox = (Box)this.modifiablePanel.getComponent(0);
        Box attributebox = (Box)tempbox.getComponent(0);
        int compCount = attributebox.getComponentCount();
        String currentAttributeString = "";
        String currentValue = "";
        int e = 0;
        while (e < compCount) {
            currentAttribute = (MMAX2Attribute)attributebox.getComponent(e);
            if (currentAttribute.getType() != 5) {
                currentAttributeString = currentAttribute.getLowerCasedAttributeName();
                currentValue = currentAttribute.getSelectedValue();
                result.put(new String(currentAttributeString), new String(currentValue));
            }
            ++e;
        }
        return result;
    }

    public final List<MMAX2Attribute> getAllCurrentAttributes() {
        ArrayList<MMAX2Attribute> result = new ArrayList<MMAX2Attribute>();
        MMAX2Attribute currentAttribute = null;
        Box tempbox = (Box)this.modifiablePanel.getComponent(0);
        Box attributebox = (Box)tempbox.getComponent(0);
        int compCount = attributebox.getComponentCount();
        int e = 0;
        while (e < compCount) {
            currentAttribute = (MMAX2Attribute)attributebox.getComponent(e);
            result.add(currentAttribute);
            ++e;
        }
        return result;
    }

    public final void setMarkableAttributes(Markable markable, boolean rerender) {
        boolean change = false;
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        HashMap<String, String> oldAttributes = new HashMap<String, String>(markable.getAttributes());
        List<MMAX2Attribute> currentAttributes = this.getAllCurrentAttributes();
        MMAX2Attribute currentAttribute = null;
        ArrayList<String> frozenNames = new ArrayList<String>();
        int z = 0;
        while (z < currentAttributes.size()) {
            currentAttribute = currentAttributes.get(z);
            if (currentAttribute.getIsFrozen()) {
                System.out.println("Skipping frozen " + currentAttribute.getDisplayAttributeName());
                frozenNames.add(currentAttribute.getLowerCasedAttributeName());
            } else {
                String currentAttributeString = currentAttribute.getLowerCasedAttributeName();
                String currentValue = currentAttribute.getSelectedValue();
                newAttributes.put(new String(currentAttributeString), new String(currentValue));
                if (oldAttributes.remove(currentAttributeString) == null && !currentAttributeString.equals("comment")) {
                    change = true;
                }
            }
            ++z;
        }
        Iterator allAttributeStrings = oldAttributes.keySet().iterator();
        String retainedExtraAttributes = "";
        while (allAttributeStrings.hasNext()) {
            String currentAttributeString = (String)allAttributeStrings.next();
            if (frozenNames.contains(currentAttributeString)) {
                newAttributes.put(new String(currentAttributeString.toLowerCase()), new String((String)oldAttributes.get(currentAttributeString.toLowerCase())));
                continue;
            }
            if (!this.scheme.isDefined(currentAttributeString)) {
                newAttributes.put(new String(currentAttributeString.toLowerCase()), new String((String)oldAttributes.get(currentAttributeString.toLowerCase())));
                retainedExtraAttributes = String.valueOf(retainedExtraAttributes) + "\n" + currentAttributeString + "(" + (String)oldAttributes.get(currentAttributeString) + ")";
                continue;
            }
            if (this.keepables.contains(currentAttributeString)) {
                newAttributes.put(new String(currentAttributeString.toLowerCase()), new String((String)oldAttributes.get(currentAttributeString.toLowerCase())));
                continue;
            }
            int u = 0;
            while (u < this.lastValidAttributes.size()) {
                MMAX2Attribute currentCurrentAttribute = this.lastValidAttributes.get(u);
                if (currentCurrentAttribute.getLowerCasedAttributeName().equalsIgnoreCase(currentAttributeString)) {
                    MarkableRelation relation;
                    if (currentCurrentAttribute.getType() == 6) {
                        relation = currentCurrentAttribute.getMarkableRelation();
                        MarkablePointer pointer = relation.getMarkablePointerForSourceMarkable(this.currentMarkable);
                        if (pointer != null) {
                            this.currentMarkable.getMarkableLevel().getCurrentDiscourse().getCurrentMarkableChart().removeMarkablePointerWithSourceMarkable(this.currentMarkable, relation, false);
                            this.getContainer().getMMAX2().requestRefreshDisplay();
                        } else {
                            System.err.println("No value for markable_pointer " + currentAttributeString);
                        }
                    } else if (currentCurrentAttribute.getType() == 5) {
                        relation = currentCurrentAttribute.getMarkableRelation();
                        MarkableSet set = relation.getMarkableSetWithAttributeValue(this.currentMarkable.getAttributeValue(currentAttributeString));
                        if (set != null) {
                            this.currentMarkable.getMarkableLevel().getCurrentDiscourse().getCurrentMarkableChart().removeMarkableFromMarkableSet(this.currentMarkable, set, false);
                            this.getContainer().getMMAX2().requestRefreshDisplay();
                        } else {
                            System.err.println("No value for markable_set " + currentAttributeString);
                        }
                    }
                }
                ++u;
            }
        }
        markable.setAttributes(newAttributes);
        if (change) {
            markable.getMarkableLevel().setIsDirty(true, false);
        }
        this.setApplyEnabled(false);
        this.setUndoEnabled(false);
        List<MMAX2Attribute> visibleAttributes = this.getAllCurrentAttributes();
        int z2 = 0;
        while (z2 < this.scheme.getSize()) {
            if (!visibleAttributes.contains(this.scheme.getAttributes().get(z2))) {
                this.scheme.getAttributes().get(z2).toDefault();
            }
            ++z2;
        }
        if (rerender) {
            MMAX2Document doc = markable.getMarkableLevel().getCurrentDiscourse().getDisplayDocument();
            doc.startChanges(markable);
            markable.renderMe(MMAX2Constants.RENDER_SELECTED);
            doc.commitChanges();
        }
    }

    public final void removeAllAttributes() {
        Box tempbox = (Box)this.modifiablePanel.getComponent(0);
        tempbox.removeAll();
    }

    public final void addAttributes(MMAX2Attribute[] attributes) {
        Box tempbox = (Box)this.modifiablePanel.getComponent(0);
        Box schemebox = null;
        if (tempbox.getComponentCount() != 1) {
            schemebox = Box.createVerticalBox();
            schemebox.setBackground(Color.yellow);
            tempbox.add(schemebox);
        } else {
            schemebox = (Box)tempbox.getComponent(0);
        }
        int z = 0;
        while (z < attributes.length) {
            schemebox.add(attributes[z]);
            ++z;
        }
        this.rebuild();
        this.container.invalidate();
    }

    public final void addAttributesAfter(MMAX2Attribute[] attributes, MMAX2Attribute leader) {
        Box tempbox = (Box)this.modifiablePanel.getComponent(0);
        Box schemebox = null;
        if (tempbox.getComponentCount() != 1) {
            schemebox = Box.createVerticalBox();
            schemebox.setBackground(Color.yellow);
            tempbox.add(schemebox);
        } else {
            schemebox = (Box)tempbox.getComponent(0);
        }
        int offset = 0;
        int o = 0;
        while (o < schemebox.getComponentCount()) {
            if (schemebox.getComponent(o) == leader) {
                offset = o;
                break;
            }
            ++o;
        }
        int z = 0;
        while (z < attributes.length) {
            schemebox.add((Component)attributes[z], offset + z + 1);
            ++z;
        }
        this.rebuild();
        this.container.invalidate();
    }

    public final MMAX2Attribute getLastAttribute() {
        Box tempbox = (Box)this.modifiablePanel.getComponent(0);
        Box schemebox = (Box)tempbox.getComponent(0);
        return (MMAX2Attribute)schemebox.getComponent(schemebox.getComponentCount() - 1);
    }

    public final MMAX2Attribute[] removeTrailingDependentAttributes(MMAX2Attribute lastAttribute) {
        MMAX2Attribute currentAttribute = null;
        ArrayList<MMAX2Attribute> removedAsList = new ArrayList<MMAX2Attribute>();
        Box tempbox = (Box)this.modifiablePanel.getComponent(0);
        Box attributebox = (Box)tempbox.getComponent(0);
        int compCount = attributebox.getComponentCount();
        int e = compCount - 1;
        while (e >= 0) {
            currentAttribute = (MMAX2Attribute)attributebox.getComponent(e);
            if (currentAttribute.dependsOn(lastAttribute)) {
                removedAsList.add(currentAttribute);
                attributebox.remove(e);
            }
            --e;
        }
        MMAX2Attribute[] result = removedAsList.toArray(new MMAX2Attribute[removedAsList.size()]);
        this.container.repaint();
        return result;
    }

    public final void rebuild() {
        Box tempbox = (Box)this.modifiablePanel.getComponent(0);
        tempbox.repaint();
        this.modifiablePanel.repaint();
        this.repaint();
    }

    public final void setApplyEnabled(boolean status) {
        this.container.setApplyEnabled(status);
    }

    public final void setUndoEnabled(boolean status) {
        this.container.setUndoEnabled(status);
    }

    public final MMAX2AttributePanelContainer getContainer() {
        return this.container;
    }
}

