/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmax4ref.gui.windows;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import pl.waw.ipipan.zil.core.mmax4ref.Messages;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.Markable;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.markables.MarkableLevel;
import pl.waw.ipipan.zil.core.mmax4ref.annotation.scheme.MMAX2Attribute;
import pl.waw.ipipan.zil.core.mmax4ref.core.MMAX2;
import pl.waw.ipipan.zil.core.mmax4ref.gui.windows.MMAX2AttributePanel;

public class MMAX2AttributePanelContainer
extends JFrame
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = -440056038886843174L;
    private MMAX2 mmax2 = null;
    private JButton applyButton = null;
    private JButton undoButton = null;
    private Markable currentMarkable = null;
    private final Box annoBox;
    private MMAX2AttributePanel attributePanel;

    public MMAX2AttributePanelContainer() {
        this.setDefaultCloseOperation(0);
        Container cp = this.getContentPane();
        Box outerBox = Box.createVerticalBox();
        this.annoBox = Box.createVerticalBox();
        Box annoButtonBox = Box.createHorizontalBox();
        this.undoButton = new JButton(Messages.getString("MMAX2AttributePanelContainer.Undo_changes"));
        this.undoButton.setActionCommand("undo");
        this.undoButton.addActionListener(this);
        this.applyButton = new JButton(Messages.getString("MMAX2AttributePanelContainer.Apply"));
        this.applyButton.setActionCommand("apply");
        this.applyButton.addActionListener(this);
        annoButtonBox.add(this.applyButton);
        annoButtonBox.add(Box.createHorizontalStrut(20));
        annoButtonBox.add(this.undoButton);
        Box outerButtonBox = Box.createVerticalBox();
        outerButtonBox.add(annoButtonBox);
        Box smallBox = Box.createHorizontalBox();
        outerButtonBox.add(Box.createHorizontalStrut(10));
        outerButtonBox.add(smallBox);
        outerBox.add(this.annoBox);
        outerBox.add(outerButtonBox);
        cp.add(outerBox);
        this.addWindowListener(this);
        this.setLocation(0, 0);
        this.setTitle(Messages.getString("MMAX2AttributePanelContainer.nothing_selected"));
    }

    public void setAttributePanel(MarkableLevel markableLevel) {
        this.setAttributePanel(markableLevel.getCurrentAnnotationScheme().getCurrentAttributePanel(), markableLevel.getMarkableLevelName(), markableLevel.getMarkableLevelLocalizedName());
    }

    public final void setAttributePanel(MMAX2AttributePanel _panel, String levelName, String localizedName) {
        JScrollPane pane = new JScrollPane(_panel, 20, 31);
        _panel.setScrollPane(pane);
        this.annoBox.removeAll();
        this.currentMarkable = null;
        this.annoBox.add(pane);
        this.attributePanel = _panel;
        _panel.setAttributePanelContainer(this);
        _panel.invalidate();
        _panel.rebuild();
        _panel.repaint();
        this.invalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command.equals("apply")) {
            this.attributePanel.keepables.clear();
            this.attributePanel.setMarkableAttributes(this.currentMarkable, true);
            this.attributePanel.displayMarkableAttributes(this.currentMarkable);
            this.attributePanel.setHasUncommittedChanges(false);
            this.attributePanel.invalidate();
            this.attributePanel.rebuild();
            this.attributePanel.repaint();
            this.invalidate();
            this.repaint();
            this.currentMarkable.getMarkableLevel().setIsDirty(true, false);
            this.currentMarkable.getMarkableLevel().getCurrentDiscourse().getMMAX2().getCurrentTextPane().startAutoRefresh();
        } else if (command.equals("undo")) {
            this.attributePanel.displayMarkableAttributes(this.currentMarkable);
            this.attributePanel.setHasUncommittedChanges(false);
            this.attributePanel.invalidate();
            this.attributePanel.rebuild();
            this.attributePanel.repaint();
            this.invalidate();
            this.repaint();
        } else {
            System.err.println("Unknown command!");
        }
    }

    public final void disableAll() {
        this.attributePanel.setEnabled(false);
        this.attributePanel.rebuild();
        this.applyButton.setEnabled(false);
        this.undoButton.setEnabled(false);
    }

    public final List<MMAX2Attribute> getAvailableAttributes(Markable clickedMarkable) {
        return this.attributePanel.getAllCurrentAttributes();
    }

    public final void displayMarkableAttributes(Markable selectedMarkable) {
        this.currentMarkable = selectedMarkable;
        this.attributePanel.displayMarkableAttributes(this.currentMarkable);
        if (this.currentMarkable == null) {
            this.setTitle(Messages.getString("MMAX2AttributePanel.nothing_selected"));
            this.disableAll();
        }
        this.validate();
    }

    public final void setUndoEnabled(boolean status) {
        this.undoButton.setEnabled(status);
    }

    public final void setApplyEnabled(boolean status) {
        this.applyButton.setEnabled(status);
    }

    public final MMAX2 getMMAX2() {
        return this.mmax2;
    }

    public final void setMMAX2(MMAX2 _mmax2) {
        this.mmax2 = _mmax2;
    }

    public final boolean isToFront() {
        return this.mmax2.getUserSettings().isAttributePanelToFront();
    }

    public final boolean isAutoApply() {
        return this.mmax2.getUserSettings().isAutoApply();
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.mmax2.requestWindowsToFront(e);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

