# -*- coding: utf-8 -*-
# generated by wxGlade 0.6.3 on Tue Sep 27 12:15:56 2011

import wx

import i18n
_ = i18n.language.ugettext

from DownloadNumberDialog import DownloadNumberDialog
from ReturnReasonDialog import ReturnReasonDialog
from SortableListCtrl import SortableListCtrl

import const
import utils

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode

# end wxGlade

class MainFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: MainFrame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.window_1 = wx.SplitterWindow(self, -1, style=wx.SP_3D|wx.SP_BORDER)
        self.window_1_pane_2 = wx.Panel(self.window_1, -1)
        self.window_1_pane_1 = wx.Panel(self.window_1, -1)
        self.notebook_1 = wx.Notebook(self.window_1_pane_1, -1, style=wx.BK_DEFAULT)        
        self.notebook_1_pane_1 = wx.Panel(self.notebook_1, -1)
        self.notebook_1_pane_2 = wx.Panel(self.notebook_1, -1)        

        self.log_ctrl = wx.TextCtrl(self.window_1_pane_2, -1, "", style=wx.TE_MULTILINE|wx.TE_READONLY)

        self.files_list = SortableListCtrl(self.notebook_1_pane_1, self.log_ctrl, False, const.program, const.extension)
        self.super_files_list = SortableListCtrl(self.notebook_1_pane_2, self.log_ctrl, True, const.program, const.extension)
        
        # Menu Bar
        self.frame_1_menubar = wx.MenuBar()
        self.dir_menu = wx.Menu()
        self.dir_menu_open = wx.MenuItem(self.dir_menu, 5, _("Open"), _("Open new directory"), wx.ITEM_NORMAL)
        self.dir_menu.AppendItem(self.dir_menu_open)
        self.dir_menu.Append(6, _("Reconfigure"), _("Reconfigure directory"), wx.ITEM_NORMAL)
        self.dir_menu.AppendSeparator()
        if not const.hide_dir_menu == "yes":
            self.frame_1_menubar.Append(self.dir_menu, _("Directory"))
        wxglade_tmp_menu = wx.Menu()
        wxglade_tmp_menu.Append(1, _("Upload Selected"), _("Upload annotated or adjudicated files"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.Append(8, _("Checkin Selected"), _("Upload annotated or adjudicated; files will be deleted from local disk and you will not be able to modify them again"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.Append(10, _("Return Selected"), _("Return annotated or adjudicated because they are not suitable for annotation or contain errors"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(2, _("Download (annotation)"), _("Download files for annotation"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.Append(3, _("Download (adjudication)"), _("Download files for adjudication"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(7, _("Checkout"), _("Checkout files from server to your local, empty directory"), wx.ITEM_NORMAL)
        
        self.frame_1_menubar.Append(wxglade_tmp_menu, _("Files"))
        wxglade_tmp_menu = wx.Menu()
        wxglade_tmp_menu.Append(4, _("Ready"), _("Select items which are marked for upload"), wx.ITEM_NORMAL)
        wxglade_tmp_menu.Append(9, _("Modified"), _("Select items which are modified"), wx.ITEM_NORMAL)
        self.frame_1_menubar.Append(wxglade_tmp_menu, _("Select"))
                
        wxglade_tmp_menu = wx.Menu()
        wxglade_tmp_menu.Append(11, _("Finished count"), _("Check number of finished texts"), wx.ITEM_NORMAL)
        self.frame_1_menubar.Append(wxglade_tmp_menu, _("Annotation"))
        
        self.SetMenuBar(self.frame_1_menubar)
        # Menu Bar end
        
        self.CreateStatusBar()                        

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_MENU, self.open_directory, self.dir_menu_open)
        self.Bind(wx.EVT_MENU, self.reconf_directory, id=6)
        self.Bind(wx.EVT_MENU, self.upload, id=1)
        self.Bind(wx.EVT_MENU, self.checkin, id=8)
        self.Bind(wx.EVT_MENU, self.download, id=2)
        self.Bind(wx.EVT_MENU, self.download_prim, id=3)
        self.Bind(wx.EVT_MENU, self.checkout, id=7)
        self.Bind(wx.EVT_MENU, self.select_ready, id=4)
        self.Bind(wx.EVT_MENU, self.select_modified, id=9)
        self.Bind(wx.EVT_MENU, self.return_files, id=10)
        self.Bind(wx.EVT_MENU, self.check_stats, id=11)
        
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.activate_item, self.files_list)        
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.activate_super_item, self.super_files_list)

    def __set_properties(self):
        # begin wxGlade: MainFrame.__set_properties
        self.SetTitle("--")
        self.SetSize((663, 556))
        self.SetFocus()
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: MainFrame.__do_layout
        sizer_6 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_7 = wx.BoxSizer(wx.VERTICAL)
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_3 = wx.BoxSizer(wx.VERTICAL)
        sizer_2 = wx.BoxSizer(wx.VERTICAL)
        sizer_2.Add(self.files_list, 1, wx.EXPAND, 0)
        self.notebook_1_pane_1.SetSizer(sizer_2)
        sizer_3.Add(self.super_files_list, 1, wx.EXPAND, 0)
        self.notebook_1_pane_2.SetSizer(sizer_3)
        self.notebook_1.AddPage(self.notebook_1_pane_1, _("Annotation"))
        self.notebook_1.AddPage(self.notebook_1_pane_2, _("Adjudication"))
        sizer_1.Add(self.notebook_1, 1, wx.EXPAND, 0)
        self.window_1_pane_1.SetSizer(sizer_1)
        sizer_7.Add(self.log_ctrl, 1, wx.EXPAND, 0)
        self.window_1_pane_2.SetSizer(sizer_7)
        self.window_1.SplitHorizontally(self.window_1_pane_1, self.window_1_pane_2, -100)
        sizer_6.Add(self.window_1, 1, wx.EXPAND, 0)
        self.SetSizer(sizer_6)
        self.Layout()
        self.Centre()
        # end wxGlade

    def set_manager(self, manager):
        self.manager = manager

    def open_directory(self, event): # wxGlade: MainFrame.<event_handler>
        if event.GetId() == self.dir_menu_open.GetId():
            dlg = wx.DirDialog(self, message=_("Choose a directory"))
            try:
                if dlg.ShowModal() == wx.ID_OK:
                    self.manager.set_directory(dlg.GetPath())
            finally:
                dlg.Destroy()
        else:
            item = self.dir_menu.FindItemById(event.GetId())
            self.manager.set_directory(item.GetLabel())

    def upload(self, event): # wxGlade: MainFrame.<event_handler>
        names = ( self.files_list.get_selected()
                + self.super_files_list.get_selected() )
        info = ( _("Do you want to upload the following files?")+"\n\n"
               + "\n".join(names) )
        dial = wx.MessageDialog( self, info, _('Question')
                               , wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION )
        try:
            if dial.ShowModal() == wx.ID_YES:
                self.manager.upload(names, checkin=False)
        finally:
            dial.Destroy()
            
    def return_files(self, event): # wxGlade: MainFrame.<event_handler>
        names = ( self.files_list.get_selected()
                + self.super_files_list.get_selected() )
        reason = None
        dialog = ReturnReasonDialog(self, names)
        try:
            if dialog.ShowModal() == wx.ID_OK:
                reason = dialog.reason.GetValue().encode("utf-8")
        finally:
            dialog.Destroy()
        if reason is not None:
            self.manager.return_files(names, reason)       

    def download(self, event): # wxGlade: MainFrame.<event_handler>
        num = None
        dialog = DownloadNumberDialog(self, -1)
        try:
            if dialog.ShowModal() == wx.ID_OK:
                num = dialog.checkout_number.GetValue()
        finally:
            dialog.Destroy()
        if num is not None:
            self.manager.download(num)

    def download_prim(self, event): # wxGlade: MainFrame.<event_handler>
        num = None
        dialog = DownloadNumberDialog(self, -1)
        try:
            if dialog.ShowModal() == wx.ID_OK:
                num = dialog.checkout_number.GetValue()
        finally:
            dialog.Destroy()
        if num is not None:
            self.manager.download_prim(num)

    def activate_item(self, event): # wxGlade: MainFrame.<event_handler>
        utils.change_ready( self.manager.ready
                          , self.files_list
                          , event.GetIndex() )

    def activate_super_item(self, event): # wxGlade: MainFrame.<event_handler>
        utils.change_ready_prim( self.manager.ready
                               , self.super_files_list
                               , event.GetIndex() )

    def reconf_directory(self, event): # wxGlade: MainFrame.<event_handler>
        self.manager.reconf_directory()

    def select_ready(self, event): # wxGlade: MainFrame.<event_handler>
        self.files_list.select_ready()
        self.super_files_list.select_ready()

    def checkout(self, event): # wxGlade: MainFrame.<event_handler>
        self.manager.checkout()

    def checkin(self, event): # wxGlade: MainFrame.<event_handler>
        names = ( self.files_list.get_selected()
                + self.super_files_list.get_selected() )
        info = ( _("Do you want to checkin the following files?")+"\n\n"
               + "\n".join(names) 
               + "\n\n"+_("Files will be deleted from the local directory and you will not be able to read, write or modify them later."))
        dial = wx.MessageDialog( self, info, _('Question')
                               , wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION )
        try:
            if dial.ShowModal() == wx.ID_YES:
                self.manager.upload(names, checkin=True)
        finally:
            dial.Destroy()

    def select_modified(self, event): # wxGlade: MainFrame.<event_handler>
        self.files_list.select_modified()
        self.super_files_list.select_modified()
            
    def check_stats(self, event): # wxGlade: MainFrame.<event_handler>        
        self.manager.check_stats()            
        
# end of class MainFrame
