# -*- coding: utf-8 -*-
import os

from dfs.config import Config

# Global configuration file
global_config_name = "data/global.cfg"
_cfg = Config(global_config_name)

# File with list of directories
dir_cache_name = _cfg["general.dir_cache"]

# File with directory configuration
config_name = _cfg["general.config"]
# File with file names marked as ready
ready_name = _cfg["general.ready"]
# File with files footprints
footprints_name = _cfg["general.footprints"]
# Default file extensions
default_exts = _cfg["general.default_exts"].split()
# Language (pl or en)
lang = _cfg["general.lang"]
# option to hide dir menu if precofigured
hide_dir_menu = _cfg["general.hide_dir_menu"]

program = _cfg["general.program"]

extension = _cfg["general.extension"]

conn_host = _cfg["connection.host"]
conn_port = int(_cfg["connection.port"])
conn_cert = _cfg["connection.cert"]

# Path to directory-specific configuration files 
def path(p, name):
    return os.path.join(p, name)
