# -*- coding: utf-8 -*-
"""Directory cache manipulation"""

import os

class DirCache:

    def __init__(self, path, size):
        if not os.path.exists(path):
            with open(path, "w") as f: pass
        self.path = path
        self.size = size

    def add(self, dir_name):
        cache = self.get()
        if dir_name in cache:
            cache.remove(dir_name)
        cache.insert(0, dir_name)
        self.write(cache[:self.size])

    def get(self):
        with open(self.path) as f:
            return [x.strip() for x in f.readlines()]

    def write(self, cache):
        with open(self.path, "w") as f:
            for entry in cache:
                print >> f, entry
