# -*- coding: utf-8 -*-
import os, sys
import locale
import gettext
import const

def get_path():
    '''Get the path to this script no matter how it's run.'''
    #Determine if the application is a py/pyw or a frozen exe.
    if hasattr(sys, 'frozen'):
        # If run from exe
        dir_path = os.path.dirname(sys.executable)
    elif '__file__' in locals():
        # If run from py
        dir_path = os.path.dirname(__file__)
    else:
        # If run from command line
        dir_path = sys.path[0]
    return dir_path

       
# Change this variable to your app name!
#  The translation files will be under 
#  @LOCALE_DIR@/@LANGUAGE@/LC_MESSAGES/@APP_NAME@.mo
#
APP_NAME = "manager"
# This is ok for maemo. Not sure in a regular desktop:
APP_DIR = get_path()
LOCALE_DIR = os.path.join(APP_DIR, 'po')

langs = ["pl"]
if (const.lang == "en"):
    langs = ["en"]
    
# Lets tell those details to gettext
gettext.install (True)
gettext.bindtextdomain (APP_NAME,
                        LOCALE_DIR)
gettext.textdomain (APP_NAME)
language = gettext.translation (APP_NAME,
                                LOCALE_DIR,
                                languages = langs,
                                fallback = False)

    