#!/usr/bin/env python
# -*- coding: utf-8 -*-
# generated by wxGlade 0.6.3 on Tue Sep 27 12:15:56 2011

import os
import wx

import i18n
_ = i18n.language.ugettext #use ugettext instead of getttext to avoid unicode errors

from dfs.config import Config
from client import run_upload, run_download, run_download_prim, run_checkout, run_return, run_check_stats

from MainFrame import MainFrame
import utils
import const
from ready import Ready
from dir_cache import DirCache
from log_thread import LogThread
from footprints import FootPrints

class FileManager(wx.App):

    def OnInit(self):
        wx.InitAllImageHandlers()
        self.main_frame = MainFrame(None, -1, "")
        self.SetTopWindow(self.main_frame)
        self.main_frame.Show()

        # Custom code
        self.main_frame.set_manager(self)        

        self.curr_dir = None
        self.config = None
        self.selection = None
        self.connected = False
        self.dir_cache = DirCache(const.dir_cache_name, size=5)
        self.refresh_thread = utils.RefreshThread(self, delay=2)
        self.refresh_thread.start()

        utils.fill_dir_menu(self.main_frame, self.dir_cache.get())
        # End custom code
        
        return 1

    def reconf_directory(self):
        if not self.curr_dir:
            return
        config_path = const.path(self.curr_dir, const.config_name)
        if utils.create_dir_config( config_path, self.main_frame
                                  , config=self.config ):
            self.config = Config(config_path)
            self.refresh()

    def set_directory(self, path):
        config_path = const.path(path, const.config_name)
        if not os.path.exists(config_path):
            if not utils.create_dir_config(config_path, self.main_frame):
                return
        self.config = Config(config_path)
        self.ready = Ready(const.path(path, const.ready_name))
        self.curr_dir = path
        self.dir_cache.add(path)
        self.main_frame.SetTitle(path)
        self.refresh()

    def begin_conn(self):
        if not self.curr_dir:
            wx.MessageBox(_('Directory not set'), _('Info'))
            return False
        if self.connected:
            wx.MessageBox(_('Another operation running'), _('Info'))
            return False
        self.connected = True
        return True

    def end_conn(self, op_result):
        self.connected = False

    def upload(self, files, checkin=False):
        if not self.begin_conn():
            return

        def on_end(result):
            self.end_conn(result)
            if checkin:
                return
            if result == True:
                prints = self.footprints()
                for file_name in files:
                    prints.renew(file_name)
                prints.save()

        logger = LogThread( text_ctrl=self.main_frame.log_ctrl
                          , target=run_upload
                          , args=( self.config["login"]
                                 , self.config["passwd"]
                                 , const.conn_host
                                 , const.conn_port
                                 , const.conn_cert
                                 , files
                                 , self.curr_dir
                                 , self.config["extensions"].split()
                                 , checkin )
                          , on_end=on_end )
        logger.start()

    def download(self, n):
        if not self.begin_conn():
            return
        logger = LogThread( text_ctrl=self.main_frame.log_ctrl
                          , target=run_download
                          , args=( self.config["login"]
                                 , self.config["passwd"]
                                 , const.conn_host
                                 , const.conn_port
                                 , const.conn_cert
                                 , n
                                 , self.curr_dir )
                          , on_end=self.end_conn )
        logger.start()

    def download_prim(self, n):
        if not self.begin_conn():
            return
        logger = LogThread( text_ctrl=self.main_frame.log_ctrl
                          , target=run_download_prim
                          , args=( self.config["login"]
                                 , self.config["passwd"]
                                 , const.conn_host
                                 , const.conn_port
                                 , const.conn_cert
                                 , n
                                 , self.curr_dir )
                          , on_end=self.end_conn )
        logger.start()

    def checkout(self):
        if not self.begin_conn():
            return
        
        def on_end(result):
            self.end_conn(result)
            if result == True:
                prints = self.footprints()
                files_before = prints.prints.keys()                
                prints.renew_all()
                prints.save()
                
                
        logger = LogThread( text_ctrl=self.main_frame.log_ctrl
                          , target=run_checkout
                          , args=( self.config["login"]
                                 , self.config["passwd"]
                                 , const.conn_host
                                 , const.conn_port
                                 , const.conn_cert
                                 , self.curr_dir
                                 , self.config["extensions"].split() )
                          , on_end=on_end )
        logger.start()
        
    def return_files(self, files, reason):
        if not self.begin_conn():
            return

        def on_end(result):
            self.end_conn(result)
            
        logger = LogThread( text_ctrl=self.main_frame.log_ctrl
                          , target=run_return
                          , args=( self.config["login"]
                                 , self.config["passwd"]
                                 , const.conn_host
                                 , const.conn_port
                                 , const.conn_cert
                                 , files
                                 , reason
                                 , self.curr_dir
                                 , self.config["extensions"].split()
                                 )
                          , on_end=on_end )
        logger.start()
        
    def footprints(self):
        return FootPrints( const.path(self.curr_dir, const.footprints_name)
                         , self.curr_dir
                         , self.config["extensions"].split() )

    def refresh(self):
        if self.curr_dir is None:
            return

        ready = self.ready.get_entries()
        extensions = self.config["extensions"].split()

        footprints = self.footprints()
        footprints.refresh()

        data = utils.normal_entries(
                self.curr_dir,
                extensions,
                ready,
                footprints)
                        
    	shown = self.main_frame.files_list.shown_data()
        
    	if utils.differ(data, shown):
    	    print "Data changed !"
    	    self.main_frame.files_list.show(data)
            footprints.save()
            
        data = utils.super_entries(
                 self.curr_dir,
                 extensions,
                 ready,
                 footprints)
            
    	shown = self.main_frame.super_files_list.shown_data()
        
    	if utils.differ(data, shown):
    	    print "Data changed !"
    	    self.main_frame.super_files_list.show(data)
    
        footprints.save()

    def check_stats(self):
        if not self.begin_conn():
            return

        def on_end(result):
            self.end_conn(result)

        logger = LogThread( text_ctrl=self.main_frame.log_ctrl
                          , target=run_check_stats
                          , args=( self.config["login"]
                                 , self.config["passwd"]
                                 , const.conn_host
                                 , const.conn_port
                                 , const.conn_cert )
                          , on_end=on_end )
        logger.start()
        
# end of class FileManager

if __name__ == "__main__":
    manager = FileManager(0)
    manager.MainLoop()
    manager.refresh_thread.exitFlag = True
