# -*- coding: utf-8 -*-
import os

class Ready:
    
    """Class for ready file manipulation."""

    def __init__(self, ready_path):
        if not os.path.exists(ready_path):
            with open(ready_path, "w") as f: pass
        self.ready_path = ready_path

    def _check_file(self, file_name, is_ready):
        entries = self.get_entries()
        if is_ready == True:
            entries.append(file_name)
        else:
            entries.remove(file_name)
        self.write_entries(entries)

    def remove_file(self, file_name):
        self._check_file(file_name, False)

    def save_file(self, file_name):
        self._check_file(file_name, True)

#    def remove_super_file(self, file_name):
#        self._check_file(file_name, False, type="s_checkin")
#
#    def save_super_file(self, file_name):
#        self._check_file(file_name, True, type="s_checkin")

    def get_entries(self):
        result = []
        with open(self.ready_path) as inp:
            result = [x.strip() for x in inp.readlines()]
        return result

    def write_entries(self, entries):
        with open(self.ready_path, "w") as out:
            for entry in entries:
                print >> out, entry
