# -*- coding: utf-8 -*-
import os
import re
import wx
import threading
import time

import i18n
_ = i18n.language.ugettext #use ugettext instead of getttext to avoid unicode errors 

import  wx.lib.mixins.listctrl  as  listmix

from ConfigDialog import ConfigDialog
import const

def match_ext(name, exts):
    return any(name.endswith(ext) for ext in exts)

def cut_ext(name, exts):
    return re.sub("(%s)$" % "|".join(exts), "", name)

def normal_files(work_dir, exts):
    names = set(cut_ext(name, exts)
                for name in os.listdir(work_dir)
                if match_ext(name, exts))
    return sorted(names)

def super_files(work_dir, exts):
    names = []
    for name in os.listdir(work_dir):
        path = os.path.join(work_dir, name)
        if os.path.isdir(path):
            local = set(cut_ext(name, exts)
                        for name in os.listdir(path)
                        if match_ext(name, exts))
            names.extend(os.path.join(name, tail) for tail in local)
    return sorted(names)

def all_files(work_dir, exts):
    return normal_files(work_dir, exts) + super_files(work_dir, exts)

def get_entries(get_names, work_dir, exts, ready, footprints):
    names = get_names(work_dir, exts)
    result = []
    for file_name in names:
        status = _("Modified") if footprints.modified(file_name) else "--"
        is_ready = _("Yes") if file_name in ready else _("No")
        stage = "--"
        result.append((file_name, status, is_ready, stage))
    return result

def normal_entries(work_dir, exts, ready, footprints):
    return get_entries(normal_files, work_dir, exts, ready, footprints)

def super_entries(work_dir, exts, ready, footprints):
    return get_entries(super_files, work_dir, exts, ready, footprints)
    
def differ(data1, data2):
    if len(data1) != len(data2):
        return True
    d1={}
    for i in range(len(data1)):
        d1[data1[i][0]]=data1[i][1:]
    for i in range(len(data2)):
        if not d1.has_key(data2[i][0]):
            return True        
        if d1[data2[i][0]] != data2[i][1:]:
            return True
    return False

def change_ready(ready, file_list, pos):
    file_name = file_list.GetFilename(pos)
    if file_list.IsReady(pos):
        file_list.SetReadyNo(pos)        
        ready.remove_file(file_name)
    else:
        file_list.SetReadyYes(pos)        
        ready.save_file(file_name)        
            
def change_ready_prim(ready, super_file_list, pos):
    def set_no(dirname):
        for i in range(super_file_list.GetItemCount()):
            other_name = super_file_list.GetFilename(i)
            if os.path.dirname(other_name) == dirname:
                super_file_list.SetReadyNo(i)
                if other_name in ready.get_entries():
                    ready.remove_file(other_name)

    file_name = super_file_list.GetFilename(pos)
    if super_file_list.IsReady(pos):
        super_file_list.SetReadyNo(pos)
        ready.remove_file(file_name)
    else:
        set_no(os.path.dirname(file_name))
        super_file_list.SetReadyYes(pos)
        ready.save_file(file_name)

def create_dir_config(path, parent, config=None):
    dialog = ConfigDialog(parent, -1)
    if config:
        dialog.login_ctrl.SetValue(config["login"])
        dialog.passwd_ctrl.SetValue(config["passwd"])
        dialog.exts_ctrl.SetValue(config["extensions"])
    else:
        dialog.exts_ctrl.SetValue(" ".join(const.default_exts))
    try:
        if dialog.ShowModal() == wx.ID_OK:
            login = dialog.login_ctrl.GetValue()
            password = dialog.passwd_ctrl.GetValue()
            file_exts = dialog.exts_ctrl.GetValue()
            with open(path, "w") as conf:
                print >> conf, "login =", login
                print >> conf, "passwd =", password
                print >> conf, "extensions =", file_exts
            return True
    finally:
        dialog.Destroy()
    return False

def fill_dir_menu(main_frame, cache):
    dir_menu = main_frame.dir_menu
    last_dir_set=False
    for entry in cache:
        if not os.path.isdir(entry):
            continue
        wx_id = wx.NewId()
        dir_menu.Append(wx_id, entry, kind=wx.ITEM_NORMAL)
        main_frame.Bind(wx.EVT_MENU, main_frame.open_directory, id=wx_id)
        if not last_dir_set:
            cmd = wx.CommandEvent(wx.EVT_MENU.evtType[0])            
            cmd.SetEventObject(main_frame)
            cmd.SetId(wx_id)
            main_frame.GetEventHandler().ProcessEvent(cmd)            
            last_dir_set = True

# Watek odswieza informacje o zawartosci pliku to-checkin.txt
# (moze sie zmienic za posrednictwem TrEda lub wyedytowany recznie).
class RefreshThread (threading.Thread):
    def __init__(self, manager, delay=2):
        self.exitFlag = False
        self.delay = delay
        self.manager = manager
        threading.Thread.__init__(self)

    def run(self):
        while self.exitFlag != True:
            wx.CallAfter(self.manager.refresh)
            time.sleep(self.delay)

#        self.mtime = None   # message file 'modified time'
#        while self.exitFlag != True:
#            new_mtime = os.stat(self.ready_path).st_mtime
#            if new_mtime != self.mtime:
#                wx.CallAfter(self.manager.refresh)
#                self.mtime = new_mtime
#            time.sleep(self.delay)

