/*
 * Decompiled with CFR 0.152.
 */
package evaluation;

import corpusapi.tei.TEISense;
import corpusapi.tei.TEISenseEntry;
import corpusapi.tei.TEISenseInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import utils.Counter;

public class AnnotationStats
extends HashMap<String, Counter> {
    private static final long serialVersionUID = 2462719502167974479L;
    public Map<String, String> senseIdToOrth = new HashMap<String, String>();
    public Map<String, String> senseIdToPos = new HashMap<String, String>();

    public AnnotationStats(TEISenseInventory dict) {
        for (Map.Entry entry : dict.getSenseEntries().entrySet()) {
            Counter c = this.getCounterForLexeme((String)entry.getKey());
            for (TEISense subs : ((TEISenseEntry)entry.getValue()).getSenseList()) {
                c.put(subs.getId(), 0);
            }
        }
    }

    public int getAllCount() {
        return this.getAllCount(null);
    }

    public int getAllCount(String pos) {
        int result = 0;
        for (String s : this.getLexemeSet(pos)) {
            result += this.getCountForLexeme(s);
        }
        return result;
    }

    public int getCountForLexeme(String lexeme) {
        int result = 0;
        Counter c = (Counter)this.get(lexeme);
        if (c != null) {
            Iterator iterator = c.values().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                result += i;
            }
        }
        return result;
    }

    private Counter getCounterForLexeme(String lexeme) {
        Counter c = (Counter)this.get(lexeme);
        if (c == null) {
            c = new Counter();
            this.put(lexeme, c);
        }
        return c;
    }

    public void addAnnotation(String lexeme, String senseId) {
        if (!lexeme.equalsIgnoreCase("NULL")) {
            Counter c = this.getCounterForLexeme(lexeme);
            c.increase(senseId);
        }
    }

    public Set<String> getLexemeSet() {
        return this.keySet();
    }

    public Set<String> getLexemeSet(String pos) {
        if (pos == null) {
            return this.getLexemeSet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : this.keySet()) {
            if (!this.senseIdToPos.get(s).equals(pos)) continue;
            result.add(s);
        }
        return result;
    }

    public List<String> getSubsensesList(final String lexeme) {
        ArrayList<String> result = new ArrayList<String>(this.getCounterForLexeme(lexeme).keySet());
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return Integer.valueOf(AnnotationStats.this.getCountForSubsense(lexeme, arg1)).compareTo(AnnotationStats.this.getCountForSubsense(lexeme, arg0));
            }
        });
        return result;
    }

    public double getSenseWeight(String lexeme, String subsenseId) {
        int all = this.getCountForLexeme(lexeme);
        int subsenseCount = this.getCountForSubsense(lexeme, subsenseId);
        if (subsenseCount == 0) {
            return 0.0;
        }
        return Math.log(1.0 * (double)all / (double)subsenseCount) + 1.0;
    }

    public int getCountForSubsense(String lexeme, String subsenseId) {
        Counter c = this.getCounterForLexeme(lexeme);
        Integer i = (Integer)c.get(subsenseId);
        if (i != null) {
            return i;
        }
        return 0;
    }

    public double getMfsForLexeme(String lexeme) {
        int max = 0;
        for (String subsenseId : this.getSubsensesList(lexeme)) {
            int count = this.getCountForSubsense(lexeme, subsenseId);
            if (count <= max) continue;
            max = count;
        }
        return 1.0 * (double)max / (double)this.getCountForLexeme(lexeme);
    }

    public List<Map.Entry<String, Double>> getSortedMfs() {
        return this.getSortedMfs(null);
    }

    public List<Map.Entry<String, Double>> getSortedMfs(String pos) {
        HashMap<String, Double> mfs = new HashMap<String, Double>();
        for (String key : this.getLexemeSet(pos)) {
            mfs.put(key, this.getMfsForLexeme(key));
        }
        ArrayList<Map.Entry<String, Double>> sorted = new ArrayList<Map.Entry<String, Double>>(mfs.entrySet());
        Collections.sort(sorted, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        return sorted;
    }

    public Double getTotalRandomAccuracy(String pos) {
        int totalCorrect = 0;
        int totalAll = 0;
        for (String lexeme : this.getLexemeSet(pos)) {
            totalCorrect += this.getCountForLexeme(lexeme) / this.getSubsensesList(lexeme).size();
            totalAll += this.getCountForLexeme(lexeme);
        }
        return 1.0 * (double)totalCorrect / (double)totalAll;
    }

    public Double getTotalMFSAccuracy(String pos) {
        int totalCorrect = 0;
        int totalAll = 0;
        for (String lexeme : this.getLexemeSet(pos)) {
            int mfs = 0;
            int all = 0;
            for (String sub : this.getSubsensesList(lexeme)) {
                int c = this.getCountForSubsense(lexeme, sub);
                if (c > mfs) {
                    mfs = c;
                }
                all += c;
            }
            totalCorrect += mfs;
            totalAll += all;
        }
        return 1.0 * (double)totalCorrect / (double)totalAll;
    }
}

