/*
 * Decompiled with CFR 0.152.
 */
package evaluation;

import corpusapi.ContinueMode;
import corpusapi.Corpus;
import corpusapi.CorpusText;
import corpusapi.SenseSegmentGroup;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEISenseInventory;
import corpusapi.tei.TEISenseSegmentGroup;
import evaluation.AnnotationReader;
import evaluation.AnnotationStats;
import evaluation.SingleMethodEvaluation;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import utils.Utils;

public class Evaluator {
    public Collection<SingleMethodEvaluation> evaluate(Corpus corpus, AnnotationReader annotationReader, TEISenseInventory dict) {
        System.out.println("Evaluating given annotation on given corpus...");
        int segmentsUnknownInOracle = 0;
        int segmentsAll = 0;
        int textsWithoutErrors = 0;
        int textsWithErrors = 0;
        HashMap<String, SingleMethodEvaluation> allMethods = new HashMap<String, SingleMethodEvaluation>();
        for (String methodName : annotationReader.getAnnotatorsNames()) {
            allMethods.put(methodName, new SingleMethodEvaluation(methodName, dict));
        }
        for (String corpusTextId : corpus.getCorpusTextIds()) {
            TEICorpusText corpusText = (TEICorpusText)corpus.getCorpusText(corpusTextId);
            try {
                try {
                    annotationReader.setCurrentCorpusText((CorpusText)corpusText);
                    AnnotationReader.SegmentAnnotation singleSegmentAnnotations = null;
                    HashMap<String, String> goldStandardAnnotations = new HashMap<String, String>();
                    TEISenseSegmentGroup currentSsg = (TEISenseSegmentGroup)corpusText.getFirstSegmentGroup(SenseSegmentGroup.class);
                    while (currentSsg != null) {
                        goldStandardAnnotations.put((String)currentSsg.getSegmentIds().get(0), currentSsg.getSenseId());
                        currentSsg = currentSsg.getNext(ContinueMode.ALWAYS_CONTINUE);
                    }
                    while ((singleSegmentAnnotations = annotationReader.getNextTaggedSegment()) != null) {
                        String segmentId = singleSegmentAnnotations.segmentId;
                        String lexeme = singleSegmentAnnotations.lexeme;
                        String correctSenseId = (String)goldStandardAnnotations.get(segmentId);
                        if (correctSenseId == null) {
                            ++segmentsUnknownInOracle;
                            continue;
                        }
                        ++segmentsAll;
                        for (Map.Entry<String, String> annotation : singleSegmentAnnotations.annotations.entrySet()) {
                            String methodId = annotation.getKey();
                            String predictedSenseId = annotation.getValue();
                            SingleMethodEvaluation methodEvaluation = (SingleMethodEvaluation)allMethods.get(methodId);
                            String subsenseId = correctSenseId.split("#")[1];
                            if (predictedSenseId.equals("")) {
                                ++methodEvaluation.segmentsTaggedAsUnknown;
                                continue;
                            }
                            if (predictedSenseId.equals(correctSenseId)) {
                                methodEvaluation.addCorrectAnnotation(lexeme, subsenseId);
                                continue;
                            }
                            methodEvaluation.addIncorrectAnnotation(lexeme, subsenseId);
                        }
                    }
                    ++textsWithoutErrors;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(String.valueOf(corpusText.getPath()) + " Skipping text because of: " + e.getMessage().replaceAll("\\n", " "));
                    ++textsWithErrors;
                    corpusText.closeCorpusText();
                    continue;
                }
            }
            catch (Throwable throwable) {
                corpusText.closeCorpusText();
                throw throwable;
            }
            corpusText.closeCorpusText();
        }
        System.out.println();
        System.out.println("Texts - all          : " + (textsWithErrors + textsWithoutErrors));
        System.out.println("Texts without errors : " + textsWithoutErrors);
        System.out.println("Texts with errors    : " + textsWithErrors);
        System.out.println();
        System.out.println("Segments - all (known in oracle) : " + segmentsAll);
        System.out.println("Segments - unknown in oracle     : " + segmentsUnknownInOracle);
        System.out.println();
        return allMethods.values();
    }

    private List<SingleMethodEvaluation> getSortedEvaluations(Collection<SingleMethodEvaluation> evals, Sorting sortingType, final AnnotationStats goldenStandard) {
        ArrayList<SingleMethodEvaluation> sorted = new ArrayList<SingleMethodEvaluation>(evals);
        Comparator<SingleMethodEvaluation> comp = null;
        if (Sorting.MFS_IMPROVEMENT.equals((Object)sortingType)) {
            comp = new Comparator<SingleMethodEvaluation>(){

                @Override
                public int compare(SingleMethodEvaluation o1, SingleMethodEvaluation o2) {
                    return Integer.valueOf(o2.getNumberOfImprovements(null, goldenStandard)).compareTo(o1.getNumberOfImprovements(null, goldenStandard));
                }
            };
        } else if (Sorting.ACCURACY.equals((Object)sortingType)) {
            comp = new Comparator<SingleMethodEvaluation>(){

                @Override
                public int compare(SingleMethodEvaluation o1, SingleMethodEvaluation o2) {
                    return o2.getTotalAccuracy().compareTo(o1.getTotalAccuracy());
                }
            };
        } else if (Sorting.RARE.equals((Object)sortingType)) {
            comp = new Comparator<SingleMethodEvaluation>(){

                @Override
                public int compare(SingleMethodEvaluation o1, SingleMethodEvaluation o2) {
                    return Double.valueOf(o2.getWeightedRank(null, goldenStandard)).compareTo(o1.getWeightedRank(null, goldenStandard));
                }
            };
        } else {
            return sorted;
        }
        Collections.sort(sorted, comp);
        return sorted;
    }

    public void printEvaluationResults(BufferedWriter bw, Collection<SingleMethodEvaluation> smes, AnnotationStats goldenStandard) throws IOException {
        String separator = ",";
        for (SingleMethodEvaluation result : smes) {
            String[] splitted = result.getMethodId().split(":");
            if (splitted[0].equals("lesk")) {
                String[] stringArray = splitted;
                int n = splitted.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    bw.append(String.valueOf(s) + separator);
                    ++n2;
                }
            } else {
                bw.append(String.valueOf(splitted[0]) + separator);
                int i = 0;
                while (i < 12) {
                    bw.append(separator);
                    ++i;
                }
            }
            bw.append("" + Utils.round(result.getTotalAccuracy(null, goldenStandard)));
            bw.append(String.valueOf(separator) + result.getNumberOfImprovements(null, goldenStandard));
            bw.append(String.valueOf(separator) + Utils.round(result.getWeightedRank(null, goldenStandard)));
            bw.append("\n");
        }
    }

    public void printEvaluationResultsOnLexemes(Writer w, Collection<SingleMethodEvaluation> results, AnnotationStats goldenStandard) throws IOException {
        List<Map.Entry<String, Double>> sorted = goldenStandard.getSortedMfs();
        String separator = ",";
        for (Map.Entry<String, Double> key : sorted) {
            double baseAcc = key.getValue();
            double randomAcc = 1.0 / (double)goldenStandard.getSubsensesList(key.getKey()).size();
            String lemma = key.getKey();
            ArrayList<String> line = new ArrayList<String>();
            line.add(goldenStandard.senseIdToOrth.get(lemma));
            line.add(Integer.toString(goldenStandard.getCountForLexeme(lemma)));
            ArrayList<String> subline = new ArrayList<String>();
            for (String subsense : goldenStandard.getSubsensesList(lemma)) {
                subline.add(Integer.toString(goldenStandard.getCountForSubsense(lemma, subsense)));
            }
            line.add(Utils.join(subline, "/"));
            line.add(Double.toString(Utils.round(baseAcc)));
            line.add(Double.toString(Utils.round(randomAcc)));
            int nr = 0;
            for (SingleMethodEvaluation result : results) {
                ++nr;
                double acc = result.getLexemeAccuracy(lemma);
                line.add(Double.toString(Utils.round(acc)));
            }
            w.append(String.valueOf(Utils.join(line, separator)) + "\n");
        }
    }

    public Collection<SingleMethodEvaluation> selectBestMethods(Collection<SingleMethodEvaluation> results, Sorting sortingType, Integer howMany, AnnotationStats goldenStandard) {
        List<SingleMethodEvaluation> smes = this.getSortedEvaluations(results, sortingType, goldenStandard);
        if (howMany != null) {
            return new ArrayList<SingleMethodEvaluation>(smes.subList(0, howMany > smes.size() ? smes.size() : howMany.intValue()));
        }
        return new ArrayList<SingleMethodEvaluation>(smes);
    }

    public static enum Sorting {
        MFS_IMPROVEMENT,
        RARE,
        ACCURACY;

    }
}

