/*
 * Decompiled with CFR 0.152.
 */
package resources;

import corpusapi.ContinueMode;
import corpusapi.tei.TEICorpus;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEIMorphoSegmentGroup;
import corpusapi.tei.TEISegment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import utils.CorpusManager;
import utils.Counter;

public class FrequencyCounter {
    private Map<String, Double> idfs = new HashMap<String, Double>();
    private Map<String, Double> ilfs = new HashMap<String, Double>();
    private int documentCount = 0;
    private Counter counts = new Counter();
    private Counter documentCounts = new Counter();

    public FrequencyCounter(String frequencyCounterPath) {
        this.loadFromFile(frequencyCounterPath);
    }

    public FrequencyCounter(TEICorpus corpus) {
        this.loadFromCorpus(corpus);
    }

    private void loadFromFile(String path) {
        this.getCountsFromFile(path);
        this.calculateMeasures();
    }

    private void loadFromCorpus(TEICorpus corpus) {
        this.getCountsFromCorpus(corpus);
        this.calculateMeasures();
    }

    private void saveIntoFile(String path) {
        ArrayList l = new ArrayList(this.counts.entrySet());
        Collections.sort(l, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new FileWriter(new File(path)));
                bw.write(String.valueOf(this.documentCount) + "\n");
                for (Map.Entry entry : l) {
                    bw.write(String.valueOf((String)entry.getKey()) + ":" + entry.getValue() + ":" + this.documentCounts.get(entry.getKey()) + "\n");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
                try {
                    bw.flush();
                    bw.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    System.exit(1);
                }
            }
        }
        finally {
            try {
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void calculateMeasures() {
        for (Map.Entry w : this.documentCounts.entrySet()) {
            this.idfs.put((String)w.getKey(), Math.log(1.0 * (double)this.documentCount / (double)(1 + (Integer)w.getValue())));
        }
        for (Map.Entry w : this.counts.entrySet()) {
            this.ilfs.put((String)w.getKey(), 1.0 / Math.log(1 + (Integer)w.getValue()));
        }
    }

    private void getCountsFromCorpus(TEICorpus corpus) {
        System.out.println("Calculation freqs...");
        int processedSegments = 0;
        int processedTexts = 0;
        int numberOfTexts = corpus.getCorpusTextIds().size();
        int c = 0;
        for (String corpusTextId : corpus.getCorpusTextIds()) {
            if (++c % (numberOfTexts / 10) == 0) {
                System.out.println("Processing text nr: " + c);
            }
            TEICorpusText corpusText = corpus.getCorpusText(corpusTextId);
            int segmentsInText = 0;
            TEISegment segment = null;
            HashSet<String> basesInText = new HashSet<String>();
            try {
                try {
                    segment = corpusText.getFirstSegment();
                    if (segment == null) {
                        throw new Exception("NULL first segment!");
                    }
                    do {
                        ++segmentsInText;
                        TEIMorphoSegmentGroup morph = (TEIMorphoSegmentGroup)segment.getSegmentGroup(TEIMorphoSegmentGroup.class);
                        String baseForm = morph.getChosenInterpretation().getBase();
                        if (baseForm.contains(":") || baseForm.equals("")) continue;
                        this.counts.increase(baseForm);
                        basesInText.add(baseForm);
                    } while ((segment = segment.getNext(ContinueMode.ALWAYS_CONTINUE)) != null);
                    processedSegments += segmentsInText;
                    ++processedTexts;
                    for (String w : basesInText) {
                        this.documentCounts.increase(w);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(String.valueOf(corpusText.getPath()) + " Skipping text because of: " + e.getMessage().replaceAll("\\n", " "));
                    corpusText.closeCorpusText();
                    continue;
                }
            }
            catch (Throwable throwable) {
                corpusText.closeCorpusText();
                throw throwable;
            }
            corpusText.closeCorpusText();
        }
        this.documentCount = processedTexts;
        System.out.println("Processed " + processedTexts + " texts out of " + corpus.getCorpusTextIds().size());
        System.out.println("Processed segments: " + processedSegments);
        System.out.println("Done.");
    }

    private void getCountsFromFile(String path) {
        block16: {
            System.out.println("Loading freqs from file...");
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(new File(path)));
                String line = br.readLine();
                this.documentCount = Integer.valueOf(line);
                while ((line = br.readLine()) != null) {
                    String[] spl = line.split(":");
                    String word = spl[0];
                    int count = Integer.valueOf(spl[1]);
                    int docCount = Integer.valueOf(spl[2]);
                    this.counts.put(word, count);
                    this.documentCounts.put(word, docCount);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
                try {
                    br.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    System.exit(1);
                }
                break block16;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    System.exit(1);
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                        System.exit(1);
                    }
                }
            }
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        System.out.println("Done");
    }

    public double getIDF(String lexeme) {
        Double d = this.idfs.get(lexeme);
        if (d == null) {
            return Math.log(1.0 * (double)this.documentCount);
        }
        return d;
    }

    public double getILF(String lexeme) {
        Double d = this.ilfs.get(lexeme);
        if (d == null) {
            return 1.0;
        }
        return d;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Wrong number of arguments specified.");
            System.out.println("Should be: FrequencyCounter.jar corpusConfigFilePath outputPath");
            System.exit(1);
        }
        String corpusPath = args[0];
        String outputFilePath = args[1];
        File corp = new File(corpusPath);
        if (!corp.exists() || !corp.isFile()) {
            System.out.println("Corpus config file doesn't exist.");
            System.exit(1);
        }
        try {
            FrequencyCounter fc = new FrequencyCounter(CorpusManager.getCorpusFromConfigFile(corpusPath));
            fc.saveIntoFile(outputFilePath);
        }
        catch (Exception e) {
            System.out.println("Error creating corpus statistics. Details follow.");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

