/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import pl.wroc.pwr.ci.plwordnet.Main;
import pl.wroc.pwr.ci.plwordnet.database.dao.SynsetDAO;
import pl.wroc.pwr.ci.plwordnet.database.dto.LexicalUnitDTO;
import pl.wroc.pwr.ci.plwordnet.database.dto.SynsetDTO;
import resources.SynonymDictionary;
import utils.FileManager;

public class RelationsPlwordnet
extends SynonymDictionary
implements Serializable {
    private static final long serialVersionUID = 2145615861956784458L;
    private String cacheFilename = "data" + File.separator + "cache" + File.separator + "relations_plwordnet";
    private Main plwordnetProxy;
    private Map<String, SynonymDictionary.SynonymEntry> synonyms = new HashMap<String, SynonymDictionary.SynonymEntry>();
    static int c = 0;

    public RelationsPlwordnet() {
        this.plwordnetProxy = new Main();
        this.loadCache();
    }

    public void saveCache() {
        FileManager.saveObject(this.synonyms, this.cacheFilename);
    }

    public void loadCache() {
        HashMap cache = (HashMap)FileManager.loadObject(this.cacheFilename);
        if (cache != null) {
            this.synonyms = cache;
        }
    }

    @Override
    public Collection<String> getSynonymsForLemma(String lemma, boolean onlyMonosemous) {
        SynonymDictionary.SynonymEntry se = this.synonyms.get(lemma);
        if (se == null) {
            System.out.println(String.valueOf(c++) + " Relations : Searching for synonyms of " + lemma);
            if (c % 1000 == 0) {
                System.out.println("Saving cache");
                this.saveCache();
            }
            se = new SynonymDictionary.SynonymEntry();
            this.synonyms.put(lemma, se);
            Collection<LexicalUnitDTO> u = this.plwordnetProxy.getUnits(lemma);
            if (u.size() > 1) {
                se.isPolysemous = true;
            }
            HashSet<String> rels = new HashSet<String>();
            rels.add("hiperonimia");
            rels.add("cz\u0119\u015b\u0107");
            rels.add("bliskoznaczno\u015b\u0107");
            rels.add("fuzzynimia_synset\u00f3w");
            HashSet<? extends SynsetDTO> synsets = new HashSet<SynsetDTO>();
            for (LexicalUnitDTO lexicalUnitDTO : u) {
                for (SynsetDTO synset : this.plwordnetProxy.getSynsets(lexicalUnitDTO)) {
                    synsets.addAll(this.plwordnetProxy.getSynsetsInRelation(synset, rels, false));
                    synsets.add(synset);
                }
            }
            for (SynsetDTO synsetDTO : synsets) {
                Collection<LexicalUnitDTO> units = SynsetDAO.dbFastGetUnits(synsetDTO);
                for (LexicalUnitDTO unit : units) {
                    se.synonyms.add(unit.getLemma());
                }
            }
        }
        if (onlyMonosemous && se.isPolysemous) {
            return new HashSet<String>();
        }
        return se.synonyms;
    }
}

