/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import resources.SynonymDictionary;

public class SynonymsSynonimyUx
extends SynonymDictionary {
    private Map<String, SynonymDictionary.SynonymEntry> synonyms = new HashMap<String, SynonymDictionary.SynonymEntry>();
    private File file = new File("data" + File.separator + "knowledge" + File.separator + "synonyms.txt");

    public SynonymsSynonimyUx() {
        try {
            this.loadDictionary();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public Collection<String> getSynonymsForLemma(String lemma, boolean onlyMonosemous) {
        SynonymDictionary.SynonymEntry entry = this.synonyms.get(lemma);
        if (entry == null) {
            return new HashSet<String>();
        }
        if (onlyMonosemous && entry.isPolysemous) {
            return new HashSet<String>();
        }
        return entry.synonyms;
    }

    public void loadDictionary() throws IOException {
        String line;
        System.out.println("Loading synonyms ux...");
        FileInputStream fis = new FileInputStream(this.file);
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)fis, "iso-8859-2"));
        while ((line = input.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] splitted = line.split(";");
            HashSet<String> synGroup = new HashSet<String>();
            String[] stringArray = splitted;
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                synGroup.add(s);
                ++n2;
            }
            for (String s : synGroup) {
                SynonymDictionary.SynonymEntry entry = this.synonyms.get(s);
                if (entry == null) {
                    entry = new SynonymDictionary.SynonymEntry();
                    this.synonyms.put(s, entry);
                } else {
                    entry.isPolysemous = true;
                }
                HashSet without = new HashSet(synGroup);
                without.remove(s);
                entry.synonyms.addAll(without);
            }
        }
        input.close();
        System.out.println("Done.");
    }
}

