/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public class FileManager {
    public static void saveObject(Object o, String path) {
        System.out.println("Saving object at path: " + path);
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(path);
            out = new ObjectOutputStream(fos);
            out.writeObject(o);
            out.close();
            fos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static Object loadObject(String path) {
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(path);
            in = new ObjectInputStream(fis);
            Object object = in.readObject();
            in.close();
            fis.close();
            System.out.println("Object loaded sucessfully at path: " + path);
            in = null;
            fis = null;
            return object;
        }
        catch (IOException ex) {
            System.out.println("Object load error.");
        }
        catch (ClassNotFoundException ex) {
            System.out.println("Object load error.");
        }
        return null;
    }

    public static void saveStringInFile(String string, String where) {
        try {
            File g = new File(where);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(g), "UTF8"));
            out.write(string);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void saveStringListInFile(List<String> l, String where) {
        try {
            File g = new File(where);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(g), "UTF8"));
            for (String s : l) {
                out.write(String.valueOf(s) + "\n");
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists() && !targetLocation.mkdirs()) {
                throw new IOException("Error creating target dir!");
            }
            String[] children = sourceLocation.list();
            int i = 0;
            while (i < children.length) {
                FileManager.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                ++i;
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }
}

