/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import pl.wroc.pwr.plwordnet.clarin.ws.takipi.DocumentFormat;
import pl.wroc.pwr.plwordnet.clarin.ws.takipi.TaggerResponse;
import pl.wroc.pwr.plwordnet.clarin.ws.takipi.TakipiProxy;
import utils.FileManager;

public class TakipiManager {
    protected Map<String, String> cache = this.loadCache();

    public String getCacheFilename() {
        return "data" + File.separator + "cache" + File.separator + "takipi";
    }

    public void saveCache() {
        FileManager.saveObject(this.cache, this.getCacheFilename());
    }

    public Map<String, String> loadCache() {
        HashMap cache = (HashMap)FileManager.loadObject(this.getCacheFilename());
        if (cache != null) {
            return cache;
        }
        return new HashMap<String, String>();
    }

    public String takipize(String text) {
        if (this.cache.containsKey(text)) {
            return this.cache.get(text);
        }
        System.out.println("Takipizing");
        TakipiProxy proxy = new TakipiProxy();
        try {
            TaggerResponse request = proxy.tag(text, DocumentFormat.TXT, true);
            String token = request.getMsg();
            int status = request.getStatus();
            if (status == 2) {
                while ((status = proxy.getStatus(token)) == 2 || status == 3) {
                }
                if (status == 1) {
                    TaggerResponse result = proxy.getResult(token);
                    this.cache.put(text, result.getMsg());
                    return result.getMsg();
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return text;
    }
}

