/*
 * Decompiled with CFR 0.152.
 */
package annotation;

import annotation.AnnSensesTXT;
import annotation.WELesk;
import annotation.WEMFS;
import annotation.WERandom;
import annotation.WordExpert;
import basic.Context;
import corpusapi.ContinueMode;
import corpusapi.Corpus;
import corpusapi.SenseInventory;
import corpusapi.SenseStatistics;
import corpusapi.tei.TEICorpus;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEICorpusTools;
import corpusapi.tei.TEIInterpretation;
import corpusapi.tei.TEIMorphoSegmentGroup;
import corpusapi.tei.TEISegment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import utils.TakipiManager;

public class Annotator {
    private static final int WINDOW_SIZE = 50;

    public void annotateMulti(TEICorpus corpus, String filename, Map<String, List<WordExpert>> wordExperts) {
        System.out.println("Annotating...");
        int processedSegments = 0;
        int processedTexts = 0;
        int numberOfTexts = corpus.getCorpusTextIds().size();
        int c = 0;
        for (String corpusTextId : corpus.getCorpusTextIds()) {
            if (++c % (numberOfTexts / 10) == 0) {
                System.out.println("Processing text nr: " + c + " out of " + numberOfTexts);
            }
            TEICorpusText corpusText = corpus.getCorpusText(corpusTextId);
            int segmentsInText = 0;
            TEISegment segment = null;
            try {
                try {
                    segment = corpusText.getFirstSegment();
                    if (segment == null) {
                        throw new Exception("NULL first segment!");
                    }
                    AnnSensesTXT ann_sensesTXT = new AnnSensesTXT(corpusText.getPath());
                    do {
                        ++segmentsInText;
                        TEIMorphoSegmentGroup morph = (TEIMorphoSegmentGroup)segment.getSegmentGroup(TEIMorphoSegmentGroup.class);
                        String baseForm = morph.getChosenInterpretation().getBase();
                        if (!wordExperts.containsKey(baseForm)) continue;
                        Context context = this.loadContextForSegment(segment);
                        List<WordExpert> wes = wordExperts.get(baseForm);
                        ArrayList<String> answers = new ArrayList<String>();
                        for (WordExpert we : wes) {
                            answers.add("NKJP_WSI.xml#" + we.disambiguate(context).getId());
                        }
                        ann_sensesTXT.add(segment, answers);
                    } while ((segment = segment.getNext(ContinueMode.ALWAYS_CONTINUE)) != null);
                    ann_sensesTXT.saveAsTxt(filename);
                    ann_sensesTXT = null;
                    processedSegments += segmentsInText;
                    ++processedTexts;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(String.valueOf(corpusText.getPath()) + " Skipping text because of: " + e.getMessage().replaceAll("\\n", " "));
                    corpusText.closeCorpusText();
                    corpusText = null;
                    continue;
                }
            }
            catch (Throwable throwable) {
                corpusText.closeCorpusText();
                corpusText = null;
                throw throwable;
            }
            corpusText.closeCorpusText();
            corpusText = null;
        }
        System.out.println("Processed " + processedTexts + " texts out of " + corpus.getCorpusTextIds().size());
        System.out.println("Processed segments: " + processedSegments);
        System.out.println("Done.");
    }

    private Context loadContextForSegment(TEISegment senseSegment) throws Exception {
        Context result = new Context();
        int relativePosition = 0;
        TEISegment currentSegment = senseSegment;
        while (relativePosition > -50 && currentSegment.getPrev(ContinueMode.CONTINUOUS) != null) {
            currentSegment = currentSegment.getPrev(ContinueMode.CONTINUOUS);
            --relativePosition;
        }
        result.setKeywordIndex(-relativePosition);
        TEIMorphoSegmentGroup morpho = (TEIMorphoSegmentGroup)currentSegment.getSegmentGroup(TEIMorphoSegmentGroup.class);
        TEIInterpretation interp = morpho.getChosenInterpretation();
        result.addWord(currentSegment.getOrth(), interp.getBase());
        while (relativePosition < 50 && currentSegment.getNext(ContinueMode.CONTINUOUS) != null) {
            currentSegment = currentSegment.getNext(ContinueMode.CONTINUOUS);
            ++relativePosition;
            morpho = (TEIMorphoSegmentGroup)currentSegment.getSegmentGroup(TEIMorphoSegmentGroup.class);
            interp = morpho.getChosenInterpretation();
            result.addWord(currentSegment.getOrth(), interp.getBase());
        }
        return result;
    }

    private Map<String, String> createMFSDecs(SenseInventory dict, TEICorpus corpus) {
        TEICorpusTools ct = new TEICorpusTools();
        SenseStatistics globalStats = ct.getSenseStatistics((Corpus)corpus);
        Map mfsDecsId = ct.getMFSDecisionsfromStats(globalStats);
        HashMap<String, String> mfsDecsOrth = new HashMap<String, String>();
        for (String lemma : dict.getAllPolysemousLemmas()) {
            mfsDecsOrth.put(lemma, (String)mfsDecsId.get(dict.getSenseEntryIdFromOrth(lemma)));
        }
        return mfsDecsOrth;
    }

    public Map<String, List<WordExpert>> createWordExperts(SenseInventory dict, List<String> methods, TEICorpus corpus, TakipiManager takipiManager) throws Exception {
        Map<String, String> mfsDecsOrth = null;
        HashMap<String, List<WordExpert>> wordExperts = new HashMap<String, List<WordExpert>>();
        for (String lemma : dict.getAllPolysemousLemmas()) {
            Collection senses = dict.getSensesForLemma(lemma);
            ArrayList<WordExpert> experts = new ArrayList<WordExpert>();
            for (String params : methods) {
                String[] splitted = params.split(":", 2);
                String weClass = splitted[0];
                if (weClass.equalsIgnoreCase("lesk")) {
                    String weParams = splitted[1];
                    experts.add(new WELesk(lemma, senses, weParams, takipiManager));
                    continue;
                }
                if (weClass.equalsIgnoreCase("random")) {
                    experts.add(new WERandom(lemma, senses));
                    continue;
                }
                if (weClass.equalsIgnoreCase("mfs")) {
                    if (mfsDecsOrth == null) {
                        mfsDecsOrth = this.createMFSDecs(dict, corpus);
                    }
                    experts.add(new WEMFS(lemma, senses, mfsDecsOrth.get(lemma)));
                    continue;
                }
                System.out.println("Wrong expert specification: " + params);
            }
            wordExperts.put(lemma, experts);
        }
        takipiManager.saveCache();
        return wordExperts;
    }

    public Map<String, List<WordExpert>> createWordExpertsMfs(SenseInventory dict, Corpus corpus) {
        TEICorpusTools ct = new TEICorpusTools();
        SenseStatistics globalStats = ct.getSenseStatistics(corpus);
        Map mfsDecsId = ct.getMFSDecisionsfromStats(globalStats);
        HashMap<String, String> mfsDecsOrth = new HashMap<String, String>();
        for (String lemma : dict.getAllPolysemousLemmas()) {
            mfsDecsOrth.put(lemma, (String)mfsDecsId.get(dict.getSenseEntryIdFromOrth(lemma)));
        }
        HashMap<String, List<WordExpert>> wordExperts = new HashMap<String, List<WordExpert>>();
        for (String lemma : dict.getAllPolysemousLemmas()) {
            Collection senses = dict.getSensesForLemma(lemma);
            ArrayList<WEMFS> experts = new ArrayList<WEMFS>();
            experts.add(new WEMFS(lemma, senses, (String)mfsDecsOrth.get(lemma)));
            wordExperts.put(lemma, experts);
        }
        return wordExperts;
    }
}

