/*
 * Decompiled with CFR 0.152.
 */
package evaluation;

import corpusapi.CorpusText;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationReader {
    private BufferedReader br = null;
    private String filename = null;
    private List<String> annotatorsNames = null;

    public AnnotationReader(String annotationFilename, List<String> annotatorsNames) {
        this.filename = annotationFilename;
        this.annotatorsNames = annotatorsNames;
    }

    public void setCurrentCorpusText(CorpusText ct) throws IOException {
        this.br = new BufferedReader(new FileReader(String.valueOf(ct.getPath()) + File.separator + this.filename));
    }

    public SegmentAnnotation getNextTaggedSegment() throws IOException {
        SegmentAnnotation result = null;
        String line = this.br.readLine();
        if (line != null) {
            result = new SegmentAnnotation();
            String[] splitted = line.split("\t", 2);
            result.segmentId = splitted[0];
            String[] annotations = splitted[1].split("\t");
            int i = 0;
            String[] stringArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String annotation = stringArray[n2];
                result.annotations.put(this.annotatorsNames.get(i++), annotation);
                ++n2;
            }
            result.lexeme = annotations[0].split("#")[1].split("\\.")[0];
        } else {
            this.br.close();
            this.br = null;
        }
        return result;
    }

    public List<String> getAnnotatorsNames() {
        return this.annotatorsNames;
    }

    public static class SegmentAnnotation {
        public String segmentId;
        public Map<String, String> annotations = new HashMap<String, String>();
        public String lexeme;
    }
}

