/*
 * Decompiled with CFR 0.152.
 */
package evaluation;

import corpusapi.tei.TEISenseInventory;
import evaluation.AnnotationStats;
import java.util.HashSet;
import java.util.Set;

public class SingleMethodEvaluation {
    public String methodId;
    private AnnotationStats correctAnnotations;
    private AnnotationStats incorrectAnnotations;
    public int segmentsTaggedAsUnknown = 0;

    public SingleMethodEvaluation(String methodName, TEISenseInventory dict) {
        this.methodId = methodName;
        this.correctAnnotations = new AnnotationStats(dict);
        this.incorrectAnnotations = new AnnotationStats(dict);
    }

    public void printStats() {
        System.out.println();
        System.out.println(this.methodId);
        System.out.println();
        int totalCorrect = this.correctAnnotations.getAllCount();
        int totalIncorrect = this.incorrectAnnotations.getAllCount();
        double totalAccuracy = 1.0 * (double)totalCorrect / (double)(totalIncorrect + totalCorrect);
        System.out.println("Segments - tagged correctly      : " + totalCorrect);
        System.out.println("Segments - tagged incorrectly    : " + totalIncorrect);
        System.out.println("Segments - tagged as unknown     : " + this.segmentsTaggedAsUnknown);
        System.out.println();
        System.out.println("Total accuracy                 : " + totalAccuracy);
        System.out.println();
        System.out.println("Done.");
    }

    public Double getTotalAccuracy() {
        int totalCorrect = this.correctAnnotations.getAllCount();
        int totalIncorrect = this.incorrectAnnotations.getAllCount();
        return 1.0 * (double)totalCorrect / (double)(totalIncorrect + totalCorrect);
    }

    public double getLexemeImprovement(AnnotationStats goldenStandard, String lexeme) {
        double baseAcc = goldenStandard.getMfsForLexeme(lexeme);
        double methAcc = this.getLexemeAccuracy(lexeme);
        return methAcc - baseAcc;
    }

    public int getLexemeCount(String lexeme) {
        int correct = this.correctAnnotations.getCountForLexeme(lexeme);
        int incorrect = this.incorrectAnnotations.getCountForLexeme(lexeme);
        return correct + incorrect;
    }

    public Double getEqualDistLexemeAccuracy(String lexeme) {
        double sum = 0.0;
        int count = 0;
        for (String sub : this.getSubsenseSet(lexeme)) {
            Double s = this.getSubsenseAccuracy(lexeme, sub);
            if (s == null) continue;
            sum += s.doubleValue();
            ++count;
        }
        return sum / (double)count;
    }

    public Double getLexemeAccuracy(String lexeme) {
        int correct = this.correctAnnotations.getCountForLexeme(lexeme);
        int incorrect = this.incorrectAnnotations.getCountForLexeme(lexeme);
        return 1.0 * (double)correct / (double)(incorrect + correct);
    }

    public Double getSubsenseAccuracy(String lexeme, String subsenseId) {
        int incorrect;
        int correct = this.correctAnnotations.getCountForSubsense(lexeme, subsenseId);
        if (correct + (incorrect = this.incorrectAnnotations.getCountForSubsense(lexeme, subsenseId)) == 0) {
            return null;
        }
        return 1.0 * (double)correct / (double)(incorrect + correct);
    }

    public String getMethodId() {
        return this.methodId;
    }

    public int getNumberOfImprovements(String pos, AnnotationStats goldenStandard) {
        int better = 0;
        for (String lexeme : goldenStandard.getLexemeSet(pos)) {
            if (!(this.getLexemeAccuracy(lexeme) > goldenStandard.getMfsForLexeme(lexeme))) continue;
            ++better;
        }
        return better;
    }

    public double getWeightedRank(String pos, AnnotationStats goldenStandard) {
        double result = 0.0;
        for (String lexeme : goldenStandard.getLexemeSet(pos)) {
            for (String subsense : goldenStandard.getSubsensesList(lexeme)) {
                int correct = this.correctAnnotations.getCountForSubsense(lexeme, subsense);
                double weight = goldenStandard.getSenseWeight(lexeme, subsense);
                result += weight * (double)correct;
            }
        }
        return result;
    }

    public void addCorrectAnnotation(String lexeme, String senseId) {
        this.correctAnnotations.addAnnotation(lexeme, senseId);
    }

    public void addIncorrectAnnotation(String lexeme, String senseId) {
        this.incorrectAnnotations.addAnnotation(lexeme, senseId);
    }

    public Set<String> getLexemeSet() {
        HashSet<String> result = new HashSet<String>(this.correctAnnotations.getLexemeSet());
        result.addAll(this.incorrectAnnotations.getLexemeSet());
        return result;
    }

    public Set<String> getSubsenseSet(String lexeme) {
        HashSet<String> result = new HashSet<String>(this.correctAnnotations.getSubsensesList(lexeme));
        result.addAll(this.incorrectAnnotations.getSubsensesList(lexeme));
        return result;
    }

    public double getTotalAccuracy(String pos, AnnotationStats goldenStandard) {
        int correct = 0;
        int incorrect = 0;
        for (String lexeme : goldenStandard.getLexemeSet(pos)) {
            correct += this.correctAnnotations.getCountForLexeme(lexeme);
            incorrect += this.incorrectAnnotations.getCountForLexeme(lexeme);
        }
        return 1.0 * (double)correct / (double)(correct + incorrect);
    }
}

