/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import resources.SynonymDictionary;
import utils.FileManager;

public class SemSimPlwordnet
extends SynonymDictionary
implements Serializable {
    private static final long serialVersionUID = 2145615861956784458L;
    private String cacheFilename = "data" + File.separator + "cache" + File.separator + "semsim_plwordnet";
    private Map<String, SynonymDictionary.SynonymEntry> synonyms = new HashMap<String, SynonymDictionary.SynonymEntry>();
    static int c = 0;

    public SemSimPlwordnet() {
        this.loadCache();
    }

    public void saveCache() {
        FileManager.saveObject(this.synonyms, this.cacheFilename);
    }

    public void loadCache() {
        HashMap cache = (HashMap)FileManager.loadObject(this.cacheFilename);
        if (cache != null) {
            this.synonyms = cache;
        }
    }

    @Override
    public Collection<String> getSynonymsForLemma(String lemma, boolean onlyMonosemous) {
        SynonymDictionary.SynonymEntry se = this.synonyms.get(lemma);
        if (se == null) {
            System.out.println(String.valueOf(c++) + " SemSim : Searching for synonyms of " + lemma);
            if (c % 1000 == 0) {
                System.out.println("Saving cache");
                this.saveCache();
            }
            se = new SynonymDictionary.SynonymEntry();
            this.synonyms.put(lemma, se);
            ArrayList<String> syns = new ArrayList<String>();
            URL url = null;
            URLConnection urlConn = null;
            InputStreamReader inStream = null;
            BufferedReader buff = null;
            try {
                String nextLine;
                url = new URL("http://plwordnet.pwr.wroc.pl/wordnet/msr/" + lemma);
                urlConn = url.openConnection();
                inStream = new InputStreamReader(urlConn.getInputStream());
                buff = new BufferedReader(inStream);
                String td = "<td class=\"l\">";
                while ((nextLine = buff.readLine()) != null) {
                    if (!nextLine.contains("<table class=\"msr\">")) continue;
                    while (!(nextLine = buff.readLine()).contains("</table>")) {
                        if (!nextLine.contains(td)) continue;
                        String[] spl = nextLine.split("[><]");
                        String word = spl[8];
                        syns.add(word);
                    }
                    break;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            for (String syn : syns) {
                se.synonyms.add(syn);
            }
        }
        return se.synonyms;
    }
}

