/*
 * Decompiled with CFR 0.152.
 */
package annotation;

import annotation.MatchingStrategy;
import annotation.WordExpert;
import basic.Context;
import basic.Gloss;
import corpusapi.Sense;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utils.TakipiManager;

public class WELesk
extends WordExpert {
    private MatchingStrategy matchingStrategy;
    private String paramString;
    private int contextWindow;
    private boolean fullGloss;
    private Map<String, Gloss> preprocessedGlosses = new HashMap<String, Gloss>();
    private static Comparator<Map.Entry<String, Double>> comparator = new Comparator<Map.Entry<String, Double>>(){

        @Override
        public int compare(Map.Entry<String, Double> arg0, Map.Entry<String, Double> arg1) {
            return arg1.getValue().compareTo(arg0.getValue());
        }
    };
    private static final Pattern pat = Pattern.compile("<orth>(.*?)</orth>.*?<lex disamb=\"1\"><base>(.*?)</base><ctag>(.*?)</ctag></lex>", 32);

    public WELesk(String baseForm, Collection<? extends Sense> senses, String params, TakipiManager takipi) throws Exception {
        super(baseForm, senses);
        this.paramString = "Lesk:" + params;
        String[] splitted = params.split(":", 3);
        String cw = splitted[0];
        String gs = splitted[1];
        this.contextWindow = Integer.valueOf(cw);
        this.fullGloss = gs.equalsIgnoreCase("full");
        for (Sense sense : senses) {
            this.preprocessedGlosses.put(sense.getId(), this.preprocessGloss(sense, takipi));
        }
        this.matchingStrategy = new MatchingStrategy(this.preprocessedGlosses, splitted[2]);
    }

    @Override
    public Sense disambiguate(Context context) {
        Context preprocessedContext = new Context(context);
        preprocessedContext.cutToWindow(this.contextWindow);
        Sense answer = null;
        double max = Double.NEGATIVE_INFINITY;
        HashMap<String, Double> similarities = new HashMap<String, Double>();
        Map<String, Double> contextVector = this.matchingStrategy.prepareContextVector(preprocessedContext);
        for (Sense sense : this.senses) {
            String string = sense.getId();
            double similarity = this.matchingStrategy.computeSimilarity(contextVector, string);
            similarities.put(string, similarity);
            if (!(similarity > max)) continue;
            max = similarity;
            answer = sense;
        }
        ArrayList similaritiesSorted = new ArrayList(similarities.entrySet());
        Collections.sort(similaritiesSorted, comparator);
        float total = 0.0f;
        for (Map.Entry entry : similaritiesSorted) {
            total = (float)((double)total + (Double)entry.getValue());
        }
        if (total != 0.0f) {
            for (Map.Entry entry : similaritiesSorted) {
                entry.setValue((Double)entry.getValue() / (double)total);
            }
        }
        return answer;
    }

    private Gloss preprocessGloss(Sense sense, TakipiManager takipi) {
        Gloss gloss = new Gloss();
        String definition = null;
        StringBuffer sb = new StringBuffer();
        if (this.fullGloss) {
            for (String def : sense.getDefinitions()) {
                sb.append(String.valueOf(def) + " ");
            }
            definition = sb.toString();
        } else {
            definition = sense.getDefinition();
        }
        String taggedGloss = takipi.takipize(definition);
        Matcher matcher = pat.matcher(taggedGloss);
        while (matcher.find()) {
            if (matcher.groupCount() != 3) {
                System.out.println("error parsing tagging!");
                System.exit(1);
            }
            String orth = matcher.group(1);
            String base = matcher.group(2);
            String ctag = matcher.group(3);
            gloss.addWord(orth, base);
        }
        return gloss;
    }

    @Override
    public String getParamString() {
        return this.paramString;
    }
}

