/*
 * Decompiled with CFR 0.152.
 */
package KnoW;

import annotation.Annotator;
import annotation.WordExpert;
import corpusapi.Corpus;
import corpusapi.SenseInventory;
import corpusapi.tei.TEICorpus;
import corpusapi.tei.TEISenseInventory;
import evaluation.AnnotationReader;
import evaluation.AnnotationStats;
import evaluation.Evaluator;
import evaluation.SingleMethodEvaluation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import resources.FrequencyCounter;
import resources.RelationsPlwordnet;
import resources.SemSimPlwordnet;
import resources.SynonymDictionary;
import resources.SynonymsPlwordnet;
import resources.SynonymsSynonimyUx;
import utils.CorpusManager;
import utils.TakipiManager;

public class KnoW {
    private static TEICorpus corpus;
    private static AnnotationStats goldenStandard;
    private static TEISenseInventory dict;
    private static Annotator annotator;
    private static Evaluator evaluator;
    private static SynonymsSynonimyUx synonimyUx;
    private static SynonymsPlwordnet plwordnetSynonyms;
    private static RelationsPlwordnet plwordnetRelations;
    private static SemSimPlwordnet plwordnetSemSim;
    private static FrequencyCounter frequencyCounter;
    private static TakipiManager takipiManager;
    private static final String frequencyCounterPath;
    private static final String annotationFilename = "ann_senses_multi";

    static {
        synonimyUx = null;
        plwordnetSynonyms = null;
        plwordnetRelations = null;
        plwordnetSemSim = null;
        frequencyCounter = null;
        takipiManager = null;
        frequencyCounterPath = "data" + File.separator + "knowledge" + File.separator + "frequencies.txt";
    }

    public static void main(String[] args) {
        if (args.length > 6 || args.length < 5) {
            System.out.println("Wrong number of arguments specified.");
            System.out.println("Should be: KnoW.jar experimentDescriptionsPath outputPath corpusPath dictionaryPath outputType [maxMethods]");
            System.exit(1);
        }
        String experimentDescriptionsPath = args[0];
        String outputFilePath = args[1];
        String corpusPath = args[2];
        String dictPath = args[3];
        String option = args[4];
        Integer howMany = null;
        if (args.length == 6) {
            try {
                howMany = Integer.valueOf(args[5]);
            }
            catch (NumberFormatException e) {
                System.out.println("Error parsing the max number of methods parameter. " + args[5] + " is not proper integer.");
                System.exit(1);
            }
            if (howMany < 1) {
                System.out.println("Max number of methods parameter should be greater than 0.");
                System.exit(1);
            }
        }
        KnoW.checkArguments(experimentDescriptionsPath, option, corpusPath, dictPath);
        KnoW.initialize(corpusPath, dictPath);
        List<List<String>> spl = null;
        try {
            spl = KnoW.getSplits(experimentDescriptionsPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        KnoW.annotate(spl, annotationFilename);
        Collection<SingleMethodEvaluation> results = KnoW.evaluate(spl, annotationFilename, dict);
        ArrayList<SingleMethodEvaluation> selectedResults = new ArrayList<SingleMethodEvaluation>();
        File f = new File(outputFilePath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            if (option.equals("compare")) {
                bw.append("ACC\n");
                selectedResults.addAll(evaluator.selectBestMethods(results, Evaluator.Sorting.ACCURACY, howMany, goldenStandard));
                evaluator.printEvaluationResults(bw, selectedResults, goldenStandard);
                bw.append("RARE\n");
                selectedResults.clear();
                selectedResults.addAll(evaluator.selectBestMethods(results, Evaluator.Sorting.RARE, howMany, goldenStandard));
                evaluator.printEvaluationResults(bw, selectedResults, goldenStandard);
                bw.append("IMPROVE\n");
                selectedResults.clear();
                selectedResults.addAll(evaluator.selectBestMethods(results, Evaluator.Sorting.MFS_IMPROVEMENT, howMany, goldenStandard));
                evaluator.printEvaluationResults(bw, selectedResults, goldenStandard);
            } else if (option.equals("all")) {
                System.out.println("ALL");
                selectedResults.clear();
                selectedResults.addAll(evaluator.selectBestMethods(results, Evaluator.Sorting.ACCURACY, null, goldenStandard));
                evaluator.printEvaluationResults(bw, selectedResults, goldenStandard);
            } else {
                selectedResults.addAll(evaluator.selectBestMethods(results, Evaluator.Sorting.ACCURACY, howMany, goldenStandard));
                selectedResults.addAll(evaluator.selectBestMethods(results, Evaluator.Sorting.RARE, howMany, goldenStandard));
                selectedResults.addAll(evaluator.selectBestMethods(results, Evaluator.Sorting.MFS_IMPROVEMENT, howMany, goldenStandard));
                evaluator.printEvaluationResultsOnLexemes(bw, selectedResults, goldenStandard);
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        KnoW.saveCaches();
        System.out.println("Removing annotation files...");
        for (String cid : corpus.getCorpusTextIds()) {
            File dir = new File(corpus.getCorpusText(cid).getPath());
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().startsWith(annotationFilename)) {
                    file.delete();
                }
                ++n2;
            }
        }
        System.out.println("Done");
    }

    private static void checkArguments(String experimentDescriptionsPath, String option, String corpusPath, String dictPath) {
        File dict;
        File corp;
        File exp = new File(experimentDescriptionsPath);
        if (!exp.exists() || !exp.isFile()) {
            System.out.println("Experiment description file doesn't exist.");
            System.exit(1);
        }
        if (!(corp = new File(corpusPath)).exists() || !corp.isFile()) {
            System.out.println("Corpus description file doesn't exist.");
            System.exit(1);
        }
        if (!(dict = new File(dictPath)).exists() || !dict.isFile()) {
            System.out.println("Dictionary file doesn't exist.");
            System.exit(1);
        }
        if (!(option.equals("compare") || option.equals("all") || option.equals("lexemes"))) {
            System.out.println("Wrong option for output type.");
            System.exit(1);
        }
    }

    private static Collection<SingleMethodEvaluation> evaluate(List<List<String>> spl, String filename, TEISenseInventory dict) {
        HashSet<SingleMethodEvaluation> results = new HashSet<SingleMethodEvaluation>();
        int c = 0;
        for (List<String> methods : spl) {
            System.out.println("Split nr " + ++c);
            String splitsuf = "";
            if (spl.size() > 1) {
                splitsuf = "_" + c;
            }
            AnnotationReader annotationReader = new AnnotationReader(String.valueOf(filename) + splitsuf + ".txt", methods);
            results.addAll(evaluator.evaluate((Corpus)corpus, annotationReader, dict));
        }
        return results;
    }

    private static List<List<String>> getSplits(String experimentDescriptionsPath) throws IOException {
        ArrayList<String> allmethods = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(new File(experimentDescriptionsPath)));
        String line = "";
        while ((line = br.readLine()) != null) {
            allmethods.add(line);
        }
        System.out.println("Number of methods: " + allmethods.size());
        List<List<String>> spl = KnoW.splitMethods(allmethods, 50);
        System.out.println("Splitted into " + spl.size() + " splits.");
        return spl;
    }

    private static void annotate(List<List<String>> spl, String filename) {
        try {
            int c = 0;
            for (List<String> methods : spl) {
                System.out.println("Split nr " + ++c);
                System.out.println("Creating wordExperts...");
                Map<String, List<WordExpert>> wordExpertsMulti = annotator.createWordExperts((SenseInventory)dict, methods, corpus, takipiManager);
                System.out.println("..done.");
                String splitsuf = "";
                if (spl.size() > 1) {
                    splitsuf = "_" + c;
                }
                annotator.annotateMulti(corpus, String.valueOf(filename) + splitsuf + ".txt", wordExpertsMulti);
                wordExpertsMulti.clear();
                wordExpertsMulti = null;
            }
        }
        catch (Exception e) {
            System.out.println("Error while annotating. Details follow.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static List<List<String>> splitMethods(List<String> methods, int bucketSize) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        while (!methods.isEmpty()) {
            List<String> sublist = methods.subList(0, Math.min(methods.size(), bucketSize));
            ArrayList<String> bucketList = new ArrayList<String>(sublist);
            sublist.clear();
            result.add(bucketList);
        }
        return result;
    }

    public static SynonymDictionary getSynonimyUx() {
        if (synonimyUx == null) {
            synonimyUx = new SynonymsSynonimyUx();
        }
        return synonimyUx;
    }

    public static SynonymDictionary getPlwordnetSynonyms() {
        if (plwordnetSynonyms == null) {
            plwordnetSynonyms = new SynonymsPlwordnet();
        }
        return plwordnetSynonyms;
    }

    public static SynonymDictionary getPlwordnetRelations() {
        if (plwordnetRelations == null) {
            plwordnetRelations = new RelationsPlwordnet();
        }
        return plwordnetRelations;
    }

    public static SynonymDictionary getPlwordnetSemSim() {
        if (plwordnetSemSim == null) {
            plwordnetSemSim = new SemSimPlwordnet();
        }
        return plwordnetSemSim;
    }

    public static FrequencyCounter getFrequencyCounter() {
        if (frequencyCounter == null) {
            frequencyCounter = new FrequencyCounter(frequencyCounterPath);
        }
        return frequencyCounter;
    }

    private static void saveCaches() {
        if (plwordnetSynonyms != null) {
            plwordnetSynonyms.saveCache();
        }
        if (plwordnetRelations != null) {
            plwordnetRelations.saveCache();
        }
        if (plwordnetSemSim != null) {
            plwordnetSemSim.saveCache();
        }
        if (takipiManager != null) {
            takipiManager.saveCache();
        }
    }

    private static void initialize(String corpusConfigFilePath, String senseInventoryPath) {
        try {
            corpus = CorpusManager.getCorpusFromConfigFile(corpusConfigFilePath);
            dict = TEISenseInventory.createFromXML((String)senseInventoryPath);
            goldenStandard = CorpusManager.getSenseStatisticsForCorpus((Corpus)corpus, dict);
            takipiManager = new TakipiManager();
            annotator = new Annotator();
            evaluator = new Evaluator();
        }
        catch (Exception ex) {
            System.out.println("Errors during initialization. Details follow");
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

