/*
 * Decompiled with CFR 0.152.
 */
package annotation;

import KnoW.KnoW;
import basic.Context;
import basic.Gloss;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import resources.SynonymDictionary;
import utils.Counter;

public class MatchingStrategy {
    private boolean lemmatize;
    private IntersectionType intersectionType;
    private boolean withIGF;
    private boolean withIDF;
    private boolean glossNormalisation;
    private ContextNormalisation contextNormalisation;
    private boolean binary;
    private ExtensionType extensionType;
    private double thresholdLow;
    private double thresholdHigh;
    private Map<String, Double> igfs;
    private Map<String, Map<String, Double>> glossVectors;

    public MatchingStrategy(Map<String, Gloss> preprocessedGlosses, String params) throws Exception {
        this.setParams(params);
        if (this.withIGF) {
            this.igfs = this.calculateIgfs(preprocessedGlosses);
        }
        this.glossVectors = new HashMap<String, Map<String, Double>>();
        for (Map.Entry<String, Gloss> gloss : preprocessedGlosses.entrySet()) {
            String senseId = gloss.getKey();
            Gloss preprocessedGloss = gloss.getValue();
            Counter glossCounter = new Counter();
            List<String> words = this.lemmatize ? preprocessedGloss.getBases() : preprocessedGloss.getOrths();
            for (String s : words) {
                if (this.binary) {
                    glossCounter.put(s, 1);
                    continue;
                }
                glossCounter.increase(s);
            }
            HashMap<String, Double> glossVector = new HashMap<String, Double>();
            for (Map.Entry entry : glossCounter.entrySet()) {
                if (this.withIGF) {
                    glossVector.put((String)entry.getKey(), this.igfs.get(entry.getKey()) * (double)((Integer)entry.getValue()).intValue());
                    continue;
                }
                glossVector.put((String)entry.getKey(), 1.0 * (double)((Integer)entry.getValue()).intValue());
            }
            if (this.glossNormalisation) {
                MatchingStrategy.normalizeVector(glossVector);
            }
            if (this.extensionType.equals((Object)ExtensionType.SYNONIMY_UX_ALL)) {
                MatchingStrategy.extendVectorWithSynonyms(glossVector, KnoW.getSynonimyUx(), false);
            } else if (this.extensionType.equals((Object)ExtensionType.SYNONIMY_UX_MONO)) {
                MatchingStrategy.extendVectorWithSynonyms(glossVector, KnoW.getSynonimyUx(), true);
            } else if (this.extensionType.equals((Object)ExtensionType.PLWORDNET_ALL)) {
                MatchingStrategy.extendVectorWithSynonyms(glossVector, KnoW.getPlwordnetSynonyms(), false);
            } else if (this.extensionType.equals((Object)ExtensionType.PLWORDNET_MONO)) {
                MatchingStrategy.extendVectorWithSynonyms(glossVector, KnoW.getPlwordnetSynonyms(), true);
            } else if (this.extensionType.equals((Object)ExtensionType.PLWORDNET_RELATIONS)) {
                MatchingStrategy.extendVectorWithSynonyms(glossVector, KnoW.getPlwordnetRelations(), false);
            } else if (this.extensionType.equals((Object)ExtensionType.PLWORDNET_SEMSIM)) {
                MatchingStrategy.extendVectorWithSynonyms(glossVector, KnoW.getPlwordnetSemSim(), false);
            }
            this.glossVectors.put(senseId, glossVector);
        }
    }

    public Map<String, Double> prepareContextVector(Context preprocessedContext) {
        HashMap<String, Double> contextVector = new HashMap<String, Double>();
        HashMap<String, ArrayList<Integer>> distances = new HashMap<String, ArrayList<Integer>>();
        int keywordIndex = preprocessedContext.getKeywordIndex();
        int i = 0;
        List<String> words = this.lemmatize ? preprocessedContext.getBases() : preprocessedContext.getOrths();
        for (String string : words) {
            if (i != keywordIndex) {
                if (this.binary) {
                    contextVector.put(string, 1.0);
                } else if (contextVector.containsKey(string)) {
                    contextVector.put(string, (Double)contextVector.get(string) + 1.0);
                } else {
                    contextVector.put(string, 1.0);
                }
                int d = Math.abs(i - keywordIndex);
                ArrayList<Integer> di = (ArrayList<Integer>)distances.get(string);
                if (di == null) {
                    di = new ArrayList<Integer>();
                    distances.put(string, di);
                }
                di.add(d);
            }
            ++i;
        }
        if (this.withIDF) {
            for (Map.Entry entry : contextVector.entrySet()) {
                entry.setValue((Double)entry.getValue() * KnoW.getFrequencyCounter().getIDF((String)entry.getKey()));
            }
        }
        MatchingStrategy.thresholdVector(contextVector, this.thresholdLow, this.thresholdHigh);
        if (!this.contextNormalisation.equals((Object)ContextNormalisation.NONE)) {
            for (Map.Entry entry : contextVector.entrySet()) {
                double d = 0.0;
                for (Integer di : (Collection)distances.get(entry.getKey())) {
                    if (this.contextNormalisation.equals((Object)ContextNormalisation.SQUARE)) {
                        d += 1.0 / (double)(di * di);
                        continue;
                    }
                    if (!this.contextNormalisation.equals((Object)ContextNormalisation.LINEAR)) continue;
                    d += 1.0 / (double)di.intValue();
                }
                entry.setValue((Double)entry.getValue() * d);
            }
        }
        if (this.extensionType.equals((Object)ExtensionType.SYNONIMY_UX_ALL)) {
            MatchingStrategy.extendVectorWithSynonyms(contextVector, KnoW.getSynonimyUx(), false);
        } else if (this.extensionType.equals((Object)ExtensionType.SYNONIMY_UX_MONO)) {
            MatchingStrategy.extendVectorWithSynonyms(contextVector, KnoW.getSynonimyUx(), true);
        } else if (this.extensionType.equals((Object)ExtensionType.PLWORDNET_ALL)) {
            MatchingStrategy.extendVectorWithSynonyms(contextVector, KnoW.getPlwordnetSynonyms(), false);
        } else if (this.extensionType.equals((Object)ExtensionType.PLWORDNET_MONO)) {
            MatchingStrategy.extendVectorWithSynonyms(contextVector, KnoW.getPlwordnetSynonyms(), true);
        } else if (this.extensionType.equals((Object)ExtensionType.PLWORDNET_RELATIONS)) {
            MatchingStrategy.extendVectorWithSynonyms(contextVector, KnoW.getPlwordnetRelations(), false);
        } else if (this.extensionType.equals((Object)ExtensionType.PLWORDNET_SEMSIM)) {
            MatchingStrategy.extendVectorWithSynonyms(contextVector, KnoW.getPlwordnetSemSim(), false);
        }
        return contextVector;
    }

    public double computeSimilarity(Map<String, Double> contextVector, String senseId) {
        Map<String, Double> glossVector = this.glossVectors.get(senseId);
        return MatchingStrategy.getVectorSimilarity(glossVector, contextVector, this.intersectionType);
    }

    private static void thresholdVector(Map<String, Double> vector, double thresholdLow, double thresholdHigh) {
        double maxValue = -1.0;
        for (Double d : vector.values()) {
            if (!(d > maxValue)) continue;
            maxValue = d;
        }
        Iterator<Map.Entry<String, Double>> i = vector.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Double> entry = i.next();
            if (!(entry.getValue() < thresholdLow * maxValue) && !(entry.getValue() > thresholdHigh * maxValue)) continue;
            i.remove();
        }
    }

    private static void extendVectorWithSynonyms(Map<String, Double> vector, SynonymDictionary dict, boolean onlyMonosemous) {
        HashMap<String, Double> copy = new HashMap<String, Double>(vector);
        for (Map.Entry entry : copy.entrySet()) {
            if (!((String)entry.getKey()).matches("[a-zA-Z\u0105\u0104\u0107\u0106\u0119\u0118\u0142\u0141\u0144\u0143\u00f3\u00d3\u015b\u015a\u017a\u0179\u017c\u017b\\-\u00e9]+")) continue;
            Collection<String> synonyms = dict.getSynonymsForLemma((String)entry.getKey(), onlyMonosemous);
            for (String synonym : synonyms) {
                String[] stringArray = synonym.split("\\s+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String sub = stringArray[n2];
                    if (!vector.containsKey(sub) && sub.matches("[a-zA-Z\u0105\u0104\u0107\u0106\u0119\u0118\u0142\u0141\u0144\u0143\u00f3\u00d3\u015b\u015a\u017a\u0179\u017c\u017b\\-\u00e9]+")) {
                        vector.put(sub, (Double)entry.getValue());
                    }
                    ++n2;
                }
            }
        }
    }

    private static void normalizeVector(Map<String, Double> vector) {
        double sumOfValues = 0.0;
        for (Double d : vector.values()) {
            sumOfValues += d.doubleValue();
        }
        for (Map.Entry entry : vector.entrySet()) {
            entry.setValue(100.0 * (Double)entry.getValue() / sumOfValues);
        }
    }

    private Map<String, Double> calculateIgfs(Map<String, Gloss> preprocessedGlosses) {
        Counter c = new Counter();
        for (Map.Entry<String, Gloss> e : preprocessedGlosses.entrySet()) {
            Gloss g = e.getValue();
            HashSet<String> strings = new HashSet<String>();
            if (this.lemmatize) {
                strings.addAll(g.getBases());
            } else {
                strings.addAll(g.getOrths());
            }
            for (String w : strings) {
                c.increase(w);
            }
        }
        HashMap<String, Double> idfFromGlossess = new HashMap<String, Double>();
        for (Map.Entry s : c.entrySet()) {
            idfFromGlossess.put((String)s.getKey(), Math.log(1.0 * (double)preprocessedGlosses.size() / (double)((Integer)s.getValue()).intValue()));
        }
        return idfFromGlossess;
    }

    private static double getVectorSimilarity(Map<String, Double> vector1, Map<String, Double> vector2, IntersectionType intersectionType) {
        double result = 0.0;
        if (intersectionType.equals((Object)IntersectionType.EUCLIDEAN)) {
            Collection<String> words = MatchingStrategy.getAllWords(vector1, vector2);
            for (String word : words) {
                Double weigth1 = vector1.get(word);
                Double weigth2 = vector2.get(word);
                if (weigth1 == null) {
                    weigth1 = 0.0;
                }
                if (weigth2 == null) {
                    weigth2 = 0.0;
                }
                result += Math.pow(weigth2 - weigth1, 2.0);
            }
            if (result == 0.0) {
                result += 1.0E-17;
            }
            result = 1.0 / Math.sqrt(result);
        } else if (intersectionType.equals((Object)IntersectionType.JACCARD)) {
            double nom = MatchingStrategy.getProduct(vector1, vector2);
            double denom = Math.pow(MatchingStrategy.getVectorLength(vector1), 2.0) + Math.pow(MatchingStrategy.getVectorLength(vector2), 2.0) - result;
            result = denom == 0.0 ? 0.0 : nom / denom;
        } else if (intersectionType.equals((Object)IntersectionType.KULLBACK)) {
            Collection<String> words = MatchingStrategy.getAllWords(vector1, vector2);
            for (String word : words) {
                Double weigth1 = vector1.get(word);
                Double weigth2 = vector2.get(word);
                if (weigth1 == null) {
                    weigth1 = 0.0;
                }
                if (weigth2 == null) {
                    weigth2 = 0.0;
                }
                double pi1 = weigth1 / (weigth1 + weigth2);
                double pi2 = weigth2 / (weigth1 + weigth2);
                double w = pi1 * weigth1 + pi2 * weigth2;
                if (weigth1 > 0.0) {
                    result += pi1 * (weigth1 * Math.log(weigth1 / w));
                }
                if (!(weigth2 > 0.0)) continue;
                result += pi2 * (weigth2 * Math.log(weigth2 / w));
            }
            result = 1.0 / result;
        } else if (intersectionType.equals((Object)IntersectionType.PEARSON)) {
            double tf1 = MatchingStrategy.getSumWeights(vector1, 1);
            double tf2 = MatchingStrategy.getSumWeights(vector2, 1);
            double m = MatchingStrategy.getAllWords(vector1, vector2).size();
            double nom = m * MatchingStrategy.getProduct(vector1, vector2) - tf1 * tf2;
            double denom = (m * MatchingStrategy.getSumWeights(vector1, 2) - Math.pow(tf1, 2.0)) * (MatchingStrategy.getSumWeights(vector2, 2) - Math.pow(tf2, 2.0));
            if (denom < 0.0) {
                denom = 0.0;
            }
            result = (denom = Math.sqrt(denom)) == 0.0 ? (nom == 0.0 ? 2.0 : 0.0) : 1.0 + nom / denom;
        } else if (intersectionType.equals((Object)IntersectionType.PRODUCT)) {
            result = MatchingStrategy.getProduct(vector1, vector2);
        } else if (intersectionType.equals((Object)IntersectionType.COSINE)) {
            double nom = MatchingStrategy.getProduct(vector1, vector2);
            double denom = MatchingStrategy.getVectorLength(vector1) * MatchingStrategy.getVectorLength(vector2);
            result = denom == 0.0 ? 0.0 : nom / denom;
        }
        return result;
    }

    private static double getVectorLength(Map<String, Double> vector) {
        double result = 0.0;
        for (Double val : vector.values()) {
            result += val * val;
        }
        result = Math.sqrt(result);
        return result;
    }

    private static Collection<String> getAllWords(Map<String, Double> vector1, Map<String, Double> vector2) {
        HashSet<String> result = new HashSet<String>(vector1.keySet());
        result.addAll(new HashSet<String>(vector2.keySet()));
        return result;
    }

    private static double getSumWeights(Map<String, Double> vector, int pow) {
        double result = 0.0;
        for (Double val : vector.values()) {
            result += Math.pow(val, pow);
        }
        return result;
    }

    private static double getProduct(Map<String, Double> vector1, Map<String, Double> vector2) {
        double result = 0.0;
        for (Map.Entry<String, Double> entry : vector1.entrySet()) {
            String word = entry.getKey();
            Double f = vector2.get(word);
            if (f == null) continue;
            result += f * entry.getValue();
        }
        return result;
    }

    private void setParams(String params) throws Exception {
        String[] splitted = params.split(":");
        if (splitted.length != 10) {
            throw new Exception("Wrong parameters length!" + params);
        }
        String lm = splitted[0];
        String bi = splitted[1];
        String wigf = splitted[2];
        String widf = splitted[3];
        String thl = splitted[4];
        String thh = splitted[5];
        String nog = splitted[6];
        String noc = splitted[7];
        String et = splitted[8];
        String it = splitted[9];
        this.lemmatize = lm.equalsIgnoreCase("yes");
        this.binary = bi.equalsIgnoreCase("yes");
        this.withIGF = wigf.equalsIgnoreCase("yes");
        this.withIDF = widf.equalsIgnoreCase("yes");
        this.thresholdLow = Double.valueOf(thl);
        this.thresholdHigh = Double.valueOf(thh);
        this.glossNormalisation = nog.equalsIgnoreCase("yes");
        if (noc.equalsIgnoreCase("NONE")) {
            this.contextNormalisation = ContextNormalisation.NONE;
        } else if (noc.equalsIgnoreCase("SQUARE")) {
            this.contextNormalisation = ContextNormalisation.SQUARE;
        } else if (noc.equalsIgnoreCase("LINEAR")) {
            this.contextNormalisation = ContextNormalisation.LINEAR;
        }
        if (et.equalsIgnoreCase("NONE")) {
            this.extensionType = ExtensionType.NONE;
        } else if (et.equalsIgnoreCase("SYNONIMY_UX_ALL")) {
            this.extensionType = ExtensionType.SYNONIMY_UX_ALL;
        } else if (et.equalsIgnoreCase("SYNONIMY_UX_MONO")) {
            this.extensionType = ExtensionType.SYNONIMY_UX_MONO;
        } else if (et.equalsIgnoreCase("PLWORDNET_ALL")) {
            this.extensionType = ExtensionType.PLWORDNET_ALL;
        } else if (et.equalsIgnoreCase("PLWORDNET_MONO")) {
            this.extensionType = ExtensionType.PLWORDNET_MONO;
        } else if (et.equalsIgnoreCase("PLWORDNET_RELATIONS")) {
            this.extensionType = ExtensionType.PLWORDNET_RELATIONS;
        } else if (et.equalsIgnoreCase("PLWORDNET_SEMSIM")) {
            this.extensionType = ExtensionType.PLWORDNET_SEMSIM;
        } else {
            throw new Exception("Wrong parameters!" + params);
        }
        if (it.equalsIgnoreCase("COSINE")) {
            this.intersectionType = IntersectionType.COSINE;
        } else if (it.equalsIgnoreCase("EUCLIDEAN")) {
            this.intersectionType = IntersectionType.EUCLIDEAN;
        } else if (it.equalsIgnoreCase("JACCARD")) {
            this.intersectionType = IntersectionType.JACCARD;
        } else if (it.equalsIgnoreCase("KULLBACK")) {
            this.intersectionType = IntersectionType.KULLBACK;
        } else if (it.equalsIgnoreCase("PEARSON")) {
            this.intersectionType = IntersectionType.PEARSON;
        } else if (it.equalsIgnoreCase("PRODUCT")) {
            this.intersectionType = IntersectionType.PRODUCT;
        } else {
            throw new Exception("Wrong parameters!" + it + params);
        }
    }

    private static enum ContextNormalisation {
        NONE,
        SQUARE,
        LINEAR;

    }

    private static enum ExtensionType {
        NONE,
        SYNONIMY_UX_ALL,
        SYNONIMY_UX_MONO,
        PLWORDNET_ALL,
        PLWORDNET_MONO,
        PLWORDNET_RELATIONS,
        PLWORDNET_SEMSIM;

    }

    private static enum IntersectionType {
        PRODUCT,
        COSINE,
        EUCLIDEAN,
        JACCARD,
        KULLBACK,
        PEARSON;

    }
}

