package corpusapi;

import java.util.List;


public interface SegmentGroup {	
	/**
	 * Zwraca indeksy segmentów z bieżącej grupy w bloku tekstu
	 * @return indeksy segmentów z bieżącej grupy w bloku tekstu
	 */
	public int[] getSegmentPositions();
	
	/**
	 * Zwraca segment z grupy segmentów o podanym indeksie (w ramach grupy)
	 * @param idx indeks segmentu w ramach grupy (nie bloku tekstu)
	 * @return wskazany segment
	 */
	public Segment getSegment(int idx);
	
	/**
	 * Zwraca liczbę segmentów w grupie
	 * @return liczba segmentów w grupie
	 */
	public int getSize();
	
	/**
	 * Zwraca pierwszy segment z grupy segmentów
	 * @return pierwszy segment z grupy segmentów lub null jeśli grupa jest pusta
	 */
	public Segment getFirstSegment();
	
	/**
	 * Zwraca kolejny segment z grupy segmentów lub null, jeśli nie ma
	 * @return kolejny segment z grupy segmentów lub null, jeśli nie ma
	 */
	public Segment getNextSegment();
	
	/**
	 * Spradza, czy istnieje kolejny segment w grupie
	 * @return true, jeśli istnieje kolejny segment w grupie, false wpp. 
	 */
	public boolean hasNextSegment();
	
	/**
	 * Zwraca kolejną grupę segmentów o tym samym typie. Kontynuuje w następnych
	 * blokach niezależnie od ich powiązania z bieżącym (tryb ALWAYS_CONTINUE)
	 * @return kolejna grupa segmentów o tym samym typie
	 */
	public SegmentGroup getNext();
	
	/**
	 * Zwraca kolejną grupę segmentów o tym samym typie, zgodnie z polityką w argumencie
	 * @return kolejna grupa segmentów o tym samym typie, zgodnie z polityką w argumencie
	 */
	public SegmentGroup getNext(ContinueMode mode);
	
	/**
	 * Zwraca poprzednią grupę segmentów o tym samym typie. Kontynuuje w poprzednich
	 * blokach niezależnie od ich powiązania z bieżącym (tryb ALWAYS_CONTINUE)
	 * @return poprzednia grupa segmentów o tym samym typie
	 */
	public SegmentGroup getPrev();
	
	/**
	 * Zwraca poprzednią grupę segmentów o tym samym typie, zgodnie z polityką w argumencie
	 * @return poprzednia grupa segmentów o tym samym typie, zgodnie z polityką w argumencie
	 */
	public SegmentGroup getPrev(ContinueMode mode);
	
	public String getId();
	
	public List<String> getSegmentIds();
}
