package corpusapi.tei;

import java.io.IOException;
import java.util.List;

import javax.xml.stream.XMLStreamException;

import corpusapi.ContinueMode;
import corpusapi.SegmentGroup;
import corpusapi.tei.readers.TEIReader;
import corpusapi.tei.readers.TEISegmentationReader;

public abstract class TEISegmentGroup implements SegmentGroup {
	protected String id;
	protected List<String> segmentIdList;
	protected int currentPosition = 0;
	public String nextGroupId = null;
	protected String prevGroupId = null;

	public TEICorpusText corpusText;

	public TEISegmentGroup(String id, TEICorpusText corpusText,
			List<String> segmentIdList, String nextGroupId, String prevGroupId) {
		this.id = id;
		this.corpusText = corpusText;
		this.segmentIdList = segmentIdList;
		this.nextGroupId = nextGroupId;
		this.prevGroupId = prevGroupId;
	}

	@Override
	public TEISegment getFirstSegment() {
		if (segmentIdList.isEmpty())
			return null;

		currentPosition = 0;
		TEISegment segment = null;
		try {
			TEISegmentationReader segmentationReader = TEIReader
					.getTEISegmentationReader(corpusText);
			segment = segmentationReader.getSegmentById(segmentIdList
					.get(currentPosition));
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (segment != null)
			currentPosition++;

		return segment;
	}

	@Override
	public TEISegmentGroup getNext() {
		return getNext(ContinueMode.ALWAYS_CONTINUE);
	}

	@Override
	public abstract TEISegmentGroup getNext(ContinueMode mode);

	@Override
	public TEISegment getNextSegment() {
		if (!hasNextSegment())
			return null;

		TEISegment segment = null;
		try {
			TEISegmentationReader segmentationReader = TEIReader
					.getTEISegmentationReader(corpusText);
			segment = segmentationReader.getSegmentById(segmentIdList
					.get(currentPosition));
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (segment != null)
			currentPosition++;

		return segment;
	}

	@Override
	public TEISegmentGroup getPrev() {
		return getPrev(ContinueMode.ALWAYS_CONTINUE);
	}

	@Override
	public abstract TEISegmentGroup getPrev(ContinueMode mode);

	@Override
	public TEISegment getSegment(int idx) {
		if (segmentIdList.size() <= idx || idx < 0)
			return null;

		TEISegment segment = null;
		try {
			TEISegmentationReader segmentationReader = TEIReader
					.getTEISegmentationReader(corpusText);
			segment = segmentationReader.getSegmentById(segmentIdList.get(idx));
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return segment;
	}

	@Override
	public int[] getSegmentPositions() {
		int[] result = new int[segmentIdList.size()];

		int i = 0;
		for (String id : segmentIdList) {
			TEISegment seg = null;
			try {
				TEISegmentationReader segmentationReader = TEIReader
						.getTEISegmentationReader(corpusText);
				seg = segmentationReader.getSegmentById(id);
			} catch (XMLStreamException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			result[i++] = seg.segmentPosition;
		}

		return result;
	}

	@Override
	public int getSize() {
		return segmentIdList.size();
	}

	@Override
	public boolean hasNextSegment() {
		return (segmentIdList.size() > currentPosition);
	}

	@Override
	public String toString() {
		return "id=" + id + ", nextGroupId=" + nextGroupId + ", prevGroupId="
				+ prevGroupId;
	}

	/**
	 * Zwraca jedną z dwóch, podanych jako argumenty, grup segmentów, zgodnie z
	 * parametrem returnFirst (jeśli returnFirst==true, zwraca pierwszą grupę,
	 * wpp. drugą). Poza tym sprawdza, czy te dwie grupy są w zgodnej z polityką
	 * w mode relacji, jeżeli nie, to zwraca null.
	 * 
	 * @param mode
	 * @param first
	 * @param second
	 * @param returnFirst
	 * @return TEISegmentGroup lub null
	 */
	protected TEISegmentGroup getNeighbour(ContinueMode mode,
			TEISegmentGroup first, TEISegmentGroup second, boolean returnFirst) {

		if (!mode.equals(ContinueMode.ALWAYS_CONTINUE)) {

			// obliczanie ostatniego segmentu pierwszej grupy
			TEISegment lastSegment = first.getSegment(first.getSize() - 1);
			// obliczanie pierwszego segmentu drugiej grupy
			TEISegment firstSegment = second.getFirstSegment();

			if (mode.equals(ContinueMode.ALWAYS_STOP)) {
				if (!lastSegment.getTextBlock().equals(
						firstSegment.getTextBlock())) {
					return null;
				}
			} else if (mode.equals(ContinueMode.CONTINUOUS)) {
				if (!lastSegment.isRelatedToSuccessor(firstSegment)) {
					return null;
				}
			}
		}
		if (returnFirst)
			return first;
		return second;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public List<String> getSegmentIds() {
		return segmentIdList;
	}
}
