package corpusapi;


public interface CorpusText {
	/**
	 * Zwraca pierwszy blok z tekstu (<p>, <ab>, <u>) i ustawia wskaźnik iteracji na ten blok
	 * @return pierwszy blok z tekstu
	 */
	public TextBlock getFirstTextBlock();
	
	/**
	 * Zwraca kolejny blok z tekstu lub null, jeśli nie ma
	 * @return kolejny blok z tekstu lub null, jeśli nie ma
	 */
	public TextBlock getNextTextBlock();
	
	/**
	 * Czy istnieje następny blok tekstu
	 * @return true jeśli istnieje, false wpp.
	 */
	public boolean hasNextTextBlock();
	
	/**
	 * Zwraca blok tekstu o podanej pozycji w pliku zrodlowym.
	 * Ta operacja doczytuje bloki tekstu, az do zadanej pozycji.
	 * Nie zmienia iteratora, przypisanego do operacji getNextTextBlock.
	 * @param position - pozycja w pliku tekstowym (numer kolejny bloku tekstu)
	 * @return blok tekstu lub null, jesli takiego nie ma.
	 */
	public TextBlock getTextBlock(int position);
	
	/**
	 * Zamyka tekst i probuje zwolnic zarezerwowane zasoby
	 * 
	 */
	public void closeCorpusText();
	
	public Corpus getCorpus();
	
	public String getPath();
	
	public Segment getFirstSegment() throws Exception;
}
