package corpusapi;

import java.util.List;

/**
 * 	Sensy mają strukture hierarchiczną (drzewo)
 * 
 *
 */
public interface Sense {
	/**
	 * zwraca wpis w słowniku (słowo wieloznacznego) dla tego sensu
	 * @return wpis w słowniku (słowo wieloznacznego) dla tego sensu
	 */
	
	public SenseEntry getSenseEntry();
	
	/**
	 * zwraca id tego sensu w słowniku
	 * @return id sensu lub null jeśli sens nie ma id
	 */
	public String getId();
	
	/**
	 * zwraca definicje tego sensu
	 * @return definicja
	 */
	public String getDefinition();
	
	/**
	 * zwraca listę definicji tego sensu i podsensow
	 * 
	 * @return
	 */
	public List<String> getDefinitions();
	
	/**
	 * zwraca listę przykładów danego sensu
	 * @return lista przykładów danego sensu
	 */
	public List<String> getQuotes();
	
	/**
	 * zwraca listę wszystkich przykładów (suma z przykładami z podsensów) 
	 * @return
	 */
	public List<String> getAllQuotes();
	
	/**
	 * zwraca listę podSensów danego sensu 
	 * @return lista podsensów
	 */
	
	public List<? extends Sense> getSubSenses();
	
	/**
	 * zwraca ogólniejszy sens lub nulla jeżeli taki nie istnieje
	 * @return ogólniejszy sens lub null, jeżeli taki nie istnieje
	 */
	public Sense getCoarserSense();
	
	/**
	 * zwraca poziom 'gruboziarnistosci' danego sensu. Poziomy numerowane od 1
	 * @return
	 */
	public int getCoarseness();
}
