package corpusapi.tei;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import corpusapi.SenseStatistics;

public class TEISenseStatistics implements SenseStatistics {

	HashMap<String,Integer> senseCounter;
	HashMap<String,Integer> senseEntryCounter;
	HashMap<String,Set<String>> senseEntrySenseMap;
	HashMap<String,String> senseSenseEntryMap;
	public boolean complete;
	String corpusId;
	
	
	public TEISenseStatistics(String corpusId) {
		this.corpusId = corpusId;
		senseCounter =  new HashMap<String, Integer>();		
		senseEntryCounter = new HashMap<String, Integer>();
		senseEntrySenseMap = new HashMap<String, Set<String>>();
		senseSenseEntryMap = new HashMap<String, String>();
	}
	
	@Override
	public void addOccurence(String senseEntry, String sense) {
		//System.out.println(senseEntry+ " "+sense);
		Integer i;
		
		//mapa sense -> senseEntry
		senseSenseEntryMap.put(sense, senseEntry);
		
		//licznik konkretnych sensów
		if ((i = senseCounter.get(sense))==null) {
			i = 0;
		}
		i++;
		senseCounter.put(sense, i);
		
		//licnzik słów wieloznacznych (ile razy kazde wystepuje) (czyli suma wystapien jego sensow)
		if ((i = senseEntryCounter.get(senseEntry))==null) {
			i = 0;
		}
		i++;
		senseEntryCounter.put(senseEntry, i);
		
		Set<String> s;
		//mapa slowo wieloznaczne -> zbior jego sensow
		if ((s = senseEntrySenseMap.get(senseEntry))==null) {
			s = new HashSet<String>();
		}
		s.add(sense);
		senseEntrySenseMap.put(senseEntry, s);

	}

	@Override
	public Set<String> availableSenseEntries() {
		return senseEntryCounter.keySet();
	}

	@Override
	public String corpusId() {
		return corpusId;
	}

	@Override
	public int getSenseCount(String sense) {
		Integer i;
		if ((i = senseCounter.get(sense))==null) {
			i = 0;
		}
		return i;
	}

	@Override
	public int getSenseEntryCount(String senseEntry) {
		Integer i;
		if ((i = senseEntryCounter.get(senseEntry))==null) {
			i = 0;
		}
		return i;
	}

	@Override
	public boolean isComplete() {
		return complete;
	}

	@Override
	public SenseStatistics projectionToSenseEntries(List<String> senseEntries) {
		// TODO Auto-generated method stub
		return null;
	}

	public HashMap<String, Set<String>> getSenseEntrySenseMap() {
		return senseEntrySenseMap;
	}

	@Override
	public Collection<String> getSenseEntrySenses(String senseEntry) {
		return senseEntrySenseMap.get(senseEntry);
	}
}
