package test;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

import javax.xml.stream.XMLStreamException;

import corpusapi.ContinueMode;
import corpusapi.Corpus;
import corpusapi.CorpusFactory;
import corpusapi.MorphoSegmentGroup;
import corpusapi.Segment;
import corpusapi.SegmentGroup;
import corpusapi.SenseSegmentGroup;
import corpusapi.SentenceSegmentGroup;
import corpusapi.TextBlock;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEIMorphoSegmentGroup;
import corpusapi.tei.TEISegment;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.TEISense;
import corpusapi.tei.TEISenseEntry;
import corpusapi.tei.TEISenseInventory;
import corpusapi.tei.TEITextBlock;
import corpusapi.tei.readers.TEIReader;
import corpusapi.tei.readers.TEITextReader;

public class APITest {
	private static CorpusFactory factory = CorpusFactory.getInstance();
	private static Corpus corpus;
	private static TEICorpusText corpusText;

	public static void main(String[] args) {
		corpus = factory.getCorpus(args[0], true);
		corpus.open();

//		System.out.println(corpus.getCorpusTextIds());
//		System.out.println(corpus.getCorpusTextIds().size());
//		System.out.println();
		
//		for (String tid : corpus.getCorpusTextIds()) {
//			System.out.println(corpus.getCorpusText(tid).getPath());
//		}

//		System.exit(0);
		
//		corpusText = (TEICorpusText) corpus.getCorpusText(corpus.getCorpusTextIds().toArray()[0].toString());
//		System.out.println("\nPobrano tekst: " + corpusText.getPath());

		long start = System.nanoTime();

		try {
		// testXpointers();
		// testTextBlocksForSegments();
		testMorfo();
//		testWypluwka();
		// testSenseReader();
		// testTextBlocks();
		// testSenseInventory();
		// testMorphReader();
		// testSentenceReader();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		
		long end = System.nanoTime();

		long total = (end - start);
		System.out.println("\tNanos: " + total);
		double seconds = (double) total / 1000000000.0;
		System.out.println("\tSeconds: " + seconds);
	}

	private static void testMorphReader() throws Exception {
		testSegmentGroup(MorphoSegmentGroup.class, 1, 1, ContinueMode.CONTINUOUS);
	}

	private static void testSentenceReader() throws Exception {
		testSegmentGroup(SentenceSegmentGroup.class, 1, Integer.MAX_VALUE, ContinueMode.CONTINUOUS);
	}

	private static void testSenseReader() throws Exception {
		testSegmentGroup(SenseSegmentGroup.class, 20, 2, ContinueMode.CONTINUOUS);
	}

	/**
	 * Testuje grupe segmentow wybranego typu.
	 * 
	 * @param type
	 *            - typ grupy (klasa)
	 * @param segmentsPerBlock
	 *            - ilosc segmentow pobierana z poczatku danego bloku
	 * @param groupsForwardAndBackward
	 *            - ilosc grup sprawdzana w przod i w tyl od znalezionej grupy
	 *            segmentow
	 * @param mode
	 *            - polityka sprawdzania w przod i w tyl
	 * @throws Exception 
	 */
	private static void testSegmentGroup(Class<? extends SegmentGroup> type, int segmentsPerBlock,
			int groupsForwardAndBackward, ContinueMode mode) throws Exception {
		TextBlock tb = corpusText.getFirstTextBlock();
		int cnt = 0;
		do {
			System.out.println("\n" + tb);
			for (int i = 0; i < tb.getSize() && i < segmentsPerBlock; i++) {
				Segment segment = tb.getSegment(i);
				SegmentGroup group = segment.getSegmentGroup(type);
				SegmentGroup next = null;
				try {
					next = segment.getFirstSegmentGroup(1, type, mode);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				SegmentGroup prev = null;
				try {
					prev = segment.getFirstSegmentGroup(-1, type, mode);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				System.out.println(" " + segment);
				System.out.println("    Its " + type.getSimpleName() + ": " + group);
				if (group != null)
					cnt++;

				if (groupsForwardAndBackward > 0) {
					int max = groupsForwardAndBackward;
					while (next != null && max > 0) {
						System.out.println("   Next " + type.getSimpleName() + ": " + next);
						next = next.getNext(mode);
						max--;
					}

					max = groupsForwardAndBackward;
					while (prev != null && max > 0) {
						System.out.println("   Prev " + type.getSimpleName() + ": " + prev);
						prev = prev.getPrev(mode);
						max--;
					}
				}
				System.out.println("");
			}
			System.out.println("");
		} while ((tb = tb.getNext()) != null);

		System.out.println("Ilosc grup (tylko na segmentach):" + cnt);
	}

	private static void testTextBlocks() {
		TEITextBlock tb = null;

		System.out.println("\nTEST Pobieranie kolejnych wszystkich blokow z tekstu.");

		TEITextReader reader = TEIReader.getTEITextReader(corpusText);

		int c = 0;
		while (corpusText.hasNextTextBlock()) {
			c++;
			tb = corpusText.getNextTextBlock();
			tb.getSize();

			System.out.println(tb);
			try {
				System.out.println(reader.getTextBlockById(tb.getId()));
			} catch (XMLStreamException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			System.out.println();
		}
		System.out.println("Ilość pobranych bloków:" + c);

		System.out.println("\nTEST Pobieranie 20 losowych blokow z tekstu.");
		Random r = new Random();

		int b = 0;
		while (b < 20) {
			b++;
			tb = corpusText.getTextBlock(r.nextInt(c));
			tb.getSize();
		}
		System.out.println("Ilość pobranych bloków:" + b);
	}

	private static void testSenseInventory() {
		/*********** RM START ******************/
		TEISenseInventory si = (TEISenseInventory) factory.getSenseInventory("../config.xml");
		System.out.println(si.getTitle());

		Set<String> keys = si.getSenseEntries().keySet();
		Iterator<String> ite = keys.iterator();

		while (ite.hasNext()) {
			TEISenseEntry senseEntry = si.getSenseEntries().get(ite.next());
			System.out.println(senseEntry.getOrthForm());
			for (TEISense sense : senseEntry.getSenseList()) {
				System.out.println("\t" + sense.getId() + ":" + sense.getDefinition());
			}
		}

		TEISenseEntry entry = si.getSenseEntries().get("zostac");

		// System.exit(0);

		List<String> defs = entry.getSenseList().get(0).getAllQuotes();
		for (String string : defs) {
			System.out.println(string);
		}
		System.out.println(entry);

		System.out.println(entry.getSenseList().get(0).getSubSenses().get(0).getMultiDefinition().get(0).getKeyword());

		/**** RM END ***********/

	}

	/********************** testy korpusu 
	 * @throws Exception ***********************************/

	private static void testXpointers() throws Exception {
		List<String> ctIds = corpus.getCorpusTextIds();

		System.out.println("Ilość wszystkich tekstów:" + ctIds.size());

		int segmentsCount = 0;

		for (String ctId : ctIds) { // dla każdego tekstu
			TEICorpusText ct = (TEICorpusText) corpus.getCorpusText(ctId);

			int segmentsInText = 0;
			TEISegment s = ct.getFirstSegment();
			if (s == null) {
				System.out.println("TEKST bez segmentów! " + ct.getPath());
			} else {
				// System.out.println("\t\t<text path=\""+ct.getPath().substring(2)+"\"/>");
			}
			while (s != null) {
				segmentsInText++;
				if (((TEISegment) s).getTextBlockId().equals("")) {
					System.out.println("Xpoin \t" + s.getId() + "\t" + ct.getPath());
					// System.out.println("result.add(\""+ctId+"\");");
				}

				// System.out.println(s.getOrth());
				s = s.getNext(ContinueMode.ALWAYS_CONTINUE);
			}

			// System.out.println("  Segmentów w tekście:"+segmentsInText);
			segmentsCount += segmentsInText;

			ct.closeCorpusText();
		}

		System.out.println("  Segmentów w korpusie:" + segmentsCount);
	}

	private static void testTextBlocksForSegments() throws Exception {
		List<String> ctIds = corpus.getCorpusTextIds();

		System.out.println("Ilość wszystkich tekstów:" + ctIds.size());

		int segmentsCount = 0;

		for (String ctId : ctIds) { // dla każdego tekstu
			TEICorpusText ct = (TEICorpusText) corpus.getCorpusText(ctId);

			Set<String> textBlocksIdsInSegm = new HashSet<String>();
			int segmentsInText = 0;
			TEISegment s = ct.getFirstSegment();
			if (s == null) {
				System.out.println("TEKST bez segmentów! " + ct.getPath());
			}
			while (s != null) {
				segmentsInText++;
				textBlocksIdsInSegm.add(s.getTextBlockId());

				s = s.getNext(ContinueMode.ALWAYS_CONTINUE);
			}
			// System.out.println("  Segmentów w tekście:"+segmentsInText);
			segmentsCount += segmentsInText;

			Set<String> textBlocksIdsInText = new HashSet<String>();
			TEITextBlock tb = ct.getFirstTextBlock();
			while (tb != null) {
				textBlocksIdsInText.add(tb.getId());
				tb = tb.getNext();
			}

			if (!textBlocksIdsInText.containsAll(textBlocksIdsInSegm)) {
				textBlocksIdsInSegm.removeAll(textBlocksIdsInText);
				System.out.println(textBlocksIdsInSegm + "\t" + ct.getPath());
				// System.out.println("result.add(\""+ctId+"\");");
			}

			ct.closeCorpusText();
		}

		System.out.println("  Segmentów w korpusie:" + segmentsCount);
	}

	private static void testMorfo() throws Exception {
		List<String> ctIds = corpus.getCorpusTextIds();

		System.out.println("Ilość wszystkich tekstów:" + ctIds.size());

		int segmentsCount = 0;

		for (String ctId : ctIds) { // dla każdego tekstu
			// System.out.println("Otwieranie tekstu: "+ctId);
			TEICorpusText ct = (TEICorpusText) corpus.getCorpusText(ctId);

			int segmentsInText = 0;
			TEISegment s = ct.getFirstSegment();
			if (s == null) {
				System.out.println("TEKST bez segmentów! " + ct.getPath());
			}
			while (s != null) {
				segmentsInText++;

				TEIMorphoSegmentGroup morph = (TEIMorphoSegmentGroup) s.getSegmentGroup(MorphoSegmentGroup.class);
				if (morph != null) {
					String morport = morph.orth.replace('–', '-');
					String or = s.getOrth().replace('–', '-').replace(" ", "").replace(" ", "");

					if (!morport.equals(or)) {
						// System.out.println(morport+"\t"+or+'\t'+s.getId()+'\t'+ct.getPath()+"\t"+"result.add(\""+ctId+"\");");
						// System.out.println("result.add(\""+ctId+"\");");
					}
				}
				s = s.getNext(ContinueMode.ALWAYS_CONTINUE);
			}
			// System.out.println("  Segmentów w tekście:"+segmentsInText);
			segmentsCount += segmentsInText;

			ct.closeCorpusText();
		}

		System.out.println("  Segmentów w korpusie:" + segmentsCount);
	}

	private static void testWypluwka() throws Exception {
		List<String> ctIds = corpus.getCorpusTextIds();

		System.out.println("Ilość wszystkich tekstów:" + ctIds.size());

		int segmentsCount = 0;

		for (String ctId : ctIds) { // dla każdego tekstu
			// System.out.println("Otwieranie tekstu: "+ctId);
			TEICorpusText ct = (TEICorpusText) corpus.getCorpusText(ctId);

			int segmentsInText = 0;
			int prevSegEndIdx = -1;
			String prevTextBId = "";
			TEISegment s = ct.getFirstSegment();
			if (s == null) {
				System.out.println("TEKST bez segmentów!");
				// System.out.println("result.add(\""+ctId+"\");");
			}
			while (s != null) {
				segmentsInText++;
				// if (s.getStartIdx() < prevSegEndIdx &&
				// prevTextBId.equals(s.getTextBlockId())) {
				// System.out.println(s+"\t"+ct.getPath());
				// }
				// prevSegEndIdx = s.getEndIdx();
				// prevTextBId = s.getTextBlockId();
				TEISegmentGroup m = s.getSegmentGroup(TEIMorphoSegmentGroup.class);
				s = s.getNext(ContinueMode.ALWAYS_CONTINUE);
			}
			// System.out.println("  Segmentów w tekście:"+segmentsInText);
			segmentsCount += segmentsInText;

			ct.closeCorpusText();
		}

		System.out.println("  Segmentów w korpusie:" + segmentsCount);
	}
}
