package corpusapi.tei;

import java.util.List;
import java.util.Vector;

import corpusapi.SenseEntry;

public class TEISenseEntry implements SenseEntry {

	/**
	 * id tego wpisu
	 */
	private String id;
	
	/**
	 * część mowy
	 */
	private String POS;
	
	/**
	 * forma hasłowa; tutaj chyba troche w tym xmlu nie przemyslane...
	 */
	private String orthForm;
	
	private TEISenseInventory teiSI;

	private List<TEISense> senses;
	
	public TEISenseEntry(String senseEntryID, TEISenseInventory teiSI) {
		this.id = senseEntryID;
		this.teiSI = teiSI;
		this.senses = new Vector<TEISense>();
	}
	
	
	public void setPOS(String POS) {
		this.POS = POS;
	}

	public void setOrthForm(String orthForm) {
		this.orthForm = orthForm;
	}

	public void addSense(TEISense sense) {
		this.senses.add(sense);
	}
	
	@Override
	public List<TEISense> getSenseList() {
		return senses;
	}

	/**
	 * zwraca identyfikator tego SenseEntry
	 * 
	 * @return
	 */
	public String getID() {
		return id;
	}
	
	/**
	 * zwraca część mowy tego SenseEntry
	 * 
	 * @return
	 */
	public String getPOS() {
		return POS;
	}
	
	/**
	 * zwraca formę ortograficzną tego SenseEntry
	 * 
	 * @return
	 */
	public String getOrthForm() {
		return orthForm;
	}


	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("ID:" + id + "\n");
		sb.append(orthForm + ", " + POS);
		sb.append('\n');
		
		
		for (TEISense sense : senses) {
			sb.append(sense.toString());
		}
		
		return sb.toString();
	}


	@Override
	public TEISenseInventory getSenseInventory() {
		return teiSI;
	}


	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}


	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TEISenseEntry other = (TEISenseEntry) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}
	
	
}
