/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */

package annotation;

import java.io.File;
import java.util.List;
import java.util.Vector;

import utils.FileManager;
import corpusapi.tei.TEISegment;

/**
 * Object representation of the file with annotation.
 * 
 * @author Mateusz Kopec
 * 
 */
public class AnnSensesTXT {

	/**
	 * Path to the directory in which file is going to be created
	 */
	private String path = null;
	/**
	 * List of annotations
	 */
	private Vector<String> segments = new Vector<String>();

	/**
	 * Constructor
	 * 
	 * @param ctPath
	 *            path to the directory in which file is going to be created
	 */
	public AnnSensesTXT(String ctPath) {
		path = ctPath;
	}

	/**
	 * Add annotation of multiple experts
	 * 
	 * @param seg
	 *            segment being annotated
	 * @param senseIds
	 *            decisions of experts - chosen sense ids
	 */
	public void add(TEISegment seg, List<String> senseIds) {
		StringBuffer sb = new StringBuffer(seg.getId());
		for (String senseId : senseIds)
			sb.append("\t" + senseId);
		segments.add(sb.toString());
	}

	/**
	 * Saves file
	 * 
	 * @param filename
	 *            name of the file
	 */
	public void saveAsTxt(String filename) {
		FileManager.saveStringListInFile(segments, path + File.separator + filename);
	}

	/**
	 * Gets number of annotated segments
	 * 
	 * @return number
	 */
	public int getCount() {
		return segments.size();
	}

}
